/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.gui;

import commons.network.packets.APIGuiGetFileBrowserDirectory;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.objects.Player;
import pluginapi.PluginCallbackManager;
import pluginapi.PluginManager;
import pluginapi.manager.PluginGuiManager;

public class GuiFileBrowser
extends GuiElement {
    private int entryCount = 10;
    private String defaultDirectory = "*";
    private String[] fileExtensionFilter = null;
    private boolean previewImageEnabled = false;
    private float previewImageX = 1.1f;
    private float previewImageY = 0.5f;
    private boolean previewImageRelativePosition = true;
    private int previewImageDimension = 256;
    public static final String USER_DIR = "*";
    public static final String USER_HOME = "**";

    public GuiFileBrowser(float x, float y, boolean relativeposition, float width, float height, boolean relativesize) {
        this(10, x, y, relativeposition, width, height, relativesize);
    }

    public GuiFileBrowser(int entryCount, float x, float y, boolean relativeposition, float width, float height, boolean relativesize) {
        super(x, y, relativeposition, width, height, relativesize);
        if (entryCount < 1) {
            entryCount = 1;
        } else if (entryCount > 100) {
            entryCount = 100;
        }
        this.entryCount = entryCount;
        this.color = 0;
        this.clickable = true;
    }

    public void setEntryCount(int count) {
        if (count < 1) {
            count = 1;
        } else if (count > 100) {
            count = 100;
        }
        if (this.entryCount != count) {
            this.entryCount = count;
            this.updateFileBrowser(false);
        }
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void setPreviewImageEnabled(boolean set) {
        if (this.previewImageEnabled != set) {
            this.previewImageEnabled = set;
            this.updateFileBrowser(false);
        }
    }

    public boolean isPreviewImageEnabled() {
        return this.previewImageEnabled;
    }

    public void setPreviewImagePosition(float x, float y, boolean relative) {
        if (this.previewImageX != x || this.previewImageY != y || this.previewImageRelativePosition != relative) {
            this.previewImageX = x;
            this.previewImageY = y;
            this.previewImageRelativePosition = relative;
            this.updateFileBrowser(false);
        }
    }

    public float getPreviewImagePositionX() {
        return this.previewImageX;
    }

    public float getPreviewImagePositionY() {
        return this.previewImageY;
    }

    public boolean isRelativePreviewImagePosition() {
        return this.previewImageRelativePosition;
    }

    public void setPreviewImageDimension(int dimension) {
        if (this.previewImageDimension != dimension) {
            this.previewImageDimension = dimension;
            this.updateFileBrowser(false);
        }
    }

    public int getPreviewImageDimension() {
        return this.previewImageDimension;
    }

    public void setDirectory(String path) {
        this.defaultDirectory = path;
        this.updateFileBrowser(true);
    }

    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public void getCurrentDirectory(Player player, Callback<String> callback) {
        int callbackID = PluginCallbackManager.registerCallback(callback);
        APIGuiGetFileBrowserDirectory msg = new APIGuiGetFileBrowserDirectory(player.getID(), callbackID, null);
        PluginManager.sendPacket((int)player.getID(), (Object)msg);
    }

    public void setFileExtensionFilter(String ... extension) {
        this.fileExtensionFilter = extension;
        this.updateFileBrowser(false);
    }

    public String[] getFileExtensionFilter() {
        return this.fileExtensionFilter;
    }

    @Override
    public void setColor(int color) {
        super.setColor(color);
    }

    @Override
    public void setColor(float r, float g, float b, float a) {
        super.setColor(r, g, b, a);
    }

    @Override
    public void setClickable(boolean set) {
        super.setClickable(set);
    }

    @Override
    public boolean isClickable() {
        return super.isClickable();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateFileBrowser(false);
    }

    private void updateFileBrowser(boolean updateDirectory) {
        PluginGuiManager.updateGuiFileBrowser((GuiFileBrowser)this, (boolean)updateDirectory);
    }
}

