/*
 * Decompiled with CFR 0.152.
 */
package SyBozz.RisingWorld.Notify;

import SyBozz.RisingWorld.Notify.Color;
import SyBozz.RisingWorld.Notify.Notification;
import SyBozz.RisingWorld.Notify.Point;
import SyBozz.RisingWorld.Notify.Size;
import net.risingworld.api.Timer;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

class NotifyAction {
    private static float _normalHeight = 0.05f;
    private GuiPanel _background;
    private GuiPanel _timeBar;
    private GuiLabel _msgLabel;
    private GuiPanel _sideBar;
    private Player _player;
    private Point _bgPos;
    private Size _bgSize;
    private Point _tbPos;
    private Size _tbSize;
    private float _widthFactor;
    private Color _bgColor;
    private Color _tbColor;
    private Color _sbColor;
    private Timer _bgInTimer;
    private Timer _bgOutTimer;
    private Timer _tbTimer;
    private Timer _moveTimer;
    private Timer _refreshTimer;
    private float _bgDuration = 1.0f;
    private float _bgEndpos;
    private int _duration;
    private String _message;
    private int _position;
    private boolean _colorCodes;
    private boolean _isActive;
    private boolean _showSideBar;

    NotifyAction(Player player, String message, int duration, Color bgColor, Color tbColor, Color sbColor, boolean colorCodes, boolean showSideBar) {
        this._player = player;
        this._message = message;
        this._position = 0;
        this._duration = duration;
        this._bgColor = bgColor;
        this._tbColor = tbColor;
        this._sbColor = sbColor;
        this._colorCodes = colorCodes;
        this._isActive = false;
        this._showSideBar = showSideBar;
        this._bgSize = new Size(Float.valueOf(0.25f), Float.valueOf(_normalHeight), true);
        this._tbSize = new Size(Float.valueOf(0.0f), Float.valueOf(0.1f), true);
        float posY = 0.2f + _normalHeight * (float)this._position + 0.01f * (float)this._position;
        this._bgPos = new Point(Float.valueOf(1.0f), Float.valueOf(posY), true);
        this._tbPos = new Point(Float.valueOf(0.0f), Float.valueOf(0.0f + this._tbSize.height), true);
        this._widthFactor = 1.0f / (float)(this._duration * 100);
        this._bgEndpos = 1.0f - (this._bgSize.width + 0.01f);
        this.CreateGui();
    }

    private void CreateGui() {
        this._background = new GuiPanel();
        this._background.setPivot(PivotPosition.TopLeft);
        this._background.setPosition(this._bgPos.X, this._bgPos.Y, this._bgPos.relative);
        this._background.setSize(this._bgSize.width, this._bgSize.height, this._bgSize.relative);
        this._background.setColor(this._bgColor.r, this._bgColor.g, this._bgColor.b, this._bgColor.a);
        this._background.setVisible(false);
        this._msgLabel = new GuiLabel(this._message, 0.5f, 0.5f, true);
        this._msgLabel.setPivot(PivotPosition.Center);
        this._msgLabel.setFontSize(20);
        this._msgLabel.setColorCodesEnabled(this._colorCodes);
        this._msgLabel.setVisible(true);
        this._timeBar = new GuiPanel();
        this._timeBar.setPivot(PivotPosition.TopLeft);
        this._timeBar.setPosition(this._tbPos.X, this._tbPos.Y, this._tbPos.relative);
        this._timeBar.setSize(this._tbSize.width, this._tbSize.height, this._tbSize.relative);
        this._timeBar.setColor(this._tbColor.r, this._tbColor.g, this._tbColor.b, this._tbColor.a);
        this._timeBar.setVisible(true);
        this._sideBar = new GuiPanel();
        this._sideBar.setPivot(PivotPosition.TopLeft);
        this._sideBar.setPosition(0.99f, 1.0f, true);
        this._sideBar.setSize(0.015f, 1.0f, true);
        this._sideBar.setColor(this._sbColor.r, this._sbColor.g, this._sbColor.b, this._sbColor.a);
        this._sideBar.setVisible(this._showSideBar);
        this._background.addChild(this._msgLabel);
        this._background.addChild(this._timeBar);
        this._background.addChild(this._sideBar);
        this._player.addGuiElement(this._background);
        this._player.addGuiElement(this._msgLabel);
        this._player.addGuiElement(this._timeBar);
        this._player.addGuiElement(this._sideBar);
        this._bgInTimer = new Timer(0.01f, 0.0f, -1, this::blendPopupIn);
        this._bgOutTimer = new Timer(0.01f, 0.0f, -1, this::blendPopupOut);
        this._tbTimer = new Timer(0.01f, 0.0f, -1, this::runProcessbar);
    }

    private void blendPopupIn() {
        if (this._bgInTimer != null) {
            if (!this._bgInTimer.isActive()) {
                return;
            }
            this._bgPos.X -= (1.0f - this._bgEndpos) / (this._bgDuration * 100.0f);
            if (this._bgPos.X <= this._bgEndpos) {
                this._bgPos.X = this._bgEndpos;
                if (this._bgInTimer.isActive()) {
                    this._bgInTimer.kill();
                }
                if (this._tbTimer != null) {
                    this._tbTimer.start();
                }
            }
            this._background.setPosition(this._bgPos.X, this._bgPos.Y, this._bgPos.relative);
        }
    }

    private void blendPopupOut() {
        if (this._bgOutTimer != null) {
            if (!this._bgOutTimer.isActive()) {
                return;
            }
            this._bgPos.X += (1.0f - this._bgEndpos) / (this._bgDuration * 100.0f);
            if (this._bgPos.X >= 1.0f) {
                this._bgPos.X = 1.0f;
                if (this._bgOutTimer.isActive()) {
                    this._bgOutTimer.kill();
                }
                this.destroy();
                return;
            }
            this._background.setPosition(this._bgPos.X, this._bgPos.Y, this._bgPos.relative);
        }
    }

    private void runProcessbar() {
        if (this._tbTimer != null) {
            if (!this._tbTimer.isActive()) {
                return;
            }
            this._tbSize.width += this._widthFactor;
            if (this._tbSize.width >= 1.0f) {
                this._tbSize.width = 1.0f;
                if (this._tbTimer.isActive()) {
                    this._tbTimer.kill();
                }
                if (this._bgOutTimer != null) {
                    this._bgOutTimer.start();
                }
            }
            this._timeBar.setSize(this._tbSize.width, this._tbSize.height, this._tbSize.relative);
        }
    }

    private void moveUp() {
        if (this._moveTimer != null) {
            if (!this._moveTimer.isActive()) {
                return;
            }
            this._bgPos.Y += (_normalHeight + 0.01f) / 25.0f;
            float posY = 0.2f + _normalHeight * (float)this._position + 0.01f * (float)this._position;
            if (this._bgPos.Y >= posY) {
                this._bgPos.Y = posY;
                if (this._moveTimer.isActive()) {
                    this._moveTimer.kill();
                }
            }
            this._background.setPosition(this._bgPos.X, this._bgPos.Y, this._bgPos.relative);
        }
    }

    int getPosition() {
        return this._position;
    }

    void startMoveUp(int newPosition) {
        this._position = newPosition;
        this._moveTimer = new Timer(0.01f, 0.0f, -1, this::moveUp);
        this._moveTimer.start();
    }

    private void start() {
        this._refreshTimer = new Timer(1.0f, 0.0f, -1, () -> this._background.refresh());
        this._background.setVisible(true);
        this._isActive = true;
        if (this._bgInTimer != null) {
            this._bgInTimer.start();
        }
    }

    void start(int position) {
        this._position = position;
        float posY = 0.2f + _normalHeight * (float)position + 0.01f * (float)position;
        this._bgPos = new Point(Float.valueOf(1.0f), Float.valueOf(posY), true);
        this._tbPos = new Point(Float.valueOf(0.0f), Float.valueOf(0.0f + this._tbSize.height), true);
        this.start();
    }

    boolean isActive() {
        return this._isActive;
    }

    private void destroy() {
        if (this._refreshTimer.isActive()) {
            this._refreshTimer.kill();
        }
        if (this._timeBar != null) {
            this._timeBar.destroy();
        }
        if (this._msgLabel != null) {
            this._msgLabel.destroy();
        }
        if (this._sideBar != null) {
            this._sideBar.destroy();
        }
        if (this._background != null) {
            this._background.destroy();
        }
        this._bgInTimer = null;
        this._bgOutTimer = null;
        this._tbTimer = null;
        this._moveTimer = null;
        this._refreshTimer = null;
        this._isActive = false;
        new Timer(0.0f, 0.5f, 1, () -> Notification.removeNotify(this._player, this)).start();
    }
}

