/*
 * Decompiled with CFR 0.152.
 */
package SyBozz.RisingWorld.Notify;

import SyBozz.RisingWorld.Notify.Color;
import SyBozz.RisingWorld.Notify.Main;
import SyBozz.RisingWorld.Notify.Notification;
import SyBozz.RisingWorld.Notify.NotifyAction;
import java.util.Collection;
import net.risingworld.api.objects.Player;

public class Notify {
    private Color _bgColor = Main.config.get_bgColor();
    private Color _tbColor = Main.config.get_tbColor();
    private Color _sbColor = Main.config.get_sbColor();
    private int _duration;
    private String _message;
    private boolean _colorCodes;
    private boolean _showSideBar;

    public Notify(String message) {
        this(message, 10);
    }

    public Notify(String message, int duration) {
        this.setMessage(message);
        this.setDuration(duration);
        this._colorCodes = false;
        this._showSideBar = Main.config.is_enableSB();
    }

    public Color getBackgroundColor() {
        if (this._bgColor == null) {
            this._bgColor = Color.black;
        }
        return this._bgColor;
    }

    public void setBackgroundColor(Color bgColor) {
        if (bgColor == null) {
            return;
        }
        this._bgColor = bgColor;
    }

    public Color getTimebarColor() {
        if (this._tbColor == null) {
            this._tbColor = Color.red;
        }
        return this._tbColor;
    }

    public void setTimebarColor(Color tbColor) {
        if (tbColor == null) {
            return;
        }
        this._tbColor = tbColor;
    }

    public Color getSideBarColor() {
        if (this._sbColor == null) {
            this._sbColor = Color.yellow;
        }
        return this._sbColor;
    }

    public void setSideBarColor(Color sbColor) {
        if (sbColor == null) {
            return;
        }
        this._sbColor = sbColor;
    }

    public int getDuration() {
        return this._duration;
    }

    public void setDuration(int duration) {
        this._duration = duration < 1 ? 1 : (duration > 30 ? 30 : duration);
    }

    public String getMessage() {
        if (this._message == null) {
            this._message = "empty";
        }
        return this._message;
    }

    public void setMessage(String message) {
        if (message.isEmpty()) {
            message = "empty";
        }
        this._message = message.length() > 25 ? message.substring(0, 24) : message;
    }

    public boolean isColorCodesEnabled() {
        return this._colorCodes;
    }

    public void setColorCodesEnabled(boolean enabled) {
        this._colorCodes = enabled;
    }

    public boolean isSideBarEnabled() {
        return this._showSideBar;
    }

    public void setSideBarEnabled(boolean enabled) {
        this._showSideBar = enabled;
    }

    public void sendToAll(Collection<Player> playerList) {
        if (playerList.size() < 1) {
            return;
        }
        for (Player player : playerList) {
            this.sendToPlayer(player);
        }
    }

    public void sendToPlayer(Player player) {
        NotifyAction newNotify = new NotifyAction(player, this._message, this._duration, this._bgColor, this._tbColor, this._sbColor, this._colorCodes, this._showSideBar);
        Notification.sendToPlayer(player, newNotify);
    }
}

