/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player;

import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public class PlayerChangePositionEvent
extends PlayerEvent
implements Cancellable {
    private Vector3f position;
    private Quaternion rotation;
    private boolean cancelled = false;

    public PlayerChangePositionEvent(Player player, Vector3f position, Quaternion rotation) {
        super(player);
        this.position = position;
        this.rotation = rotation;
    }

    public void setPosition(Vector3f position) {
        this.setPosition(position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setRotation(Quaternion quaternion) {
        this.rotation.set(quaternion);
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

