/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.worldelements.WorldElement;
import pluginapi.manager.PluginElementManager;

public class WorldArea
extends WorldElement {
    private Area area = null;
    private boolean alwaysVisible = true;
    private boolean frameVisible = true;
    private int color = -120;

    public WorldArea(Area area) {
        this.area = area;
        this.setPositionAndRotation();
    }

    public void setArea(Area area) {
        if (this.area != area) {
            this.area = area;
            this.setPositionAndRotation();
            this.updateElement(true);
        }
    }

    public Area getArea() {
        return this.area;
    }

    public void setAlwaysVisible(boolean set) {
        if (this.alwaysVisible != set) {
            this.alwaysVisible = set;
            this.updateElement(false);
        }
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    public void setFrameVisible(boolean set) {
        if (this.frameVisible != set) {
            this.frameVisible = set;
            this.updateElement(false);
        }
    }

    public boolean isFrameVisible() {
        return this.frameVisible;
    }

    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.updateElement(false);
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.setColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public int getColor() {
        return this.color;
    }

    private void setPositionAndRotation() {
        if (this.area == null) {
            this.setPosition(0.0f, 0.0f, 0.0f);
        } else {
            this.setPosition(Utils.ChunkUtils.getGlobalPosition(this.area.getStartChunkPosition(), this.area.getStartBlockPosition(), this.position));
        }
        this.setRotation(this.rotation.loadIdentity());
    }

    private void updateElement(boolean updateArea) {
        PluginElementManager.update3DArea((WorldArea)this, (boolean)updateArea);
    }
}

