/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import net.risingworld.api.utils.Vector3f;
import pluginapi.PluginManager;

public class RayCastResult {
    private Vector3f collisionPoint;
    private Vector3f collisionNormal;
    private float distance;
    private int collisionType;
    private int collisionInfo;

    public RayCastResult() {
    }

    public RayCastResult(int type, int info, Vector3f collisionPoint, Vector3f collisionNormal, float distance) {
        this.collisionType = type;
        this.collisionInfo = info;
        this.collisionPoint = collisionPoint;
        this.collisionNormal = collisionNormal;
        this.distance = distance;
    }

    public boolean hasCollision() {
        return this.collisionPoint != null;
    }

    public int getCollisionType() {
        return this.collisionType;
    }

    public Object getCollisionObject() {
        switch (this.collisionType) {
            case 64: {
                return PluginManager.getServer().getPlayer(this.collisionInfo);
            }
            case 128: {
                return PluginManager.getWorld().getNpc(this.collisionInfo);
            }
        }
        return null;
    }

    public Vector3f getCollisionPoint() {
        return this.collisionPoint;
    }

    public Vector3f getCollisionNormal() {
        return this.collisionNormal;
    }

    public float getDistance() {
        return this.distance;
    }

    public String toString() {
        if (this.collisionPoint == null) {
            return "N/A";
        }
        return "(Type: " + this.collisionType + ", Point: " + this.collisionPoint + " (dist: " + this.distance + "), Normal: " + this.collisionNormal + ")";
    }
}

