/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.shader;

import java.io.File;
import net.risingworld.api.utils.Utils;

class Shader {
    private String name;
    private Type type;
    private String sourceCode;

    Shader(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String code) {
        this.sourceCode = code;
    }

    public boolean loadFromFile(File shaderFile) {
        String src;
        if (shaderFile.exists() && (src = Utils.FileUtils.readStringFromFile(shaderFile)) != null && !src.isEmpty()) {
            this.sourceCode = src;
            return true;
        }
        return false;
    }

    static enum Type {
        Vertex,
        Fragment,
        Geometry,
        Tessellation;

    }
}

