/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.world;

import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.BoundingInformation;
import net.risingworld.api.utils.Vector3f;

public class PlayerPlaceBlueprintEvent
extends PlayerEvent
implements Cancellable {
    BoundingInformation boundingInformation;
    int blocks;
    int constructions;
    int objects;
    boolean cancelled = false;

    public PlayerPlaceBlueprintEvent(Player player, BoundingInformation boundingInformation, int blocks, int constructions, int objects) {
        super(player);
        this.boundingInformation = boundingInformation;
        this.blocks = blocks;
        this.constructions = constructions;
        this.objects = objects;
    }

    public BoundingInformation getBoundingInformation() {
        return this.boundingInformation;
    }

    public Vector3f getPosition() {
        return this.boundingInformation.getCenter();
    }

    public float getMaxExtent() {
        float x = this.boundingInformation.getXExtent();
        float y = this.boundingInformation.getYExtent();
        float z = this.boundingInformation.getZExtent();
        if (x > y) {
            if (x > z) {
                return x;
            }
            return z;
        }
        if (z > y) {
            return z;
        }
        return y;
    }

    public int getBlockCount() {
        return this.blocks;
    }

    public int getConstructionCount() {
        return this.constructions;
    }

    public int getObjectCount() {
        return this.objects;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

