/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.world;

import commons.constructions.ConstructionElement;
import commons.world.WorldElement;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public abstract class PlayerConstructionEvent
extends PlayerEvent {
    short typeid;
    int texture;
    int cx;
    int cy;
    int cz;
    short px;
    short py;
    short pz;
    short rx;
    short ry;
    short rz;
    short sx;
    short sy;
    short sz;
    byte repetitionsh;
    byte repetitionsv;
    byte gap;
    Vector3f worldPosition = null;
    Vector3f worldSize = null;
    Quaternion worldRotation = null;

    public PlayerConstructionEvent(Player player, ConstructionElement construction) {
        this(player, construction.typeid, construction.texture, construction.chunkoffsetx, construction.chunkoffsety, construction.chunkoffsetz, construction.positionx, construction.positiony, construction.positionz, construction.rotationx, construction.rotationy, construction.rotationz, construction.sizex, construction.sizey, construction.sizez, construction.repetitionsh, construction.repetitionsv, construction.gap);
    }

    public PlayerConstructionEvent(Player player, short typeid, int texture, int cx, int cy, int cz, short px, short py, short pz, short rx, short ry, short rz, short sx, short sy, short sz, byte repetitionsh, byte repetitionsv, byte gap) {
        super(player);
        this.typeid = typeid;
        this.texture = texture;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        this.px = px;
        this.py = py;
        this.pz = pz;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.sx = sx;
        this.sy = sy;
        this.sz = sz;
        this.repetitionsh = repetitionsh;
        this.repetitionsv = repetitionsv;
        this.gap = gap;
    }

    public short getConstructionTypeID() {
        return this.typeid;
    }

    public int getConstructionTextureID() {
        return this.texture;
    }

    public int getChunkPositionX() {
        return this.cx;
    }

    public int getChunkPositionY() {
        return this.cy;
    }

    public int getChunkPositionZ() {
        return this.cz;
    }

    public Vector3f getConstructionPosition() {
        if (this.worldPosition == null) {
            this.worldPosition = new Vector3f(WorldElement.toWorldPositionX((short)this.px, (int)this.cx), WorldElement.toWorldPositionX((short)this.py, (int)this.cy), WorldElement.toWorldPositionX((short)this.pz, (int)this.cz));
        }
        return this.worldPosition;
    }

    public float getConstructionPositionX() {
        return WorldElement.toWorldPositionX((short)this.px, (int)this.cx);
    }

    public float getConstructionPositionY() {
        return WorldElement.toWorldPositionX((short)this.py, (int)this.cy);
    }

    public float getConstructionPositionZ() {
        return WorldElement.toWorldPositionX((short)this.pz, (int)this.cz);
    }

    public Quaternion getConstructionRotation() {
        if (this.worldRotation == null) {
            this.worldRotation = new Quaternion().fromAngles(WorldElement.toWorldRotation((short)this.rx), WorldElement.toWorldRotation((short)this.ry), WorldElement.toWorldRotation((short)this.rz));
        }
        return this.worldRotation;
    }

    public Vector3f getConstructionSize() {
        if (this.worldSize == null) {
            this.worldSize = new Vector3f(ConstructionElement.toWorldSize((short)this.sx), ConstructionElement.toWorldSize((short)this.sy), ConstructionElement.toWorldSize((short)this.sz));
        }
        return this.worldSize;
    }

    public float getConstructionSizeX() {
        return ConstructionElement.toWorldSize((short)this.sx);
    }

    public float getConstructionSizeY() {
        return ConstructionElement.toWorldSize((short)this.sy);
    }

    public float getConstructionSizeZ() {
        return ConstructionElement.toWorldSize((short)this.sz);
    }
}

