/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.gui;

import commons.network.packets.APIRequestFileUpload;
import java.io.File;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.gui.GuiFileBrowser;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;
import pluginapi.PluginCallbackManager;
import pluginapi.PluginException;
import pluginapi.PluginManager;
import pluginapi.manager.PluginElementManager;
import pluginapi.utils.ClientFile;

public class PlayerSelectFileEvent
extends PlayerEvent {
    private GuiFileBrowser fileBrowser;
    private String filename;
    private String path;
    private int bytes;
    private String md5;

    public PlayerSelectFileEvent(Player player, GuiFileBrowser fileBrowser, String filename, String path, int bytes, String md5) {
        super(player);
        this.fileBrowser = fileBrowser;
        this.filename = filename;
        this.path = path;
        this.bytes = bytes;
        this.md5 = md5;
    }

    public GuiFileBrowser getFileBrowserElement() {
        return this.fileBrowser;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPath() {
        return this.path;
    }

    public int getFilesize() {
        return this.bytes;
    }

    public String getChecksum() {
        return this.md5;
    }

    public void requestFileUpload(String targetDirectory, Callback<File> callback) {
        File target = new File(targetDirectory);
        if (!target.exists()) {
            target.mkdirs();
        }
        if (!target.exists() || !target.isDirectory()) {
            throw new PluginException("Target path \"" + targetDirectory + "\" invalid!");
        }
        ClientFile clientFile = PluginElementManager.getClientFile((String)target.getPath(), (String)this.filename);
        if (clientFile != null && clientFile.file != null) {
            if (Utils.FileUtils.getMd5(clientFile.file).equals(this.md5)) {
                if (callback != null) {
                    callback.onCall(clientFile.file);
                }
                return;
            }
            clientFile.file.delete();
            clientFile.file = null;
            clientFile.bytes = null;
        }
        int id = PluginCallbackManager.registerCallback(callback);
        System.out.println("RequestFileUpload: " + id + " " + this.filename + " " + this.path + " " + this.bytes + " " + this.md5);
        PluginCallbackManager.registerCallbackData((int)id, (Object)target);
        APIRequestFileUpload msg = new APIRequestFileUpload(id, this.filename, this.path, this.bytes, this.md5);
        PluginManager.sendPacket((int)this.getPlayer().getID(), (Object)msg);
    }
}

