/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player;

import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public class PlayerHitNpcEvent
extends PlayerEvent
implements Cancellable {
    private Npc npc;
    private Vector3f damagePoint;
    private short damage;
    private float distance;
    private boolean cancelled = false;

    public PlayerHitNpcEvent(Player player, Npc targetNpc, Vector3f damagePoint, short damage, float distance) {
        super(player);
        this.npc = targetNpc;
        this.damagePoint = damagePoint;
        this.damage = damage;
        this.distance = distance;
    }

    public Npc getTargetNpc() {
        return this.npc;
    }

    public void setDamagePosition(Vector3f position) {
        this.setDamagePosition(position.x, position.y, position.z);
    }

    public void setDamagePosition(float x, float y, float z) {
        this.damagePoint.set(x, y, z);
    }

    public Vector3f getDamagePosition() {
        return this.damagePoint;
    }

    public void setDamage(short damage) {
        this.damage = damage;
    }

    public short getDamage() {
        return this.damage;
    }

    public float getDistance() {
        return this.distance;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

