/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import java.util.Arrays;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public class WorldEditBatch {
    int[] batch = null;
    int pos = 0;
    static final int BATCHSIZE = 7;

    public WorldEditBatch() {
        this(10);
    }

    public WorldEditBatch(int initialCapacity) {
        this.batch = new int[initialCapacity * 7];
    }

    public void addToBatch(int id, Vector3f globalPosition) {
        int cx = Utils.ChunkUtils.getChunkPositionX(globalPosition.x);
        int cy = Utils.ChunkUtils.getChunkPositionY(globalPosition.y);
        int cz = Utils.ChunkUtils.getChunkPositionZ(globalPosition.z);
        int bx = Utils.ChunkUtils.getBlockPositionX(globalPosition.x, cx);
        int by = Utils.ChunkUtils.getBlockPositionY(globalPosition.y, cy);
        int bz = Utils.ChunkUtils.getBlockPositionZ(globalPosition.z, cz);
        this.addToBatch(id, cx, cy, cz, bx, by, bz);
    }

    public void addToBatch(int id, int cx, int cy, int cz, int bx, int by, int bz) {
        if (bx < 0 || bx >= 16 || by < 0 || by >= 64 || bz < 0 || bz >= 16) {
            System.err.println("API: WorldEditBatch index out of bounds " + bx + " " + by + " " + bz);
            return;
        }
        this.ensureCapacity();
        this.batch[this.pos++] = id;
        this.batch[this.pos++] = cx;
        this.batch[this.pos++] = cy;
        this.batch[this.pos++] = cz;
        this.batch[this.pos++] = bx;
        this.batch[this.pos++] = by;
        this.batch[this.pos++] = bz;
    }

    public void clearBatch() {
        Arrays.fill(this.batch, 0);
        this.pos = 0;
    }

    public int size() {
        return this.pos / 7;
    }

    public int position() {
        return this.pos;
    }

    public int[] getBatchData() {
        return this.batch;
    }

    public void setBatchData(int[] data, int pos) {
        this.batch = data;
        this.pos = pos;
    }

    void ensureCapacity() {
        if (this.pos + 7 > this.batch.length) {
            int[] tmp = new int[this.batch.length + 35];
            System.arraycopy(this.batch, 0, tmp, 0, this.batch.length);
            this.batch = tmp;
        }
    }
}

