/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import commons.definitions.Crafting;
import commons.definitions.Food;
import commons.definitions.Items;
import commons.definitions.MatDefs;
import commons.definitions.Npcs;
import commons.definitions.Objects;
import commons.definitions.Plants;
import commons.definitions.Records;
import commons.definitions.Weapons;
import commons.mesh.MeshInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.risingworld.api.utils.GameImageInformation;

public abstract class Definitions {
    public static ItemDefinition getItemDefinition(short typeID) {
        Items.ItemDefinition def = Items.getItemDefinition((short)typeID);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new ItemDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static ItemDefinition getItemDefinition(String name) {
        Items.ItemDefinition def = Items.getItemDefinition((String)name);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new ItemDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static List<ItemDefinition> getAllItemDefinitions() {
        Collection defs = Items.getAllItemDefinitions();
        ArrayList<ItemDefinition> list = new ArrayList<ItemDefinition>(defs.size());
        for (Items.ItemDefinition def : defs) {
            if (def == null) continue;
            if (def.apiDef == null) {
                def.apiDef = new ItemDefinition(def);
            }
            list.add(def.apiDef);
        }
        return list;
    }

    public static ObjectDefinition getObjectDefinition(short typeID) {
        Objects.ObjectDefinition def = Objects.getObjectDefinition((short)typeID);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new ObjectDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static ObjectDefinition getObjectDefinition(String name) {
        Objects.ObjectDefinition def = Objects.getObjectDefinition((String)name);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new ObjectDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static List<ObjectDefinition> getAllObjectDefinitions() {
        Collection defs = Objects.getAllObjectDefinitions();
        ArrayList<ObjectDefinition> list = new ArrayList<ObjectDefinition>(defs.size());
        for (Objects.ObjectDefinition def : defs) {
            if (def == null) continue;
            if (def.apiDef == null) {
                def.apiDef = new ObjectDefinition(def);
            }
            list.add(def.apiDef);
        }
        return list;
    }

    public static PlantDefinition getPlantDefinition(short typeID) {
        Plants.PlantDefinition def = Plants.getPlantDefinition((short)typeID);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new PlantDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static PlantDefinition getPlantDefinition(String name) {
        Plants.PlantDefinition def = Plants.getPlantDefinition((String)name);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new PlantDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static List<PlantDefinition> getAllPlantDefinitions() {
        Collection defs = Plants.getAllPlantDefinitions();
        ArrayList<PlantDefinition> list = new ArrayList<PlantDefinition>(defs.size());
        for (Plants.PlantDefinition def : defs) {
            if (def == null) continue;
            if (def.apiDef == null) {
                def.apiDef = new PlantDefinition(def);
            }
            list.add(def.apiDef);
        }
        return list;
    }

    public static NpcDefinition getNpcDefinition(short typeID) {
        Npcs.NpcDefinition def = Npcs.getNpcDefinition((short)typeID);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new NpcDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static NpcDefinition getNpcDefinition(String name) {
        Npcs.NpcDefinition def = Npcs.getNpcDefinition((String)name);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new NpcDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static List<NpcDefinition> getAllNpcDefinitions() {
        Collection defs = Npcs.getAllNpcDefinitions();
        ArrayList<NpcDefinition> list = new ArrayList<NpcDefinition>(defs.size());
        for (Npcs.NpcDefinition def : defs) {
            if (def == null) continue;
            if (def.apiDef == null) {
                def.apiDef = new NpcDefinition(def);
            }
            list.add(def.apiDef);
        }
        return list;
    }

    public static ChestDefinition getChestDefinition(short objectID) {
        Objects.ChestDefinition def = Objects.getChestDefinition((short)objectID);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new ChestDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static FurnaceDefinition getFurnaceDefinition(short objectID) {
        Objects.FurnaceDefinition def = Objects.getFurnaceDefinition((short)objectID);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new FurnaceDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static Recipe getRecipe(String itemName, int itemTexture) {
        Crafting.Recipe def = Crafting.getRecipe((String)itemName, (int)itemTexture);
        if (def == null) {
            return null;
        }
        if (def.apiRecipe == null) {
            def.apiRecipe = new Recipe(def);
            return def.apiRecipe;
        }
        return def.apiRecipe;
    }

    public static CraftingStation getCraftingStation(String name) {
        Crafting.CraftingStation def = Crafting.getCraftingStation((String)name);
        if (def == null) {
            return null;
        }
        if (def.apiCraftingStation == null) {
            def.apiCraftingStation = new CraftingStation(def);
            return def.apiCraftingStation;
        }
        return def.apiCraftingStation;
    }

    public static MusicDiscInfo getMusicDiscInfo(int id) {
        Records.MusicInfo def = Records.getMusicInfo((int)id);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new MusicDiscInfo(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static FoodDefinition getFoodDefinition(short typeID) {
        Food.FoodDefinition def = Food.getFoodDefinition((short)typeID);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new FoodDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static FoodDefinition getFoodDefinition(String name) {
        Food.FoodDefinition def = Food.getFoodDefinition((String)name);
        if (def == null) {
            return null;
        }
        if (def.apiDef == null) {
            def.apiDef = new FoodDefinition(def);
            return def.apiDef;
        }
        return def.apiDef;
    }

    public static List<FoodDefinition> getAllFoodDefinitions() {
        Collection defs = Food.getAllFoodDefinitions();
        ArrayList<FoodDefinition> list = new ArrayList<FoodDefinition>(defs.size());
        for (Food.FoodDefinition def : defs) {
            if (def == null) continue;
            if (def.apiDef == null) {
                def.apiDef = new FoodDefinition(def);
            }
            list.add(def.apiDef);
        }
        return list;
    }

    public static class WeaponDefinition {
        private Weapons.WeaponDefinition def;

        WeaponDefinition(Weapons.WeaponDefinition weaponDef) {
            this.def = weaponDef;
        }

        public int getDamage() {
            return this.def.damage;
        }
    }

    public static class FoodDefinition {
        private Food.FoodDefinition def;

        FoodDefinition(Food.FoodDefinition foodDef) {
            this.def = foodDef;
        }

        public int getHealthRestoreAmount() {
            return this.def.healthrestore;
        }

        public int getHungerRestoreAmount() {
            return this.def.hungerrestore;
        }

        public int getThirstRestoreAmount() {
            return this.def.thirstrestore;
        }

        public boolean healsBrokenbones() {
            return this.def.healBrokenbones;
        }

        public boolean stopsBleeding() {
            return this.def.stopBleeding;
        }

        public boolean removeOnUse() {
            return this.def.remove;
        }

        public float getValueChangePerUse() {
            return this.def.valuechange;
        }

        public boolean isEnvironmental() {
            return this.def.environmental;
        }
    }

    public static class NpcDefinition {
        private Npcs.NpcDefinition def;

        NpcDefinition(Npcs.NpcDefinition npcDef) {
            this.def = npcDef;
        }

        public int getID() {
            return this.def.id;
        }

        public String getName() {
            return this.def.name;
        }

        public String getNpcType() {
            return this.def.type.name();
        }

        public short getHealth() {
            return this.def.health;
        }

        public float getAttackRange() {
            return this.def.attackrange;
        }

        public float getAggroRadius() {
            return this.def.aggroradius;
        }

        public float getWalkspeed() {
            return this.def.walkspeed;
        }

        public boolean hasWalkAnimation() {
            return this.def.haswalkanimation;
        }

        public float getRunspeed() {
            return this.def.runspeed;
        }

        public int getAttackDamage() {
            return this.def.hitdamage;
        }

        public String getBehaviour() {
            return this.def.behaviour.name();
        }

        public String getAttackReaction() {
            return this.def.attackreaction.name();
        }
    }

    public static class MusicDiscInfo {
        private Records.MusicInfo def;

        MusicDiscInfo(Records.MusicInfo musicInfo) {
            this.def = musicInfo;
        }

        public int getID() {
            return this.def.id;
        }

        public String getTitle() {
            return this.def.title;
        }

        public String getComposer() {
            return this.def.composer;
        }

        public int getDuration() {
            return this.def.duration;
        }

        public short getRelatedItemID() {
            return this.def.relateditem.id;
        }

        public int getRelatedItemTextureID() {
            return this.def.textureid;
        }

        public String getRelatedItemName() {
            return this.def.relateditem.name;
        }

        public ItemDefinition getRelatedItemDefinition() {
            return Definitions.getItemDefinition(this.def.relateditem.id);
        }
    }

    public static class CraftingStation {
        private Crafting.CraftingStation def;
        private ObjectDefinition relatedObject = null;
        private Recipe[] recipes = null;

        CraftingStation(Crafting.CraftingStation craftingStation) {
            this.def = craftingStation;
        }

        public Recipe[] getRecipes() {
            if (this.recipes != null) {
                return this.recipes;
            }
            Recipe[] r = new Recipe[this.def.recipes.size()];
            for (int i = 0; i < this.def.recipes.size(); ++i) {
                Crafting.Recipe recipe = (Crafting.Recipe)this.def.recipes.get(i);
                r[i] = Definitions.getRecipe(recipe.targetItem.name, recipe.targetItemTexture);
            }
            this.recipes = r;
            return r;
        }

        public short getObjectID() {
            if (this.relatedObject == null) {
                this.relatedObject = Definitions.getObjectDefinition(this.def.relatedObject);
            }
            return this.relatedObject.getID();
        }

        public String getObjectName() {
            if (this.relatedObject == null) {
                this.relatedObject = Definitions.getObjectDefinition(this.def.relatedObject);
            }
            return this.relatedObject.getName();
        }

        public ObjectDefinition getObjectDefinition() {
            if (this.relatedObject == null) {
                this.relatedObject = Definitions.getObjectDefinition(this.def.relatedObject);
            }
            return this.relatedObject;
        }
    }

    public static class Recipe {
        private Crafting.Recipe def;
        private Ingredient[] ingredients;

        Recipe(Crafting.Recipe recipe) {
            this.def = recipe;
        }

        public int getID() {
            return this.def.id;
        }

        public short getTargetItemID() {
            return this.def.targetItem.id;
        }

        public String getTargetItemName() {
            return this.def.targetItem.name;
        }

        public ItemDefinition getTargetItemDefinition() {
            return Definitions.getItemDefinition(this.def.targetItem.id);
        }

        public Ingredient[] getIngredients() {
            if (this.ingredients != null) {
                return this.ingredients;
            }
            Ingredient[] ing = new Ingredient[this.def.numberOfIngredients];
            for (int i = 0; i < this.def.numberOfIngredients; ++i) {
                Crafting.Recipe.Ingredient ingredient = this.def.ingredients[i];
                if (ingredient.apiIngredient == null) {
                    ingredient.apiIngredient = new Ingredient(ingredient);
                }
                ing[i] = ingredient.apiIngredient;
            }
            this.ingredients = ing;
            return ing;
        }

        public Ingredient getIngredient(int index) {
            if (index >= 0 && index < this.def.numberOfIngredients) {
                Crafting.Recipe.Ingredient ingredient = this.def.ingredients[index];
                if (ingredient.apiIngredient == null) {
                    ingredient.apiIngredient = new Ingredient(ingredient);
                }
                return ingredient.apiIngredient;
            }
            return null;
        }

        public int getIngredientCount() {
            return this.def.numberOfIngredients;
        }

        public String getCategory() {
            return this.def.category;
        }

        public static String[] getAllCategories() {
            ArrayList categories = Crafting.getAllCraftingCategories();
            return categories.toArray(new String[categories.size()]);
        }

        public static class Ingredient {
            private Crafting.Recipe.Ingredient def;

            Ingredient(Crafting.Recipe.Ingredient ingredient) {
                this.def = ingredient;
            }

            public String getGroup() {
                return this.def.group;
            }

            public short getRelatedItemID() {
                return this.def.itemDef.id;
            }

            public int getRelatedItemTextureID() {
                return this.def.texture;
            }

            public String getRelatedItemName() {
                return this.def.itemDef.name;
            }

            public ItemDefinition getRelatedItemDefinition() {
                return Definitions.getItemDefinition(this.def.itemDef.id);
            }

            public boolean isConsumed() {
                return this.def.waste;
            }
        }
    }

    public static class FurnaceDefinition {
        private Objects.FurnaceDefinition def;

        FurnaceDefinition(Objects.FurnaceDefinition furnaceDef) {
            this.def = furnaceDef;
        }

        public boolean requiresFuel() {
            return this.def.requiresfuel;
        }

        public short getObjectID() {
            return this.def.relatedObject.id;
        }

        public String getObjectName() {
            return this.def.relatedObject.name;
        }

        public ObjectDefinition getObjectDefinition() {
            return Definitions.getObjectDefinition(this.def.relatedObject.id);
        }
    }

    public static class ChestDefinition {
        private Objects.ChestDefinition def;

        ChestDefinition(Objects.ChestDefinition chestDef) {
            this.def = chestDef;
        }

        public int getSlots() {
            return this.def.slots;
        }

        public short getObjectID() {
            return this.def.objectDefinition.id;
        }

        public String getObjectName() {
            return this.def.objectDefinition.name;
        }

        public ObjectDefinition getObjectDefinition() {
            return Definitions.getObjectDefinition(this.def.objectDefinition.id);
        }
    }

    public static class ItemDefinition {
        private Items.ItemDefinition def;

        ItemDefinition(Items.ItemDefinition itemDef) {
            this.def = itemDef;
        }

        public short getID() {
            return this.def.id;
        }

        public String getName() {
            return this.def.name;
        }

        public String getType() {
            return this.def.itemtype.name();
        }

        public boolean isEquipmentItem() {
            return this.def.isEquipment;
        }

        public boolean isAmmoItem() {
            return this.def.isAmmo;
        }

        public boolean isArmorItem() {
            return false;
        }

        public int getStrength() {
            return this.def.strength;
        }

        public int getMaxStacksize() {
            return this.def.stacksize;
        }

        public int getVariationCount() {
            return this.def.variations;
        }
    }

    public static class PlantDefinition {
        private Plants.PlantDefinition def;

        PlantDefinition(Plants.PlantDefinition plantDef) {
            this.def = plantDef;
        }

        public short getID() {
            return this.def.id;
        }

        public String getName() {
            return this.def.name;
        }

        public int getStrength() {
            return this.def.strength;
        }

        public boolean isPickupable() {
            return this.def.isPickable;
        }

        public boolean hasBirds() {
            return this.def.hasbirds;
        }

        public boolean isGrowable() {
            return this.def.canGrow;
        }

        public int getGrowthTime() {
            return this.def.growTime;
        }

        public String getNextGrowthStage() {
            return this.def.nextGrowStage;
        }

        public boolean hasRandomGrowthRotation() {
            return this.def.randomGrowRotation;
        }

        public boolean hasCollision() {
            return this.def.hasCollision;
        }
    }

    public static class ObjectDefinition {
        private Objects.ObjectDefinition def;

        ObjectDefinition(Objects.ObjectDefinition objectDef) {
            this.def = objectDef;
        }

        public short getID() {
            return this.def.id;
        }

        public String getName() {
            return this.def.name;
        }

        public String getType() {
            return this.def.objecttype.name();
        }

        public boolean hasCollision() {
            return this.def.hasCollision;
        }

        public int getVariationCount() {
            return this.def.variationcount;
        }

        public String getRelatedItem() {
            return this.def.relateditem;
        }

        public boolean isPickupable() {
            return this.def.pickupable;
        }

        public boolean isChest() {
            return this.def.objecttype == Objects.ObjectType.CHEST;
        }

        public boolean isFurnace() {
            return this.def.objecttype == Objects.ObjectType.FURNACE;
        }

        public boolean isDoor() {
            return this.def.objecttype == Objects.ObjectType.DOOR || this.def.objecttype == Objects.ObjectType.DRAWBRIDGE;
        }

        public boolean isSign() {
            return this.def.objecttype == Objects.ObjectType.SIGN;
        }

        public GameImageInformation getTexture(int number, int variation) {
            if (variation < 0 || variation > this.def.variations.length) {
                return null;
            }
            Objects.ObjectDefinition.Variation var = this.def.getVariation(variation);
            if (var != null && var.meshInfos.size() > number) {
                String texturename;
                MatDefs.ObjectMaskMaterial mat;
                String type;
                MeshInfo info = (MeshInfo)var.meshInfos.get(number);
                if (info.masked) {
                    type = "Objects/Mask";
                    mat = MatDefs.ObjectMaskMaterial.values()[info.textureindex];
                    texturename = mat.name();
                } else {
                    type = "Objects";
                    mat = MatDefs.ObjectMaterial.values()[info.textureindex];
                    texturename = mat.name();
                }
                int index = texturename.lastIndexOf(95);
                if (index < 0) {
                    return null;
                }
                texturename = texturename.substring(0, index).toLowerCase() + "_material" + texturename.substring(index);
                return new GameImageInformation(type, texturename);
            }
            return null;
        }

        public int getTextureCount(int variation) {
            if (variation < 0 || variation > this.def.variations.length) {
                return 0;
            }
            Objects.ObjectDefinition.Variation var = this.def.getVariation(variation);
            if (var != null) {
                return var.meshInfos.size();
            }
            return 0;
        }
    }
}

