/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import java.util.concurrent.atomic.AtomicInteger;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;

public class Area {
    public static final Area INFINITE;
    int globalID = id_counter.getAndIncrement();
    Vector3i startChunk;
    Vector3i startBlock;
    Vector3i endChunk;
    Vector3i endBlock;
    private static final AtomicInteger id_counter;

    public Area() {
        this.startChunk = new Vector3i();
        this.startBlock = new Vector3i();
        this.endChunk = new Vector3i();
        this.endBlock = new Vector3i();
    }

    public Area(Vector3i startChunk, Vector3i startBlock, Vector3i endChunk, Vector3i endBlock) {
        this.startChunk = new Vector3i(startChunk);
        this.startBlock = new Vector3i(startBlock);
        this.endChunk = new Vector3i(endChunk);
        this.endBlock = new Vector3i(endBlock);
        this.rearrange();
    }

    public Area(int startcx, int startcy, int startcz, int startbx, int startby, int startbz, int endcx, int endcy, int endcz, int endbx, int endby, int endbz) {
        this.startChunk = new Vector3i(startcx, startcy, startcz);
        this.startBlock = new Vector3i(startbx, startby, startbz);
        this.endChunk = new Vector3i(endcx, endcy, endcz);
        this.endBlock = new Vector3i(endbx, endby, endbz);
        this.rearrange();
    }

    public Area(Vector3f globalStartPosition, Vector3f globalEndPosition) {
        this.startChunk = new Vector3i();
        this.startBlock = new Vector3i();
        this.endChunk = new Vector3i();
        this.endBlock = new Vector3i();
        Utils.ChunkUtils.getChunkAndBlockPosition(globalStartPosition, this.startChunk, this.startBlock);
        Utils.ChunkUtils.getChunkAndBlockPosition(globalEndPosition, this.endChunk, this.endBlock);
        this.rearrange();
    }

    public Vector3i getStartChunkPosition() {
        return this.startChunk;
    }

    public Vector3i getStartBlockPosition() {
        return this.startBlock;
    }

    public Vector3i getEndChunkPosition() {
        return this.endChunk;
    }

    public Vector3i getEndBlockPosition() {
        return this.endBlock;
    }

    public int getID() {
        return this.globalID;
    }

    public boolean rearrange() {
        int bz;
        int cz;
        int by;
        int cy;
        int bx;
        int cx;
        boolean arrange = false;
        if (this.startChunk.x == this.endChunk.x) {
            if (this.startBlock.x > this.endBlock.x) {
                cx = this.endChunk.x;
                bx = this.endBlock.x;
                this.endChunk.x = this.startChunk.x;
                this.endBlock.x = this.startBlock.x;
                this.startChunk.x = cx;
                this.startBlock.x = bx;
                arrange = true;
            }
        } else if (this.startChunk.x > this.endChunk.x) {
            cx = this.endChunk.x;
            bx = this.endBlock.x;
            this.endChunk.x = this.startChunk.x;
            this.endBlock.x = this.startBlock.x;
            this.startChunk.x = cx;
            this.startBlock.x = bx;
            arrange = true;
        }
        if (this.startChunk.y == this.endChunk.y) {
            if (this.startBlock.y > this.endBlock.y) {
                cy = this.endChunk.y;
                by = this.endBlock.y;
                this.endChunk.y = this.startChunk.y;
                this.endBlock.y = this.startBlock.y;
                this.startChunk.y = cy;
                this.startBlock.y = by;
                arrange = true;
            }
        } else if (this.startChunk.y > this.endChunk.y) {
            cy = this.endChunk.y;
            by = this.endBlock.y;
            this.endChunk.y = this.startChunk.y;
            this.endBlock.y = this.startBlock.y;
            this.startChunk.y = cy;
            this.startBlock.y = by;
            arrange = true;
        }
        if (this.startChunk.z == this.endChunk.z) {
            if (this.startBlock.z > this.endBlock.z) {
                cz = this.endChunk.z;
                bz = this.endBlock.z;
                this.endChunk.z = this.startChunk.z;
                this.endBlock.z = this.startBlock.z;
                this.startChunk.z = cz;
                this.startBlock.z = bz;
                arrange = true;
            }
        } else if (this.startChunk.z > this.endChunk.z) {
            cz = this.endChunk.z;
            bz = this.endBlock.z;
            this.endChunk.z = this.startChunk.z;
            this.endBlock.z = this.startBlock.z;
            this.startChunk.z = cz;
            this.startBlock.z = bz;
            arrange = true;
        }
        return arrange;
    }

    public boolean isPointInArea(Vector3f point) {
        return this.isPointInArea(point.x, point.y, point.z);
    }

    public boolean isPointInArea(int chunkx, int chunky, int chunkz, int blockx, int blocky, int blockz) {
        return this.isPointInArea((float)(chunkx * 16 + blockx) + 0.5f, (float)(chunky * 64 + blocky) + 0.5f, (float)(chunkz * 16 + blockz) + 0.5f);
    }

    public boolean isPointInArea(float x, float y, float z) {
        this.rearrange();
        float sx = this.startChunk.x * 16 + this.startBlock.x;
        float sy = this.startChunk.y * 64 + this.startBlock.y;
        float sz = this.startChunk.z * 16 + this.startBlock.z;
        float ex = this.endChunk.x * 16 + this.endBlock.x;
        float ey = this.endChunk.y * 64 + this.endBlock.y;
        float ez = this.endChunk.z * 16 + this.endBlock.z;
        return x >= sx && x < ex + 1.0f && y >= sy && y < ey + 1.0f && z >= sz && z < ez + 1.0f;
    }

    public boolean intersects(Area area) {
        this.rearrange();
        area.rearrange();
        float sx1 = this.startChunk.x * 16 + this.startBlock.x;
        float sy1 = this.startChunk.y * 64 + this.startBlock.y;
        float sz1 = this.startChunk.z * 16 + this.startBlock.z;
        float ex1 = this.endChunk.x * 16 + this.endBlock.x;
        float ey1 = this.endChunk.y * 64 + this.endBlock.y;
        float ez1 = this.endChunk.z * 16 + this.endBlock.z;
        float sx2 = area.startChunk.x * 16 + area.startBlock.x;
        float sy2 = area.startChunk.y * 64 + area.startBlock.y;
        float sz2 = area.startChunk.z * 16 + area.startBlock.z;
        float ex2 = area.endChunk.x * 16 + area.endBlock.x;
        float ey2 = area.endChunk.y * 64 + area.endBlock.y;
        float ez2 = area.endChunk.z * 16 + area.endBlock.z;
        return (sx1 >= sx2 && sx1 <= ex2 || ex1 >= sx2 && ex1 <= ex2) && (sy1 >= sy2 && sy1 <= ey2 || ey1 >= sy2 && ey1 <= ey2) && (sz1 >= sz2 && sz1 <= ez2 || ez1 >= sz2 && ez1 <= ez2);
    }

    public String toString() {
        return "(" + this.startChunk + ", " + this.startBlock + ", " + this.endChunk + ", " + this.endBlock + ")";
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Area)) {
            return false;
        }
        Area compare = (Area)o;
        return this.globalID == compare.globalID;
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + this.globalID;
        return hash;
    }

    static {
        id_counter = new AtomicInteger();
        INFINITE = new Area(-134217727, -33554431, -134217727, 0, 0, 0, 0x7FFFFFF, 0x1FFFFFF, 0x7FFFFFF, 15, 63, 15);
    }
}

