/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.Utils;
import pluginapi.manager.PluginGuiManager;

public abstract class GuiElement {
    int id;
    PivotPosition pivot = PivotPosition.BottomLeft;
    GuiElement parent = null;
    private ArrayList<GuiElement> childs = null;
    float positionx = 0.0f;
    float positiony = 0.0f;
    boolean relativeposition = false;
    float sizex = 0.0f;
    float sizey = 0.0f;
    boolean relativesize = false;
    int color = -1;
    float borderthickness = 0.0f;
    boolean borderthicknessrelative = false;
    int bordercolor = 255;
    float alpha = 1.0f;
    boolean mipmapping = true;
    boolean clickable = false;
    boolean visible = true;
    int hovercolor = -1;
    boolean useScreenmask = false;
    ImageInformation screenmaskTexture = null;
    private static AtomicInteger id_counter = new AtomicInteger();

    GuiElement(float x, float y, boolean relativeposition, float width, float height, boolean relativesize) {
        this.id = id_counter.getAndIncrement();
        this.positionx = x;
        this.positiony = y;
        this.relativeposition = relativeposition;
        this.sizex = width;
        this.sizey = height;
        this.relativesize = relativesize;
    }

    public void setPosition(float x, float y, boolean relative) {
        if (this.positionx != x || this.positiony != y || this.relativeposition != relative) {
            this.positionx = x;
            this.positiony = y;
            this.relativeposition = relative;
            this.updateElement();
        }
    }

    public float getPositionX() {
        return this.positionx;
    }

    public float getPositionY() {
        return this.positiony;
    }

    public boolean isRelativePosition() {
        return this.relativeposition;
    }

    public void setSize(float width, float height, boolean relative) {
        if (this.sizex != width || this.sizey != height || this.relativesize != relative) {
            this.sizex = width;
            this.sizey = height;
            this.relativesize = relative;
            this.updateElement();
        }
    }

    public float getWidth() {
        return this.sizex;
    }

    public float getHeight() {
        return this.sizey;
    }

    public boolean isRelativeSize() {
        return this.relativesize;
    }

    public void setPivot(PivotPosition pivot) {
        if (this.pivot != pivot) {
            this.pivot = pivot;
            this.updateElement();
        }
    }

    public PivotPosition getPivot() {
        return this.pivot;
    }

    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.updateElement();
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.setColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public int getColor() {
        return this.color;
    }

    public void setBorderThickness(float thickness, boolean relative) {
        if (this.borderthickness != thickness || this.borderthicknessrelative != relative) {
            this.borderthickness = thickness;
            this.borderthicknessrelative = relative;
            this.updateElement();
        }
    }

    public float getBorderThickness() {
        return this.borderthickness;
    }

    public boolean isRelativeBorderThickness() {
        return this.borderthicknessrelative;
    }

    public void setBorderColor(int color) {
        if (this.bordercolor != color) {
            this.bordercolor = color;
            this.updateElement();
        }
    }

    public void setBorderColor(float r, float g, float b, float a) {
        this.setBorderColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public int getBorderColor() {
        return this.bordercolor;
    }

    public void setAlpha(float alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.updateElement();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getID() {
        return this.id;
    }

    void setClickable(boolean set) {
        if (this.clickable != set) {
            this.clickable = set;
            this.updateElement();
        }
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setVisible(boolean set) {
        if (this.visible != set) {
            this.visible = set;
            PluginGuiManager.updateGuiVisibility((int)this.id, (boolean)this.visible);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setScreenmask(ImageInformation screenmask) {
        if (this.screenmaskTexture != screenmask) {
            this.screenmaskTexture = screenmask;
        }
    }

    public void destroy() {
        PluginGuiManager.destroyElement((GuiElement)this);
    }

    public void addChild(GuiElement child) {
        if (child == this) {
            throw new IllegalStateException("Cannot add gui element to itself");
        }
        if (this.childs == null) {
            this.childs = new ArrayList(1);
        }
        this.childs.add(child);
        child.setParent(this);
        child.updateParent();
    }

    public void removeChild(GuiElement child) {
        if (this.childs == null) {
            return;
        }
        this.childs.remove(child);
        child.setParent(null);
        child.updateParent();
    }

    public List<GuiElement> getChildren() {
        return Collections.unmodifiableList(this.childs);
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    private void setParent(GuiElement parent) {
        this.parent = parent;
    }

    public GuiElement getParent() {
        return this.parent;
    }

    public int getParentID() {
        return this.parent == null ? -1 : this.parent.getID();
    }

    public int getHoverColor() {
        return this.hovercolor;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof GuiElement)) {
            return false;
        }
        GuiElement compare = (GuiElement)o;
        return this.id == compare.id;
    }

    public int hashCode() {
        return 497 + this.id;
    }

    public void refresh() {
        this.updateElement();
    }

    private void updateElement() {
        PluginGuiManager.updateGuiElement((GuiElement)this);
    }

    private void updateParent() {
        PluginGuiManager.updateGuiParent((GuiElement)this, (GuiElement)this.parent);
    }
}

