/*
 * Decompiled with CFR 0.152.
 */
package SyBozz.RisingWorld.HungerWarn;

import SyBozz.RisingWorld.Notify.Notification;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.events.Listener;
import net.risingworld.api.objects.Player;

public class Main
extends Plugin
implements Listener {
    private Timer _updateTimer;
    private String _hungerIdent = "HungerWarn-Player-Hunger";
    private String _thirstIdent = "HungerWarn-Player-Thirst";

    @Override
    public void onEnable() {
        this.registerEventListener(this);
        new Timer(0.0f, 2.0f, 1, this::checkForNotify).start();
    }

    @Override
    public void onDisable() {
    }

    private void checkForNotify() {
        boolean found = false;
        System.out.println("------------------------------------------------------------------------------------------------------------------");
        for (Plugin plugin : this.getAllPlugins()) {
            if (!plugin.getDescription("name").equals("Notify")) continue;
            found = true;
            break;
        }
        if (found) {
            this.cOuttput("Found the Notify Plugin.");
            this.start();
        } else {
            this.cOuttput("ERROR Notify plugin not found.");
        }
    }

    private void start() {
        if (this._updateTimer == null) {
            this._updateTimer = new Timer(3.0f, 0.0f, -1, this::updatePlayer);
        }
        if (!this._updateTimer.isActive()) {
            this._updateTimer.start();
        }
    }

    void cOuttput(String message) {
        System.out.println("[HungerWarn] " + message);
    }

    private void updatePlayer() {
        for (Player player : this.getServer().getAllPlayers()) {
            if (!player.hasAttribute(this._hungerIdent)) {
                player.setAttribute(this._hungerIdent, 100);
            }
            if (player.getHunger() > (Integer)player.getAttribute(this._hungerIdent)) {
                player.setAttribute(this._hungerIdent, player.getHunger());
            }
            if (!player.hasAttribute(this._thirstIdent)) {
                player.setAttribute(this._thirstIdent, 100);
            }
            if (player.getThirst() > (Integer)player.getAttribute(this._thirstIdent)) {
                player.setAttribute(this._thirstIdent, player.getThirst());
            }
            int hunger = (Integer)player.getAttribute(this._hungerIdent);
            int thirst = (Integer)player.getAttribute(this._thirstIdent);
            if (player.getHunger() <= 30 && hunger > 30) {
                Notification.sendToPlayer((Player)player, (String)"You're hungry.");
                player.setAttribute(this._hungerIdent, 30);
            } else if (player.getHunger() <= 20 && hunger > 20) {
                Notification.sendToPlayer((Player)player, (String)"You're very hungry.");
                player.setAttribute(this._hungerIdent, 20);
            } else if (player.getHunger() <= 10 && hunger > 10) {
                Notification.sendToPlayer((Player)player, (String)"You're very, very hungry.");
                player.setAttribute(this._hungerIdent, 10);
            } else if (player.getHunger() <= 5 && hunger > 5) {
                Notification.sendToPlayer((Player)player, (String)"You're seriously hungry.");
                player.setAttribute(this._hungerIdent, 5);
            }
            if (player.getThirst() <= 30 && thirst > 30) {
                Notification.sendToPlayer((Player)player, (String)"You're thirsty.");
                player.setAttribute(this._thirstIdent, 30);
                continue;
            }
            if (player.getThirst() <= 20 && thirst > 20) {
                Notification.sendToPlayer((Player)player, (String)"You're very thirsty.");
                player.setAttribute(this._thirstIdent, 20);
                continue;
            }
            if (player.getThirst() <= 10 && thirst > 10) {
                Notification.sendToPlayer((Player)player, (String)"You're very, very thirsty.");
                player.setAttribute(this._thirstIdent, 10);
                continue;
            }
            if (player.getThirst() > 5 || thirst <= 5) continue;
            Notification.sendToPlayer((Player)player, (String)"You're seriously thirsty.");
            player.setAttribute(this._thirstIdent, 5);
        }
    }
}

