/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.WorldGardListener;
import de.pbplugins.WorldGardListenerCommand;
import de.pbplugins.WorldGardListenerPlayer;
import de.pbplugins.WorldGardListenerPlayerWorld;
import de.pbplugins.WorldGardStartErrorListener;
import de.pbplugins.tools.classColorSet;
import de.pbplugins.tools.classDimension;
import de.pbplugins.tools.classWorldArea;
import de.pbplugins.tools.wgCRT;
import de.pbplugins.tools.wgConfig;
import de.pbplugins.wgArea;
import de.pbplugins.wgClassText;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.objects.Player;

public class WorldGard
extends Plugin {
    private WorldGard plugin;
    private Server server;
    private World world;
    private Database sqlite;
    private String sSQLite;
    private int debug = 1;
    private wgConfig sysConfig;
    private wgConfig colConfig;
    classColorSet wgCol = new classColorSet();
    private wgClassText textDaten;
    private wgArea area;
    wgConfig woldConfig;
    ArrayList<String> strList = new ArrayList();
    String playerNoFlyCound;

    public Database getSqlite() {
        return this.sqlite;
    }

    public int getDebug() {
        return this.debug;
    }

    public wgConfig getSysConfig() {
        return this.sysConfig;
    }

    public wgClassText getTextDaten() {
        return this.textDaten;
    }

    public wgArea getAreaDaten() {
        return this.area;
    }

    public void onEnable() {
        System.out.println("[WorldGard] Enabled");
        this.plugin = this;
        if (this.plugin.getPluginByName("SprachAPI") != null) {
            this.server = this.getServer();
            this.world = this.getWorld();
            this.sSQLite = this.getPath() + "/database/" + this.getDescription("name") + "-" + this.world.getName() + ".db";
            this.sqlite = this.getSQLiteConnection(this.sSQLite);
            this.playerNoFlyCound = this.plugin.getDescription("name") + "_playerNoFlyCound";
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] Verbindung zur Datenbank wurde hergestellt! ");
            }
            this.initDB();
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] Datenbank initalisiert! ");
            }
            String[][] sysConfigArray = new String[][]{{"KEY_GUI", "KEY_B"}, {"KEY_AreaSelect", "KEY_RETURN"}, {"KEY_AreaCancle", "KEY_ESCAPE"}, {"Debug", "1"}, {"AccesAllAdmin", "true"}, {"AccesAllUser", "true"}, {"WorldAsArea", "true"}, {"COMMAND_world_Group", ""}, {"COMMAND_RemoveAreaByOwner", "true"}, {"COMMAND_RemoveArea_Group", ""}, {"COMMAND_Setowner_Group", ""}, {"COMMAND_AddCategory_Group", ""}, {"COMMAND_Setparent_Group", ""}, {"COMMAND_Setparent_ParentOwner", "true"}, {"COMMAND_Editconfig_Group", ""}, {"COMMAND_Editdefault_Group", ""}, {"COMMAND_flag_Owner", "false"}, {"COMMAND_flag_ParentOwner", "true"}, {"COMMAND_flag_Group", ""}, {"COMMAND_define_Group", "false"}, {"COMMAND_define_ParentOwner", "false"}};
            this.sysConfig = new wgConfig("System", sysConfigArray, this, this.debug);
            this.debug = Integer.parseInt(this.sysConfig.getValue("Debug"));
            String[][] colConfigArray = new String[][]{{"cmdCommando", "[#ffa500]"}, {"cmdParameter1", "[#00d278]"}, {"cmdParameter2", "[#a4ffa4]"}, {"cmdHelp", "[#ffffc0]"}, {"cmdInfo", "[#00a5ff]"}, {"cmdError", "[#ffaaaa]"}, {"cmdOK", "[#aaffaa]"}, {"cmdNormal", "[#ffffff]"}};
            this.colConfig = new wgConfig("Color", colConfigArray, this, this.debug);
            this.wgCol.N = this.colConfig.getValue("cmdNormal");
            this.wgCol.F = this.colConfig.getValue("cmdError");
            this.wgCol.OK = this.colConfig.getValue("cmdOK");
            this.wgCol.H1 = this.colConfig.getValue("cmdCommando");
            this.wgCol.H2 = this.colConfig.getValue("cmdParameter1");
            this.wgCol.H3 = this.colConfig.getValue("cmdParameter2");
            this.wgCol.H4 = this.colConfig.getValue("cmdHelp");
            this.wgCol.H5 = this.colConfig.getValue("cmdInfo");
            String[][] woldConfigArray = new String[][]{{"Enter", "true"}, {"EnterGroup", ""}, {"EnterPlayer", ""}, {"Leave", "true"}, {"LeaveGroup", ""}, {"LeavePlayer", ""}, {"ChestAccess", "false"}, {"ChestAccessGroup", ""}, {"ChestAccessPlayer", ""}, {"ChestToInv", "false"}, {"ChestToInvGroup", ""}, {"ChestToInvPlayer", ""}, {"InvToChest", "false"}, {"InvToChestGroup", ""}, {"InvToChestPlayer", ""}, {"ChestDrop", "false"}, {"ChestDropGroup", ""}, {"ChestDropPlayer", ""}, {"Chat", "1"}, {"ChatGroup", ""}, {"ChatPlayer", ""}, {"Command", "false"}, {"CommandGroup", ""}, {"CommandPlayer", ""}, {"Craft", "true"}, {"CraftGroup", ""}, {"CraftPlayer", ""}, {"PVP", "false"}, {"PVPGroup", ""}, {"PVPPlayer", ""}, {"InteractElement", "false"}, {"InteractElementGroup", ""}, {"InteractElementPlayer", ""}, {"InteractObject", "false"}, {"InteractObjectGroup", ""}, {"InteractObjectPlayer", ""}, {"Damage", "true"}, {"DamageGroup", ""}, {"DamagePlayer", ""}, {"PickupItem", "false"}, {"PickupItemGroup", ""}, {"PickupItemPlayer", ""}, {"Sleep", "false"}, {"SleepGroup", ""}, {"SleepPlayer", ""}, {"Fly", "false"}, {"FlyGroup", ""}, {"FlyPlayer", ""}, {"DoorOpen", "false"}, {"DoorOpenGroup", ""}, {"DoorOpenPlayer", ""}, {"BlueprintCreate", "false"}, {"BlueprintCreateGroup", ""}, {"BlueprintCreatePlayer", ""}, {"CreativModus", "false"}, {"Gamemode", ""}, {"CreativModusGroup", ""}, {"CreativModusPlayer", ""}, {"CreativePlaceBlock", "false"}, {"CreativePlaceBlockGroup", ""}, {"CreativePlaceBlockPlayer", ""}, {"CreativePlaceVegetation", "false"}, {"CreativePlaceVegetationGroup", ""}, {"CreativePlaceVegetationPlayer", ""}, {"CreativeTerrainEdit", "false"}, {"CreativeTerrainEditGroup", ""}, {"CreativeTerrainEditPlayer", ""}, {"DestroyBlock", "false"}, {"DestroyBlockGroup", ""}, {"DestroyBlockPlayer", ""}, {"DestroyConstruction", "false"}, {"DestroyConstructionGroup", ""}, {"DestroyConstructionPlayer", ""}, {"DestroyObject", "false"}, {"DestroyObjectGroup", ""}, {"DestroyObjectPlayer", ""}, {"DestroyTerrain", "false"}, {"DestroyTerrainGroup", ""}, {"DestroyTerrainPlayer", ""}, {"DestroyVegetation", "false"}, {"DestroyVegetationGroup", ""}, {"DestroyVegetationPlayer", ""}, {"PlaceBlock", "false"}, {"PlaceBlockGroup", ""}, {"PlaceBlockPlayer", ""}, {"PlaceBlueprint", "false"}, {"PlaceBlueprintGroup", ""}, {"PlaceBlueprintPlayer", ""}, {"PlaceConstruction", "false"}, {"PlaceConstructionGroup", ""}, {"PlaceConstructionPlayer", ""}, {"PlaceGrass", "false"}, {"PlaceGrassGroup", ""}, {"PlaceGrassPlayer", ""}, {"PlaceObject", "false"}, {"PlaceObjectGroup", ""}, {"PlaceObjectPlayer", ""}, {"PlaceTerrain", "false"}, {"PlaceTerrainGroup", ""}, {"PlaceTerrainPlayer", ""}, {"PlaceVegetation", "false"}, {"PlaceVegetationGroup", ""}, {"PlaceVegetationPlayer", ""}, {"PlaceWater", "false"}, {"PlaceWaterGroup", ""}, {"PlaceWaterPlayer", ""}, {"RemoveConstruction", "false"}, {"RemoveConstructionGroup", ""}, {"RemoveConstructionPlayer", ""}, {"RemoveGrass", "false"}, {"RemoveGrassGroup", ""}, {"RemoveGrassPlayer", ""}, {"RemoveObject", "false"}, {"RemoveObjectGroup", ""}, {"RemoveObjectPlayer", ""}, {"RemoveVegetation", "false"}, {"RemoveVegetationGroup", ""}, {"RemoveVegetationPlayer", ""}, {"RemoveWater", "false"}, {"RemoveWaterGroup", ""}, {"RemoveWaterPlayer", ""}, {"Healing", "false"}, {"HealingGroup", ""}, {"HealingPlayer", ""}, {"BrokenBones", "true"}, {"BrokenBonesGroup", ""}, {"BrokenBonesPlayer", ""}, {"Bleeding", "true"}, {"BleedingGroup", ""}, {"BleedingPlayer", ""}, {"Explosion", "false"}, {"ExplosionGroup", ""}, {"ExplosionPlayer", ""}, {"Music", ""}};
            this.woldConfig = new wgConfig("World", woldConfigArray, this, this.debug);
            this.area = new wgArea(this);
            this.area.setDebug(this.debug);
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] Debug[" + this.debug + "] ");
            }
            this.textDaten = new wgClassText();
            this.textDaten.setDebug(this.debug);
            this.textDaten.INI(this);
            this.area.onEnable();
            this.WorldAsArea();
            this.registerEventListener(new WorldGardListener(this));
            this.registerEventListener(new WorldGardListenerCommand(this));
            this.registerEventListener(new WorldGardListenerPlayer(this));
            this.registerEventListener(new WorldGardListenerPlayerWorld(this));
            System.out.println("[" + this.plugin.getDescription("name") + "] " + this.textDaten.getText(null, "bnt_Abbruch"));
            System.out.println("[" + this.plugin.getDescription("name") + "] " + this.textDaten.getText(null, "Variable"));
            System.out.println();
        } else {
            if (this.plugin.getPluginByName("SprachAPI") == null) {
                System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Das Plugin 'SprachAPI' ist nicht installiert! Bitte installieren!");
            }
            System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Plugin im Standbay...");
            this.registerEventListener(new WorldGardStartErrorListener(this));
        }
    }

    public void onDisable() {
        System.out.println("[WorldGard] Desabled");
    }

    private void initDB() {
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'Areas' ('AreaID' INTEGER PRIMARY KEY AUTOINCREMENT, 'srvID' INTEGER, 'AreaName' VARCHAR(64), 'Eigent\u00fcmer' VARCHAR(64), 'Eigent\u00fcmerID' BIGINT, 'Eigenschaft'  VARCHAR(64), 'Mitglieder' VARCHAR(64), 'StartChunkposX' INTEGER, 'StartChunkposY' INTEGER, 'StartChunkposZ' INTEGER, 'StartBlockposX' INTEGER, 'StartBlockposY' INTEGER, 'StartBlockposZ' INTEGER, 'GlobalStartposX' FLOAT, 'GlobalStartposY' FLOAT, 'GlobalStartposZ' FLOAT, 'EndChunkposX' INTEGER, 'EndChunkposY' INTEGER, 'EndChunkposZ' INTEGER, 'EndBlockposX' INTEGER, 'EndBlockposY' INTEGER, 'EndBlockposZ' INTEGER, 'GlobalEndposX' FLOAT, 'GlobalEndposY' FLOAT, 'GlobalEndposZ' FLOAT, 'previousID' INTEGER, 'Buyable' INTEGER, 'Price' INTEGER, 'Prio' INTEGER ); ");
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'Rechte' ('RechteID' INTEGER PRIMARY KEY AUTOINCREMENT, 'rAreaID' INTEGER, 'rMsgID' INTEGER, 'HealingPoint' INTEGER, 'BrokenBonesPoint' INTEGER, 'BleedingPoint' INTEGER, 'DefineOwner' INTEGER, 'Music' VARCHAR(64), 'Enter' INTEGER, 'EnterGroup' INTEGER, 'EnterPlayer' INTEGER, 'Leave' INTEGER, 'LeaveGroup' INTEGER, 'LeavePlayer' INTEGER, 'ChestAccess' INTEGER, 'ChestAccessGroup' INTEGER, 'ChestAccessPlayer' INTEGER, 'ChestToInv' INTEGER, 'ChestToInvGroup' INTEGER, 'ChestToInvPlayer' INTEGER, 'InvToChest' INTEGER, 'InvToChestGroup' INTEGER, 'InvToChestPlayer' INTEGER, 'ChestDrop' INTEGER, 'ChestDropGroup' INTEGER, 'ChestDropPlayer' INTEGER, 'Chat' INTEGER, 'ChatGroup' INTEGER, 'ChatPlayer' INTEGER, 'Command' INTEGER, 'CommandGroup' INTEGER, 'CommandPlayer' INTEGER, 'Craft' INTEGER, 'CraftGroup' INTEGER, 'CraftPlayer' INTEGER, 'PVP' INTEGER, 'PVPGroup' INTEGER, 'PVPPlayer' INTEGER, 'InteractElement' INTEGER, 'InteractElementGroup' INTEGER, 'InteractElementPlayer' INTEGER, 'InteractObject' INTEGER, 'InteractObjectGroup' INTEGER, 'InteractObjectPlayer' INTEGER, 'Damage' INTEGER, 'DamageGroup' INTEGER, 'DamagePlayer' INTEGER, 'PickupItem' INTEGER, 'PickupItemGroup' INTEGER, 'PickupItemPlayer' INTEGER, 'Sleep' INTEGER, 'SleepGroup' INTEGER, 'SleepPlayer' INTEGER, 'Fly' INTEGER, 'FlyGroup' INTEGER, 'FlyPlayer' INTEGER, 'DoorOpen' INTEGER, 'DoorOpenGroup' INTEGER, 'DoorOpenPlayer' INTEGER, 'BlueprintCreate' INTEGER, 'BlueprintCreateGroup' INTEGER, 'BlueprintCreatePlayer' INTEGER, 'CreativModus' INTEGER, 'Gamemode' INTEGER, 'CreativModusGroup' INTEGER, 'CreativModusPlayer' INTEGER, 'CreativePlaceBlock' INTEGER, 'CreativePlaceBlockGroup' INTEGER, 'CreativePlaceBlockPlayer' INTEGER, 'CreativePlaceVegetation' INTEGER, 'CreativePlaceVegetationGroup' INTEGER, 'CreativePlaceVegetationPlayer' INTEGER, 'CreativeTerrainEdit' INTEGER, 'CreativeTerrainEditGroup' INTEGER, 'CreativeTerrainEditPlayer' INTEGER, 'DestroyBlock' INTEGER, 'DestroyBlockGroup' INTEGER, 'DestroyBlockPlayer' INTEGER, 'DestroyConstruction' INTEGER, 'DestroyConstructionGroup' INTEGER, 'DestroyConstructionPlayer' INTEGER, 'DestroyObject' INTEGER, 'DestroyObjectGroup' INTEGER, 'DestroyObjectPlayer' INTEGER, 'DestroyTerrain' INTEGER, 'DestroyTerrainGroup' INTEGER, 'DestroyTerrainPlayer' INTEGER, 'DestroyVegetation' INTEGER, 'DestroyVegetationGroup' INTEGER, 'DestroyVegetationPlayer' INTEGER, 'PlaceBlock' INTEGER, 'PlaceBlockGroup' INTEGER, 'PlaceBlockPlayer' INTEGER, 'PlaceBlueprint' INTEGER, 'PlaceBlueprintGroup' INTEGER, 'PlaceBlueprintPlayer' INTEGER, 'PlaceConstruction' INTEGER, 'PlaceConstructionGroup' INTEGER, 'PlaceConstructionPlayer' INTEGER, 'PlaceGrass' INTEGER, 'PlaceGrassGroup' INTEGER, 'PlaceGrassPlayer' INTEGER, 'PlaceObject' INTEGER, 'PlaceObjectGroup' INTEGER, 'PlaceObjectPlayer' INTEGER, 'PlaceTerrain' INTEGER, 'PlaceTerrainGroup' INTEGER, 'PlaceTerrainPlayer' INTEGER, 'PlaceVegetation' INTEGER, 'PlaceVegetationGroup' INTEGER, 'PlaceVegetationPlayer' INTEGER, 'PlaceWater' INTEGER, 'PlaceWaterGroup' INTEGER, 'PlaceWaterPlayer' INTEGER, 'RemoveConstruction' INTEGER, 'RemoveConstructionGroup' INTEGER, 'RemoveConstructionPlayer' INTEGER, 'RemoveGrass' INTEGER, 'RemoveGrassGroup' INTEGER, 'RemoveGrassPlayer' INTEGER, 'RemoveObject' INTEGER, 'RemoveObjectGroup' INTEGER, 'RemoveObjectPlayer' INTEGER, 'RemoveVegetation' INTEGER, 'RemoveVegetationGroup' INTEGER, 'RemoveVegetationPlayer' INTEGER, 'RemoveWater' INTEGER, 'RemoveWaterGroup' INTEGER, 'RemoveWaterPlayer' INTEGER, 'Healing' INTEGER, 'HealingGroup' INTEGER, 'HealingPlayer' INTEGER, 'BrokenBones' INTEGER, 'BrokenBonesGroup' INTEGER, 'BrokenBonesPlayer' INTEGER, 'Bleeding' INTEGER, 'BleedingGroup' INTEGER, 'BleedingPlayer' INTEGER, 'Explosion' INTEGER, 'ExplosionGroup' INTEGER, 'ExplosionPlayer' INTEGER ); ");
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'GroupList' ('GroupListID' INTEGER PRIMARY KEY AUTOINCREMENT, 'GroupListName' VARCHAR(64), 'gRechteID' INTEGER, 'gAreaID' INTEGER, 'GroupName' VARCHAR(64), 'GroupID' INTEGER ); ");
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'MSG' ('msgID' INTEGER PRIMARY KEY AUTOINCREMENT, 'AreaWelcomMsg' VARCHAR(128), 'AreaFarewellMsg' VARCHAR(128), 'NoEnterAreaMsg' VARCHAR(128), 'NoLeaveAreaMsg' VARCHAR(128), 'mRechteID' INTEGER ); ");
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'VisibleArea' ('VisibleID' INTEGER PRIMARY KEY AUTOINCREMENT, 'vAreaID' INTEGER, 'Player' VARCHAR(64), 'PlayerID' BIGINT, FOREIGN KEY(vAreaID) REFERENCES Areas(AreaID))");
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Lade DB");
        }
    }

    void WorldAsArea() {
        if (this.sysConfig.getValue("WorldAsArea").toLowerCase().equals("true")) {
            ArrayList<String> sFlags = new ArrayList<String>();
            try (ResultSet result = this.sqlite.executeQuery("SELECT * FROM 'Areas' WHERE srvID=0 ");){
                if (result != null) {
                    int ID = result.getInt("AreaID");
                    if (this.debug > 2) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] WorldAsArea srvID[OK]");
                    }
                } else if (this.debug > 2) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] WorldAsArea srvID[NULL]");
                }
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] WorldAsArea srvID[ERR]\n" + e.getMessage());
                try (ResultSet result2 = this.sqlite.executeQuery("PRAGMA table_info( Rechte )");){
                    if (result2 != null) {
                        while (result2.next()) {
                            int cid = result2.getInt("cid");
                            String name = result2.getString("name");
                            if (cid <= 2 || name.contains("Group") || name.contains("Player")) continue;
                            if (this.debug > 2) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] WorldAsArea Rechte Liste " + name);
                            }
                            sFlags.add(name);
                        }
                    }
                }
                catch (SQLException ee) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] " + ee.getMessage());
                }
                Connection connection = this.sqlite.getConnection();
                try (PreparedStatement prep = connection.prepareStatement("INSERT INTO 'Areas' ('AreaName', 'Eigent\u00fcmer', 'srvID', 'Prio', 'GlobalStartposX', 'GlobalStartposY', 'GlobalStartposZ', 'GlobalEndposX', 'GlobalEndposY', 'GlobalEndposZ', 'Eigenschaft', 'Mitglieder', 'Eigent\u00fcmerID', 'Buyable', 'Price') VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                    prep.setString(1, "World");
                    prep.setString(2, "##SYSTEM##");
                    prep.setInt(3, 0);
                    prep.setInt(4, 10);
                    prep.setFloat(5, -2.1474836E9f);
                    prep.setFloat(6, -2.1474836E9f);
                    prep.setFloat(7, -2.1474836E9f);
                    prep.setFloat(8, 2.1474836E9f);
                    prep.setFloat(9, 2.1474836E9f);
                    prep.setFloat(10, 2.1474836E9f);
                    prep.setString(11, "World");
                    prep.setString(12, "Mitglieder");
                    prep.setLong(13, 0L);
                    prep.setInt(14, 0);
                    prep.setInt(15, 0);
                    prep.executeUpdate();
                    ResultSet result3 = prep.getGeneratedKeys();
                    if (result3 != null) {
                        int dbID = result3.getInt(1);
                        this.area.makeDB(null, dbID);
                        classWoldLambert worldLam = new classWoldLambert();
                        this.strList.clear();
                        this.strList.add("Music");
                        sFlags.forEach(t -> {
                            if (this.debug > 3) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] WorldAsArea Flags |" + t + "|");
                            }
                            if (this.debug > 3) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] WorldAsArea woldConfig |" + this.woldConfig.getValue((String)t) + "|");
                            }
                            if (this.woldConfig.getValue((String)t) != null) {
                                Object[] obj = null;
                                obj = this.strList.contains(t) ? new Object[]{t, this.woldConfig.getValue((String)t).getClass().equals(String.class) ? this.woldConfig.getValue((String)t) : ""} : new Object[]{t, this.woldConfig.getValue((String)t).toLowerCase().equals("true") ? -1 : 0};
                                worldLam.wold = wgCRT.addElement(worldLam.wold, obj);
                            }
                        });
                        this.area.setDBWert(0, worldLam.wold);
                    }
                }
                catch (SQLException ee) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] " + ee.getMessage());
                }
            }
        } else {
            PreparedStatement prep;
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] WorldAsArea DB l\u00f6schen");
            }
            int aID = -1;
            int rID = -1;
            int mID = -1;
            try (ResultSet result = this.sqlite.executeQuery("SELECT * FROM 'Areas' WHERE srvID = 0 ");){
                if (result != null) {
                    aID = result.getInt("AreaID");
                }
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Get Rechte Info" + e.getMessage());
            }
            Connection connection = this.sqlite.getConnection();
            try {
                prep = connection.prepareStatement("DELETE FROM 'Areas' WHERE srvID = 0 ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del Areas" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'VisibleArea' WHERE aAreaID = " + aID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del VisibleAreas" + e.getMessage());
            }
            try (ResultSet result = this.sqlite.executeQuery("SELECT * FROM 'Rechte' WHERE rAreaID = " + aID + " ");){
                if (result != null) {
                    rID = result.getInt("rRechteID");
                    mID = result.getInt("rMsgID");
                }
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Get Rechte Info" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'Rechte' WHERE rAreaID = " + aID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del Rechte" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'MSG' WHERE msgID = " + mID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del MSG" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'GroupList' WHERE gRechteID = " + rID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del GroupList" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'MitgliedList' WHERE mAreaID = " + aID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del MitgliedListe" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'PlayerList' WHERE pRechteID = " + rID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del PlayerListe" + e.getMessage());
            }
        }
    }

    public String parseColor(String text) {
        String result = text;
        result = result.replace("[N]", this.wgCol.N);
        result = result.replace("[n]", this.wgCol.N);
        result = result.replace("[E]", this.wgCol.F);
        result = result.replace("[e]", this.wgCol.F);
        result = result.replace("[C]", this.wgCol.H1);
        result = result.replace("[c]", this.wgCol.H1);
        result = result.replace("[P1]", this.wgCol.H2);
        result = result.replace("[p1]", this.wgCol.H2);
        result = result.replace("[P2]", this.wgCol.H3);
        result = result.replace("[p2]", this.wgCol.H3);
        result = result.replace("[H]", this.wgCol.H4);
        result = result.replace("[h]", this.wgCol.H4);
        result = result.replace("[I]", this.wgCol.H5);
        result = result.replace("[i]", this.wgCol.H5);
        result = result.replace("[OK]", this.wgCol.OK);
        result = result.replace("[ok]", this.wgCol.OK);
        result = result.replace("[Ok]", this.wgCol.OK);
        result = result.replace("[oK]", this.wgCol.OK);
        result = result.replace("[O]", this.wgCol.OK);
        result = result.replace("[o]", this.wgCol.OK);
        return result;
    }

    Object[] getAreaAndParameter(Player player, String[] cmd, String command) {
        return this.getAreaAndParameter(player, cmd, command, true);
    }

    Object[] getAreaAndParameter(Player player, String[] cmd, String command, boolean pr\u00fcfeRechte) {
        int findArea = -1;
        String inCommand = null;
        boolean param = false;
        if (cmd.length >= 3) {
            if (cmd[2].toLowerCase().contains("-help")) {
                if (player.isAdmin()) {
                    if (this.debug > 2) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] getAreaAndParameter flags help");
                    }
                    inCommand = "-help";
                    findArea = -1;
                }
            } else if (cmd[2].toLowerCase().equals("add") || cmd[2].toLowerCase().equals("remove")) {
                int memID;
                classWorldArea res = null;
                try {
                    memID = Integer.parseInt(cmd[3]);
                }
                catch (NumberFormatException e) {
                    memID = -1;
                }
                if (this.debug > 2) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] getAreaAndParameter Area int[" + memID + "]");
                }
                if ((res = memID >= 0 ? this.area.getAreaBy(player, memID) : this.area.getAreaBy(player, cmd[3])) != null) {
                    boolean berechtigt = this.area.getBerechtigt(player, res);
                    if (this.debug > 2) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] getAreaAndParameter flags[I] Name Name[" + res.Name + "] Ausf\u00fcren[" + berechtigt + "] ");
                    }
                    if (berechtigt || !pr\u00fcfeRechte) {
                        findArea = res.srvID;
                        inCommand = command.substring(1 + cmd[0].length() + 1 + cmd[1].length() + 1 + cmd[2].length() + 1 + cmd[3].length());
                    } else {
                        player.sendTextMessage(this.plugin.parseColor("[E]" + this.textDaten.getText(player, "command_no_authorization")));
                    }
                } else {
                    ArrayList<classDimension> res_ = this.area.getAreasFromPos(player.getPosition());
                    if (res_.size() >= 1) {
                        boolean berechtigt = this.area.getBerechtigt(player, this.area.getAreaBy(player, res_.get(0)));
                        if (this.debug > 2) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] getAreaAndParameter add/remove Name[" + res_.get((int)0).Name + "] Ausf\u00fcren[" + berechtigt + "] ");
                        }
                        if (berechtigt || !pr\u00fcfeRechte) {
                            findArea = res_.get((int)0).srvID;
                            inCommand = command.substring(1 + cmd[0].length() + 1 + cmd[1].length() + 1 + cmd[2].length());
                        } else {
                            player.sendTextMessage(this.plugin.parseColor("[E]" + this.textDaten.getText(player, "command_no_authorization")));
                        }
                    } else {
                        player.sendTextMessage(this.plugin.parseColor("[H]" + this.textDaten.getText(player, "command_no_Area_found")));
                    }
                }
            } else {
                int memID;
                classWorldArea res = null;
                try {
                    memID = Integer.parseInt(cmd[2]);
                }
                catch (NumberFormatException e) {
                    memID = -1;
                }
                if (this.debug > 2) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] getAreaAndParameter Area int[" + memID + "]");
                }
                if ((res = memID >= 0 ? this.area.getAreaBy(player, memID) : this.area.getAreaBy(player, cmd[2])) != null) {
                    boolean berechtigt = this.area.getBerechtigt(player, res);
                    if (this.debug > 2) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] getAreaAndParameter flags[P] Name Name[" + res.Name + "] Ausf\u00fcren[" + berechtigt + "] ");
                    }
                    if (berechtigt || !pr\u00fcfeRechte) {
                        findArea = res.srvID;
                        inCommand = command.substring(1 + cmd[0].length() + 1 + cmd[1].length() + cmd[2].length());
                    } else {
                        player.sendTextMessage(this.plugin.parseColor("[E]" + this.textDaten.getText(player, "command_no_authorization")));
                    }
                } else {
                    block58: {
                        if (this.debug > 3) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] getAreaAndParameter flags noArea");
                        }
                        try (ResultSet result = this.sqlite.executeQuery("PRAGMA table_info( Rechte )");){
                            if (result == null) break block58;
                            while (result.next()) {
                                int cid = result.getInt("cid");
                                String name = result.getString("name");
                                if (cid <= 2 || name.contains("Group") || name.contains("Player")) continue;
                                if (this.debug > 3) {
                                    System.out.println("[" + this.plugin.getDescription("name") + "] getAreaAndParameter flags Liste " + name);
                                }
                                if (!cmd[2].toLowerCase().contains(name.toLowerCase())) continue;
                                if (this.debug > 2) {
                                    System.out.println("[" + this.plugin.getDescription("name") + "] getAreaAndParameter flags Liste Finde " + name);
                                }
                                param = true;
                                break;
                            }
                        }
                        catch (SQLException e) {
                            System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
                        }
                    }
                    if (param) {
                        ArrayList<classDimension> res_ = this.area.getAreasFromPos(player.getPosition());
                        if (res_.size() >= 1) {
                            boolean berechtigt = this.area.getBerechtigt(player, this.area.getAreaBy(player, res_.get(0)));
                            if (this.debug > 2) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreaAndParameter flags Name Name[" + res_.get((int)0).Name + "] Ausf\u00fcren[" + berechtigt + "] ");
                            }
                            if (berechtigt || !pr\u00fcfeRechte) {
                                findArea = res_.get((int)0).srvID;
                                inCommand = command.substring(1 + cmd[0].length() + cmd[1].length());
                            } else {
                                player.sendTextMessage(this.plugin.parseColor("[E]" + this.textDaten.getText(player, "command_no_authorization")));
                            }
                        } else {
                            player.sendTextMessage(this.plugin.parseColor("[H]" + this.textDaten.getText(player, "command_no_Area_found")));
                        }
                    } else {
                        player.sendTextMessage(this.plugin.parseColor("[H]" + this.textDaten.getText(player, "command_no_Area_found")));
                    }
                }
            }
        } else {
            ArrayList<classDimension> res = this.area.getAreasFromPos(player.getPosition());
            if (res.size() >= 1) {
                boolean berechtigt = this.area.getBerechtigt(player, this.area.getAreaBy(player, res.get((int)0).srvID));
                if (berechtigt || !pr\u00fcfeRechte) {
                    findArea = res.get((int)0).srvID;
                    inCommand = command.substring(1 + cmd[0].length() + cmd[1].length());
                } else {
                    player.sendTextMessage(this.plugin.parseColor("[E]" + this.textDaten.getText(player, "command_no_authorization")));
                }
            } else {
                player.sendTextMessage(this.plugin.parseColor("[H]" + this.textDaten.getText(player, "command_no_Area_found")));
            }
        }
        return new Object[]{findArea, inCommand};
    }

    ArrayList<String> getFlags() {
        return this.getFlags(false);
    }

    ArrayList<String> getFlags(boolean low) {
        classLambertHelp ausgabe = new classLambertHelp();
        if (this.debug > 1) {
            System.out.println("[" + this.plugin.getDescription("name") + "] getFlags flags show parameter");
        }
        try (ResultSet result = this.sqlite.executeQuery("PRAGMA table_info( Rechte )");){
            if (result != null) {
                while (result.next()) {
                    int cid = result.getInt("cid");
                    String name = result.getString("name");
                    if (cid <= 2 || name.contains("Group") || name.contains("Player")) continue;
                    if (this.debug > 3) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] getFlags flags Liste " + name);
                    }
                    if (low) {
                        ausgabe.sArryListe.add(name.toLowerCase());
                        continue;
                    }
                    ausgabe.sArryListe.add(name);
                }
            }
        }
        catch (SQLException e) {
            System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
        }
        return ausgabe.sArryListe;
    }

    ArrayList<String> getSonderFlags() {
        classLambertHelp ausgabe = new classLambertHelp();
        ausgabe.sArryListe.add("HealingPoint");
        ausgabe.sArryListe.add("BrokenBonesPoint");
        ausgabe.sArryListe.add("BleedingPoint");
        ausgabe.sArryListe.add("Music");
        ausgabe.sArryListe.add("Chat");
        return ausgabe.sArryListe;
    }

    boolean getRight(Player player, ArrayList<Object> res, ArrayList<classDimension> findArea, String flagName) {
        boolean user;
        long ownerID2;
        Throwable throwable;
        ResultSet result;
        boolean admin;
        boolean recht;
        boolean bl = recht = (Integer)res.get(0) == -1;
        if (this.debug > 3) {
            System.out.println("[" + this.plugin.getDescription("name") + "] getRight isAdmin Player[" + player.isAdmin() + "] AccesAdmin[" + this.sysConfig.getValue("AccesAllAdmin").toLowerCase().equals("true") + "] ");
        }
        boolean bl2 = admin = player.isAdmin() && this.sysConfig.getValue("AccesAllAdmin").toLowerCase().equals("true");
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] getRight are " + findArea.get((int)0).srvID + " value[" + res.get(0) + "] ");
        }
        boolean noGroup = false;
        boolean owner = false;
        boolean gruppe = false;
        int areaID = 0;
        int rechteID = 0;
        String ownerName = null;
        try {
            result = this.sqlite.executeQuery("SELECT * FROM 'Areas', 'Rechte', 'GroupList' WHERE Areas.srvID = " + findArea.get((int)0).srvID + " and AreaID = rAreaID  and GroupName = '" + player.getPermissionGroup().toLowerCase() + "' and AreaID = gAreaID ");
            throwable = null;
            try {
                if (result != null) {
                    if (this.debug > 4) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] getRight mit Gruppe Vorhanden");
                    }
                    areaID = 0;
                    rechteID = 0;
                    areaID = result.getInt("AreaID");
                    rechteID = result.getInt("gRechteID");
                    ownerID2 = result.getLong("Eigent\u00fcmerID");
                    ownerName = result.getString("Eigent\u00fcmer");
                    String groupName = result.getString("GroupName");
                    if (this.debug > 3) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] getRight mit Gruppe Vorhanden aID[" + areaID + "] rID[" + rechteID + "]  result[" + result + "]");
                    }
                    if (areaID != 0 && rechteID != 0) {
                        if (ownerID2 == player.getUID()) {
                            owner = true;
                        }
                        gruppe = true;
                    } else {
                        noGroup = true;
                    }
                }
            }
            catch (Throwable ownerID2) {
                throwable = ownerID2;
                throw ownerID2;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable ownerID2) {
                            throwable.addSuppressed(ownerID2);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
            noGroup = true;
        }
        if (noGroup) {
            try {
                result = this.sqlite.executeQuery("SELECT * FROM 'Areas', 'Rechte' WHERE Areas.srvID = " + findArea.get((int)0).srvID + " and AreaID = rAreaID ");
                throwable = null;
                try {
                    if (result != null) {
                        if (this.debug > 4) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] getRight ohne Gruppe Vorhanden");
                        }
                        areaID = 0;
                        rechteID = 0;
                        areaID = result.getInt("AreaID");
                        rechteID = result.getInt("RechteID");
                        ownerName = result.getString("Eigent\u00fcmer");
                        ownerID2 = result.getLong("Eigent\u00fcmerID");
                        if (this.debug > 3) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] getRight ohne Gruppe Vorhanden aID[" + areaID + "] rID[" + rechteID + "]  result[" + result + "]");
                        }
                        if (areaID != 0 && rechteID != 0 && ownerID2 == player.getUID()) {
                            owner = true;
                        }
                    }
                }
                catch (Throwable ownerID3) {
                    throwable = ownerID3;
                    throw ownerID3;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable ownerID3) {
                                throwable.addSuppressed(ownerID3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
            }
        }
        boolean bl3 = user = owner && this.sysConfig.getValue("AccesAllUser").toLowerCase().equals("true");
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] getRight Rechte " + !recht + " " + gruppe + " " + (flagName != null) + " " + flagName);
        }
        if (!recht && gruppe && flagName != null) {
            ArrayList<Object> resGroup = new ArrayList<Object>();
            if (resGroup.size() <= 0) {
                // empty if block
            }
            try (ResultSet result2 = this.sqlite.executeQuery("SELECT " + flagName + " FROM Areas, Rechte, MSG WHERE srvID = " + findArea.get((int)0).srvID + " and  rMsgID=msgID  and RechteID = " + rechteID + " ");){
                if (result2 != null) {
                    ResultSetMetaData rsmd = result2.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    for (int i = 1; i <= columnCount; ++i) {
                        String s = rsmd.getColumnTypeName(i);
                        if (this.debug > 3) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] getRight Rechte getDB: " + s);
                        }
                        if (s.equals("VARCHAR")) {
                            resGroup.add(result2.getString(i));
                            continue;
                        }
                        if (!s.equals("INTEGER")) continue;
                        resGroup.add(result2.getInt(i));
                    }
                }
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] getRight " + e.getMessage());
            }
            boolean bl4 = recht = (Integer)resGroup.get(0) == -1;
        }
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] getRight Rechte Admin[" + admin + "] User[" + user + "] Recht[" + recht + "] Owner[" + owner + "] Gruppe[" + gruppe + "] ");
        }
        return findArea.get((int)0).srvID == 0 ? admin || recht || gruppe : admin || user || recht && (owner || gruppe);
    }

    static class classLambertHelp {
        ArrayList<String> sArryListe;
        String ausgabe = null;
        int n;
        int maxLength;
        Object[] obj = null;

        public classLambertHelp() {
            ArrayList sFlagsLoc = new ArrayList();
            this.sArryListe = sFlagsLoc;
        }
    }

    private static class classWoldLambert {
        Object[][] wold;

        public classWoldLambert() {
            Object[][] woldL = new Object[][]{};
            this.wold = woldL;
        }
    }
}

