/*
 * Decompiled with CFR 0.152.
 */
package worldprotection;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeBlockPositionEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerEnterAreaEvent;
import net.risingworld.api.events.player.PlayerEnterChunkEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.PlayerLeaveAreaEvent;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.events.player.gui.PlayerGuiInputEvent;
import net.risingworld.api.events.player.world.PlayerDestroyBlockEvent;
import net.risingworld.api.events.player.world.PlayerDestroyConstructionEvent;
import net.risingworld.api.events.player.world.PlayerDestroyObjectEvent;
import net.risingworld.api.events.player.world.PlayerDestroyTerrainEvent;
import net.risingworld.api.events.player.world.PlayerDestroyVegetationEvent;
import net.risingworld.api.events.player.world.PlayerPlaceBlockEvent;
import net.risingworld.api.events.player.world.PlayerPlaceConstructionEvent;
import net.risingworld.api.events.player.world.PlayerPlaceGrassEvent;
import net.risingworld.api.events.player.world.PlayerPlaceObjectEvent;
import net.risingworld.api.events.player.world.PlayerPlaceTerrainEvent;
import net.risingworld.api.events.player.world.PlayerPlaceVegetationEvent;
import net.risingworld.api.events.player.world.PlayerPlaceWaterEvent;
import net.risingworld.api.events.player.world.PlayerRemoveConstructionEvent;
import net.risingworld.api.events.player.world.PlayerRemoveGrassEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.events.player.world.PlayerRemoveVegetationEvent;
import net.risingworld.api.events.world.ExplosionEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.ChunkLOD;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.World3DText;
import net.risingworld.api.worldelements.WorldArea;
import net.risingworld.api.worldelements.WorldElement;

public class WorldProtection
extends Plugin
implements Listener {
    private Server server;
    private World world;

    public static void main(String[] args) {
    }

    public void onDisable() {
        this.unregisterEventListener(this);
        System.out.println("World protection unloaded successfully!");
    }

    public void onEnable() {
        Throwable throwable;
        ResultSet result;
        this.registerEventListener(this);
        this.server = this.getServer();
        this.world = this.getWorld();
        System.out.println("WorldProtection plugin loaded successfully!");
        try (Database database = this.getSQLiteConnection(this.getPath() + "/database.db");){
            database.execute("CREATE TABLE IF NOT EXISTS `Areas` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `AreaOwner` VARCHAR(64), `AreaID` INTEGER, `AreaStatus` INTEGER, `AreaGuest` VARCHAR(64), `AreaIDx` INTEGER, `AreaIDy` INTEGER, `AreaIDz` INTEGER, `PlayerUID` BIGINT);");
            database.execute("CREATE TABLE IF NOT EXISTS `AdminSettings` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `AreaNum` INTEGER, `UPNum` INTEGER);");
            database.execute("CREATE TABLE IF NOT EXISTS `Friends` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `OwnerName` VARCHAR(64), `FriendName` VARCHAR(64), `AreaID` INTEGER, `PlayerUID` BIGINT);");
            database.execute("CREATE TABLE IF NOT EXISTS `PlayerNum` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `PlayerName` VARCHAR(64), `UPNum` INTEGER, `PlayerUID` BIGINT);");
            database.execute("CREATE TABLE IF NOT EXISTS `DataBaseVersion` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `Version` INTEGER);");
        }
        database = this.getSQLiteConnection(this.getPath() + "/database.db");
        try {
            result = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");
            throwable = null;
            try {
                System.out.println("looking At Admin Settings");
                if (!result.next()) {
                    System.out.println("Updating Admin Settings");
                    database.executeUpdate("INSERT INTO `AdminSettings` (AreaNum, UpNum) VALUES ('200','1');");
                }
                System.out.println("Admin Settings Looks Ok ");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            result = database.executeQuery("SELECT * FROM `DataBaseVersion` WHERE ID = '1'");
            throwable = null;
            try {
                if (!result.next()) {
                    database.executeUpdate("INSERT INTO `DataBaseVersion` (Version) VALUES ('0');");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            result = database.executeQuery("SELECT * FROM `DataBaseVersion` WHERE ID = '1'");
            throwable = null;
            try {
                System.out.println("Checking DataBase Version");
                if (result.next() && result.getInt("Version") < 1) {
                    database.execute("ALTER TABLE `Areas` ADD `PlayerUID` BIGINT");
                    database.execute("ALTER TABLE `AdminSettings` ADD `UPNum` INTEGER");
                    database.executeUpdate("UPDATE DataBaseVersion SET Version = '1' WHERE ID = '1'");
                    System.out.println("DataBase Version Updated to v1");
                }
                System.out.println("DataBase Version is up to date");
                return;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        String Playername = player.getName();
        player.registerKeys(new int[]{25});
        player.registerKeys(new int[]{50});
        player.registerKeys(new int[]{19});
        player.registerKeys(new int[]{46});
        player.setListenForKeyInput(true);
        this.GuiPlayerPanels(player);
    }

    @EventMethod
    public void onPlayerSpawnEvent(PlayerSpawnEvent event) throws SQLException {
        Player player = event.getPlayer();
        String Playername = player.getName();
        Long PlayerUID = player.getUID();
        if (player.hasAttribute("AreaDisplay")) {
            ((GuiLabel)player.getAttribute("AreaDisplay")).setText(" Area Not Loaded, Press p for World Protection help ");
        }
        if (player.hasAttribute("AreaDisplay1")) {
            ((GuiLabel)player.getAttribute("AreaDisplay1")).setText(" Move To Load The Areas ");
        }
        if (player.hasAttribute("AreaDisplay2")) {
            ((GuiLabel)player.getAttribute("AreaDisplay2")).setText(" Welcome " + Playername + " ");
        }
        player.sendTextMessage("Welcome " + Playername + "!");
        if (player.isAdmin()) {
            player.sendTextMessage("As an Admin you are incharge of WorldProtection /wp test");
        }
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        try (ResultSet result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaOwner` == '" + Playername + "' ");){
            if (!result.next()) {
                player.sendTextMessage("hey " + Playername + " Welcome, you may not know but this server Runs Yahgiggle's WorldProtection plugin, this means when you start building all your stuff is protected.");
            }
        }
        result = database.executeQuery("SELECT * FROM `Areas` WHERE AreaOwner = '" + Playername + "' AND PlayerUID = 'null'");
        var7_7 = null;
        try {
            while (result.next()) {
                database.executeUpdate("UPDATE Areas SET PlayerUID = '" + PlayerUID + "' WHERE AreaOwner = '" + Playername + "' AND PlayerUID = 'null'");
                System.out.println("Updating Areas PlayerUID " + Playername + " = " + PlayerUID + " Updated");
            }
            result.close();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var7_7 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
        result = database.executeQuery("SELECT * FROM `Friends` WHERE FriendName = '" + Playername + "' AND PlayerUID = 'null'");
        var7_7 = null;
        try {
            while (result.next()) {
                database.executeUpdate("UPDATE Friends SET PlayerUID = '" + PlayerUID + "' WHERE FriendName = '" + Playername + "' AND PlayerUID = 'null'");
                System.out.println("Updating Friends PlayerUID " + Playername + " = " + PlayerUID + " Updated");
            }
            result.close();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var7_7 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
    }

    @EventMethod
    private void GuiPlayerPanels(Player player) {
        GuiPanel panel1 = new GuiPanel(0.01f, 0.1f, true, 1300.0f, 60.0f, false);
        panel1.setPivot(PivotPosition.BottomLeft);
        panel1.setColor(47);
        panel1.setVisible(true);
        panel1.setBorderColor(159);
        panel1.setBorderThickness(0.01f, true);
        player.setAttribute("Switch2", (Object)panel1);
        player.addGuiElement((GuiElement)panel1);
        GuiLabel Display = new GuiLabel(0.002f, 0.1f, true);
        Display.setPivot(PivotPosition.BottomLeft);
        Display.setFont(Font.DefaultMono_Bold);
        Display.setFontSize(17);
        panel1.addChild((GuiElement)Display);
        player.setAttribute("AreaDisplay", (Object)Display);
        player.addGuiElement((GuiElement)Display);
        GuiLabel Display1 = new GuiLabel(0.002f, 0.38f, true);
        Display1.setPivot(PivotPosition.BottomLeft);
        Display1.setFont(Font.DefaultMono_Bold);
        Display1.setFontSize(17);
        panel1.addChild((GuiElement)Display1);
        player.setAttribute("AreaDisplay1", (Object)Display1);
        player.addGuiElement((GuiElement)Display1);
        GuiLabel Display2 = new GuiLabel(0.002f, 0.65f, true);
        Display2.setPivot(PivotPosition.BottomLeft);
        Display2.setFont(Font.DefaultMono_Bold);
        Display2.setFontSize(17);
        panel1.addChild((GuiElement)Display2);
        player.setAttribute("AreaDisplay2", (Object)Display2);
        player.addGuiElement((GuiElement)Display2);
        GuiPanel panel = new GuiPanel(0.5f, 0.52f, true, 1200.0f, 600.0f, false);
        panel.setPivot(PivotPosition.Center);
        panel.setColor(127);
        panel.setVisible(false);
        panel.setBorderColor(143);
        panel.setBorderThickness(0.01f, true);
        player.setAttribute("Switch", (Object)panel);
        player.addGuiElement((GuiElement)panel);
        GuiLabel Display3 = new GuiLabel(0.01f, 0.1f, true);
        Display3.setPivot(PivotPosition.BottomLeft);
        Display3.setFont(Font.DefaultMono_Bold);
        Display3.setFontSize(17);
        panel.addChild((GuiElement)Display3);
        player.setAttribute("AreaDisplay3", (Object)Display3);
        player.setAttribute("onoff", (Object)Display3);
        player.addGuiElement((GuiElement)Display3);
        GuiLabel close = new GuiLabel(" close X ", 0.9f, 0.02f, true);
        close.setPivot(PivotPosition.BottomLeft);
        close.setFont(Font.DefaultMono_Bold);
        close.setFontSize(17);
        close.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        player.setAttribute("state", (Object)close);
        close.setBorderColor(143);
        close.setBorderThickness(0.01f, true);
        player.setAttribute("close", (Object)close);
        panel.addChild((GuiElement)close);
        player.addGuiElement((GuiElement)close);
        GuiLabel closepanel = new GuiLabel(" Main Panel On ", 0.01f, 0.06f, true);
        closepanel.setPivot(PivotPosition.BottomLeft);
        closepanel.setFont(Font.DefaultMono_Bold);
        closepanel.setFontSize(17);
        closepanel.setColor(0.0f, 1.0f, 0.0f, 0.5f);
        closepanel.setClickable(true);
        closepanel.setBorderColor(143);
        closepanel.setBorderThickness(0.01f, true);
        player.setAttribute("closepanel", (Object)closepanel);
        panel.addChild((GuiElement)closepanel);
        player.addGuiElement((GuiElement)closepanel);
        GuiLabel openpanel = new GuiLabel(" Main Panel Off", 0.01f, 0.06f, true);
        openpanel.setPivot(PivotPosition.BottomLeft);
        openpanel.setFont(Font.DefaultMono_Bold);
        openpanel.setFontSize(17);
        openpanel.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        openpanel.setClickable(true);
        openpanel.setBorderColor(143);
        openpanel.setBorderThickness(0.01f, true);
        player.setAttribute("openpanel", (Object)openpanel);
        panel.addChild((GuiElement)openpanel);
        player.addGuiElement((GuiElement)openpanel);
        GuiLabel closeautoadd = new GuiLabel(" Auto Areas On ", 0.01f, 0.02f, true);
        closeautoadd.setPivot(PivotPosition.BottomLeft);
        closeautoadd.setFont(Font.DefaultMono_Bold);
        closeautoadd.setFontSize(17);
        closeautoadd.setColor(0.0f, 1.0f, 0.0f, 0.5f);
        closeautoadd.setClickable(true);
        closeautoadd.setBorderColor(143);
        closeautoadd.setBorderThickness(0.01f, true);
        player.setAttribute("closeautoadd", (Object)closeautoadd);
        panel.addChild((GuiElement)closeautoadd);
        player.addGuiElement((GuiElement)closeautoadd);
        GuiLabel openautoadd = new GuiLabel(" Auto Areas Off", 0.01f, 0.02f, true);
        openautoadd.setPivot(PivotPosition.BottomLeft);
        openautoadd.setFont(Font.DefaultMono_Bold);
        openautoadd.setFontSize(17);
        openautoadd.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        openautoadd.setClickable(true);
        openautoadd.setBorderColor(143);
        openautoadd.setBorderThickness(0.01f, true);
        player.setAttribute("openautoadd", (Object)openautoadd);
        panel.addChild((GuiElement)openautoadd);
        player.addGuiElement((GuiElement)openautoadd);
        GuiLabel AddArea = new GuiLabel("  Add  Area  X ", 0.125f, 0.02f, true);
        AddArea.setPivot(PivotPosition.BottomLeft);
        AddArea.setFont(Font.DefaultMono_Bold);
        AddArea.setFontSize(17);
        AddArea.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        AddArea.setClickable(true);
        AddArea.setBorderColor(143);
        AddArea.setBorderThickness(0.01f, true);
        player.setAttribute("AddArea", (Object)AddArea);
        panel.addChild((GuiElement)AddArea);
        player.addGuiElement((GuiElement)AddArea);
        GuiLabel RemoveArea = new GuiLabel(" Remove Area X ", 0.125f, 0.06f, true);
        RemoveArea.setPivot(PivotPosition.BottomLeft);
        RemoveArea.setFont(Font.DefaultMono_Bold);
        RemoveArea.setFontSize(17);
        RemoveArea.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        RemoveArea.setClickable(true);
        RemoveArea.setBorderColor(143);
        RemoveArea.setBorderThickness(0.01f, true);
        player.setAttribute("RemoveArea", (Object)RemoveArea);
        panel.addChild((GuiElement)RemoveArea);
        player.addGuiElement((GuiElement)RemoveArea);
        GuiLabel Setlimitup = new GuiLabel(" Limit +10 X ", 0.24f, 0.06f, true);
        Setlimitup.setPivot(PivotPosition.BottomLeft);
        Setlimitup.setFont(Font.DefaultMono_Bold);
        Setlimitup.setFontSize(17);
        Setlimitup.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        Setlimitup.setClickable(true);
        Setlimitup.setBorderColor(143);
        Setlimitup.setBorderThickness(0.01f, true);
        player.setAttribute("Setlimitup", (Object)Setlimitup);
        panel.addChild((GuiElement)Setlimitup);
        player.addGuiElement((GuiElement)Setlimitup);
        GuiLabel Setlimitdown = new GuiLabel(" Limit -10 X ", 0.24f, 0.02f, true);
        Setlimitdown.setPivot(PivotPosition.BottomLeft);
        Setlimitdown.setFont(Font.DefaultMono_Bold);
        Setlimitdown.setFontSize(17);
        Setlimitdown.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        Setlimitdown.setClickable(true);
        Setlimitdown.setBorderColor(143);
        Setlimitdown.setBorderThickness(0.01f, true);
        player.setAttribute("Setlimitdown", (Object)Setlimitdown);
        panel.addChild((GuiElement)Setlimitdown);
        player.addGuiElement((GuiElement)Setlimitdown);
        GuiLabel SetBonusdown = new GuiLabel(" Bonus -1 X ", 0.34f, 0.02f, true);
        SetBonusdown.setPivot(PivotPosition.BottomLeft);
        SetBonusdown.setFont(Font.DefaultMono_Bold);
        SetBonusdown.setFontSize(17);
        SetBonusdown.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        SetBonusdown.setClickable(true);
        SetBonusdown.setBorderColor(143);
        SetBonusdown.setBorderThickness(0.01f, true);
        player.setAttribute("SetBonusdown", (Object)SetBonusdown);
        panel.addChild((GuiElement)SetBonusdown);
        player.addGuiElement((GuiElement)SetBonusdown);
        GuiLabel SetBonusup = new GuiLabel(" Bonus +1 X ", 0.34f, 0.06f, true);
        SetBonusup.setPivot(PivotPosition.BottomLeft);
        SetBonusup.setFont(Font.DefaultMono_Bold);
        SetBonusup.setFontSize(17);
        SetBonusup.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        SetBonusup.setClickable(true);
        SetBonusup.setBorderColor(143);
        SetBonusup.setBorderThickness(0.01f, true);
        player.setAttribute("SetBonusup", (Object)SetBonusup);
        panel.addChild((GuiElement)SetBonusup);
        player.addGuiElement((GuiElement)SetBonusup);
        World3DText ChunkBox = new World3DText("");
        ChunkBox.setAlwaysVisible(true);
        ChunkBox.setBillboard(true);
        ChunkBox.setFontColor(1.0f, 0.0f, 0.0f, 1.0f);
        ChunkBox.setText("text demo soon coming");
        ChunkBox.setFontsize(20);
        player.setAttribute("ChunkBox", (Object)ChunkBox);
        player.addWorldElement((WorldElement)ChunkBox);
    }

    @EventMethod
    public void onPlayerKeyInput(PlayerKeyEvent evt) throws SQLException {
        Throwable throwable;
        ResultSet result;
        Player player = evt.getPlayer();
        String Playername = player.getName();
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        Long PlayerUID = player.getUID();
        player.enableClientsideKeys(new int[]{25});
        player.enableClientsideKeys(new int[]{50});
        player.enableClientsideKeys(new int[]{19});
        player.enableClientsideKeys(new int[]{46});
        GuiLabel Display3 = (GuiLabel)player.getAttribute("AreaDisplay3");
        GuiLabel onoff = (GuiLabel)player.getAttribute("onoff");
        GuiPanel Switch = (GuiPanel)player.getAttribute("Switch");
        GuiLabel closepanel = (GuiLabel)player.getAttribute("closepanel");
        GuiLabel closeautoadd = (GuiLabel)player.getAttribute("closeautoadd");
        GuiLabel openautoadd = (GuiLabel)player.getAttribute("openautoadd");
        GuiLabel openpanel = (GuiLabel)player.getAttribute("openpanel");
        GuiLabel state = (GuiLabel)player.getAttribute("state");
        if (evt.isPressed() && evt.getKeyCode() == 25 && Switch.isVisible()) {
            Switch.setVisible(false);
            onoff.setVisible(false);
            player.setMouseCursorVisible(false);
            return;
        }
        if (evt.isPressed() && evt.getKeyCode() == 25 && !Switch.isVisible()) {
            Switch.setVisible(true);
            onoff.setVisible(true);
            state.setClickable(true);
            player.setMouseCursorVisible(true);
            if (closepanel.isVisible()) {
                openpanel.setVisible(false);
            }
            if (closeautoadd.isVisible()) {
                openautoadd.setVisible(false);
            }
            Display3.setText("[#00FF12]---World Protection Help------------------------------------------------------------------------------------------------------------\n\n[#4f51ff]Player Commands Note:The AreaID is showin at the bottom left of your screen when you move into an area\n\n[#ffffff]/wpp delete AreaID = Removes the area with the given AreaID from your area list\n/wpp delete all username = Removes all your areas from your protected area list\n/wpp add username AreaID = Adds the user to the area with the given AreaID\n/wpp add username friend = Adds a friend to all your Areas Note:the name has to be 100% the same as there username\n/wpp remove FrendName from OwnerName = removes a friend from all your areas\n/wpp delete all objects username = removes all items and objects from your object protection list\n/wpp showareas = shows your areas\n/wpp hideareas = hides your areas\n/wpp showallareas = shows all the areas\n/wpp listallareas = lists all the areas to get the id\n/wpp tp ID = Teleports a player to the center of an area, flymode must be on\n/wpp areatp ID = Teleports a player to the ground level of an area \nNote:The true area could be deep in the ground or high in the sky when /wpp areatp is used\n\n\n\n\n\nKeys: R = remove area, C = claim area, M = map, P = open or close help\n\n[#ff0202]Admin Commands\n[#ffffff]/wpp set limit 1000 = Sets the limit of areas users can claim 1000 is the defalt example /wpp set limit 75 = 75 areas set\n/wpp friends Ownername Friendname friend  =  Adds a friend to a players areas for players\n\n\n\n[#00FF12]------------------------------------------------------------------------------------------------------------------------------------");
        }
        if (evt.isPressed() && evt.getKeyCode() == 50) {
            player.showMap(true);
        }
        if (evt.isPressed() && evt.getKeyCode() == 19) {
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + player.getAttribute("AreaID") + "'");
            throwable = null;
            try {
                if (result.next()) {
                    String AreaID = result.getString("AreaID");
                    String AreaOwner = result.getString("AreaOwner");
                    long OwnerPlayerUID = result.getLong("PlayerUID");
                    if (player.isAdmin()) {
                        database.executeUpdate("DELETE FROM `Areas` WHERE `AreaID` = '" + player.getAttribute("AreaID") + "'");
                        Display.setText(" Area ID" + AreaID + " removed from " + AreaOwner + " ");
                        return;
                    }
                    if (PlayerUID == OwnerPlayerUID) {
                        database.executeUpdate("DELETE FROM `Areas` WHERE `AreaID` = '" + player.getAttribute("AreaID") + "'");
                        Display.setText(" Area ID" + AreaID + " removed from " + AreaOwner + " ");
                        return;
                    }
                }
                if (!result.next()) {
                    Display.setText(" Error you need to move into the area you are removing and you need to own it!!!!");
                    return;
                }
            }
            catch (Throwable AreaID) {
                throwable = AreaID;
                throw AreaID;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        if (evt.isPressed() && evt.getKeyCode() == 46) {
            throwable = null;
            try (ResultSet AreaNumresult = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");){
                int BonusAreas = (Integer)player.getAttribute("BonusAreas");
                int AreaNum = AreaNumresult.getInt("AreaNum") + BonusAreas;
                try (ResultSet Countresults = database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");){
                    int Count = Countresults.getInt("COUNT(*)");
                    if (AreaNum <= Count) {
                        Display.setText(" Area Limit reached!!! ");
                        return;
                    }
                }
            }
            catch (Throwable BonusAreas) {
                throwable = BonusAreas;
                throw BonusAreas;
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + player.getAttribute("AreaID") + "'");
            throwable = null;
            try {
                if (result.next()) {
                    Display.setText(" Error Area ID" + player.getAttribute("AreaID") + " has been clamed!!!");
                    return;
                }
                if (!result.next()) {
                    Object AreaID = player.getAttribute("AreaID");
                    int AreaIDx = (Integer)player.getAttribute("AreaIDx");
                    int AreaIDy = (Integer)player.getAttribute("AreaIDy");
                    int AreaIDz = (Integer)player.getAttribute("AreaIDz");
                    Vector3i StartBlock = new Vector3i(0, 0, 0);
                    Vector3i EndBlock = new Vector3i(15, 63, 15);
                    Vector3i StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                    Vector3i EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                    Area area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                    WorldArea SetArea = new WorldArea(area);
                    SetArea.setAlwaysVisible(false);
                    SetArea.setFrameVisible(true);
                    SetArea.setColor(0.0f, 0.5f, 0.0f, 0.05f);
                    player.addWorldElement((WorldElement)SetArea);
                    Timer FrameVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> SetArea.setFrameVisible(false));
                    FrameVisibleTimer.start();
                    Timer BoxVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> player.removeWorldElement((WorldElement)SetArea));
                    BoxVisibleTimer.start();
                    database.executeUpdate("INSERT INTO `Areas` (AreaOwner, AreaID, AreaStatus, AreaIDx, AreaIDy, AreaIDz, PlayerUID) VALUES ('" + Playername + "','" + AreaID + "','locked','" + AreaIDx + "','" + AreaIDy + "','" + AreaIDz + "','" + PlayerUID + "');");
                    Display.setText(" Area ID" + player.getAttribute("AreaID") + " Now Added to your areas");
                    return;
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable BonusAreas) {
                            throwable.addSuppressed(BonusAreas);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
    }

    @EventMethod
    public void onPlayerGuiClick(PlayerGuiElementClickEvent evt) throws SQLException {
        ResultSet result;
        Throwable throwable;
        String setmode;
        Player player = evt.getPlayer();
        String Playername = player.getName();
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        Long PlayerUID = player.getUID();
        int Click = evt.getMouseButton();
        Display.setText("" + Click + "");
        GuiElement task = evt.getGuiElement();
        GuiLabel closepanel = (GuiLabel)player.getAttribute("closepanel");
        GuiLabel closeautoadd = (GuiLabel)player.getAttribute("closeautoadd");
        GuiLabel openautoadd = (GuiLabel)player.getAttribute("openautoadd");
        GuiLabel openpanel = (GuiLabel)player.getAttribute("openpanel");
        GuiLabel AddArea = (GuiLabel)player.getAttribute("AddArea");
        GuiLabel RemoveArea = (GuiLabel)player.getAttribute("RemoveArea");
        GuiLabel Setlimitup = (GuiLabel)player.getAttribute("Setlimitup");
        GuiLabel Setlimitdown = (GuiLabel)player.getAttribute("Setlimitdown");
        GuiLabel SetBonusup = (GuiLabel)player.getAttribute("SetBonusup");
        GuiLabel SetBonusdown = (GuiLabel)player.getAttribute("SetBonusdown");
        GuiLabel close = (GuiLabel)player.getAttribute("close");
        GuiLabel onoff = (GuiLabel)player.getAttribute("onoff");
        GuiPanel Switch = (GuiPanel)player.getAttribute("Switch");
        GuiPanel Switch2 = (GuiPanel)player.getAttribute("Switch2");
        if (task == null) {
            return;
        }
        if (task == close) {
            onoff.setVisible(false);
            Switch.setVisible(false);
            player.setMouseCursorVisible(false);
        }
        if (task == closepanel) {
            Switch2.setVisible(false);
            openpanel.setVisible(true);
            closepanel.setVisible(false);
        }
        if (task == openpanel) {
            Switch2.setVisible(true);
            openpanel.setVisible(false);
            closepanel.setVisible(true);
        }
        if (task == closeautoadd) {
            setmode = "off";
            player.setAttribute("setmode", (Object)setmode);
            openautoadd.setVisible(true);
            closeautoadd.setVisible(false);
        }
        if (task == openautoadd) {
            setmode = "on";
            player.setAttribute("setmode", (Object)setmode);
            openautoadd.setVisible(false);
            closeautoadd.setVisible(true);
        }
        if (task == AddArea) {
            throwable = null;
            try (ResultSet AreaNumresult = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");){
                int BonusAreas = (Integer)player.getAttribute("BonusAreas");
                int AreaNum = AreaNumresult.getInt("AreaNum") + BonusAreas;
                try (ResultSet Countresults = database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");){
                    int Count = Countresults.getInt("COUNT(*)");
                    if (AreaNum <= Count) {
                        Display.setText(" Area Limit reached!!! ");
                        return;
                    }
                }
            }
            catch (Throwable BonusAreas) {
                throwable = BonusAreas;
                throw BonusAreas;
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + player.getAttribute("AreaID") + "'");
            throwable = null;
            try {
                if (result.next()) {
                    Display.setText(" Error Area ID" + player.getAttribute("AreaID") + " has been clamed!!!");
                    return;
                }
                if (!result.next()) {
                    Object AreaID = player.getAttribute("AreaID");
                    int AreaIDx = (Integer)player.getAttribute("AreaIDx");
                    int AreaIDy = (Integer)player.getAttribute("AreaIDy");
                    int AreaIDz = (Integer)player.getAttribute("AreaIDz");
                    Vector3i StartBlock = new Vector3i(0, 0, 0);
                    Vector3i EndBlock = new Vector3i(15, 63, 15);
                    Vector3i StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                    Vector3i EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                    Area area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                    WorldArea SetArea = new WorldArea(area);
                    SetArea.setAlwaysVisible(false);
                    SetArea.setFrameVisible(true);
                    SetArea.setColor(0.0f, 0.5f, 0.0f, 0.05f);
                    player.addWorldElement((WorldElement)SetArea);
                    Timer FrameVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> SetArea.setFrameVisible(false));
                    FrameVisibleTimer.start();
                    Timer BoxVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> player.removeWorldElement((WorldElement)SetArea));
                    BoxVisibleTimer.start();
                    database.executeUpdate("INSERT INTO `Areas` (AreaOwner, AreaID, AreaStatus, AreaIDx, AreaIDy, AreaIDz, PlayerUID) VALUES ('" + Playername + "','" + AreaID + "','locked','" + AreaIDx + "','" + AreaIDy + "','" + AreaIDz + "','" + PlayerUID + "');");
                    Display.setText(" Area ID" + player.getAttribute("AreaID") + " Now Added to your areas");
                    return;
                }
            }
            catch (Throwable AreaID) {
                throwable = AreaID;
                throw AreaID;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable BonusAreas) {
                            throwable.addSuppressed(BonusAreas);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        if (task == RemoveArea) {
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + player.getAttribute("AreaID") + "'");
            throwable = null;
            try {
                if (result.next()) {
                    String AreaID = result.getString("AreaID");
                    String AreaOwner = result.getString("AreaOwner");
                    long OwnerPlayerUID = result.getLong("PlayerUID");
                    if (player.isAdmin()) {
                        database.executeUpdate("DELETE FROM `Areas` WHERE `AreaID` = '" + player.getAttribute("AreaID") + "'");
                        Display.setText(" Area ID" + AreaID + " removed from " + AreaOwner + " ");
                        return;
                    }
                    if (PlayerUID == OwnerPlayerUID) {
                        database.executeUpdate("DELETE FROM `Areas` WHERE `AreaID` = '" + player.getAttribute("AreaID") + "'");
                        Display.setText(" Area ID" + AreaID + " removed from " + AreaOwner + " ");
                        return;
                    }
                }
                if (!result.next()) {
                    Display.setText(" Error you need to move into the area you are removing and you need to own it!!!!");
                    return;
                }
            }
            catch (Throwable AreaID) {
                throwable = AreaID;
                throw AreaID;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        if (task == Setlimitup) {
            if (player.isAdmin()) {
                result = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");
                throwable = null;
                try {
                    int AreaNum = result.getInt("AreaNum");
                    int AreaNumSet = AreaNum + 10;
                    database.executeUpdate("UPDATE AdminSettings SET AreaNum = '" + AreaNumSet + "' WHERE ID = '1'");
                    Display.setText(" Limit changed upto " + AreaNumSet + "");
                    return;
                }
                catch (Throwable AreaNum) {
                    throwable = AreaNum;
                    throw AreaNum;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            Display.setText(" Error you need to be an Admin to set limits");
        }
        if (task == Setlimitdown) {
            if (player.isAdmin()) {
                result = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");
                throwable = null;
                try {
                    int AreaNum = result.getInt("AreaNum");
                    int AreaNumSet = AreaNum - 10;
                    database.executeUpdate("UPDATE AdminSettings SET AreaNum = '" + AreaNumSet + "' WHERE ID = '1'");
                    Display.setText(" Limit changed upto " + AreaNumSet + "");
                    return;
                }
                catch (Throwable AreaNum) {
                    throwable = AreaNum;
                    throw AreaNum;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            Display.setText(" Error you need to be an Admin to set limits");
        }
        if (task == SetBonusup) {
            if (player.isAdmin()) {
                result = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");
                throwable = null;
                try {
                    int UpNum = result.getInt("UpNum");
                    int UpNumSet = UpNum + 1;
                    database.executeUpdate("UPDATE AdminSettings SET UpNum = '" + UpNumSet + "' WHERE ID = '1'");
                    Display.setText("Bonus Limit changed upto " + UpNumSet + "");
                    return;
                }
                catch (Throwable UpNum) {
                    throwable = UpNum;
                    throw UpNum;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            Display.setText(" Error you need to be an Admin to set limits");
        }
        if (task == SetBonusdown) {
            if (player.isAdmin()) {
                result = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");
                throwable = null;
                try {
                    int UpNum = result.getInt("UpNum");
                    int UpNumSet = UpNum - 1;
                    database.executeUpdate("UPDATE AdminSettings SET UpNum = '" + UpNumSet + "' WHERE ID = '1'");
                    Display.setText("Bonus Limit changed upto " + UpNumSet + "");
                    return;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            Display.setText(" Error you need to be an Admin to set Bonus limits");
        }
    }

    @EventMethod
    public void onPlayerGuiInput(PlayerGuiInputEvent evt) throws SQLException {
    }

    @EventMethod
    public void onPlayerEnterArea(PlayerEnterAreaEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        Area area = evt.getArea();
    }

    @EventMethod
    public void onPlayerLeaveArea(PlayerLeaveAreaEvent evt) throws SQLException {
    }

    @EventMethod
    public void onExplosion(ExplosionEvent event) {
        event.setPlayerDamage((short)0);
        event.setNpcDamage((short)0);
        event.setWorldDamage((short)0);
    }

    @EventMethod
    public void onPlayerChangeBlockPosition(PlayerChangeBlockPositionEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        String Playername = player.getName();
        Vector3i playerblockPos = player.getBlockPosition();
        int blockposx = playerblockPos.x;
        int blockposy = playerblockPos.y;
        int blockposz = playerblockPos.z;
    }

    @EventMethod
    public void onPlayerEnterChunk(PlayerEnterChunkEvent evt) throws SQLException {
        ResultSet result;
        Throwable throwable;
        Player player = evt.getPlayer();
        String Playername = player.getName();
        Long PlayerUID = player.getUID();
        Object tnt = null;
        String itemName = "none";
        Item EquippedItem = player.getEquippedItem();
        if (EquippedItem != null) {
            itemName = EquippedItem.getName();
        }
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        GuiLabel Display1 = (GuiLabel)player.getAttribute("AreaDisplay1");
        GuiLabel Display2 = (GuiLabel)player.getAttribute("AreaDisplay2");
        World3DText ChunkBox = (World3DText)player.getAttribute("ChunkBox");
        if (player.hasAttribute("AreaDisplay")) {
            ((GuiLabel)player.getAttribute("AreaDisplay")).setText("");
        }
        if (player.hasAttribute("AreaDisplay1")) {
            ((GuiLabel)player.getAttribute("AreaDisplay1")).setText("");
        }
        if (player.hasAttribute("AreaDisplay2")) {
            ((GuiLabel)player.getAttribute("AreaDisplay2")).setText("");
        }
        Vector3i AreaIDV = evt.getNewChunkCoordinates();
        int AreaIDx = AreaIDV.x;
        int AreaIDy = AreaIDV.y;
        int AreaIDz = AreaIDV.z;
        String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
        player.setAttribute("AreaIDx", (Object)AreaIDx);
        player.setAttribute("AreaIDy", (Object)AreaIDy);
        player.setAttribute("AreaIDz", (Object)AreaIDz);
        player.setAttribute("AreaID", (Object)AreaID);
        ChunkBox.setPosition((float)AreaIDx, (float)AreaIDy, (float)AreaIDz);
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        try {
            throwable = null;
            try (ResultSet resultNum = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");){
                if (resultNum.next() && Display1 != null) {
                    int AreaNum = resultNum.getInt("AreaNum");
                    int UpNum = resultNum.getInt("UpNum");
                    int ONLineTime = player.getTotalPlayTime();
                    int DevidedTimeToHours = ONLineTime / 60 / 60;
                    int BonusAreas = DevidedTimeToHours * UpNum;
                    int TotalAreas = DevidedTimeToHours * UpNum + AreaNum;
                    player.setAttribute("BonusAreas", (Object)BonusAreas);
                    Display1.setText(" Default Start Areas Allowed = " + AreaNum + " Total Online Hours:" + DevidedTimeToHours + " Bonus Area per Hour:X" + UpNum + " = " + TotalAreas + " Areas");
                }
            }
            catch (Throwable AreaNum) {
                throwable = AreaNum;
                throw AreaNum;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            result = database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");
            throwable = null;
            try {
                if (result.next() && Display2 != null) {
                    String Count = result.getString("COUNT(*)");
                    Display2.setText(" Areas owned = " + Count + " ");
                }
            }
            catch (Throwable Count) {
                throwable = Count;
                throw Count;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable Count) {
                            throwable.addSuppressed(Count);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (result.next() && Display != null) {
                    String AreaOwner = result.getString("AreaOwner");
                    int ID = result.getInt("ID");
                    if (!AreaOwner.equals(Playername) && itemName.matches("tnt")) {
                        player.sendYellMessage("Remove your tnt to enter that area");
                        evt.setCancelled(true);
                        Timer testTimer = new Timer(0.0f, 5.0f, 0, () -> player.sendYellMessage("Remove your tnt to enter that area"));
                        testTimer.start();
                    }
                    Display.setText(" ID:" + ID + " Area " + AreaID + " owned by " + AreaOwner + " ");
                    return;
                }
                if (!result.next() && player.hasAttribute("AreaDisplay")) {
                    ((GuiLabel)player.getAttribute("AreaDisplay")).setText(" Area " + AreaID + " Unprotected ");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventMethod
    public void onPlayerPlaceObject(PlayerPlaceObjectEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        String Playername = player.getName();
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        Long PlayerUID = player.getUID();
        int AreaIDx = evt.getChunkPositionX();
        int AreaIDy = evt.getChunkPositionY();
        int AreaIDz = evt.getChunkPositionZ();
        String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
        player.setAttribute("AreaID", (Object)AreaID);
        short ObjectType = evt.getObjectTypeID();
        int objectinfo = evt.getObjectInfoID();
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        try (ResultSet AreaNumresult = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");){
            ResultSet result;
            Throwable throwable;
            block198: {
                int BonusAreas = (Integer)player.getAttribute("BonusAreas");
                int AreaNum = AreaNumresult.getInt("AreaNum") + BonusAreas;
                throwable = null;
                try (ResultSet Countresults = database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");){
                    int Count = Countresults.getInt("COUNT(*)");
                    if (AreaNum > Count) break block198;
                    try (ResultSet result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                        if (!result2.next()) {
                            Display.setText(" placed Object " + objectinfo + "");
                        }
                    }
                    result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                    var21_39 = null;
                    try {
                        if (result2.next()) {
                            String AreaOwner = result2.getString("AreaOwner");
                            String AreaStatus = result2.getString("AreaStatus");
                            long OwnerPlayerUID = result2.getLong("PlayerUID");
                            if (AreaStatus.matches("unlocked")) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + objectinfo + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (player.isAdmin()) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + objectinfo + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (PlayerUID == OwnerPlayerUID) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + objectinfo + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            evt.setCancelled(true);
                            Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                        }
                    }
                    catch (Throwable AreaOwner) {
                        var21_39 = AreaOwner;
                        throw AreaOwner;
                    }
                    finally {
                        if (result2 != null) {
                            if (var21_39 != null) {
                                try {
                                    result2.close();
                                }
                                catch (Throwable throwable2) {
                                    var21_39.addSuppressed(throwable2);
                                }
                            } else {
                                result2.close();
                            }
                        }
                    }
                    Display.setText(" Area Limit reached!!! ");
                    return;
                }
                catch (Throwable Count) {
                    throwable = Count;
                    throw Count;
                }
            }
            if (player.getAttribute("setmode") == null) {
                String setmode = "on";
                player.setAttribute("setmode", (Object)setmode);
                player.sendTextMessage(setmode);
            }
            if (player.getAttribute("setmode") == "on") {
                result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                throwable = null;
                try {
                    if (!result.next()) {
                        Vector3i StartBlock = new Vector3i(0, 0, 0);
                        Vector3i EndBlock = new Vector3i(15, 63, 15);
                        Vector3i StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Vector3i EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Area area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                        WorldArea SetArea = new WorldArea(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.0f, 0.5f, 0.0f, 0.01f);
                        player.addWorldElement((WorldElement)SetArea);
                        Timer FrameVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> SetArea.setFrameVisible(false));
                        FrameVisibleTimer.start();
                        Timer BoxVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> player.removeWorldElement((WorldElement)SetArea));
                        BoxVisibleTimer.start();
                        database.executeUpdate("INSERT INTO `Areas` (AreaOwner, AreaID, AreaStatus, AreaIDx, AreaIDy, AreaIDz, PlayerUID) VALUES ('" + Playername + "','" + AreaID + "','locked','" + AreaIDx + "','" + AreaIDy + "','" + AreaIDz + "','" + PlayerUID + "');");
                        Display.setText(" placed Object ID" + objectinfo + "  and you now own this area, press p for help");
                        return;
                    }
                }
                catch (Throwable StartBlock) {
                    throwable = StartBlock;
                    throw StartBlock;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) {
                    Display.setText(" placed Object ID" + objectinfo + " , Auto add area is set to off push p to enable it");
                    return;
                }
            }
            catch (Throwable StartBlock) {
                throwable = StartBlock;
                throw StartBlock;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartBlock) {
                            throwable.addSuppressed(StartBlock);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) return;
                String AreaOwner = result.getString("AreaOwner");
                String AreaStatus = result.getString("AreaStatus");
                long OwnerPlayerUID = result.getLong("PlayerUID");
                if (AreaStatus.matches("unlocked")) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + objectinfo + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + objectinfo + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (PlayerUID == OwnerPlayerUID) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + objectinfo + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "' AND `PlayerUID` = '" + PlayerUID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + objectinfo + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var24_61 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + objectinfo + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                catch (Throwable throwable4) {
                    var24_61 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (resultfriend != null) {
                        if (var24_61 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable5) {
                                var24_61.addSuppressed(throwable5);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                return;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable area) {
                            throwable.addSuppressed(area);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventMethod
    public void onPlayerPlaceBlock(PlayerPlaceBlockEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        String Playername = player.getName();
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        Object PlayerUID = null;
        int ObjectIDx = evt.getBlockPositionX();
        int ObjectIDy = evt.getBlockPositionY();
        int ObjectIDz = evt.getBlockPositionZ();
        String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
        int AreaIDx = evt.getChunkPositionX();
        int AreaIDy = evt.getChunkPositionY();
        int AreaIDz = evt.getChunkPositionZ();
        String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
        int ObjectType = evt.getBlockID();
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        try (ResultSet AreaNumresult = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");){
            ResultSet result;
            Throwable throwable;
            block198: {
                int BonusAreas = (Integer)player.getAttribute("BonusAreas");
                int AreaNum = AreaNumresult.getInt("AreaNum") + BonusAreas;
                throwable = null;
                try (ResultSet Countresults = database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");){
                    int Count = Countresults.getInt("COUNT(*)");
                    if (AreaNum > Count) break block198;
                    try (ResultSet result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                        if (!result2.next()) {
                            Display.setText(" placed Object ID" + ObjectID + " now added ");
                        }
                    }
                    result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                    var24_42 = null;
                    try {
                        if (result2.next()) {
                            String AreaOwner = result2.getString("AreaOwner");
                            String AreaStatus = result2.getString("AreaStatus");
                            if (AreaStatus.matches("unlocked")) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (player.isAdmin()) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (Playername.matches(AreaOwner)) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            evt.setCancelled(true);
                            Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                        }
                    }
                    catch (Throwable AreaOwner) {
                        var24_42 = AreaOwner;
                        throw AreaOwner;
                    }
                    finally {
                        if (result2 != null) {
                            if (var24_42 != null) {
                                try {
                                    result2.close();
                                }
                                catch (Throwable throwable2) {
                                    var24_42.addSuppressed(throwable2);
                                }
                            } else {
                                result2.close();
                            }
                        }
                    }
                    Display.setText(" Area Limit reached ");
                    return;
                }
                catch (Throwable Count) {
                    throwable = Count;
                    throw Count;
                }
            }
            if (player.getAttribute("setmode") == null) {
                String setmode = "on";
                player.setAttribute("setmode", (Object)setmode);
                player.sendTextMessage(setmode);
            }
            if (player.getAttribute("setmode") == "on") {
                result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                throwable = null;
                try {
                    if (!result.next()) {
                        Vector3i StartBlock = new Vector3i(0, 0, 0);
                        Vector3i EndBlock = new Vector3i(15, 63, 15);
                        Vector3i StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Vector3i EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Area area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                        WorldArea SetArea = new WorldArea(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.0f, 0.5f, 0.0f, 0.05f);
                        player.addWorldElement((WorldElement)SetArea);
                        Timer FrameVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> SetArea.setFrameVisible(false));
                        FrameVisibleTimer.start();
                        Timer BoxVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> player.removeWorldElement((WorldElement)SetArea));
                        BoxVisibleTimer.start();
                        database.executeUpdate("INSERT INTO `Areas` (AreaOwner, AreaID, AreaStatus, AreaIDx, AreaIDy, AreaIDz, PlayerUID) VALUES ('" + Playername + "','" + AreaID + "','locked','" + AreaIDx + "','" + AreaIDy + "','" + AreaIDz + "','" + PlayerUID + "');");
                        Display.setText(" placed Object ID" + ObjectID + " and you now own this area, press p for help");
                        return;
                    }
                }
                catch (Throwable StartBlock) {
                    throwable = StartBlock;
                    throw StartBlock;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) {
                    Display.setText(" placed Object ID" + ObjectID + " , Auto add area is set to off push p to enable it");
                    return;
                }
            }
            catch (Throwable StartBlock) {
                throwable = StartBlock;
                throw StartBlock;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartBlock) {
                            throwable.addSuppressed(StartBlock);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) return;
                String AreaOwner = result.getString("AreaOwner");
                String AreaStatus = result.getString("AreaStatus");
                if (AreaStatus.matches("unlocked")) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var25_57 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                catch (Throwable throwable4) {
                    var25_57 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (resultfriend != null) {
                        if (var25_57 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable5) {
                                var25_57.addSuppressed(throwable5);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                return;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartChunk) {
                            throwable.addSuppressed(StartChunk);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventMethod
    public void onPlayerPlaceConstruction(PlayerPlaceConstructionEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        String Playername = player.getName();
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        Object PlayerUID = null;
        int ObjectIDx = (int)evt.getConstructionPositionX();
        int ObjectIDy = (int)evt.getConstructionPositionY();
        int ObjectIDz = (int)evt.getConstructionPositionZ();
        String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
        int AreaIDx = evt.getChunkPositionX();
        int AreaIDy = evt.getChunkPositionY();
        int AreaIDz = evt.getChunkPositionZ();
        String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
        short ObjectType = evt.getConstructionTypeID();
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        try (ResultSet AreaNumresult = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");){
            ResultSet result;
            Throwable throwable;
            block198: {
                int BonusAreas = (Integer)player.getAttribute("BonusAreas");
                int AreaNum = AreaNumresult.getInt("AreaNum") + BonusAreas;
                throwable = null;
                try (ResultSet Countresults = database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");){
                    int Count = Countresults.getInt("COUNT(*)");
                    if (AreaNum > Count) break block198;
                    try (ResultSet result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                        if (!result2.next()) {
                            Display.setText(" placed Object ID" + ObjectID + " now added to your Object Ownership ");
                        }
                    }
                    result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                    var24_42 = null;
                    try {
                        if (result2.next()) {
                            String AreaOwner = result2.getString("AreaOwner");
                            String AreaStatus = result2.getString("AreaStatus");
                            if (AreaStatus.matches("unlocked")) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (player.isAdmin()) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (Playername.matches(AreaOwner)) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            evt.setCancelled(true);
                            Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                        }
                    }
                    catch (Throwable AreaOwner) {
                        var24_42 = AreaOwner;
                        throw AreaOwner;
                    }
                    finally {
                        if (result2 != null) {
                            if (var24_42 != null) {
                                try {
                                    result2.close();
                                }
                                catch (Throwable throwable2) {
                                    var24_42.addSuppressed(throwable2);
                                }
                            } else {
                                result2.close();
                            }
                        }
                    }
                    Display.setText(" Area Limit reached ");
                    return;
                }
                catch (Throwable Count) {
                    throwable = Count;
                    throw Count;
                }
            }
            if (player.getAttribute("setmode") == null) {
                String setmode = "on";
                player.setAttribute("setmode", (Object)setmode);
                player.sendTextMessage(setmode);
            }
            if (player.getAttribute("setmode") == "on") {
                result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                throwable = null;
                try {
                    if (!result.next()) {
                        Vector3i StartBlock = new Vector3i(0, 0, 0);
                        Vector3i EndBlock = new Vector3i(15, 63, 15);
                        Vector3i StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Vector3i EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Area area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                        WorldArea SetArea = new WorldArea(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.0f, 0.5f, 0.0f, 0.05f);
                        player.addWorldElement((WorldElement)SetArea);
                        Timer FrameVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> SetArea.setFrameVisible(false));
                        FrameVisibleTimer.start();
                        Timer BoxVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> player.removeWorldElement((WorldElement)SetArea));
                        BoxVisibleTimer.start();
                        database.executeUpdate("INSERT INTO `Areas` (AreaOwner, AreaID, AreaStatus, AreaIDx, AreaIDy, AreaIDz, PlayerUID) VALUES ('" + Playername + "','" + AreaID + "','locked','" + AreaIDx + "','" + AreaIDy + "','" + AreaIDz + "','" + PlayerUID + "');");
                        Display.setText(" placed Object ID" + ObjectID + "  and you now own this area, press p for help");
                        return;
                    }
                }
                catch (Throwable StartBlock) {
                    throwable = StartBlock;
                    throw StartBlock;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) {
                    Display.setText(" placed Object ID" + ObjectID + " now added to your Object Ownership, Auto add area is set to off push p to enable it");
                    return;
                }
            }
            catch (Throwable StartBlock) {
                throwable = StartBlock;
                throw StartBlock;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartBlock) {
                            throwable.addSuppressed(StartBlock);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) return;
                String AreaOwner = result.getString("AreaOwner");
                String AreaStatus = result.getString("AreaStatus");
                if (AreaStatus.matches("unlocked")) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var25_57 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                catch (Throwable throwable4) {
                    var25_57 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (resultfriend != null) {
                        if (var25_57 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable5) {
                                var25_57.addSuppressed(throwable5);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                return;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartChunk) {
                            throwable.addSuppressed(StartChunk);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventMethod
    public void onPlayerPlaceGrass(PlayerPlaceGrassEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        String Playername = player.getName();
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        Object PlayerUID = null;
        int ObjectIDx = evt.getBlockPositionX();
        int ObjectIDy = evt.getBlockPositionY();
        int ObjectIDz = evt.getBlockPositionZ();
        String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
        int AreaIDx = evt.getChunkPositionX();
        int AreaIDy = evt.getChunkPositionY();
        int AreaIDz = evt.getChunkPositionZ();
        String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
        int ObjectType = evt.getGrassID();
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        try (ResultSet AreaNumresult = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");){
            ResultSet result;
            Throwable throwable;
            block198: {
                int BonusAreas = (Integer)player.getAttribute("BonusAreas");
                int AreaNum = AreaNumresult.getInt("AreaNum") + BonusAreas;
                throwable = null;
                try (ResultSet Countresults = database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");){
                    int Count = Countresults.getInt("COUNT(*)");
                    if (AreaNum > Count) break block198;
                    try (ResultSet result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                        if (!result2.next()) {
                            Display.setText(" placed Object ID" + ObjectID + " now added ");
                        }
                    }
                    result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                    var24_42 = null;
                    try {
                        if (result2.next()) {
                            String AreaOwner = result2.getString("AreaOwner");
                            String AreaStatus = result2.getString("AreaStatus");
                            if (AreaStatus.matches("unlocked")) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (player.isAdmin()) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (Playername.matches(AreaOwner)) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            evt.setCancelled(true);
                            Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                        }
                    }
                    catch (Throwable AreaOwner) {
                        var24_42 = AreaOwner;
                        throw AreaOwner;
                    }
                    finally {
                        if (result2 != null) {
                            if (var24_42 != null) {
                                try {
                                    result2.close();
                                }
                                catch (Throwable throwable2) {
                                    var24_42.addSuppressed(throwable2);
                                }
                            } else {
                                result2.close();
                            }
                        }
                    }
                    Display.setText(" Area Limit reached ");
                    return;
                }
                catch (Throwable Count) {
                    throwable = Count;
                    throw Count;
                }
            }
            if (player.getAttribute("setmode") == null) {
                String setmode = "on";
                player.setAttribute("setmode", (Object)setmode);
                player.sendTextMessage(setmode);
            }
            if (player.getAttribute("setmode") == "on") {
                result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                throwable = null;
                try {
                    if (!result.next()) {
                        Vector3i StartBlock = new Vector3i(0, 0, 0);
                        Vector3i EndBlock = new Vector3i(15, 63, 15);
                        Vector3i StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Vector3i EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Area area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                        WorldArea SetArea = new WorldArea(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.0f, 0.5f, 0.0f, 0.05f);
                        player.addWorldElement((WorldElement)SetArea);
                        Timer FrameVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> SetArea.setFrameVisible(false));
                        FrameVisibleTimer.start();
                        Timer BoxVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> player.removeWorldElement((WorldElement)SetArea));
                        BoxVisibleTimer.start();
                        database.executeUpdate("INSERT INTO `Areas` (AreaOwner, AreaID, AreaStatus, AreaIDx, AreaIDy, AreaIDz, PlayerUID) VALUES ('" + Playername + "','" + AreaID + "','locked','" + AreaIDx + "','" + AreaIDy + "','" + AreaIDz + "','" + PlayerUID + "');");
                        Display.setText(" placed Object ID" + ObjectID + " now added to your Object Ownership and you now own this area, press p for help");
                        return;
                    }
                }
                catch (Throwable StartBlock) {
                    throwable = StartBlock;
                    throw StartBlock;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) {
                    Display.setText(" placed Object ID" + ObjectID + ", Auto add area is set to off push p to enable it");
                    return;
                }
            }
            catch (Throwable StartBlock) {
                throwable = StartBlock;
                throw StartBlock;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartBlock) {
                            throwable.addSuppressed(StartBlock);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) return;
                String AreaOwner = result.getString("AreaOwner");
                String AreaStatus = result.getString("AreaStatus");
                if (AreaStatus.matches("unlocked")) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var25_57 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                catch (Throwable throwable4) {
                    var25_57 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (resultfriend != null) {
                        if (var25_57 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable5) {
                                var25_57.addSuppressed(throwable5);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                return;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartChunk) {
                            throwable.addSuppressed(StartChunk);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventMethod
    public void onPlayerPlaceTerrain(PlayerPlaceTerrainEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        String Playername = player.getName();
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        Object PlayerUID = null;
        int ObjectIDx = evt.getBlockPositionX();
        int ObjectIDy = evt.getBlockPositionY();
        int ObjectIDz = evt.getBlockPositionZ();
        String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
        int AreaIDx = evt.getChunkPositionX();
        int AreaIDy = evt.getChunkPositionY();
        int AreaIDz = evt.getChunkPositionZ();
        String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
        int ObjectType = evt.getTerrainID();
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        try (ResultSet AreaNumresult = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");){
            ResultSet result;
            Throwable throwable;
            block198: {
                int BonusAreas = (Integer)player.getAttribute("BonusAreas");
                int AreaNum = AreaNumresult.getInt("AreaNum") + BonusAreas;
                throwable = null;
                try (ResultSet Countresults = database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");){
                    int Count = Countresults.getInt("COUNT(*)");
                    if (AreaNum > Count) break block198;
                    try (ResultSet result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                        if (!result2.next()) {
                            Display.setText(" placed Object ID" + ObjectID + " now added to your Object Ownership ");
                        }
                    }
                    result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                    var24_42 = null;
                    try {
                        if (result2.next()) {
                            String AreaOwner = result2.getString("AreaOwner");
                            String AreaStatus = result2.getString("AreaStatus");
                            if (AreaStatus.matches("unlocked")) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (player.isAdmin()) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (Playername.matches(AreaOwner)) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            evt.setCancelled(true);
                            Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                        }
                    }
                    catch (Throwable AreaOwner) {
                        var24_42 = AreaOwner;
                        throw AreaOwner;
                    }
                    finally {
                        if (result2 != null) {
                            if (var24_42 != null) {
                                try {
                                    result2.close();
                                }
                                catch (Throwable throwable2) {
                                    var24_42.addSuppressed(throwable2);
                                }
                            } else {
                                result2.close();
                            }
                        }
                    }
                    Display.setText(" Area Limit reached ");
                    return;
                }
                catch (Throwable Count) {
                    throwable = Count;
                    throw Count;
                }
            }
            if (player.getAttribute("setmode") == null) {
                String setmode = "on";
                player.setAttribute("setmode", (Object)setmode);
                player.sendTextMessage(setmode);
            }
            if (player.getAttribute("setmode") == "on") {
                result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                throwable = null;
                try {
                    if (!result.next()) {
                        Vector3i StartBlock = new Vector3i(0, 0, 0);
                        Vector3i EndBlock = new Vector3i(15, 63, 15);
                        Vector3i StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Vector3i EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Area area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                        WorldArea SetArea = new WorldArea(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.0f, 0.5f, 0.0f, 0.05f);
                        player.addWorldElement((WorldElement)SetArea);
                        Timer FrameVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> SetArea.setFrameVisible(false));
                        FrameVisibleTimer.start();
                        Timer BoxVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> player.removeWorldElement((WorldElement)SetArea));
                        BoxVisibleTimer.start();
                        database.executeUpdate("INSERT INTO `Areas` (AreaOwner, AreaID, AreaStatus, AreaIDx, AreaIDy, AreaIDz, PlayerUID) VALUES ('" + Playername + "','" + AreaID + "','locked','" + AreaIDx + "','" + AreaIDy + "','" + AreaIDz + "','" + PlayerUID + "');");
                        Display.setText(" placed Object ID" + ObjectID + " and you now own this area, press p for help");
                        return;
                    }
                }
                catch (Throwable StartBlock) {
                    throwable = StartBlock;
                    throw StartBlock;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) {
                    Display.setText(" placed Object ID" + ObjectID + ", Auto add area is set to off push p to enable it");
                    return;
                }
            }
            catch (Throwable StartBlock) {
                throwable = StartBlock;
                throw StartBlock;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartBlock) {
                            throwable.addSuppressed(StartBlock);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) return;
                String AreaOwner = result.getString("AreaOwner");
                String AreaStatus = result.getString("AreaStatus");
                if (AreaStatus.matches("unlocked")) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var25_57 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                catch (Throwable throwable4) {
                    var25_57 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (resultfriend != null) {
                        if (var25_57 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable5) {
                                var25_57.addSuppressed(throwable5);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                return;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartChunk) {
                            throwable.addSuppressed(StartChunk);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventMethod
    public void onPlayerPlaceVegetation(PlayerPlaceVegetationEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        String Playername = player.getName();
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        Object PlayerUID = null;
        int ObjectIDx = (int)evt.getPlantPositionX();
        int ObjectIDy = (int)evt.getPlantPositionY();
        int ObjectIDz = (int)evt.getPlantPositionZ();
        String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
        int AreaIDx = evt.getChunkPositionX();
        int AreaIDy = evt.getChunkPositionY();
        int AreaIDz = evt.getChunkPositionZ();
        String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
        short ObjectType = evt.getPlantTypeID();
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        try (ResultSet AreaNumresult = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");){
            ResultSet result;
            Throwable throwable;
            block198: {
                int BonusAreas = (Integer)player.getAttribute("BonusAreas");
                int AreaNum = AreaNumresult.getInt("AreaNum") + BonusAreas;
                throwable = null;
                try (ResultSet Countresults = database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");){
                    int Count = Countresults.getInt("COUNT(*)");
                    if (AreaNum > Count) break block198;
                    try (ResultSet result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                        if (!result2.next()) {
                            Display.setText(" placed Object ID" + ObjectID + " now added to your Object Ownership ");
                        }
                    }
                    result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                    var24_42 = null;
                    try {
                        if (result2.next()) {
                            String AreaOwner = result2.getString("AreaOwner");
                            String AreaStatus = result2.getString("AreaStatus");
                            if (AreaStatus.matches("unlocked")) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (player.isAdmin()) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (Playername.matches(AreaOwner)) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            evt.setCancelled(true);
                            Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                        }
                    }
                    catch (Throwable AreaOwner) {
                        var24_42 = AreaOwner;
                        throw AreaOwner;
                    }
                    finally {
                        if (result2 != null) {
                            if (var24_42 != null) {
                                try {
                                    result2.close();
                                }
                                catch (Throwable throwable2) {
                                    var24_42.addSuppressed(throwable2);
                                }
                            } else {
                                result2.close();
                            }
                        }
                    }
                    Display.setText(" Area Limit reached ");
                    return;
                }
                catch (Throwable Count) {
                    throwable = Count;
                    throw Count;
                }
            }
            if (player.getAttribute("setmode") == null) {
                String setmode = "on";
                player.setAttribute("setmode", (Object)setmode);
                player.sendTextMessage(setmode);
            }
            if (player.getAttribute("setmode") == "on") {
                result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                throwable = null;
                try {
                    if (!result.next()) {
                        Vector3i StartBlock = new Vector3i(0, 0, 0);
                        Vector3i EndBlock = new Vector3i(15, 63, 15);
                        Vector3i StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Vector3i EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Area area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                        WorldArea SetArea = new WorldArea(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.0f, 0.5f, 0.0f, 0.05f);
                        player.addWorldElement((WorldElement)SetArea);
                        Timer FrameVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> SetArea.setFrameVisible(false));
                        FrameVisibleTimer.start();
                        Timer BoxVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> player.removeWorldElement((WorldElement)SetArea));
                        BoxVisibleTimer.start();
                        database.executeUpdate("INSERT INTO `Areas` (AreaOwner, AreaID, AreaStatus, AreaIDx, AreaIDy, AreaIDz, PlayerUID) VALUES ('" + Playername + "','" + AreaID + "','locked','" + AreaIDx + "','" + AreaIDy + "','" + AreaIDz + "','" + PlayerUID + "');");
                        Display.setText(" placed Object ID" + ObjectID + " and you now own this area, press p for help");
                        return;
                    }
                }
                catch (Throwable StartBlock) {
                    throwable = StartBlock;
                    throw StartBlock;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) {
                    Display.setText(" placed Object ID" + ObjectID + ", Auto add area is set to off push p to enable it");
                    return;
                }
            }
            catch (Throwable StartBlock) {
                throwable = StartBlock;
                throw StartBlock;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartBlock) {
                            throwable.addSuppressed(StartBlock);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) return;
                String AreaOwner = result.getString("AreaOwner");
                String AreaStatus = result.getString("AreaStatus");
                if (AreaStatus.matches("unlocked")) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var25_57 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                catch (Throwable throwable4) {
                    var25_57 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (resultfriend != null) {
                        if (var25_57 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable5) {
                                var25_57.addSuppressed(throwable5);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                return;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartChunk) {
                            throwable.addSuppressed(StartChunk);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventMethod
    public void onPlayerPlaceWater(PlayerPlaceWaterEvent evt) throws SQLException {
        Player player = evt.getPlayer();
        String Playername = player.getName();
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        Object PlayerUID = null;
        int ObjectIDx = evt.getBlockPositionX();
        int ObjectIDy = evt.getBlockPositionY();
        int ObjectIDz = evt.getBlockPositionZ();
        String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
        int AreaIDx = evt.getChunkPositionX();
        int AreaIDy = evt.getChunkPositionY();
        int AreaIDz = evt.getChunkPositionZ();
        String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
        int ObjectType = evt.getWaterID();
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        try (ResultSet AreaNumresult = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");){
            ResultSet result;
            Throwable throwable;
            block198: {
                int BonusAreas = (Integer)player.getAttribute("BonusAreas");
                int AreaNum = AreaNumresult.getInt("AreaNum") + BonusAreas;
                throwable = null;
                try (ResultSet Countresults = database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");){
                    int Count = Countresults.getInt("COUNT(*)");
                    if (AreaNum > Count) break block198;
                    try (ResultSet result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                        if (!result2.next()) {
                            Display.setText(" placed Object ID" + ObjectID + " now added ");
                        }
                    }
                    result2 = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                    var24_42 = null;
                    try {
                        if (result2.next()) {
                            String AreaOwner = result2.getString("AreaOwner");
                            String AreaStatus = result2.getString("AreaStatus");
                            if (AreaStatus.matches("unlocked")) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (player.isAdmin()) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            if (Playername.matches(AreaOwner)) {
                                evt.setCancelled(false);
                                Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                                return;
                            }
                            evt.setCancelled(true);
                            Display.setText(" Protected Area ID" + AreaID + " owner " + AreaOwner + " ");
                        }
                    }
                    catch (Throwable AreaOwner) {
                        var24_42 = AreaOwner;
                        throw AreaOwner;
                    }
                    finally {
                        if (result2 != null) {
                            if (var24_42 != null) {
                                try {
                                    result2.close();
                                }
                                catch (Throwable throwable2) {
                                    var24_42.addSuppressed(throwable2);
                                }
                            } else {
                                result2.close();
                            }
                        }
                    }
                    Display.setText(" Area Limit reached ");
                    return;
                }
                catch (Throwable Count) {
                    throwable = Count;
                    throw Count;
                }
            }
            if (player.getAttribute("setmode") == null) {
                String setmode = "on";
                player.setAttribute("setmode", (Object)setmode);
                player.sendTextMessage(setmode);
            }
            if (player.getAttribute("setmode") == "on") {
                result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
                throwable = null;
                try {
                    if (!result.next()) {
                        Vector3i StartBlock = new Vector3i(0, 0, 0);
                        Vector3i EndBlock = new Vector3i(15, 63, 15);
                        Vector3i StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Vector3i EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        Area area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                        WorldArea SetArea = new WorldArea(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.0f, 0.5f, 0.0f, 0.05f);
                        player.addWorldElement((WorldElement)SetArea);
                        Timer FrameVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> SetArea.setFrameVisible(false));
                        FrameVisibleTimer.start();
                        Timer BoxVisibleTimer = new Timer(0.0f, 120.0f, 0, () -> player.removeWorldElement((WorldElement)SetArea));
                        BoxVisibleTimer.start();
                        database.executeUpdate("INSERT INTO `Areas` (AreaOwner, AreaID, AreaStatus, AreaIDx, AreaIDy, AreaIDz, PlayerUID) VALUES ('" + Playername + "','" + AreaID + "','locked','" + AreaIDx + "','" + AreaIDy + "','" + AreaIDz + "','" + PlayerUID + "');");
                        Display.setText(" placed Object ID" + ObjectID + " and you now own this area, press p for help");
                        return;
                    }
                }
                catch (Throwable StartBlock) {
                    throwable = StartBlock;
                    throw StartBlock;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) {
                    Display.setText(" placed Object ID" + ObjectID + ", Auto add area is set to off push p to enable it");
                    return;
                }
            }
            catch (Throwable StartBlock) {
                throwable = StartBlock;
                throw StartBlock;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartBlock) {
                            throwable.addSuppressed(StartBlock);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) return;
                String AreaOwner = result.getString("AreaOwner");
                String AreaStatus = result.getString("AreaStatus");
                if (AreaStatus.matches("unlocked")) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var25_57 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Area ID" + AreaID + " owner " + AreaOwner + " Object ID" + ObjectID + " Added Object typeid " + ObjectType + " ");
                        return;
                    }
                }
                catch (Throwable throwable4) {
                    var25_57 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (resultfriend != null) {
                        if (var25_57 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable5) {
                                var25_57.addSuppressed(throwable5);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText("Protected Area ID" + AreaID + " owner " + AreaOwner + "");
                return;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable StartChunk) {
                            throwable.addSuppressed(StartChunk);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
    }

    @EventMethod
    public void onPlayerObjectInteraction(PlayerObjectInteractionEvent evt) throws SQLException {
        block56: {
            Player player = evt.getPlayer();
            String Playername = player.getName();
            GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
            int ObjectIDx = (int)evt.getObjectPositionX();
            int ObjectIDy = (int)evt.getObjectPositionY();
            int ObjectIDz = (int)evt.getObjectPositionZ();
            String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
            int AreaIDx = evt.getChunkPositionX();
            int AreaIDy = evt.getChunkPositionY();
            int AreaIDz = evt.getChunkPositionZ();
            String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
            Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
            try (ResultSet result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                if (!result.next()) break block56;
                String AreaOwner = result.getString("AreaOwner");
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var18_22 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    var18_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultfriend != null) {
                        if (var18_22 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable) {
                                var18_22.addSuppressed(throwable);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Object ID" + ObjectID + " Protected ");
            }
        }
    }

    @EventMethod
    public void onPlayerRemoveObject(PlayerRemoveObjectEvent evt) throws SQLException {
        block56: {
            Player player = evt.getPlayer();
            String Playername = player.getName();
            GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
            int ObjectIDx = (int)evt.getObjectPositionX();
            int ObjectIDy = (int)evt.getObjectPositionY();
            int ObjectIDz = (int)evt.getObjectPositionZ();
            String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
            int AreaIDx = evt.getChunkPositionX();
            int AreaIDy = evt.getChunkPositionY();
            int AreaIDz = evt.getChunkPositionZ();
            String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
            Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
            try (ResultSet result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                if (!result.next()) break block56;
                String AreaOwner = result.getString("AreaOwner");
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var18_22 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    var18_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultfriend != null) {
                        if (var18_22 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable) {
                                var18_22.addSuppressed(throwable);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Object ID" + ObjectID + " Protected ");
            }
        }
    }

    @EventMethod
    public void onPlayerRemoveConstruction(PlayerRemoveConstructionEvent evt) throws SQLException {
        block56: {
            Player player = evt.getPlayer();
            String Playername = player.getName();
            GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
            int ObjectIDx = (int)evt.getConstructionPositionX();
            int ObjectIDy = (int)evt.getConstructionPositionY();
            int ObjectIDz = (int)evt.getConstructionPositionZ();
            String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
            int AreaIDx = evt.getChunkPositionX();
            int AreaIDy = evt.getChunkPositionY();
            int AreaIDz = evt.getChunkPositionZ();
            String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
            Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
            try (ResultSet result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                if (!result.next()) break block56;
                String AreaOwner = result.getString("AreaOwner");
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var18_22 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    var18_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultfriend != null) {
                        if (var18_22 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable) {
                                var18_22.addSuppressed(throwable);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Object ID" + ObjectID + " Protected ");
            }
        }
    }

    @EventMethod
    public void onPlayerRemoveGrass(PlayerRemoveGrassEvent evt) throws SQLException {
        block56: {
            Player player = evt.getPlayer();
            String Playername = player.getName();
            GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
            int ObjectIDx = evt.getBlockPositionX();
            int ObjectIDy = evt.getBlockPositionY();
            int ObjectIDz = evt.getBlockPositionZ();
            String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
            int AreaIDx = evt.getChunkPositionX();
            int AreaIDy = evt.getChunkPositionY();
            int AreaIDz = evt.getChunkPositionZ();
            String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
            Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
            try (ResultSet result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                if (!result.next()) break block56;
                String AreaOwner = result.getString("AreaOwner");
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var18_22 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    var18_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultfriend != null) {
                        if (var18_22 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable) {
                                var18_22.addSuppressed(throwable);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Object ID" + ObjectID + " Protected ");
            }
        }
    }

    @EventMethod
    public void onPlayerRemoveVegetation(PlayerRemoveVegetationEvent evt) throws SQLException {
        block56: {
            Player player = evt.getPlayer();
            String Playername = player.getName();
            GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
            int ObjectIDx = (int)evt.getPlantPositionX();
            int ObjectIDy = (int)evt.getPlantPositionY();
            int ObjectIDz = (int)evt.getPlantPositionZ();
            String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
            int AreaIDx = evt.getChunkPositionX();
            int AreaIDy = evt.getChunkPositionY();
            int AreaIDz = evt.getChunkPositionZ();
            String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
            Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
            try (ResultSet result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                if (!result.next()) break block56;
                String AreaOwner = result.getString("AreaOwner");
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var18_22 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    var18_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultfriend != null) {
                        if (var18_22 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable) {
                                var18_22.addSuppressed(throwable);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Object ID" + ObjectID + " Protected ");
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyBlock(PlayerDestroyBlockEvent evt) throws SQLException {
        block56: {
            Player player = evt.getPlayer();
            String Playername = player.getName();
            GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
            int ObjectIDx = evt.getBlockPositionX();
            int ObjectIDy = evt.getBlockPositionY();
            int ObjectIDz = evt.getBlockPositionZ();
            String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
            int AreaIDx = evt.getChunkPositionX();
            int AreaIDy = evt.getChunkPositionY();
            int AreaIDz = evt.getChunkPositionZ();
            String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
            Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
            try (ResultSet result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                if (!result.next()) break block56;
                String AreaOwner = result.getString("AreaOwner");
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + "3");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var18_22 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    var18_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultfriend != null) {
                        if (var18_22 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable) {
                                var18_22.addSuppressed(throwable);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Object ID" + ObjectID + " Protected in " + AreaID + "");
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyVegetation(PlayerDestroyVegetationEvent evt) throws SQLException {
        block56: {
            Player player = evt.getPlayer();
            String Playername = player.getName();
            GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
            int ObjectIDx = (int)evt.getPlantPositionX();
            int ObjectIDy = (int)evt.getPlantPositionY();
            int ObjectIDz = (int)evt.getPlantPositionZ();
            String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
            int AreaIDx = evt.getChunkPositionX();
            int AreaIDy = evt.getChunkPositionY();
            int AreaIDz = evt.getChunkPositionZ();
            String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
            Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
            try (ResultSet result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                if (!result.next()) break block56;
                String AreaOwner = result.getString("AreaOwner");
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var18_22 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    var18_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultfriend != null) {
                        if (var18_22 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable) {
                                var18_22.addSuppressed(throwable);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Object ID" + ObjectID + " Protected ");
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyConstruction(PlayerDestroyConstructionEvent evt) throws SQLException {
        block56: {
            Player player = evt.getPlayer();
            String Playername = player.getName();
            GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
            int ObjectIDx = (int)evt.getConstructionPositionX();
            int ObjectIDy = (int)evt.getConstructionPositionY();
            int ObjectIDz = (int)evt.getConstructionPositionZ();
            String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
            int AreaIDx = evt.getChunkPositionX();
            int AreaIDy = evt.getChunkPositionY();
            int AreaIDz = evt.getChunkPositionZ();
            String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
            Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
            try (ResultSet result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                if (!result.next()) break block56;
                String AreaOwner = result.getString("AreaOwner");
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var18_22 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    var18_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultfriend != null) {
                        if (var18_22 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable) {
                                var18_22.addSuppressed(throwable);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Object ID" + ObjectID + " Protected ");
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyObject(PlayerDestroyObjectEvent evt) throws SQLException {
        block56: {
            Player player = evt.getPlayer();
            String Playername = player.getName();
            GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
            int ObjectIDx = (int)evt.getObjectPositionX();
            int ObjectIDy = (int)evt.getObjectPositionY();
            int ObjectIDz = (int)evt.getObjectPositionZ();
            String ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
            int AreaIDx = evt.getChunkPositionX();
            int AreaIDy = evt.getChunkPositionY();
            int AreaIDz = evt.getChunkPositionZ();
            String AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
            Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
            try (ResultSet result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");){
                if (!result.next()) break block56;
                String AreaOwner = result.getString("AreaOwner");
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var18_22 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " ");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    var18_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultfriend != null) {
                        if (var18_22 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable) {
                                var18_22.addSuppressed(throwable);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Object ID" + ObjectID + " Protected ");
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyTerrain(PlayerDestroyTerrainEvent evt) throws SQLException {
        Throwable throwable;
        ResultSet result;
        Database database;
        String AreaID;
        String ObjectID;
        GuiLabel Display;
        Player player;
        block102: {
            String TerrainType;
            player = evt.getPlayer();
            String Playername = player.getName();
            Display = (GuiLabel)player.getAttribute("AreaDisplay");
            int ObjectIDx = evt.getBlockPositionX();
            int ObjectIDy = evt.getBlockPositionY();
            int ObjectIDz = evt.getBlockPositionZ();
            ObjectID = "" + ObjectIDx + ObjectIDy + ObjectIDz + "";
            int AreaIDx = evt.getChunkPositionX();
            int AreaIDy = evt.getChunkPositionY();
            int AreaIDz = evt.getChunkPositionZ();
            AreaID = "" + AreaIDx + AreaIDy + AreaIDz + "";
            if (evt.getTerrainID() == 0) {
                TerrainType = "Air";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 1) {
                TerrainType = "Dirt";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 2) {
                TerrainType = "Grass";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 3) {
                TerrainType = "Stone Type 1";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 4) {
                TerrainType = "Gravel";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 5) {
                TerrainType = "Stone Type 2";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 6) {
                TerrainType = "Farmland";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 7) {
                TerrainType = "Mud";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 8) {
                TerrainType = "Snow";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 9) {
                TerrainType = "Sand";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 10) {
                TerrainType = "Desertdirt";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 11) {
                TerrainType = "Desertstone";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 12) {
                TerrainType = "Clay";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 13) {
                TerrainType = "Dungeonwall";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 14) {
                TerrainType = "Dungeonfloor";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 15) {
                TerrainType = "Bonewall";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 16) {
                TerrainType = "Hellstone";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -3) {
                TerrainType = "Grass";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 15) {
                TerrainType = "Coal";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -77) {
                TerrainType = "Could be Snow mix with land ?";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -87) {
                TerrainType = "Could be Snow land ?";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -101) {
                TerrainType = "Iron";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -102) {
                TerrainType = "Copper";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -103) {
                TerrainType = "Aluminium";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -104) {
                TerrainType = "Silver";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -105) {
                TerrainType = "Gold";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -106) {
                TerrainType = "Tungsten";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -107) {
                TerrainType = "Cobalt";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == -108) {
                TerrainType = "Mithril";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 100) {
                TerrainType = "water";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            if (evt.getTerrainID() == 101) {
                TerrainType = "saltwater";
                player.setAttribute("AreaType", (Object)TerrainType);
            }
            database = this.getSQLiteConnection(this.getPath() + "/database.db");
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
            throwable = null;
            try {
                if (!result.next()) break block102;
                String AreaOwner = result.getString("AreaOwner");
                if (Playername.matches(AreaOwner)) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " " + player.getAttribute("AreaType") + " ID" + evt.getTerrainID() + " ");
                    return;
                }
                if (player.isAdmin()) {
                    evt.setCancelled(false);
                    Display.setText(" Object ID" + ObjectID + " " + player.getAttribute("AreaType") + " ID" + evt.getTerrainID() + " ");
                    return;
                }
                try (ResultSet resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `AreaID` = '" + AreaID + "'");){
                    String FriendName;
                    if (resultfriend.next() && Playername.matches(FriendName = resultfriend.getString("FriendName"))) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " " + player.getAttribute("AreaType") + " ID" + evt.getTerrainID() + " Protected ");
                        return;
                    }
                }
                resultfriend = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + AreaOwner + "' AND `FriendName` = '" + Playername + "' AND `AreaID` = 'friend'");
                var18_25 = null;
                try {
                    if (resultfriend.next()) {
                        evt.setCancelled(false);
                        Display.setText(" Object ID" + ObjectID + " " + player.getAttribute("AreaType") + " ID" + evt.getTerrainID() + " Protected ");
                        return;
                    }
                }
                catch (Throwable throwable2) {
                    var18_25 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resultfriend != null) {
                        if (var18_25 != null) {
                            try {
                                resultfriend.close();
                            }
                            catch (Throwable throwable3) {
                                var18_25.addSuppressed(throwable3);
                            }
                        } else {
                            resultfriend.close();
                        }
                    }
                }
                evt.setCancelled(true);
                Display.setText(" Object ID" + ObjectID + " " + player.getAttribute("AreaType") + " ID" + evt.getTerrainID() + " Protected ");
                return;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + AreaID + "'");
        throwable = null;
        try {
            if (!result.next()) {
                evt.setCancelled(false);
                Display.setText(" Object ID" + ObjectID + " " + player.getAttribute("AreaType") + " ID" + evt.getTerrainID() + " ");
            }
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            if (result != null) {
                if (throwable != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    result.close();
                }
            }
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent evt) throws SQLException {
        Vector3i chunkPosition;
        WorldArea SetArea;
        Area area;
        Vector3i EndChunk;
        Vector3i StartChunk;
        Vector3i EndBlock;
        Vector3i StartBlock;
        int AreaIDz;
        int AreaIDy;
        String AreaOwner;
        String AreaID2;
        Throwable throwable;
        ResultSet result;
        Player player = evt.getPlayer();
        String Playername = player.getName();
        String command = evt.getCommand();
        String[] cmd = evt.getCommand().split(" ");
        GuiLabel Display = (GuiLabel)player.getAttribute("AreaDisplay");
        GuiLabel Display3 = (GuiLabel)player.getAttribute("AreaDisplay3");
        GuiLabel onoff = (GuiLabel)player.getAttribute("onoff");
        GuiPanel Switch = (GuiPanel)player.getAttribute("Switch");
        GuiPanel Switch2 = (GuiPanel)player.getAttribute("Switch2");
        Database database = this.getSQLiteConnection(this.getPath() + "/database.db");
        Database scriptDatabase = this.getSQLiteConnection(this.getPath() + "/scriptDatabase.db");
        if (cmd.length == 3 && cmd[0].equals("/wpp") && cmd[1].equals("delete")) {
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + cmd[2] + "'");
            throwable = null;
            try {
                if (result.next()) {
                    AreaID2 = result.getString("AreaID");
                    AreaOwner = result.getString("AreaOwner");
                    if (player.isAdmin()) {
                        database.executeUpdate("DELETE FROM `Areas` WHERE `AreaID` = '" + cmd[2] + "'");
                        Display.setText(" Area ID" + AreaID2 + " removed from " + AreaOwner + " ");
                        return;
                    }
                    if (Playername.matches(AreaOwner)) {
                        database.executeUpdate("DELETE FROM `Areas` WHERE `AreaID` = '" + cmd[2] + "'");
                        Display.setText(" Area ID" + AreaID2 + " removed from " + AreaOwner + " ");
                        return;
                    }
                }
            }
            catch (Throwable AreaID2) {
                throwable = AreaID2;
                throw AreaID2;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        if (cmd.length == 4 && cmd[0].equals("/wpp") && cmd[1].equals("add")) {
            if (cmd[3].equals("friend")) {
                result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");
                throwable = null;
                try {
                    if (result.next()) {
                        database.executeUpdate("INSERT INTO `Friends` (OwnerName, FriendName, AreaID) VALUES ('" + Playername + "','" + cmd[2] + "','" + cmd[3] + "');");
                        Display.setText(" Friend " + cmd[2] + " added to all your areas ");
                        return;
                    }
                }
                catch (Throwable AreaID2) {
                    throwable = AreaID2;
                    throw AreaID2;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable AreaID2) {
                                throwable.addSuppressed(AreaID2);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
                Display.setText(" Error you need to own one area before adding any friends ");
                return;
            }
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaID` = '" + cmd[3] + "'");
            throwable = null;
            try {
                if (result.next()) {
                    AreaID2 = result.getString("AreaID");
                    AreaOwner = result.getString("AreaOwner");
                    if (player.isAdmin()) {
                        database.executeUpdate("INSERT INTO `Friends` (OwnerName, FriendName, AreaID) VALUES ('" + AreaOwner + "','" + cmd[2] + "','" + AreaID2 + "');");
                        Display.setText(" Friend" + cmd[2] + " added to area " + AreaID2 + " ");
                        return;
                    }
                    if (Playername.matches(AreaOwner)) {
                        database.executeUpdate("INSERT INTO `Friends` (OwnerName, FriendName, AreaID) VALUES ('" + AreaOwner + "','" + cmd[2] + "','" + AreaID2 + "');");
                        Display.setText(" Friend" + cmd[2] + " added to area " + AreaID2 + " ");
                        return;
                    }
                }
            }
            catch (Throwable AreaID3) {
                throwable = AreaID3;
                throw AreaID3;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        if (cmd.length == 5 && cmd[0].equals("/wpp") && cmd[1].equals("friends")) {
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaOwner` = '" + cmd[2] + "'");
            throwable = null;
            try {
                if (result.next()) {
                    String AreaOwner2 = result.getString("AreaOwner");
                    if (player.isAdmin()) {
                        database.executeUpdate("INSERT INTO `Friends` (OwnerName, FriendName, AreaID) VALUES ('" + cmd[2] + "','" + cmd[3] + "','" + cmd[4] + "');");
                        Display.setText(" Friend " + cmd[3] + " added to " + AreaOwner2 + " Friends List ");
                        return;
                    }
                }
            }
            catch (Throwable AreaOwner2) {
                throwable = AreaOwner2;
                throw AreaOwner2;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable AreaOwner3) {
                            throwable.addSuppressed(AreaOwner3);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            Display.setText(" Friend " + cmd[3] + " cannot be added to " + cmd[2] + "Because they own no areas ");
        }
        if (cmd.length == 5 && cmd[0].equals("/wpp") && cmd[1].equals("remove")) {
            if (player.isAdmin()) {
                database.executeUpdate("DELETE FROM `Friends` WHERE `FriendName` = '" + cmd[2] + "' AND `OwnerName` = '" + cmd[4] + "'");
                Display.setText(" User " + cmd[2] + " removed from " + cmd[4] + "s Area List ");
                return;
            }
            result = database.executeQuery("SELECT * FROM `Friends` WHERE `OwnerName` = '" + Playername + "'");
            throwable = null;
            try {
                String OwnerName;
                if (result.next() && Playername.matches(OwnerName = result.getString("OwnerName"))) {
                    database.executeUpdate("DELETE FROM `Friends` WHERE `FriendName` = '" + cmd[2] + "' AND `OwnerName` = '" + Playername + "'");
                    Display.setText(" Friend" + cmd[2] + " removed from all your area lis ");
                    return;
                }
            }
            catch (Throwable OwnerName) {
                throwable = OwnerName;
                throw OwnerName;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable AreaOwner3) {
                            throwable.addSuppressed(AreaOwner3);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        if (cmd.length == 4 && cmd[0].equals("/wpp") && cmd[1].equals("delete") && cmd[2].equals("all")) {
            result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaOwner` = '" + cmd[3] + "'");
            throwable = null;
            try {
                if (result.next()) {
                    AreaID2 = result.getString("AreaID");
                    AreaOwner = result.getString("AreaOwner");
                    if (player.isAdmin()) {
                        database.executeUpdate("DELETE FROM `Areas` WHERE `AreaOwner` = '" + cmd[3] + "'");
                        Display.setText(" All protected areas removed from " + AreaOwner + " ");
                        return;
                    }
                    if (Playername.matches(AreaOwner)) {
                        database.executeUpdate("DELETE FROM `Areas` WHERE `AreaOwner` = '" + cmd[3] + "'");
                        Display.setText(" All protected areas removed from " + AreaOwner + " ");
                        return;
                    }
                }
            }
            catch (Throwable AreaID4) {
                throwable = AreaID4;
                throw AreaID4;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        if (cmd.length == 5 && cmd[0].equals("/wpp") && cmd[1].equals("delete") && cmd[2].equals("all") && cmd[3].equals("objects")) {
            result = database.executeQuery("SELECT * FROM `Objects` WHERE `ObjectOwner` = '" + cmd[4] + "'");
            throwable = null;
            try {
                if (result.next()) {
                    String ObjectOwner = result.getString("ObjectOwner");
                    if (player.isAdmin()) {
                        database.executeUpdate("DELETE FROM `Objects` WHERE `ObjectOwner` = '" + cmd[4] + "'");
                        Display.setText(" All Objects removed from " + ObjectOwner + "s protection ");
                        return;
                    }
                    if (Playername.matches(ObjectOwner)) {
                        database.executeUpdate("DELETE FROM `Objects` WHERE `ObjectOwner` = '" + cmd[4] + "'");
                        Display.setText(" All Objects removed from " + ObjectOwner + "s protection ");
                        return;
                    }
                }
            }
            catch (Throwable ObjectOwner) {
                throwable = ObjectOwner;
                throw ObjectOwner;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable AreaOwner4) {
                            throwable.addSuppressed(AreaOwner4);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        if (cmd.length == 2 && cmd[0].equals("/wpp") && cmd[1].equals("hideareas")) {
            player.removeAllWorldElements();
        }
        if (cmd.length == 2 && cmd[0].equals("/wpp") && cmd[1].equals("showareas")) {
            try {
                result = database.executeQuery("SELECT * FROM `Areas` WHERE `AreaOwner` = '" + Playername + "'");
                throwable = null;
                try {
                    int i = 1;
                    while (result.next()) {
                        int AreaIDx = result.getInt("AreaIDx");
                        AreaIDy = result.getInt("AreaIDy");
                        AreaIDz = result.getInt("AreaIDz");
                        StartBlock = new Vector3i(0, 0, 0);
                        EndBlock = new Vector3i(15, 63, 15);
                        StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                        SetArea = new WorldArea(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.0f, 0.0f, 0.5f, 0.05f);
                        player.addWorldElement((WorldElement)SetArea);
                        ++i;
                    }
                }
                catch (Throwable i) {
                    throwable = i;
                    throw i;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable i) {
                                throwable.addSuppressed(i);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (cmd.length == 2 && cmd[0].equals("/wpp") && cmd[1].equals("showallareas")) {
            try {
                result = database.executeQuery("SELECT * FROM `Areas`");
                throwable = null;
                try {
                    int i = 1;
                    while (result.next()) {
                        int AreaIDx = result.getInt("AreaIDx");
                        AreaIDy = result.getInt("AreaIDy");
                        AreaIDz = result.getInt("AreaIDz");
                        StartBlock = new Vector3i(0, 0, 0);
                        EndBlock = new Vector3i(15, 63, 15);
                        StartChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        EndChunk = new Vector3i(AreaIDx, AreaIDy, AreaIDz);
                        area = new Area(StartChunk, StartBlock, EndChunk, EndBlock);
                        SetArea = new WorldArea(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.5f, 0.0f, 0.0f, 0.05f);
                        player.addWorldElement((WorldElement)SetArea);
                        ++i;
                    }
                }
                catch (Throwable i) {
                    throwable = i;
                    throw i;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable i) {
                                throwable.addSuppressed(i);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (cmd.length == 2 && cmd[0].equals("/wpp") && cmd[1].equals("listallareas")) {
            try {
                result = database.executeQuery("SELECT * FROM `Areas`");
                throwable = null;
                try {
                    int i = 1;
                    while (result.next()) {
                        String Owner = result.getString("AreaOwner");
                        int ID = result.getInt("ID");
                        String AreaID5 = result.getString("AreaID");
                        player.sendTextMessage("ID:" + ID + "  PlayerName:" + Owner + " AreaID:" + AreaID5 + "");
                        ++i;
                    }
                }
                catch (Throwable i) {
                    throwable = i;
                    throw i;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable i) {
                                throwable.addSuppressed(i);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (cmd.length == 3 && cmd[0].equals("/wpp") && cmd[1].equals("tp")) {
            try {
                result = database.executeQuery("SELECT * FROM `Areas` where `ID` = '" + cmd[2] + "'");
                throwable = null;
                try {
                    if (result.next()) {
                        if (player.isFlying()) {
                            String Owner = result.getString("AreaOwner");
                            int ID = result.getInt("ID");
                            String AreaID6 = result.getString("AreaID");
                            int AreaIDx = result.getInt("AreaIDx");
                            int AreaIDy2 = result.getInt("AreaIDy");
                            int AreaIDz2 = result.getInt("AreaIDz");
                            chunkPosition = new Vector3i(AreaIDx, 0, AreaIDz2);
                            Vector3i blockPosition = new Vector3i(8, 32, 8);
                            Vector3f GlobalPosition = Utils.ChunkUtils.getGlobalPosition((Vector3i)chunkPosition, (Vector3i)blockPosition);
                            float GBx = GlobalPosition.getX();
                            float GBy = GlobalPosition.getY();
                            float GBz = GlobalPosition.getZ();
                            player.setPosition(GBx, GBy, GBz);
                            player.sendTextMessage("Teleporting player to area ID:" + ID + "  PlayerName:" + Owner + " AreaID:" + AreaID6 + "");
                        } else if (!player.isFlying()) {
                            player.sendTextMessage("before you can teleport you must be in fly mode, or you can use /wpp areatp AreaID");
                            return;
                        }
                        return;
                    }
                    if (!result.next()) {
                        player.sendTextMessage("Error Unknowin Area ID");
                        return;
                    }
                }
                catch (Throwable Owner) {
                    throwable = Owner;
                    throw Owner;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable Owner) {
                                throwable.addSuppressed(Owner);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (cmd.length == 3 && cmd[0].equals("/wpp") && cmd[1].equals("areatp")) {
            try {
                result = database.executeQuery("SELECT * FROM `Areas` where `ID` = '" + cmd[2] + "'");
                throwable = null;
                try {
                    if (result.next()) {
                        String Owner = result.getString("AreaOwner");
                        int ID = result.getInt("ID");
                        String AreaID7 = result.getString("AreaID");
                        int AreaIDx = result.getInt("AreaIDx");
                        int AreaIDy3 = result.getInt("AreaIDy");
                        int AreaIDz3 = result.getInt("AreaIDz");
                        chunkPosition = new Vector3i(AreaIDx, 0, AreaIDz3);
                        int getblockX = 8;
                        int getblockZ = 8;
                        ChunkLOD chunklod = this.world.getChunkLOD(AreaIDx, AreaIDz3);
                        short SurfaceElevation = chunklod.getSurfaceElevation(getblockX, getblockZ);
                        Vector3i blockPosition = new Vector3i(8, (int)SurfaceElevation, 8);
                        Vector3f GlobalPosition = Utils.ChunkUtils.getGlobalPosition((Vector3i)chunkPosition, (Vector3i)blockPosition);
                        float GBx = GlobalPosition.getX();
                        float GBy = GlobalPosition.getY();
                        float GBz = GlobalPosition.getZ();
                        player.setPosition(GBx, GBy, GBz);
                        player.sendTextMessage("Teleporting player to area ID:" + ID + "  PlayerName:" + Owner + " AreaID:" + AreaID7 + "");
                        return;
                    }
                    if (!result.next()) {
                        player.sendTextMessage("Error Unknowin Area ID");
                        return;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (cmd.length == 4 && cmd[0].equals("/wpp") && cmd[1].equals("set") && cmd[2].equals("limit")) {
            result = database.executeQuery("SELECT * FROM `AdminSettings` WHERE `ID` = '1'");
            throwable = null;
            try {
                if (player.isAdmin()) {
                    database.executeUpdate("UPDATE AdminSettings SET AreaNum = '" + cmd[3] + "' WHERE ID = '1'");
                    Display.setText(" Area limit now updated to " + cmd[3] + " ");
                    return;
                }
                Display.setText(" Error!!! you need to be admin to change this setting ");
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        if (cmd.length == 2 && cmd[0].equals("/wpp") && cmd[1].equals("help")) {
            Display3.setText("[#00FF12]---World Protection Help-----------------------------------------------------------------------------------------------------------\n\n[#4f51ff]Player Commands Note:The AreaID is showin at the bottom left of your screen when you move into an area\n\n[#ffffff]/wpp delete AreaID = Removes the area with the given AreaID from your area list\n/wpp delete all username = Removes all your areas from your protected area list\n/wpp add username AreaID = Adds the user to the area with the given AreaID\n/wpp add username friend = Adds a friend to all your Areas Note:the name has to be 100% the same as there username\n/wpp remove FrendName from OwnerName = removes a friend from all your areas\n/wpp delete all objects username = removes all items and objects from your object protection list\n/wpp showareas = shows your areas\n/wpp hideareas = hides your areas\n/wpp showallareas = shows all the areas\n/wpp listallareas = lists all the areas to get the id\n/wpp tp ID = Teleports a player to the center of an area, flymode must be on\n/wpp areatp ID = Teleports a player to the ground level of an area\nNote:The true area could be deep in the ground or high in the sky when /wpp areatp is used\n\n\n\n\n\nKeys: R = remove area, C = claim area, M = map, P = open or close help\n\n[#ff0202]Admin Commands\n[#ffffff]/wpp set limit 1000 = Sets the limit of areas users can claim 1000 is the defalt example /wpp set limit 75 = 75 areas set\n/wpp friends Ownername Friendname friend  =  Adds a friend to a players areas for players\n\n\n\n[#00FF12]-----------------------------------------------------------------------------------------------------------------------------------");
            onoff.setVisible(true);
            Switch.setVisible(true);
            player.setMouseCursorVisible(true);
        }
    }

    private Area getArea() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

