/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.switchgrasstype;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.world.PlayerPlaceGrassEvent;
import net.risingworld.api.objects.Player;

public class GrassTypeSwitch
extends Plugin
implements Listener {
    private static final String CHAT_CMD = "grass";
    private static final String OPT_HELP = "help";
    private static final String OPT_DEF = "def";
    private static final String OPT_SAV = "sav";
    private static final String OPT_MDW = "mdw";
    private static final String OPT_TUN = "tun";
    private static final String OPT_ICE = "ice";
    private static final String ATTR_NAME = "sgt_type";
    private static final int TYPE_SAV = -57;
    private static final int TYPE_MDW = -29;
    private static final int TYPE_TUN = -77;
    private static final int TYPE_ICE = -85;
    private static final Map<String, String> desc = new HashMap<String, String>(5);

    public void onEnable() {
        this.registerEventListener(this);
    }

    public void onDisable() {
        this.unregisterEventListener(this);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerConnectEvent(PlayerConnectEvent evt) {
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent evt) {
        Player player = evt.getPlayer();
        player.deleteAttribute(ATTR_NAME);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerSpawnEvent(PlayerSpawnEvent evt) {
        Player player = evt.getPlayer();
        player.setAttribute(ATTR_NAME, (Object)OPT_DEF);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerPlaceGrassEvent(PlayerPlaceGrassEvent evt) {
        String type;
        if (evt.isCancelled()) {
            return;
        }
        Player player = evt.getPlayer();
        switch (type = (String)player.getAttribute(ATTR_NAME)) {
            case "sav": {
                evt.setGrassID(-57);
                break;
            }
            case "mdw": {
                evt.setGrassID(-29);
                break;
            }
            case "tun": {
                evt.setGrassID(-77);
                break;
            }
            case "ice": {
                evt.setGrassID(-85);
                break;
            }
        }
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerCommand(PlayerCommandEvent evt) {
        Player player = evt.getPlayer();
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() < 2) {
            return;
        }
        String cmd = st.nextToken();
        if (!CHAT_CMD.equals(cmd)) {
            return;
        }
        switch (cmd = st.nextToken()) {
            case "help": {
                this.printHelp(player);
                break;
            }
            case "def": 
            case "sav": 
            case "mdw": 
            case "tun": 
            case "ice": {
                player.setAttribute(ATTR_NAME, (Object)cmd);
                player.sendTextMessage("[#ffff00]Grass type switched to: " + desc.get(cmd));
                break;
            }
        }
    }

    private void printHelp(Player player) {
        String type = (String)player.getAttribute(ATTR_NAME);
        player.sendTextMessage("");
        player.sendTextMessage("");
        player.sendTextMessage("");
        player.sendTextMessage("***************************************");
        player.sendTextMessage("*           SwitchGrassType           *");
        player.sendTextMessage("***************************************");
        player.sendTextMessage("* [#ffff00]/grass def   [#7fff00]reset to " + desc.get(OPT_DEF));
        player.sendTextMessage("* [#ffff00]/grass sav   [#7fff00]place " + desc.get(OPT_SAV));
        player.sendTextMessage("* [#ffff00]/grass mdw   [#7fff00]place " + desc.get(OPT_MDW));
        player.sendTextMessage("* [#ffff00]/grass tun   [#7fff00]place " + desc.get(OPT_TUN));
        player.sendTextMessage("* [#ffff00]/grass ice   [#7fff00]place " + desc.get(OPT_ICE));
        player.sendTextMessage("* ");
        player.sendTextMessage("* Actual grass type: " + desc.get(type));
        player.sendTextMessage("***************************************");
    }

    static {
        desc.put(OPT_DEF, "default grass");
        desc.put(OPT_SAV, "savannah grass");
        desc.put(OPT_MDW, "meadow grass");
        desc.put(OPT_TUN, "tundra grass");
        desc.put(OPT_ICE, "iced grass");
    }
}

