/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.WorldGard;
import de.pbplugins.tools.classDimension;
import de.pbplugins.tools.wgConfig;
import de.pbplugins.wgArea;
import de.pbplugins.wgClassText;
import java.util.ArrayList;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeGamemodeEvent;
import net.risingworld.api.events.player.PlayerChatEvent;
import net.risingworld.api.events.player.PlayerChestAccessEvent;
import net.risingworld.api.events.player.PlayerCraftItemEvent;
import net.risingworld.api.events.player.PlayerDamageEvent;
import net.risingworld.api.events.player.PlayerElementHitEvent;
import net.risingworld.api.events.player.PlayerElementInteractionEvent;
import net.risingworld.api.events.player.PlayerEnterAreaEvent;
import net.risingworld.api.events.player.PlayerHitEvent;
import net.risingworld.api.events.player.PlayerLeaveAreaEvent;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.events.player.PlayerPickupItemEvent;
import net.risingworld.api.events.player.PlayerSleepEvent;
import net.risingworld.api.events.player.PlayerStartFlyingEvent;
import net.risingworld.api.events.player.PlayerStopFlyingEvent;
import net.risingworld.api.events.player.inventory.PlayerChestDropEvent;
import net.risingworld.api.events.player.inventory.PlayerChestToInventoryEvent;
import net.risingworld.api.events.player.inventory.PlayerInventoryAddEvent;
import net.risingworld.api.events.player.inventory.PlayerInventoryToChestEvent;
import net.risingworld.api.events.player.world.PlayerObjectEvent;
import net.risingworld.api.objects.Player;

public class WorldGardListenerPlayer
implements Listener {
    private final WorldGard plugin;
    private final wgArea area;
    private final Database sqlite;
    private int debug = 1;
    private wgClassText textDaten;
    private final wgConfig sysConfig;

    public WorldGardListenerPlayer(WorldGard plugin) {
        this.plugin = plugin;
        this.area = plugin.getAreaDaten();
        this.sqlite = plugin.getSqlite();
        this.textDaten = plugin.getTextDaten();
        this.sysConfig = plugin.getSysConfig();
        this.debug = plugin.getDebug();
    }

    @EventMethod
    public void onPlayerChatEvent(PlayerChatEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Chat Spieler[" + event.getPlayer().getName() + "]\t" + event.getChatMessage());
        }
    }

    @EventMethod
    public void onPlayerChestAccessEvent(PlayerChestAccessEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ChestAccess ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "CheastAccess")) != null) {
            if ((Integer)res.get(0) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin") == "true") {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerChestDropEvent(PlayerChestDropEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ChestDrop ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "ChestDrop")) != null) {
            if ((Integer)res.get(0) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin") == "true") {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerChestToInventoryEvent(PlayerChestToInventoryEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ChestToInventory ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "ChestToInventory")) != null) {
            if ((Integer)res.get(0) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin") == "true") {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerInventoryToChestEvent(PlayerInventoryToChestEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] InventoryToChest ");
        }
    }

    @EventMethod
    public void onPlayerChangeGamemodeEvent(PlayerChangeGamemodeEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ChangeGamemode ");
        }
    }

    @EventMethod
    public void onPlayerCraftItemEvent(PlayerCraftItemEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] CraftItem ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "Craft")) != null) {
            if ((Integer)res.get(0) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin") == "true") {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerDamageEvent(PlayerDamageEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Damage ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "Damage")) != null) {
            if ((Integer)res.get(0) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin") == "true") {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerEnterAreaEvent(PlayerEnterAreaEvent event) {
        ArrayList res;
        Player player = event.getPlayer();
        int dbINT = 0;
        String dbSTRING = null;
        int srvID = event.getArea().getID();
        if (this.debug > 1) {
            System.out.println("[" + this.plugin.getDescription("name") + "] EnterArea ID[" + srvID + "]");
        }
        if ((res = (ArrayList)this.area.getDBWert(srvID, "AreaName, Enter, AreaWelcomMsg, NoEnterAreaMsg")) != null) {
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] EnterArea | " + res.get(0).getClass() + " " + res.get(1).getClass() + " " + res.get(2).getClass());
            }
            if (res.get(0).getClass().equals(String.class)) {
                dbSTRING = (String)res.get(0);
            }
            if (res.get(1).getClass().equals(Integer.class)) {
                dbINT = (Integer)res.get(1);
            }
            if (res.get(2).getClass().equals(String.class)) {
                dbSTRING = (String)res.get(2);
            }
            if (res.get(3).getClass().equals(String.class)) {
                dbSTRING = (String)res.get(3);
            }
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] EnterArea # " + dbINT + " " + dbSTRING + " " + (String)res.get(2));
            }
            if ((Integer)res.get(1) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin").toLowerCase().equals("true")) {
                if ((String)res.get(2) != null) {
                    player.sendTextMessage(String.format(this.plugin.parseColor("[I]" + (String)res.get(2)), (String)res.get(0), srvID));
                }
            } else {
                event.setCancelled(true);
                if ((String)res.get(3) != null) {
                    player.sendTextMessage(String.format(this.plugin.parseColor("[I]" + (String)res.get(3)), (String)res.get(0), srvID));
                }
            }
        }
    }

    @EventMethod
    public void onPlayerLeaveAreaEvent(PlayerLeaveAreaEvent event) {
        ArrayList res;
        Player player = event.getPlayer();
        int srvID = event.getArea().getID();
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] LeaveArea ID[" + srvID + "]");
        }
        if ((res = (ArrayList)this.area.getDBWert(event.getArea().getID(), "AreaName, Leave, AreaFarewellMsg, NoLeaveAreaMsg")) != null) {
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] LeaveArea | " + res.get(0).toString() + " " + res.get(1).toString());
            }
            if ((Integer)res.get(1) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin").toLowerCase().equals("true")) {
                if ((String)res.get(2) != null) {
                    player.sendTextMessage(String.format(this.plugin.parseColor("[I]" + (String)res.get(2)), (String)res.get(0), srvID));
                }
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerSleepEvent(PlayerSleepEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Sleep ");
        }
    }

    @EventMethod
    public void onPlayerStartFlyingEvent(PlayerStartFlyingEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] StartFlying ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "Fly")) != null) {
            if ((Integer)res.get(0) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin") == "true") {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerStopFlyingEvent(PlayerStopFlyingEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] StopFlying ");
        }
    }

    @EventMethod
    public void onPlayerPickupItemEvent(PlayerPickupItemEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] PickupItem ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "PickupItem")) != null) {
            if ((Integer)res.get(0) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin") == "true") {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerObjectInteractionEvent(PlayerObjectInteractionEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ObjectInteraction W\u00e4hlbar[" + event.isObjectSelectable() + "]\tType[" + event.getObjectTypeID() + "]\tVariante[" + event.getObjectVariation() + "]\tStatus[" + event.getObjectStatus() + "]\tInfoID[" + event.getObjectInfoID() + "] ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "InteractObject, Sleep, DoorOpen")) != null) {
            if ((Integer)res.get(0) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin") == "true") {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerObjectEvent(PlayerObjectEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Object ");
        }
    }

    @EventMethod
    public void onPlayerElementInteractionEvent(PlayerElementInteractionEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ElementInteraction ");
        }
    }

    @EventMethod
    public void onPlayerElementHitEvent(PlayerElementHitEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] PlayerElementHit ");
        }
    }

    @EventMethod
    public void onPlayerInventoryAddEvent(PlayerInventoryAddEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] InventoryAdd  ItemType[" + event.getItem().getTypeID() + "]  ItemVariation[" + event.getItem().getVariation() + "]  ItemStatus[" + event.getItem().getStatus() + "]  ItemOrigin[" + event.getOrigin().ordinal() + "]  Origin[" + event.getOrigin().name() + "] ");
        }
    }

    @EventMethod
    public void onPlayerHitEvent(PlayerHitEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] PVP ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "PVP")) != null) {
            if ((Integer)res.get(0) == -1 || player.isAdmin() && this.sysConfig.getValue("IgnoreAdmin") == "true") {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }
}

