/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.WorldGard;
import de.pbplugins.classDimension;
import de.pbplugins.classIDs;
import de.pbplugins.classWorldArea;
import de.pbplugins.wgCRT;
import de.pbplugins.wgClassText;
import de.pbplugins.wgConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import net.risingworld.api.Server;
import net.risingworld.api.database.Database;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.World3DText;
import net.risingworld.api.worldelements.WorldArea;
import net.risingworld.api.worldelements.WorldElement;

public class wgArea {
    private final WorldGard plugin;
    private Database sqlite;
    private wgClassText textDaten;
    private wgConfig sysConfig;
    private int debug = 1;
    private Server server;
    private ArrayList<classIDs> IDs = null;
    public String playerIsAreaCreate;
    public String playerIsAreaName;
    public String playerIsAreaEigenschaft;
    public String playerGuiLabelAreaCreateEnter;
    public String playerGuiAreaDaten;

    public wgArea(WorldGard plugin) {
        this.plugin = plugin;
        this.playerIsAreaCreate = plugin.getDescription("name") + "_isAreaCreate";
        this.playerIsAreaName = plugin.getDescription("name") + "_isAreaName";
        this.playerIsAreaEigenschaft = plugin.getDescription("name") + "_isAreaEigenschaft";
        this.playerGuiLabelAreaCreateEnter = plugin.getDescription("name") + "_guiAreaCreateEnter";
        this.playerGuiAreaDaten = plugin.getDescription("name") + "_guiAreaDaten";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnable() {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Lade Area");
        }
        this.sqlite = this.plugin.getSqlite();
        this.textDaten = this.plugin.getTextDaten();
        this.sysConfig = this.plugin.getSysConfig();
        this.server = this.plugin.getServer();
        this.IDs = new ArrayList();
        try (ResultSet result = this.sqlite.executeQuery("SELECT * FROM 'Areas'");){
            if (result != null) {
                while (result.next()) {
                    int id = result.getInt("AreaID");
                    int srvID = result.getInt("srvID");
                    String name = result.getString("AreaName");
                    float GlobalStartposX = result.getFloat("GlobalStartposX");
                    float GlobalStartposY = result.getFloat("GlobalStartposY");
                    float GlobalStartposZ = result.getFloat("GlobalStartposZ");
                    float GlobalEndposX = result.getFloat("GlobalEndposX");
                    float GlobalEndposY = result.getFloat("GlobalEndposY");
                    float GlobalEndposZ = result.getFloat("GlobalEndposZ");
                    Vector3f Start = new Vector3f(GlobalStartposX, GlobalStartposY, GlobalStartposZ);
                    Vector3f End = new Vector3f(GlobalEndposX, GlobalEndposY, GlobalEndposZ);
                    Area area = new Area(Start, End);
                    this.server.addArea(area);
                    classIDs inp = new classIDs();
                    inp.srvID = area.getID();
                    inp.dbID = id;
                    inp.Name = name;
                    this.IDs.add(inp);
                    if (this.debug <= 2) continue;
                    System.out.println("[" + this.plugin.getDescription("name") + "] Finde AreaID[" + id + "] SET srvID[" + area.getID() + "] ID.size[" + this.IDs.size() + "]");
                }
            }
        }
        catch (SQLException e) {
            System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
        }
        finally {
            Connection con = this.sqlite.getConnection();
            this.IDs.forEach(vID -> {
                try {
                    PreparedStatement prep = con.prepareStatement("UPDATE 'Areas' SET srvID = " + vID.srvID + " WHERE AreaID = " + vID.dbID);
                    prep.executeUpdate();
                }
                catch (SQLException e) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
                }
            });
        }
    }

    public void onPlayerConnect(Player player) {
        ArrayList worldArea = new ArrayList();
        player.setAttribute(this.playerGuiAreaDaten, worldArea);
        this.server.getAllAreas().stream().map(area -> {
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] onPlayerConnect srvAreaID[" + area.getID() + "]");
            }
            return area;
        }).forEachOrdered(area -> this.IDs.stream().filter(iArea -> area.getID() == iArea.srvID).map(iArea -> {
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] onPlayerConnect     srvID[" + iArea.srvID + "] dbID[" + iArea.dbID + "] Name[" + iArea.Name + "]");
            }
            return iArea;
        }).forEachOrdered(iArea -> this.createWorldArea(player, (Area)area, (classIDs)iArea)));
        this.showAllAreas(player, (ArrayList)player.getAttribute(this.playerGuiAreaDaten));
    }

    private void createWorldArea(Player player, Area area, classIDs iArea) {
        WorldArea wArea = new WorldArea(area);
        wArea.setAlwaysVisible(false);
        wArea.setFrameVisible(true);
        wArea.setVisibleRange(3.0f);
        wArea.setColor(0xFF0022);
        World3DText wText = new World3DText(iArea.Name + "\nID[" + iArea.srvID + "]");
        wText.setAlwaysVisible(true);
        wText.setFontsize(20);
        wText.setFont(Font.Default);
        wText.setFontColor(0xFF55FF);
        wText.setBackgroundColor(0);
        Vector3f posStart = Utils.ChunkUtils.getGlobalPosition((Vector3i)area.getStartChunkPosition(), (Vector3i)area.getStartBlockPosition());
        Vector3f posEnd = Utils.ChunkUtils.getGlobalPosition((Vector3i)area.getEndChunkPosition(), (Vector3i)area.getEndBlockPosition());
        Vector3f tPos = wArea.getPosition();
        tPos.set(tPos.x + (posEnd.x - posStart.x) / 2.0f, tPos.y + (posEnd.y - posStart.y) / 2.0f, tPos.z + (posEnd.z - posStart.z) / 2.0f);
        wText.setPosition(tPos);
        wText.setBillboard(true);
        wText.setVisibleRange(3.0f);
        classWorldArea inp = new classWorldArea();
        inp.srvID = iArea.srvID;
        inp.Name = iArea.Name;
        inp.Area = wArea;
        inp.Text3D = wText;
        ((ArrayList)player.getAttribute(this.playerGuiAreaDaten)).add(inp);
        ((ArrayList)player.getAttribute(this.playerGuiAreaDaten)).forEach(worldArea -> {
            if (worldArea.srvID == iArea.srvID) {
                worldArea.Text3D.setText(iArea.Name + "\nID[" + iArea.srvID + "];");
            }
        });
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] createWorldArea srvID[" + iArea.srvID + "] dbID[" + iArea.dbID + "] Name[" + iArea.Name + "] TextID[" + wText.getID() + "] ");
        }
    }

    public classWorldArea getAreaFromSrvID(Player player, int srvID) {
        for (classWorldArea worldArea : (ArrayList)player.getAttribute(this.playerGuiAreaDaten)) {
            if (worldArea.srvID != srvID) continue;
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] getAreaFromSrvID     srvID[" + worldArea.srvID + "] Name[" + worldArea.Name + "] wArea[" + worldArea.Area.toString() + "] wText[" + worldArea.Text3D.getID() + "]");
            }
            return worldArea;
        }
        return null;
    }

    public void areaReview(Player player) {
    }

    public void showAllAreas(Player player, ArrayList<classWorldArea> worldArea) {
        worldArea.forEach(area -> this.showArea(player, (classWorldArea)area));
    }

    public void showArea(Player player, classWorldArea area) {
        this.showArea(player, area, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showArea(Player player, classWorldArea area, boolean pr\u00fcfen) {
        if (pr\u00fcfen) {
            try (ResultSet result2 = this.sqlite.executeQuery("SELECT * FROM 'VisibleArea' WHERE AreaID = " + area.srvID + " and Player = '" + player.getName() + "' ");){
                if (result2 == null) return;
                int ID = result2.getInt("VisibleID");
                player.addWorldElement((WorldElement)area.Area);
                player.sendTextMessage(String.format(this.textDaten.getText(player, "areaShowMsg"), area.Name, area.srvID));
                return;
            }
            catch (SQLException result2) {}
            return;
        }
        player.addWorldElement((WorldElement)area.Area);
        player.sendTextMessage(String.format(this.textDaten.getText(player, "areaShowMsg"), area.Name, area.srvID));
        Connection connection = this.sqlite.getConnection();
        try (PreparedStatement prep = connection.prepareStatement("INSERT INTO 'VisibleArea' ('AreaID', 'Player') VALUES (?, ?)");){
            prep.setInt(1, area.srvID);
            prep.setString(2, player.getName());
            prep.executeUpdate();
            return;
        }
        catch (SQLException e) {
            System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
        }
        return;
    }

    public void hideAllAreas(Player player, ArrayList<classWorldArea> worldArea) {
        worldArea.forEach(area -> this.hideArea(player, (classWorldArea)area));
    }

    public void hideArea(Player player, classWorldArea area) {
        this.hideArea(player, area, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideArea(Player player, classWorldArea area, boolean l\u00f6schen) {
        if (l\u00f6schen) {
            Connection connection = this.sqlite.getConnection();
            try {
                PreparedStatement prep = connection.prepareStatement("DELETE FROM 'VisibleArea' WHERE AreaID = " + area.srvID + " and Player = '" + player.getName() + "' ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
            }
        }
        player.removeWorldElement((WorldElement)area.Area);
        player.sendTextMessage(String.format(this.textDaten.getText(player, "areaHideMsg"), area.Name, area.srvID));
    }

    public void removeArea(Player player, classWorldArea area) {
        Connection connection = this.sqlite.getConnection();
        int aID = -1;
        int rID = -1;
        int mID = -1;
        int rIDs = 0;
        for (classIDs id : this.IDs) {
            if (id.srvID == area.srvID) {
                aID = id.dbID;
                break;
            }
            ++rIDs;
        }
        if (aID >= 0) {
            PreparedStatement prep;
            try {
                prep = connection.prepareStatement("DELETE FROM 'Areas' WHERE srvID = " + area.srvID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del Areas" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'VisibleArea' WHERE AreaID = " + aID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del VisibleAreas" + e.getMessage());
            }
            try (ResultSet result = this.sqlite.executeQuery("SELECT * FROM 'Rechte' WHERE AreaID = " + aID + " ");){
                if (result != null) {
                    rID = result.getInt("RechteID");
                    mID = result.getInt("msgID");
                }
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Get Rechte Info" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'Rechte' WHERE AreaID = " + aID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del Rechte" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'MSG' WHERE msgID = " + mID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del MSG" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'GroupList' WHERE RechteID = " + rID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del GroupList" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'MitgliedList' WHERE AreaID = " + aID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del MitgliedListe" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'PlayerList' WHERE RechteID = " + rID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del PlayerListe" + e.getMessage());
            }
            this.hideArea(player, area);
            this.IDs.remove(rIDs);
        }
    }

    public void getArea(Player player, String areaName, String Eigenschaft, Boolean DefineOwner) {
        player.setAttribute(this.playerIsAreaCreate, (Object)true);
        player.setAttribute(this.playerIsAreaName, (Object)areaName);
        player.setAttribute(this.playerIsAreaEigenschaft, (Object)Eigenschaft);
        player.registerKeys(new int[]{wgCRT.getKeyInputValue(this.sysConfig.getValue("KEY_AreaSelect")), wgCRT.getKeyInputValue(this.sysConfig.getValue("KEY_AreaCancle"))});
        player.enableAreaSelectionTool();
        ((GuiElement)player.getAttribute(this.playerGuiLabelAreaCreateEnter)).setVisible(true);
    }

    public void getAreaSelect(Player player) {
        player.getAreaSelectionData(NFA -> {
            if (NFA == null) {
                player.sendTextMessage(this.textDaten.getText(player, "GuiLabelAreaCreateEnter"));
                this.getAreaSelectCancle(player);
                return;
            }
            NFA.rearrange();
            Vector3f GlobalStartPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)NFA.getStartChunkPosition(), (Vector3i)NFA.getStartBlockPosition());
            Vector3f GlobalEndPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)NFA.getEndChunkPosition(), (Vector3i)NFA.getEndBlockPosition());
            float GlobalStartPosX = GlobalStartPos.x;
            float GlobalStartPosY = GlobalStartPos.y;
            float GlobalStartPosZ = GlobalStartPos.z;
            float GlobalEndPosX = GlobalEndPos.x;
            float GlobalEndPosY = GlobalEndPos.y;
            float GlobalEndPosZ = GlobalEndPos.z;
            int areaID = 0;
            int rechteID = 0;
            int msgID = 0;
            Connection connection = this.sqlite.getConnection();
            try (PreparedStatement prep = connection.prepareStatement("INSERT INTO 'Areas' ('AreaName', 'Eigent\u00fcmer', 'srvID', 'Prio', 'GlobalStartposX', 'GlobalStartposY', 'GlobalStartposZ', 'GlobalEndposX', 'GlobalEndposY', 'GlobalEndposZ', 'Eigenschaft', 'Mitglieder') VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                prep.setString(1, (String)player.getAttribute(this.playerIsAreaName));
                prep.setString(2, player.getName());
                prep.setInt(3, NFA.getID());
                prep.setInt(4, 10);
                prep.setFloat(5, GlobalStartPosX);
                prep.setFloat(6, GlobalStartPosY);
                prep.setFloat(7, GlobalStartPosZ);
                prep.setFloat(8, GlobalEndPosX);
                prep.setFloat(9, GlobalEndPosY);
                prep.setFloat(10, GlobalEndPosZ);
                prep.setString(11, (String)player.getAttribute(this.playerIsAreaEigenschaft));
                prep.setString(12, "Mitglieder");
                prep.executeUpdate();
                ResultSet result = prep.getGeneratedKeys();
                if (result != null) {
                    areaID = result.getInt(1);
                }
                this.server.addArea(NFA);
                player.sendTextMessage(String.format(this.textDaten.getText(player, "GuiLabelAreaCreate"), (String)player.getAttribute(this.playerIsAreaName), areaID));
                classIDs inp = new classIDs();
                inp.srvID = NFA.getID();
                inp.dbID = areaID;
                inp.Name = (String)player.getAttribute(this.playerIsAreaName);
                this.IDs.add(inp);
                this.createWorldArea(player, (Area)NFA, this.IDs.get(this.IDs.size() - 1));
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Test IDs " + areaID + " " + NFA.getID() + " " + (String)player.getAttribute(this.playerIsAreaName) + "\n\t" + this.IDs.toString());
                }
                this.showArea(player, this.getAreaFromSrvID(player, NFA.getID()));
                return;
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
                return;
            }
            finally {
                ResultSet result2;
                Throwable e;
                PreparedStatement prep2;
                this.getAreaSelectCancle(player);
                try {
                    prep2 = connection.prepareStatement("INSERT INTO 'MSG' ('AreaWelcomMsg', 'AreaFarewellMsg', 'NoEnterAreaMsg', 'NoLeaveAreaMsg') VALUES (?, ?, ?, ?)");
                    e = null;
                    try {
                        prep2.setString(1, this.textDaten.getText(player, "areaDafaultWelcomMsg"));
                        prep2.setString(2, this.textDaten.getText(player, "areaDafaultFarewellMsg"));
                        prep2.setString(3, this.textDaten.getText(player, "areaDafaultNoEnterMsg"));
                        prep2.setString(4, this.textDaten.getText(player, "areaDafaultNoLeaveMsg"));
                        prep2.executeUpdate();
                        result2 = prep2.getGeneratedKeys();
                        if (result2 != null) {
                            msgID = result2.getInt(1);
                        }
                    }
                    catch (Throwable result2) {
                        e = result2;
                        throw result2;
                    }
                    finally {
                        if (prep2 != null) {
                            if (e != null) {
                                try {
                                    prep2.close();
                                }
                                catch (Throwable result2) {
                                    e.addSuppressed(result2);
                                }
                            } else {
                                prep2.close();
                            }
                        }
                    }
                }
                catch (SQLException e2) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] MSG I " + e2.getMessage());
                }
                try {
                    prep2 = connection.prepareStatement("INSERT INTO 'Rechte' ('AreaID', 'msgID', 'HealingPoint', 'BrokenBonesPoint', 'BleedingPoint', 'DefineOwner') VALUES (?, ?, ?, ?, ?, ?)");
                    e = null;
                    try {
                        prep2.setInt(1, areaID);
                        prep2.setInt(2, msgID);
                        prep2.setInt(3, 50);
                        prep2.setInt(4, 50);
                        prep2.setInt(5, 50);
                        prep2.setInt(6, 0);
                        prep2.executeUpdate();
                        result2 = prep2.getGeneratedKeys();
                        if (result2 != null) {
                            rechteID = result2.getInt(1);
                        }
                        if (this.debug > 1) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] SQL Rechte I erstellt");
                        }
                    }
                    catch (Throwable throwable) {
                        e = throwable;
                        throw throwable;
                    }
                    finally {
                        if (prep2 != null) {
                            if (e != null) {
                                try {
                                    prep2.close();
                                }
                                catch (Throwable throwable) {
                                    e.addSuppressed(throwable);
                                }
                            } else {
                                prep2.close();
                            }
                        }
                    }
                }
                catch (SQLException e3) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] Rechte I " + e3.getMessage());
                }
                try {
                    prep2 = connection.prepareStatement("UPDATE MSG SET RechteID = ?WHERE msgID = " + msgID + " ");
                    e = null;
                    try {
                        prep2.setInt(1, rechteID);
                        prep2.executeUpdate();
                        if (this.debug > 0) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] SQL MSG erstellt");
                        }
                    }
                    catch (Throwable throwable) {
                        e = throwable;
                        throw throwable;
                    }
                    finally {
                        if (prep2 != null) {
                            if (e != null) {
                                try {
                                    prep2.close();
                                }
                                catch (Throwable throwable) {
                                    e.addSuppressed(throwable);
                                }
                            } else {
                                prep2.close();
                            }
                        }
                    }
                }
                catch (SQLException e4) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] MSG II " + e4.getMessage());
                }
                int defValue = -1;
                try (PreparedStatement prep3 = connection.prepareStatement("UPDATE Rechte SET Enter = ?, EnterGroup = ?, EnterPlayer = ?, Leave = ?, LeaveGroup = ?, LeavePlayer = ?, CheastAccess = ?, CheastAccessGroup = ?, CheastAccessPlayer = ?, CheastToInv = ?, CheastToInvGroup = ?, CheastToInvPlayer = ?, InvToCheast = ?, InvToCheastGroup = ?, InvToCheastPlayer = ?, ChestDrop = ?, ChestDropGroup = ?, ChestDropPlayer = ?, Chat = ?, ChatGroup = ?, ChatPlayer = ?, Command = ?, CommandGroup = ?, CommandPlayer = ?, Craft = ?, CraftGroup = ?, CraftPlayer = ?, PVP = ?, PVPGroup = ?, PVPPlayer = ?, InteractElement = ?, InteractElementGroup = ?, InteractElementPlayer = ?, InteractObject = ?, InteractObjectGroup = ?, InteractObjectPlayer = ?, GetHit = ?, GetHitGroup = ?, GetHitPlayer = ?, PickupItem = ?, PickupItemGroup = ?, PickupItemPlayer = ?, Sleep = ?, SleepGroup = ?, SleepPlayer = ?, Fly = ?, FlyGroup = ?, FlyPlayer = ?, DoorOpen = ?, DoorOpenGroup = ?, DoorOpenPlayer = ?, BlueprintCreate = ?, BlueprintCreateGroup = ?, BlueprintCreatePlayer = ?, CreativModus = ?, CreativModusGroup = ?, CreativModusPlayer = ?, CreativePlaceBlock = ?, CreativePlaceBlockGroup = ?, CreativePlaceBlockPlayer = ?, CreativePlaceVegetation = ?, CreativePlaceVegetationGroup = ?, CreativePlaceVegetationPlayer = ?, CreativeTerrainEdit = ?, CreativeTerrainEditGroup = ?, CreativeTerrainEditPlayer = ?, DestroyBlock = ?, DestroyBlockGroup = ?, DestroyBlockPlayer = ?, DestroyConstruction = ?, DestroyConstructionGroup = ?, DestroyConstructionPlayer = ?, DestroyObject = ?, DestroyObjectGroup = ?, DestroyObjectPlayer = ?, DestroyTerrain = ?, DestroyTerrainGroup = ?, DestroyTerrainPlayer = ?, DestroyVegetation = ?, DestroyVegetationGroup = ?, DestroyVegetationPlayer = ?, PlaceBlock = ?, PlaceBlockGroup = ?, PlaceBlockPlayer = ?, PlaceBlueprint = ?, PlaceBlueprintGroup = ?, PlaceBlueprintPlayer = ?, PlaceConstruction = ?, PlaceConstructionGroup = ?, PlaceConstructionPlayer = ?, PlaceGrass = ?, PlaceGrassGroup = ?, PlaceGrassPlayer = ?, PlaceObject = ?, PlaceObjectGroup = ?, PlaceObjectPlayer = ?, PlaceTerrain = ?, PlaceTerrainGroup = ?, PlaceTerrainPlayer = ?, PlaceVegetation = ?, PlaceVegetationGroup = ?, PlaceVegetationPlayer = ?, PlaceWater = ?, PlaceWaterGroup = ?, PlaceWaterPlayer = ?, RemoveConstruction = ?, RemoveConstructionGroup = ?, RemoveConstructionPlayer = ?, RemoveGrass = ?, RemoveGrassGroup = ?, RemoveGrassPlayer = ?, RemoveObject = ?, RemoveObjectGroup = ?, RemoveObjectPlayer = ?, RemoveVegetation = ?, RemoveVegetationGroup = ?, RemoveVegetationPlayer = ?, RemoveWater = ?, RemoveWaterGroup = ?, RemoveWaterPlayer = ?, Healing = ?, HealingGroup = ?, HealingPlayer = ?, BrokenBones = ?, BrokenBonesGroup = ?, BrokenBonesPlayer = ?, Bleeding = ?, BleedingGroup = ?, BleedingPlayer = ?, Explosion = ?, ExplosionGroup = ?, ExplosionPlayer = ? WHERE RechteID = " + rechteID + " AND AreaID = " + areaID + " ");){
                    prep3.setInt(1, defValue);
                    prep3.setInt(2, defValue);
                    prep3.setInt(3, defValue);
                    prep3.setInt(4, defValue);
                    prep3.setInt(5, defValue);
                    prep3.setInt(6, defValue);
                    prep3.setInt(7, defValue);
                    prep3.setInt(8, defValue);
                    prep3.setInt(9, defValue);
                    prep3.setInt(10, defValue);
                    prep3.setInt(11, defValue);
                    prep3.setInt(12, defValue);
                    prep3.setInt(13, defValue);
                    prep3.setInt(14, defValue);
                    prep3.setInt(15, defValue);
                    prep3.setInt(16, defValue);
                    prep3.setInt(17, defValue);
                    prep3.setInt(18, defValue);
                    prep3.setInt(19, defValue);
                    prep3.setInt(20, defValue);
                    prep3.setInt(21, defValue);
                    prep3.setInt(22, defValue);
                    prep3.setInt(23, defValue);
                    prep3.setInt(24, defValue);
                    prep3.setInt(25, defValue);
                    prep3.setInt(26, defValue);
                    prep3.setInt(27, defValue);
                    prep3.setInt(28, defValue);
                    prep3.setInt(29, defValue);
                    prep3.setInt(30, defValue);
                    prep3.setInt(31, defValue);
                    prep3.setInt(32, defValue);
                    prep3.setInt(33, defValue);
                    prep3.setInt(34, defValue);
                    prep3.setInt(35, defValue);
                    prep3.setInt(36, defValue);
                    prep3.setInt(37, defValue);
                    prep3.setInt(38, defValue);
                    prep3.setInt(39, defValue);
                    prep3.setInt(40, defValue);
                    prep3.setInt(41, defValue);
                    prep3.setInt(42, defValue);
                    prep3.setInt(43, defValue);
                    prep3.setInt(44, defValue);
                    prep3.setInt(45, defValue);
                    prep3.setInt(46, defValue);
                    prep3.setInt(47, defValue);
                    prep3.setInt(48, defValue);
                    prep3.setInt(49, defValue);
                    prep3.setInt(50, defValue);
                    prep3.setInt(51, defValue);
                    prep3.setInt(52, defValue);
                    prep3.setInt(53, defValue);
                    prep3.setInt(54, defValue);
                    prep3.setInt(55, defValue);
                    prep3.setInt(56, defValue);
                    prep3.setInt(57, defValue);
                    prep3.setInt(58, defValue);
                    prep3.setInt(59, defValue);
                    prep3.setInt(60, defValue);
                    prep3.setInt(61, defValue);
                    prep3.setInt(62, defValue);
                    prep3.setInt(63, defValue);
                    prep3.setInt(64, defValue);
                    prep3.setInt(65, defValue);
                    prep3.setInt(66, defValue);
                    prep3.setInt(67, defValue);
                    prep3.setInt(68, defValue);
                    prep3.setInt(69, defValue);
                    prep3.setInt(70, defValue);
                    prep3.setInt(71, defValue);
                    prep3.setInt(72, defValue);
                    prep3.setInt(73, defValue);
                    prep3.setInt(74, defValue);
                    prep3.setInt(75, defValue);
                    prep3.setInt(76, defValue);
                    prep3.setInt(77, defValue);
                    prep3.setInt(78, defValue);
                    prep3.setInt(79, defValue);
                    prep3.setInt(80, defValue);
                    prep3.setInt(81, defValue);
                    prep3.setInt(82, defValue);
                    prep3.setInt(83, defValue);
                    prep3.setInt(84, defValue);
                    prep3.setInt(85, defValue);
                    prep3.setInt(86, defValue);
                    prep3.setInt(87, defValue);
                    prep3.setInt(88, defValue);
                    prep3.setInt(89, defValue);
                    prep3.setInt(90, defValue);
                    prep3.setInt(91, defValue);
                    prep3.setInt(92, defValue);
                    prep3.setInt(93, defValue);
                    prep3.setInt(94, defValue);
                    prep3.setInt(95, defValue);
                    prep3.setInt(96, defValue);
                    prep3.setInt(97, defValue);
                    prep3.setInt(98, defValue);
                    prep3.setInt(99, defValue);
                    prep3.setInt(100, defValue);
                    prep3.setInt(101, defValue);
                    prep3.setInt(102, defValue);
                    prep3.setInt(103, defValue);
                    prep3.setInt(104, defValue);
                    prep3.setInt(105, defValue);
                    prep3.setInt(106, defValue);
                    prep3.setInt(107, defValue);
                    prep3.setInt(108, defValue);
                    prep3.setInt(109, defValue);
                    prep3.setInt(110, defValue);
                    prep3.setInt(111, defValue);
                    prep3.setInt(112, defValue);
                    prep3.setInt(113, defValue);
                    prep3.setInt(114, defValue);
                    prep3.setInt(115, defValue);
                    prep3.setInt(116, defValue);
                    prep3.setInt(117, defValue);
                    prep3.setInt(118, defValue);
                    prep3.setInt(119, defValue);
                    prep3.setInt(120, defValue);
                    prep3.setInt(121, defValue);
                    prep3.setInt(122, defValue);
                    prep3.setInt(123, defValue);
                    prep3.setInt(124, defValue);
                    prep3.setInt(125, defValue);
                    prep3.setInt(126, defValue);
                    prep3.setInt(127, defValue);
                    prep3.setInt(128, defValue);
                    prep3.setInt(129, defValue);
                    prep3.setInt(130, defValue);
                    prep3.setInt(131, defValue);
                    prep3.setInt(132, defValue);
                    prep3.executeUpdate();
                    if (this.debug > 0) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] SQL Rechte II erstellt");
                    }
                }
                catch (SQLException e5) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] Rechte II " + e5.getMessage());
                }
            }
        });
    }

    public void getAreaSelectCancle(Player player) {
        player.setAttribute(this.playerIsAreaCreate, (Object)false);
        player.setAttribute(this.playerIsAreaName, (Object)"");
        player.setAttribute(this.playerIsAreaEigenschaft, (Object)"");
        player.disableAreaSelectionTool();
        player.unregisterKeys(new int[]{28});
        ((GuiElement)player.getAttribute(this.playerGuiLabelAreaCreateEnter)).setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getDBWert(int srvID, String sqlQueryTabelle) {
        ArrayList<Object> res = new ArrayList<Object>();
        try {
            try (ResultSet result = this.sqlite.executeQuery("SELECT " + sqlQueryTabelle + " FROM Areas, Rechte, MSG WHERE srvID = " + srvID + " and Rechte.AreaID=Areas.AreaID and Rechte.msgID=MSG.msgID");){
                if (result == null) return res;
                ResultSetMetaData rsmd = result.getMetaData();
                int columnCount = rsmd.getColumnCount();
                int i = 1;
                while (i <= columnCount) {
                    String s = rsmd.getColumnTypeName(i);
                    if (s.equals("VARCHAR")) {
                        res.add(result.getString(i));
                    } else if (s.equals("INTEGER")) {
                        res.add(result.getInt(i));
                    }
                    ++i;
                }
                return res;
            }
            catch (SQLException e) {
                if (!e.getMessage().equals("ResultSet closed")) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] getDBWert: " + e.getMessage());
                }
                res = null;
                return res;
            }
        }
        finally {
            return res;
        }
    }

    public void setDBWert(int srvID, Object[][] sqlQueryTabelle) {
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert Liste " + sqlQueryTabelle.length);
        }
        String sqlQuery = "";
        String sqlMsgQuery = "";
        int n = 0;
        int m = 0;
        for (Object[] value : sqlQueryTabelle) {
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert Value " + value.length + " " + n);
            }
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert Name[" + value[0] + "] Value[" + value[1] + "]");
            }
            if (!value[0].equals("AreaWelcomMsg") && !value[0].equals("AreaFarewellMsg")) {
                if (n > 0) {
                    sqlQuery = sqlQuery + ",";
                }
                if (!value[1].getClass().equals(String.class)) {
                    sqlQuery = sqlQuery + value[0] + "=" + value[1];
                }
                ++n;
                continue;
            }
            if (m > 0) {
                sqlMsgQuery = sqlMsgQuery + ",";
            }
            sqlMsgQuery = value[1].getClass().equals(String.class) ? sqlMsgQuery + value[0] + "='" + value[1] + "'" : sqlMsgQuery + value[0] + "=" + value[1];
            ++m;
        }
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert " + sqlQuery);
        }
        Connection connection = this.sqlite.getConnection();
        if (!sqlMsgQuery.equals("")) {
            try (PreparedStatement prep = connection.prepareStatement("UPDATE MSG SET " + sqlMsgQuery + " WHERE exists ( select * FROM Rechte,Areas where Areas.srvID = " + srvID + " and Areas.AreaID = Rechte.AreaID and Rechte.msgID = MSG.msgID ) ");){
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] setDBWert: " + e.getMessage());
            }
        }
        if (!sqlQuery.equals("")) {
            try (PreparedStatement prep = connection.prepareStatement("UPDATE Rechte SET " + sqlQuery + " WHERE exists ( select * FROM Areas where Areas.srvID = " + srvID + " and Areas.AreaID = Rechte.AreaID ) ");){
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] setDBWert: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<classDimension> getAreasFromPos(Vector3f pos) {
        ArrayList<classDimension> dimList = new ArrayList<classDimension>();
        try {
            try (ResultSet result = this.sqlite.executeQuery("SELECT * FROM 'Areas' WHERE (GlobalStartposX <= " + (pos.getX() + 1.0f) + " and GlobalEndposX >= " + (pos.getX() + 0.0f) + ") and (GlobalStartposY <= " + (pos.getY() + 0.0f) + " and GlobalEndposY >= " + (pos.getY() + 0.0f) + ") and (GlobalStartposZ <= " + (pos.getZ() + 0.0f) + " and GlobalEndposZ >= " + (pos.getZ() - 1.0f) + ") ");){
                if (result == null) return dimList;
                float pX = pos.getX();
                float pY = pos.getY();
                float pZ = pos.getZ();
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos Finde Area @[" + pX + "-" + pY + "-" + pZ + "] ");
                }
                while (true) {
                    Iterator<classDimension> iterator;
                    int nPos;
                    int n;
                    classDimension dim;
                    block34: {
                        if (result.next()) {
                            if (result == null) continue;
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos    " + result.getString("AreaName") + " " + result.getInt("srvID"));
                            }
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos    Start    @[" + result.getFloat("GlobalStartposX") + "|" + result.getFloat("GlobalStartposY") + "|" + result.getFloat("GlobalStartposZ") + "] ");
                            }
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos    End      @[" + result.getFloat("GlobalEndposX") + "|" + result.getFloat("GlobalEndposY") + "|" + result.getFloat("GlobalEndposZ") + "] ");
                            }
                            float dX = result.getFloat("GlobalEndposX") - result.getFloat("GlobalStartposX");
                            float dY = result.getFloat("GlobalEndposY") - result.getFloat("GlobalStartposY");
                            float dZ = result.getFloat("GlobalEndposZ") - result.getFloat("GlobalStartposZ");
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos    Dimension [" + dX + "|" + dY + "|" + dZ + "] ");
                            }
                            dim = new classDimension();
                            dim.Name = result.getString("AreaName");
                            dim.srvID = result.getInt("srvID");
                            dim.dbID = result.getInt("AreaID");
                            dim.x = dX;
                            dim.y = dY;
                            dim.z = dZ;
                            if (dimList.size() > 0) {
                                n = 0;
                                nPos = -1;
                                iterator = dimList.iterator();
                                break block34;
                            } else {
                                dimList.add(dim);
                                continue;
                            }
                        }
                        if (this.debug > 0) {
                            for (classDimension dimm : dimList) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos Liste[" + dimm.Name + "|" + dimm.srvID + "] ");
                            }
                        }
                        if (this.debug <= 2) return dimList;
                        System.out.println("[" + this.plugin.getDescription("name") + "] <NL>");
                        return dimList;
                    }
                    while (iterator.hasNext()) {
                        classDimension dimm = iterator.next();
                        if (dim.x < dimm.x || dim.y < dimm.y || dim.z < dimm.z) {
                            if (this.debug > 2) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos       Dimension[" + dimm.Name + "|" + dimm.srvID + "] kleiner " + n);
                            }
                            nPos = n;
                        } else if (this.debug > 2) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos       Dimension[" + dimm.Name + "|" + dimm.srvID + "] gr\u00f6\u00dfer " + n);
                        }
                        ++n;
                    }
                    if (nPos >= 0) {
                        dimList.add(nPos, dim);
                        continue;
                    }
                    dimList.add(dim);
                }
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos: " + e.getMessage());
            }
        }
        finally {
            return dimList;
        }
    }
}

