/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.WorldGardListener;
import de.pbplugins.WorldGardListenerCommand;
import de.pbplugins.WorldGardListenerPlayer;
import de.pbplugins.WorldGardListenerPlayerWorld;
import de.pbplugins.wgArea;
import de.pbplugins.wgCRT;
import de.pbplugins.wgClassText;
import de.pbplugins.wgConfig;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;

public class WorldGard
extends Plugin {
    private WorldGard plugin;
    private Server server;
    private World world;
    private Database sqlite;
    private String sSQLite;
    private final int debug = 1;
    private wgConfig sysConfig;
    private wgClassText textDaten;
    private wgArea area;

    public Database getSqlite() {
        return this.sqlite;
    }

    public wgConfig getSysConfig() {
        return this.sysConfig;
    }

    public wgClassText getTextDaten() {
        return this.textDaten;
    }

    public wgArea getAreaDaten() {
        return this.area;
    }

    public void onEnable() {
        Boolean Error = false;
        System.out.println("[WorldGard] Enabled");
        this.plugin = this;
        if (this.plugin.getPluginByName("SprachAPI") != null) {
            this.server = this.getServer();
            this.world = this.getWorld();
            this.sSQLite = this.getPath() + "/database/" + this.getDescription("name") + "-" + this.world.getName() + ".db";
            this.sqlite = this.getSQLiteConnection(this.sSQLite);
            System.out.println("[" + this.plugin.getDescription("name") + "] Verbindung zur Datenbank wurde hergestellt! ");
            this.initDB();
            System.out.println("[" + this.plugin.getDescription("name") + "] Datenbank initalisiert! ");
            this.area = new wgArea(this);
            this.textDaten = new wgClassText();
            this.textDaten.INI(this);
            String[][] sysConfigArray = new String[][]{{"KEY_GUI", "KEY_B"}, {"KEY_AreaSelect", "KEY_RETURN"}, {"KEY_AreaCancle", "KEY_ESCAPE"}, {"BetaParameta", "null"}, {"COMMAND_RemoveAreaByOwner", "true"}, {"COMMAND_RemoveArea_Group", ""}, {"COMMAND_Setowner_Group", ""}, {"COMMAND_AddCategory_Group", ""}, {"COMMAND_Setparent_Group", ""}, {"COMMAND_Setparent_ParentOwner", "true"}, {"COMMAND_Editconfig_Group", ""}, {"COMMAND_Editdefault_Group", ""}, {"COMMAND_flag_Owner", "false"}, {"COMMAND_flag_ParentOwner", "true"}, {"COMMAND_flag_Group", ""}, {"COMMAND_define_Group", "false"}};
            this.sysConfig = new wgConfig("System", sysConfigArray, this);
            this.area.onEnable();
            this.registerEventListener(new WorldGardListener(this));
            this.registerEventListener(new WorldGardListenerCommand(this));
            this.registerEventListener(new WorldGardListenerPlayer(this));
            this.registerEventListener(new WorldGardListenerPlayerWorld(this));
            System.out.println("[" + this.plugin.getDescription("name") + "] " + this.textDaten.getText(null, "bnt_Abbruch"));
            System.out.println("[" + this.plugin.getDescription("name") + "] " + this.textDaten.getText(null, "Variable"));
            System.out.println();
            System.out.println("[" + this.plugin.getDescription("name") + "] " + this.sysConfig.getValue("KEY_GUI"));
            int key = wgCRT.getKeyInputValue(this.sysConfig.getValue("KEY_GUI"));
            key = key < 223 ? ++key : 1;
            this.sysConfig.setValue("KEY_GUI", wgCRT.getKeyInputValue(key));
            System.out.println("[" + this.plugin.getDescription("name") + "] " + this.sysConfig.getValue("KEY_GUI"));
            System.out.println();
        } else {
            System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Das Plugin 'SprachAPI' ist nicht installiert! Bitte installieren!");
            System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Plugin wird abgebrochen...");
            Error = true;
        }
        if (Error.booleanValue()) {
            this.onDisable();
        }
    }

    public void onDisable() {
        System.out.println("[WorldGard] Desabled");
    }

    private void initDB() {
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'Areas' ('AreaID' INTEGER PRIMARY KEY AUTOINCREMENT, 'srvID' INTEGER, 'AreaName' VARCHAR(64), 'Eigent\u00fcmer' VARCHAR(64), 'Eigenschaft'  VARCHAR(64), 'Mitglieder' VARCHAR(64), 'StartChunkposX' INTEGER, 'StartChunkposY' INTEGER, 'StartChunkposZ' INTEGER, 'StartBlockposX' INTEGER, 'StartBlockposY' INTEGER, 'StartBlockposZ' INTEGER, 'GlobalStartposX' FLOAT, 'GlobalStartposY' FLOAT, 'GlobalStartposZ' FLOAT, 'EndChunkposX' INTEGER, 'EndChunkposY' INTEGER, 'EndChunkposZ' INTEGER, 'EndBlockposX' INTEGER, 'EndBlockposY' INTEGER, 'EndBlockposZ' INTEGER, 'GlobalEndposX' FLOAT, 'GlobalEndposY' FLOAT, 'GlobalEndposZ' FLOAT, 'previousID' INTEGER, 'Prio' INTEGER ); ");
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'Rechte' ('RechteID' INTEGER PRIMARY KEY AUTOINCREMENT, 'AreaID' INTEGER, 'msgID' INTEGER, 'HealingPoint' INTEGER, 'BrokenBonesPoint' INTEGER, 'BleedingPoint' INTEGER, 'DefineOwner' INTEGER, 'Enter' INTEGER, 'EnterGroup' INTEGER, 'EnterPlayer' INTEGER, 'Leave' INTEGER, 'LeaveGroup' INTEGER, 'LeavePlayer' INTEGER, 'CheastAccess' INTEGER, 'CheastAccessGroup' INTEGER, 'CheastAccessPlayer' INTEGER, 'CheastToInv' INTEGER, 'CheastToInvGroup' INTEGER, 'CheastToInvPlayer' INTEGER, 'InvToCheast' INTEGER, 'InvToCheastGroup' INTEGER, 'InvToCheastPlayer' INTEGER, 'ChestDrop' INTEGER, 'ChestDropGroup' INTEGER, 'ChestDropPlayer' INTEGER, 'Chat' INTEGER, 'ChatGroup' INTEGER, 'ChatPlayer' INTEGER, 'Command' INTEGER, 'CommandGroup' INTEGER, 'CommandPlayer' INTEGER, 'Craft' INTEGER, 'CraftGroup' INTEGER, 'CraftPlayer' INTEGER, 'PVP' INTEGER, 'PVPGroup' INTEGER, 'PVPPlayer' INTEGER, 'InteractElement' INTEGER, 'InteractElementGroup' INTEGER, 'InteractElementPlayer' INTEGER, 'InteractObject' INTEGER, 'InteractObjectGroup' INTEGER, 'InteractObjectPlayer' INTEGER, 'GetHit' INTEGER, 'GetHitGroup' INTEGER, 'GetHitPlayer' INTEGER, 'PickupItem' INTEGER, 'PickupItemGroup' INTEGER, 'PickupItemPlayer' INTEGER, 'Sleep' INTEGER, 'SleepGroup' INTEGER, 'SleepPlayer' INTEGER, 'Fly' INTEGER, 'FlyGroup' INTEGER, 'FlyPlayer' INTEGER, 'DoorOpen' INTEGER, 'DoorOpenGroup' INTEGER, 'DoorOpenPlayer' INTEGER, 'BlueprintCreate' INTEGER, 'BlueprintCreateGroup' INTEGER, 'BlueprintCreatePlayer' INTEGER, 'CreativModus' INTEGER, 'CreativModusGroup' INTEGER, 'CreativModusPlayer' INTEGER, 'CreativePlaceBlock' INTEGER, 'CreativePlaceBlockGroup' INTEGER, 'CreativePlaceBlockPlayer' INTEGER, 'CreativePlaceVegetation' INTEGER, 'CreativePlaceVegetationGroup' INTEGER, 'CreativePlaceVegetationPlayer' INTEGER, 'CreativeTerrainEdit' INTEGER, 'CreativeTerrainEditGroup' INTEGER, 'CreativeTerrainEditPlayer' INTEGER, 'DestroyBlock' INTEGER, 'DestroyBlockGroup' INTEGER, 'DestroyBlockPlayer' INTEGER, 'DestroyConstruction' INTEGER, 'DestroyConstructionGroup' INTEGER, 'DestroyConstructionPlayer' INTEGER, 'DestroyObject' INTEGER, 'DestroyObjectGroup' INTEGER, 'DestroyObjectPlayer' INTEGER, 'DestroyTerrain' INTEGER, 'DestroyTerrainGroup' INTEGER, 'DestroyTerrainPlayer' INTEGER, 'DestroyVegetation' INTEGER, 'DestroyVegetationGroup' INTEGER, 'DestroyVegetationPlayer' INTEGER, 'PlaceBlock' INTEGER, 'PlaceBlockGroup' INTEGER, 'PlaceBlockPlayer' INTEGER, 'PlaceBlueprint' INTEGER, 'PlaceBlueprintGroup' INTEGER, 'PlaceBlueprintPlayer' INTEGER, 'PlaceConstruction' INTEGER, 'PlaceConstructionGroup' INTEGER, 'PlaceConstructionPlayer' INTEGER, 'PlaceGrass' INTEGER, 'PlaceGrassGroup' INTEGER, 'PlaceGrassPlayer' INTEGER, 'PlaceObject' INTEGER, 'PlaceObjectGroup' INTEGER, 'PlaceObjectPlayer' INTEGER, 'PlaceTerrain' INTEGER, 'PlaceTerrainGroup' INTEGER, 'PlaceTerrainPlayer' INTEGER, 'PlaceVegetation' INTEGER, 'PlaceVegetationGroup' INTEGER, 'PlaceVegetationPlayer' INTEGER, 'PlaceWater' INTEGER, 'PlaceWaterGroup' INTEGER, 'PlaceWaterPlayer' INTEGER, 'RemoveConstruction' INTEGER, 'RemoveConstructionGroup' INTEGER, 'RemoveConstructionPlayer' INTEGER, 'RemoveGrass' INTEGER, 'RemoveGrassGroup' INTEGER, 'RemoveGrassPlayer' INTEGER, 'RemoveObject' INTEGER, 'RemoveObjectGroup' INTEGER, 'RemoveObjectPlayer' INTEGER, 'RemoveVegetation' INTEGER, 'RemoveVegetationGroup' INTEGER, 'RemoveVegetationPlayer' INTEGER, 'RemoveWater' INTEGER, 'RemoveWaterGroup' INTEGER, 'RemoveWaterPlayer' INTEGER, 'Healing' INTEGER, 'HealingGroup' INTEGER, 'HealingPlayer' INTEGER, 'BrokenBones' INTEGER, 'BrokenBonesGroup' INTEGER, 'BrokenBonesPlayer' INTEGER, 'Bleeding' INTEGER, 'BleedingGroup' INTEGER, 'BleedingPlayer' INTEGER, 'Explosion' INTEGER, 'ExplosionGroup' INTEGER, 'ExplosionPlayer' INTEGER ); ");
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'GroupList' ('GroupListID' INTEGER PRIMARY KEY AUTOINCREMENT, 'GroupListName' VARCHAR(64), 'RechteID' INTEGER, 'GroupName' VARCHAR(64), 'GroupID' INTEGER ); ");
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'PlayerList' ('PlayerListID' INTEGER PRIMARY KEY AUTOINCREMENT, 'PlayerListName' VARCHAR(64), 'RechteID' INTEGER, 'PlayerName' VARCHAR(64), 'PlayerID' INTEGER ); ");
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'MitgliedList' ('MitgliedListID' INTEGER PRIMARY KEY AUTOINCREMENT, 'MitgliedListName' VARCHAR(64), 'AreaID' INTEGER, 'MitgliedName' VARCHAR(64), 'MitgliedID' INTEGER ); ");
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'MSG' ('msgID' INTEGER PRIMARY KEY AUTOINCREMENT, 'AreaWelcomMsg' VARCHAR(128), 'AreaFarewellMsg' VARCHAR(128), 'NoEnterAreaMsg' VARCHAR(128), 'NoLeaveAreaMsg' VARCHAR(128), 'RechteID' INTEGER ); ");
        this.sqlite.execute("CREATE TABLE IF NOT EXISTS 'VisibleArea' ('VisibleID' INTEGER PRIMARY KEY AUTOINCREMENT, 'AreaID' INTEGER, 'Player' VARCHAR(64), FOREIGN KEY(AreaID) REFERENCES Areas(AreaID))");
        System.out.println("[" + this.plugin.getDescription("name") + "] Lade DB");
    }
}

