/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.WorldGard;
import de.pbplugins.classDimension;
import de.pbplugins.wgArea;
import de.pbplugins.wgCRT;
import de.pbplugins.wgClassText;
import de.pbplugins.wgConfig;
import java.util.ArrayList;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeBlockPositionEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.world.PlayerChangeObjectStatusEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class WorldGardListener
implements Listener {
    private final WorldGard plugin;
    private final wgArea area;
    private final Database sqlite;
    private int debug = 1;
    private wgClassText textDaten;
    private final wgConfig sysConfig;

    public WorldGardListener(WorldGard plugin) {
        this.plugin = plugin;
        this.area = plugin.getAreaDaten();
        this.sqlite = plugin.getSqlite();
        this.textDaten = plugin.getTextDaten();
        this.sysConfig = plugin.getSysConfig();
    }

    @EventMethod
    public void onPlayerChangeObjectStatusEvent(PlayerChangeObjectStatusEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ChangeObjectStatus ");
        }
        System.out.println("[" + this.plugin.getDescription("name") + "] Neuer Status: " + event.getNewObjectStatus());
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Connect ");
        }
        Player player = event.getPlayer();
        player.setAttribute(this.area.playerIsAreaCreate, (Object)false);
        player.setAttribute(this.area.playerIsAreaName, (Object)"");
        player.setAttribute(this.area.playerIsAreaEigenschaft, (Object)"");
        GuiLabel label = new GuiLabel(0.258f, 0.18f, true);
        label.setText(String.format(this.textDaten.getText(player, "GuiLabelAreaCreateEnter"), this.sysConfig.getValue("KEY_AreaSelect").substring(4), this.sysConfig.getValue("KEY_AreaCancle").substring(4)));
        label.setFont(Font.Default_Bold);
        label.setFontSize(16);
        label.setPivot(PivotPosition.BottomLeft);
        player.setAttribute(this.area.playerGuiLabelAreaCreateEnter, (Object)label);
        player.addGuiElement((GuiElement)player.getAttribute(this.area.playerGuiLabelAreaCreateEnter));
        ((GuiElement)player.getAttribute(this.area.playerGuiLabelAreaCreateEnter)).setVisible(false);
        this.area.onPlayerConnect(player);
        player.setListenForKeyInput(true);
    }

    @EventMethod
    public void onPlayerKeyEvent(PlayerKeyEvent event) {
        Player player = event.getPlayer();
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] PlayerKeyEvent  Press[" + event.isPressed() + "] RETURN[" + wgCRT.getKeyInputValue(event.getKeyCode()).equals(this.sysConfig.getValue("KEY_AreaSelect")) + "] AreaCreate[" + (Boolean)player.getAttribute(this.area.playerIsAreaCreate) + "]");
        }
        if (event.isPressed() && wgCRT.getKeyInputValue(event.getKeyCode()).equals(this.sysConfig.getValue("KEY_AreaSelect")) && ((Boolean)player.getAttribute(this.area.playerIsAreaCreate)).booleanValue()) {
            this.area.getAreaSelect(player);
        } else if (event.isPressed() && wgCRT.getKeyInputValue(event.getKeyCode()).equals(this.sysConfig.getValue("KEY_AreaCancle")) && ((Boolean)player.getAttribute(this.area.playerIsAreaCreate)).booleanValue()) {
            this.area.getAreaSelectCancle(player);
        }
    }

    @EventMethod
    public void onPlayerChangeBlockPosition(PlayerChangeBlockPositionEvent event) {
        Player player = event.getPlayer();
        ArrayList<classDimension> findArea = this.area.getAreasFromPos(player.getPosition());
        if (findArea.size() > 0) {
            player.sendTextMessage(String.format(this.textDaten.getText(player, "areaPosMsg"), findArea.get((int)0).Name, findArea.get((int)0).srvID));
            ArrayList res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "Enter, AreaWelcomMsg");
            if (res != null) {
                player.sendTextMessage(String.format((String)res.get(1), findArea.get((int)0).Name, findArea.get((int)0).srvID));
            }
        }
    }
}

