/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.pnb;

import com.vistamaresoft.pnb.Gui;
import com.vistamaresoft.pnb.Msgs;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;

public class PlanksAndBeams
extends Plugin
implements Listener {
    public static final String localeLanguageDef = "en";
    public static String commandPrefix = "/pnb";
    public static int costPerItem = 1;
    public static int windowResMult = 5;
    public static boolean freeForAdmin = false;
    public static boolean freeForCreative = false;
    public static Locale locale;
    public static final String VERSION = "0.4.1";
    public static final String publicName = "Planks 'n Beams";
    public static final int NUM_OF_QUICKSLOTS = 5;
    public static final int NUM_OF_INVSLOTS = 32;
    public static final short ORE_ID = 309;
    public static final short LUMBER_ID = 265;
    public static final short PLANK_ID = 760;
    public static final short BEAM_ID = 761;
    public static final short WINDOW1_ID = 771;
    public static final short WINDOW2_ID = 772;
    public static final short WINDOW3_ID = 773;
    public static final short WINDOW4_ID = 774;
    public static final short PLANKTRI_ID = 763;
    public static final short LOG_ID = 762;
    public static final short IRONINGOT_ID = 310;
    public static final short COPPERINGOT_ID = 311;
    public static final short DIRT_VAR = 1;
    public static final short STONE_VAR = 3;
    public static final short GRAVEL_VAR = 4;
    public static final short SAND_VAR = 9;
    public static final short SANDSTONE_VAR = 11;
    protected static final Inventory.SlotType[] slotTypeValues;
    public static final short[] resourceId;
    public static final short[] resourceVar;
    public static final short firstVariation = 21;
    public static final short lastVariation = 218;
    public static final short[] resourcePerVariation;
    public static final int ERR_SUCCESS = 0;
    public static final int ERR_INVALID_PARAM = -1;
    public static final int ERR_NO_RESOURCES = -2;
    public static final int ERR_GENERIC = -3;
    protected static PlanksAndBeams plugin;
    protected static String pluginPath;

    public void onEnable() {
        plugin = this;
        pluginPath = this.getPath();
        this.initSettings();
        Msgs.init(pluginPath, locale);
        System.out.println("Planks 'n Beams 0.4.1 loaded successfully!");
        this.registerEventListener(this);
    }

    public void onDisable() {
        this.unregisterEventListener(this);
        System.out.println("Planks 'n Beams 0.4.1 unloaded successfully!");
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        String[] cmd = event.getCommand().split(" ");
        if (cmd[0].equals(commandPrefix)) {
            this.mainGui(event.getPlayer());
        }
    }

    public String getPublicName() {
        return publicName;
    }

    public void mainGui(Player player) {
        Gui gui = new Gui(player);
        if (gui != null) {
            gui.show(player);
        }
    }

    public int buy(Player player, int type, int variation, int quantity) {
        if (variation < 21 || variation > 218) {
            return -1;
        }
        short itemId = resourceId[resourcePerVariation[variation - 21]];
        short itemVar = resourceVar[resourcePerVariation[variation - 21]];
        Boolean freeCreative = (Boolean)player.getPermissionValue("creative_freecrafting");
        int cost = player.isAdmin() && freeForAdmin || player.isCreativeModeEnabled() && freeCreative != false && freeForCreative ? 0 : quantity * costPerItem;
        Inventory inv = player.getInventory();
        int resources = 0;
        ArrayList<Integer> sourceSlots = new ArrayList<Integer>();
        if (cost > 0) {
            for (int invType = 0; invType < slotTypeValues.length; ++invType) {
                Inventory.SlotType slotType = slotTypeValues[invType];
                for (int j = 0; j < inv.getSlotCount(slotType); ++j) {
                    Item item = inv.getItem(j, slotType);
                    if (item == null || item.getTypeID() != itemId || item.getVariation() != itemVar) continue;
                    resources += item.getStacksize();
                    sourceSlots.add((invType << 16) + j);
                }
            }
        }
        if (resources < cost) {
            return -2;
        }
        Item item = inv.insertNewItem((short)type, variation, quantity);
        if (item == null) {
            return -3;
        }
        for (Integer i : sourceSlots) {
            item = inv.getItem(i & 0xFFFF, slotTypeValues[i >> 16]);
            int size = item.getStacksize();
            if (size <= cost) {
                inv.removeItem(i & 0xFFFF, slotTypeValues[i >> 16]);
                cost -= size;
            } else {
                inv.removeItem(i & 0xFFFF, slotTypeValues[i >> 16], cost);
                cost = 0;
            }
            if (cost > 0) continue;
            break;
        }
        return 0;
    }

    private void initSettings() {
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.getPath() + "/settings.properties");
            settings.load(in);
            in.close();
            commandPrefix = "/" + settings.getProperty("command", commandPrefix);
            costPerItem = PlanksAndBeams.toInteger(settings.getProperty("costPerItem"), costPerItem);
            freeForAdmin = PlanksAndBeams.toInteger(settings.getProperty("freeForAdmin"), 0) != 0;
            freeForCreative = PlanksAndBeams.toInteger(settings.getProperty("freeForCreative"), 0) != 0;
            String strLocale = settings.getProperty("locale", localeLanguageDef);
            String[] localeParams = strLocale.split("-");
            locale = localeParams.length > 0 ? (localeParams.length > 1 && localeParams[2].length() > 0 ? (localeParams.length > 2 && localeParams[2].length() > 0 ? new Locale(localeParams[0], localeParams[1], localeParams[2]) : new Locale(localeParams[0], localeParams[1])) : new Locale(localeParams[0])) : new Locale(localeLanguageDef);
        }
        catch (IOException e) {
            locale = new Locale(localeLanguageDef);
            return;
        }
    }

    protected static int toInteger(String txt, int defValue) {
        if (txt == null) {
            return defValue;
        }
        try {
            return Integer.decode(txt);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    static {
        slotTypeValues = Inventory.SlotType.values();
        resourceId = new short[]{309, 309, 309, 265, 311, 310, 309, 309};
        resourceVar = new short[]{3, 11, 1, 0, 0, 0, 4, 9};
        resourcePerVariation = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 6, 2, 7};
    }
}

