/*
 * Decompiled with CFR 0.152.
 */
package joekoperski;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.risingworld.api.Plugin;
import net.risingworld.api.database.WorldDatabase;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.objects.Player;

public class ListPlayers
extends Plugin
implements Listener {
    public void onEnable() {
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        String command;
        String[] cmd;
        Player player = event.getPlayer();
        long Index = 0L;
        if (player.isAdmin() && (cmd = (command = event.getCommand()).split(" "))[0].equals("/listplayers")) {
            String query = "SELECT * FROM Player ORDER BY Name ASC";
            if (cmd.length == 2) {
                if (cmd[1].equals("total")) {
                    query = "SELECT * FROM Player ORDER BY OnlineTime ASC";
                } else if (cmd[1].equals("last")) {
                    query = "SELECT * FROM Player ORDER BY LastTimeOnline ASC";
                }
            }
            WorldDatabase database = this.getWorldDatabase();
            try (ResultSet result = database.executeQuery(query);){
                while (result.next()) {
                    ++Index;
                    Date lastOnline = new Date(result.getLong("LastTimeOnline"));
                    SimpleDateFormat Sdf = new SimpleDateFormat("dd.MM.yyyy - HH:mm");
                    String datestr = Sdf.format(lastOnline);
                    long minutes = result.getLong("OnlineTime") / 60L;
                    long hours = minutes / 60L;
                    long days = hours / 24L;
                    player.sendTextMessage("[#80c0ff] last: " + datestr + "[#80ffa0] total: " + String.format("%3dd %2dh %2dm", days, hours %= 24L, minutes %= 60L) + "[#FEE400] " + Long.toString(Index) + " " + result.getString("Name"));
                }
            }
            catch (SQLException e) {
                player.sendTextMessage("Error!");
            }
        }
    }
}

