/*
 * Decompiled with CFR 0.152.
 */
package de.kryssi.userobjectloader;

import de.kryssi.userobjectloader.UserObjectLoader;
import de.kryssi.userobjectloader.events.ModelPutDownEvent;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerElementInteractionEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class ModelPlacementThread
extends Thread
implements Listener {
    private int delayMili = 200;
    public World3DModel previewModel = null;
    private Player player = null;
    private boolean isPutDown = false;
    private int iPutDown = 0;
    private float posX = 0.0f;
    private float posY = 0.0f;
    private float posZ = 0.0f;
    private float rx = 0.0f;
    private float ry = 0.0f;
    private float rz = 0.0f;
    float modelScale = 0.9f;
    float modelScaleOrginal = 1.0f;
    float modelScaleFaktor = 0.01f;
    float moveStep = 0.05f;
    float rotStep = 0.1f;
    float distanceToModel = 3.5f;
    private float objMoveToSpeed = 0.95f;
    private UserObjectLoader plugin;

    public ModelPlacementThread(UserObjectLoader oPlugin, World3DModel oModelToPos, Player playerToSet, int delayMS) {
        super("Model Placement Thread");
        this.plugin = oPlugin;
        this.previewModel = oModelToPos;
        this.previewModel.setInteractable(true);
        this.previewModel.setInteractionCrosshair(Crosshair.Pickup);
        this.previewModel.setHittable(true);
        this.player = playerToSet;
        this.delayMili = delayMS;
        this.refrModelPosition();
        this.rx = this.previewModel.getRotation().x;
        this.ry = this.previewModel.getRotation().y;
        this.rz = this.previewModel.getRotation().z;
        this.modelScale = this.previewModel.getScale();
        this.modelScaleFaktor = this.modelScale / 20.0f;
        this.modelScaleOrginal = this.modelScale;
        this.isPutDown = false;
        this.iPutDown = 0;
        this.rotStep = (float)Math.PI * 2 / (float)this.plugin.iRotationSteps;
        String moveStepStr = this.plugin.getProp("moveStep");
        if (moveStepStr.length() >= 1) {
            this.moveStep = Float.parseFloat(moveStepStr);
        }
        this.distanceToModel = this.plugin.fDistanceToModel;
    }

    public void setModel(World3DModel oModelToPos) {
        if (this.isPutDown) {
            this.previewModel = oModelToPos;
            this.iPutDown = 0;
        }
    }

    @Override
    public void run() {
        this.player.setListenForKeyInput(true);
        if (this.plugin.showDeveloperInfos) {
            System.out.println("Thread - START " + Thread.currentThread().getName());
            this.player.sendTextMessage("Thread - START " + Thread.currentThread().getName());
        }
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.delayMili >= 10) {
                    ModelPlacementThread.sleep(this.delayMili);
                }
                if (this.previewModel != null && !this.isPutDown) {
                    Vector3f viewDir = this.player.getViewDirection();
                    Vector3f playerPos = this.player.getPosition();
                    Vector3f previewPos = new Vector3f(playerPos).addLocal(viewDir.getX() * this.distanceToModel, viewDir.getY() * this.distanceToModel, viewDir.getZ() * this.distanceToModel);
                    this.previewModel.moveTo(previewPos, this.objMoveToSpeed);
                    this.refrModelPosition();
                    continue;
                }
                if (this.previewModel != null) continue;
                this.interrupt();
            }
            catch (InterruptedException exc) {
                System.out.println(" ");
                System.out.println(exc.getMessage());
                exc.printStackTrace();
                return;
            }
        }
        if (this.plugin.showDeveloperInfos) {
            System.out.println("Thread - END " + Thread.currentThread().getName());
            this.player.sendTextMessage("Thread - Interrupted " + Thread.currentThread().getName());
        }
    }

    public void modelPutDown() {
        this.isPutDown = true;
        ++this.iPutDown;
        for (Player getPlayer : this.plugin.getServer().getAllPlayers()) {
            if (!this.plugin.getServer().isPlayerConnected(getPlayer.getName())) continue;
            getPlayer.removeWorldElement((WorldElement)this.previewModel);
            getPlayer.addWorldElement((WorldElement)this.previewModel);
        }
        try {
            if (this.iPutDown >= 2) {
                ModelPutDownEvent evt = new ModelPutDownEvent(this.previewModel, this.player);
                this.plugin.triggerEvent(evt);
            }
        }
        catch (Exception exc) {
            this.player.sendTextMessage("Error:  Leider ist ein Fehler bei triggerEvent() aufgetreten");
            this.player.sendTextMessage(exc.getMessage());
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        if (this.iPutDown >= 2) {
            this.player.sendTextMessage("Objekt ist endgoeltig positioniert.");
            System.out.println(this.getClass() + "  modelPutDown() ");
            System.out.println("  iPutDown = " + this.iPutDown);
            if (this.plugin.showDeveloperInfos) {
                this.player.sendTextMessage("  iPutDown = " + this.iPutDown);
            }
            this.plugin.placementThreadStop();
        }
    }

    private void refrModelPosition() {
        this.posX = this.previewModel.getPosition().x;
        this.posY = this.previewModel.getPosition().y;
        this.posZ = this.previewModel.getPosition().z;
    }

    private void refreshPreviewModel() {
        try {
            for (Player player : this.plugin.getServer().getAllPlayers()) {
                if (!this.plugin.getServer().isPlayerConnected(player.getName())) continue;
                player.removeWorldElement((WorldElement)this.previewModel);
                player.addWorldElement((WorldElement)this.previewModel);
            }
            ModelPlacementThread.sleep(10L);
            this.previewModel.refresh();
        }
        catch (InterruptedException e) {
            return;
        }
    }

    @EventMethod
    public void onPlayerInteract(PlayerElementInteractionEvent evt) {
        Player pl = evt.getPlayer();
        boolean isAllowPlc = false;
        if (pl.hasAttribute("allowPlacement")) {
            isAllowPlc = (Boolean)pl.getAttribute("allowPlacement");
        }
        if (!isAllowPlc) {
            return;
        }
        if (!this.isPutDown) {
            this.isPutDown = true;
        } else {
            this.isPutDown = false;
            this.iPutDown = 0;
        }
        this.refreshPreviewModel();
    }

    @EventMethod
    public void onPlayerKeyInput(PlayerKeyEvent evt) {
        Player pk = evt.getPlayer();
        if (pk.getName() != this.player.getName()) {
            return;
        }
        if (this.previewModel == null) {
            return;
        }
        if (this.iPutDown >= 2) {
            return;
        }
        if (evt.getKeyCode() == 201) {
            this.posY += this.moveStep;
            this.previewModel.setPosition(this.posX, this.posY, this.posZ);
        }
        if (evt.getKeyCode() == 209) {
            this.posY -= this.moveStep;
            this.previewModel.setPosition(this.posX, this.posY, this.posZ);
        }
        if (evt.isPressed()) {
            if (evt.getKeyCode() == 25) {
                this.modelPutDown();
            }
            if (evt.getKeyCode() == 78) {
                this.modelScale += this.modelScaleFaktor;
                this.previewModel.setScale(this.modelScale);
                this.player.sendTextMessage("modelScale:  " + this.modelScale);
            }
            if (evt.getKeyCode() == 74) {
                this.modelScale -= this.modelScaleFaktor;
                this.previewModel.setScale(this.modelScale);
                this.player.sendTextMessage("modelScale:  " + this.modelScale);
            }
            if (evt.getKeyCode() == 14) {
                this.rx = 0.0f;
                this.ry = 0.0f;
                this.rz = 0.0f;
                this.previewModel.setRotation(this.rx, this.ry, this.rz);
                this.modelScale = this.modelScaleOrginal;
                this.previewModel.setScale(this.modelScale);
                this.player.sendTextMessage("modelScale:  " + this.modelScale);
            }
            if (evt.getKeyCode() == 71) {
                this.rx -= this.rotStep;
                if (this.rx <= 0.0f) {
                    this.rx = (float)Math.PI * 2;
                }
                this.previewModel.setRotation(this.rx, this.ry, this.rz);
            }
            if (evt.getKeyCode() == 79) {
                this.rx += this.rotStep;
                if (this.rx >= (float)Math.PI * 2) {
                    this.rx = 0.0f;
                }
                this.previewModel.setRotation(this.rx, this.ry, this.rz);
            }
            if (evt.getKeyCode() == 75) {
                this.ry -= this.rotStep;
                if (this.ry <= 0.0f) {
                    this.ry = (float)Math.PI * 2;
                }
                this.previewModel.setRotation(this.rx, this.ry, this.rz);
            }
            if (evt.getKeyCode() == 77) {
                this.ry += this.rotStep;
                if (this.ry >= (float)Math.PI * 2) {
                    this.ry = 0.0f;
                }
                this.previewModel.setRotation(this.rx, this.ry, this.rz);
            }
            if (evt.getKeyCode() == 73) {
                this.rz -= this.rotStep;
                if (this.rz <= 0.0f) {
                    this.rz = (float)Math.PI * 2;
                }
                this.previewModel.setRotation(this.rx, this.ry, this.rz);
            }
            if (evt.getKeyCode() == 81) {
                this.rz += this.rotStep;
                if (this.rz >= (float)Math.PI * 2) {
                    this.rz = 0.0f;
                }
                this.previewModel.setRotation(this.rx, this.ry, this.rz);
            }
            if (evt.getKeyCode() == 203) {
                this.posX -= this.moveStep;
                this.previewModel.setPosition(this.posX, this.posY, this.posZ);
            }
            if (evt.getKeyCode() == 205) {
                this.posX += this.moveStep;
                this.previewModel.setPosition(this.posX, this.posY, this.posZ);
            }
            if (evt.getKeyCode() == 201) {
                this.posY += this.moveStep;
                this.previewModel.setPosition(this.posX, this.posY, this.posZ);
            }
            if (evt.getKeyCode() == 209) {
                this.posY -= this.moveStep;
                this.previewModel.setPosition(this.posX, this.posY, this.posZ);
            }
            if (evt.getKeyCode() == 200) {
                this.posZ += this.moveStep;
                this.previewModel.setPosition(this.posX, this.posY, this.posZ);
            }
            if (evt.getKeyCode() == 208) {
                this.posZ -= this.moveStep;
                this.previewModel.setPosition(this.posX, this.posY, this.posZ);
            }
            this.refreshPreviewModel();
        }
    }

    @EventMethod
    public void onCommand(PlayerCommandEvent event) {
        Player myPlayer = event.getPlayer();
        String[] cmd = event.getCommand().split(" ");
        if (cmd[0].equals("/modelPutDown")) {
            this.modelPutDown();
        }
        if (cmd[0].equals("/uolOK")) {
            this.modelPutDown();
        }
        if (cmd[0].equals("/PlacementThrStop")) {
            this.plugin.placementThreadStop();
        }
        if (cmd[0].equals("/uoSetMoveSpeed")) {
            this.objMoveToSpeed = Float.parseFloat(cmd[1]);
            myPlayer.sendTextMessage("new objMoveToSpeed is  " + this.objMoveToSpeed);
        }
    }
}

