/*
 * Decompiled with CFR 0.152.
 */
package de.kryssi.userobjectloader;

import de.kryssi.userobjectloader.DatabaseHandleThread;
import de.kryssi.userobjectloader.ModelLoader;
import de.kryssi.userobjectloader.ModelPlacementThread;
import de.kryssi.userobjectloader.MyDlgBox;
import de.kryssi.userobjectloader.PlayerListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.Listener;
import net.risingworld.api.objects.Player;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class UserObjectLoader
extends Plugin {
    static Plugin plugin;
    private Listener pListener;
    public Player currPlayer = null;
    public ArrayList<World3DModel> userModels = new ArrayList();
    private ModelLoader modelLoader = null;
    private MyDlgBox loadFileGui = null;
    private ModelPlacementThread placementThread = null;
    private DatabaseHandleThread databaseHandle = null;
    public String propertiesFileName = "";
    private Properties prop;
    public float fDistanceToModel = 3.0f;
    public int iRotationSteps = 16;
    public boolean showDeveloperInfos = false;
    public long maxObjFileSize = 0x200000L;
    public String guestGroupName = "";
    public String[] allowPlacementGroups = null;
    public String[] allowPlacementUsers = null;

    public void onEnable() {
        System.out.println(" ");
        plugin = this;
        this.propertiesFileName = String.valueOf(this.getPath()) + "/" + "userObjLoader_Config.properties";
        this.prop = new Properties();
        this.readProperties();
        this.databaseHandleThread_Start();
        this.initializeGUI();
        this.pListener = new PlayerListener(this);
        this.registerEventListener(this.pListener);
        this.modelLoader = new ModelLoader(this);
        System.out.println("UOL]  " + this.getDescription("name") + "  Ver." + this.getDescription("version") + "  plugin loaded successfully!");
        System.out.println("UOL]  " + this.getDescription("name") + " by " + this.getDescription("author"));
    }

    public void onDisable() {
        System.out.println("UserObject-Loader  onDisable()  ");
        if (this.placementThread != null) {
            this.placementThread.interrupt();
        }
        if (this.databaseHandle != null) {
            this.databaseHandle.interrupt();
        }
        this.loadFileGui.destroy();
        this.modelLoader.dispose();
        this.modelLoader = null;
        this.unregisterEventListener(this.pListener);
        System.out.println("UserObjectLoader  disabled ");
    }

    private void readProperties() {
        block12: {
            System.out.println("UOL]  readProperties() ");
            Reader reader = null;
            try {
                try {
                    reader = new FileReader(this.propertiesFileName);
                    this.prop.load(reader);
                    this.prop.list(System.out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String sDistanceToModel = this.getProp("fDistanceToModel");
        this.fDistanceToModel = Float.parseFloat(sDistanceToModel);
        String sRotationStepsProp = this.getProp("iRotationSteps");
        this.iRotationSteps = (int)Long.parseLong(sRotationStepsProp);
        String sShowDeveloperInfos = this.getProp("showDeveloperInfos");
        if (sShowDeveloperInfos.toLowerCase() == "true") {
            this.showDeveloperInfos = true;
        }
        String sMaxObjFileSize = this.getProp("maxObjFileSize");
        this.maxObjFileSize = Long.parseLong(sMaxObjFileSize);
        this.guestGroupName = this.getProp("guestGroupName");
        String sAllowGroups = this.getProp("allowPlacementGroups");
        this.allowPlacementGroups = sAllowGroups.split(";");
        String sAllowUsers = this.getProp("allowPlacementUsers");
        this.allowPlacementUsers = sAllowUsers.split(";");
    }

    public void saveProperties() {
        this.readProperties();
        Writer writer = null;
        try {
            try {
                writer = new FileWriter(this.propertiesFileName);
                this.prop.setProperty("guiCommand", "/dialogbox");
                this.prop.setProperty("threadStopCommand", "/PlacementThrStop");
                this.prop.store(writer, "Einstellungs Datei f\u00fcr PlugIn UserObjectLoader \r\n");
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getProp(String keyStr) {
        if (this.prop.isEmpty()) {
            return "";
        }
        return this.prop.getProperty(keyStr);
    }

    private void initializeGUI() {
        try {
            this.loadFileGui = new MyDlgBox(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onDialogBoxClose() {
        if (this.modelLoader != null) {
            this.modelLoader.stopPreview();
        }
        this.loadFileGui = null;
    }

    public void onDialogBoxCancel() {
        if (this.modelLoader != null) {
            this.modelLoader.stopPreview();
        }
    }

    public void onDialogBoxOK() {
        if (this.modelLoader.previewModel == null) {
            return;
        }
        this.loadFileGui.close(this.currPlayer);
        this.modelLoader.stopRotateThreat();
        World3DModel oModel = this.modelLoader.previewModel;
        this.placementThread_Start(oModel);
    }

    public void showDialogBox(Player myPlayer) {
        this.placementThreadStop();
        this.currPlayer = myPlayer;
        if (this.loadFileGui == null) {
            this.loadFileGui = new MyDlgBox(this);
        }
        if (this.loadFileGui != null) {
            myPlayer.sendTextMessage("Nu kannst Du deine 3D Objekte laden");
            this.loadFileGui.show(myPlayer);
        } else {
            myPlayer.sendTextMessage("hmmm,  ein Fehler !!!  loadFileGui = NULL");
        }
    }

    public void onPlayerConnect(Player pl) {
        this.loadModelsFromArray(pl);
    }

    private void loadModelsFromArray(Player pl) {
        if (this.userModels == null || this.userModels.size() == 0) {
            return;
        }
        for (World3DModel modelToAdd : this.userModels) {
            pl.addWorldElement((WorldElement)modelToAdd);
        }
    }

    private void databaseHandleThread_Start() {
        this.databaseHandle = new DatabaseHandleThread(this, 170);
        this.registerEventListener(this.databaseHandle);
        this.databaseHandle.setPriority(5);
        this.databaseHandle.start();
    }

    public void placementThread_Start(World3DModel oModelToPos) {
        try {
            if (this.placementThread != null && this.placementThread.isAlive()) {
                this.placementThreadStop();
            }
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
        }
        this.placementThread = new ModelPlacementThread(this, oModelToPos, this.currPlayer, 125);
        this.registerEventListener(this.placementThread);
        this.placementThread.setPriority(1);
        this.placementThread.start();
    }

    public void placementThreadStop() {
        if (this.placementThread != null) {
            this.unregisterEventListener(this.placementThread);
            this.placementThread.interrupt();
            this.placementThread = null;
        }
    }

    public void setModelToPlace(World3DModel oModelToPos, Player oPlayerToSet) {
        this.currPlayer = oPlayerToSet;
        if (this.placementThread != null) {
            this.placementThread.setModel(oModelToPos);
        } else {
            this.placementThread_Start(oModelToPos);
        }
    }

    public void LoadModel(Object modelDefFile) {
        this.LoadModelAndShow((File)modelDefFile, false);
    }

    public void PreviewModel(Object modelDefFile, Player playerClicked) {
        this.currPlayer = playerClicked;
        this.LoadModelAndShow((File)modelDefFile, true);
    }

    private void LoadModelAndShow(File modelDefFile, boolean isPreview) {
        String sFileName = modelDefFile.getName();
        System.out.println("UserObject-Loader  LoadModel(" + sFileName + ") ");
        if (!sFileName.toLowerCase().endsWith(".model")) {
            return;
        }
        this.modelLoader.LoadModel(modelDefFile, isPreview);
    }
}

