/*
 * Decompiled with CFR 0.152.
 */
package de.kryssi.userobjectloader;

import de.kryssi.userobjectloader.UserObjectLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Timer;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class ModelLoader {
    private UserObjectLoader plugin;
    private String fileDir = "";
    public World3DModel previewModel = null;
    public RotationThread rotateThread;
    private float rx = 0.0f;
    private float ry = 0.0f;
    private float rz = 0.0f;
    Timer timer = new Timer();

    public ModelLoader(UserObjectLoader oPlugin) {
        this.plugin = oPlugin;
        this.fileDir = String.valueOf(this.plugin.getPath()) + "/assets";
    }

    public void dispose() {
        System.out.println(" class ModelLoader   dispose() ");
        if (this.rotateThread != null) {
            this.rotateThread.interrupt();
        }
        if (this.previewModel != null) {
            this.previewModel.destroy();
            this.previewModel = null;
        }
    }

    public void stopPreview() {
        if (this.rotateThread != null) {
            this.rotateThread.interrupt();
        }
        if (this.previewModel == null) {
            return;
        }
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            if (!this.plugin.getServer().isPlayerConnected(player.getName())) continue;
            player.removeWorldElement((WorldElement)this.previewModel);
        }
        this.previewModel.destroy();
        this.previewModel = null;
    }

    public void LoadModel(File modelDefFile, boolean isPreview) {
        System.out.println("ModelLoader.LoadModel ");
        String sFileName = modelDefFile.getName();
        if (!sFileName.toLowerCase().endsWith(".model")) {
            return;
        }
        if (this.rotateThread != null) {
            this.rotateThread.interrupt();
        }
        if (this.previewModel != null && !this.previewModel.isInteractable()) {
            this.previewModel.destroy();
        }
        this.previewModel = this.LoadModel(modelDefFile.toString());
        if (this.previewModel == null) {
            return;
        }
        Vector3f viewDir = this.plugin.currPlayer.getViewDirection();
        Vector3f previewPos = this.plugin.currPlayer.getPosition();
        previewPos.addLocal(viewDir.x * 4.0f, 0.0f, viewDir.z * 4.0f);
        this.previewModel.setPosition(previewPos.x, previewPos.y, previewPos.z);
        this.plugin.currPlayer.sendTextMessage(previewPos.toString());
        this.rotateThread = new RotationThread(this.previewModel, this.plugin.currPlayer, 350);
        this.rotateThread.start();
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            if (!this.plugin.getServer().isPlayerConnected(player.getName())) continue;
            player.removeWorldElement((WorldElement)this.previewModel);
            player.addWorldElement((WorldElement)this.previewModel);
        }
    }

    private World3DModel LoadModel(String sFilePath) {
        World3DModel model3d = null;
        String strModel = null;
        String strTexture = "";
        float px = 0.0f;
        float py = 0.0f;
        float pz = 0.0f;
        float scale = 0.9f;
        String world = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(sFilePath));
            String line = "";
            while ((line = br.readLine()) != null) {
                String[] sp = line.split(":");
                if (sp.length != 2) continue;
                switch (sp[0]) {
                    case "model": {
                        strModel = sp[1];
                        break;
                    }
                    case "texture": {
                        strTexture = sp[1];
                        break;
                    }
                    case "scale": {
                        scale = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "px": {
                        px = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "py": {
                        py = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "pz": {
                        pz = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "rx": {
                        this.rx = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "ry": {
                        this.ry = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "rz": {
                        this.rz = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "world": {
                        world = sp[1];
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            this.sendMessageToAllPlayer("ModelLoader.LoadModel() Error: " + ex.getMessage());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.sendMessageToAllPlayer("ModelLoader.LoadModel() Error: " + ex.getMessage());
        }
        if (strModel == null || strTexture == null) {
            return model3d;
        }
        if (!new File(String.valueOf(this.fileDir) + "/" + strModel).exists()) {
            this.plugin.currPlayer.sendTextMessage("[#AB0000]obj file NOT found !!! ");
            return null;
        }
        long maxSize = this.plugin.maxObjFileSize;
        if (new File(String.valueOf(this.fileDir) + "/" + strModel).length() >= maxSize) {
            this.plugin.currPlayer.sendTextMessage("[#AB1200]obj file is to big !   max size is " + maxSize + " bytes ");
            System.out.println("obj file is to big ");
            return null;
        }
        ModelInformation model = new ModelInformation(String.valueOf(this.fileDir) + "/" + strModel);
        ImageInformation texture = null;
        if (strTexture == null || strTexture == "") {
            System.out.println("Texture is empty ");
            texture = new ImageInformation("");
        } else {
            texture = new ImageInformation(String.valueOf(this.fileDir) + "/" + strTexture);
        }
        model3d = new World3DModel(model, texture);
        if (model3d != null) {
            model3d.setLightingEnabled(true);
            model3d.setCollisionShape(CollisionShape.createHullCollisionShape());
            model3d.setPosition(1.0f, 10.0f, 1.0f);
            model3d.setRotation(this.rx, this.ry, this.rz);
            model3d.setScale(scale);
            model3d.setHittable(true);
        }
        return model3d;
    }

    public void stopRotateThreat() {
        this.previewModel.setRotation(0.0f, 0.0f, 0.0f);
        this.rotateThread.interrupt();
    }

    private void sendMessageToAllPlayer(String sMessage) {
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            if (!this.plugin.getServer().isPlayerConnected(player.getName())) continue;
            player.sendTextMessage(sMessage);
        }
    }

    private static class RotationThread
    extends Thread {
        private int delayMili = 500;
        private World3DModel previewModel = null;
        private Player player = null;
        private float rx = 0.0f;
        private float ry = 0.0f;
        private float rz = 0.0f;

        public RotationThread(World3DModel oModelToRotate, Player player, int delayMS) {
            this.previewModel = oModelToRotate;
            this.player = player;
            this.delayMili = delayMS;
            this.rx = this.previewModel.getRotation().getX();
            this.ry = this.previewModel.getRotation().getY();
            this.rz = this.previewModel.getRotation().getZ();
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                this.ry += 0.5f;
                try {
                    RotationThread.sleep(this.delayMili);
                    if (this.previewModel != null) {
                        this.previewModel.setRotation(this.rx, this.ry, this.rz);
                        this.previewModel.refresh();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                if (!(this.ry >= 380.0f)) continue;
                this.ry = 0.0f;
            }
        }
    }
}

