/*
 * Decompiled with CFR 0.152.
 */
package de.kryssi.userobjectloader;

import com.vistamaresoft.rwgui.GuiDialogueBox;
import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.GuiVerticalLayout;
import com.vistamaresoft.rwgui.RWGui;
import de.kryssi.userobjectloader.UserObjectLoader;
import java.io.File;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.objects.Player;

public class MyDlgBox
extends GuiDialogueBox {
    private UserObjectLoader plugin;
    private String fileDir = "";
    private GuiLayout vLayoutFiles = null;
    private GuiLayout vLayoutDirectory = null;

    public MyDlgBox(UserObjectLoader oPlugin) {
        super(UserObjectLoader.plugin, "Load 3D model", 2, null);
        this.plugin = oPlugin;
        this.fileDir = String.valueOf(this.plugin.getPath()) + "/assets";
        this.setCallback(new DlgHandler(this.plugin));
        this.setPosition(this.getPositionX() / 3.0f, this.getPositionY(), true);
        this.setColor(0.1f, 0.1f, 0.4f, 0.4f);
        this.setMargin(2);
        this.setPadding(1);
        GuiLayout hLayout = this.addNewLayoutChild(1, 0);
        hLayout.setMargin(5);
        hLayout.setPadding(1);
        hLayout.setBorderThickness(1.0f, true);
        hLayout.setBorderColor(2);
        hLayout.setColor(0.3f, 0.3f, 0.3f, 0.5f);
        float fBreite = this.getWidth() / 2.0f - 4.0f;
        GuiLabel buttonOK = new GuiLabel("  [#FFFF95]OK  ", 0.0f, 0.0f, false);
        buttonOK.setColorCodesEnabled(true);
        buttonOK.setBorderColor(1.0f, 0.9f, 0.9f, 0.2f);
        buttonOK.setBorderThickness(1.0f, false);
        buttonOK.setSize(fBreite, 60.0f, false);
        hLayout.addChild((GuiElement)buttonOK, Integer.valueOf(1));
        GuiLabel btnCancel = new GuiLabel("[#FFFF95]cancel", 0.0f, 0.0f, false);
        btnCancel.setColorCodesEnabled(true);
        btnCancel.setBorderColor(0.7f, 0.9f, 0.9f, 0.5f);
        btnCancel.setBorderThickness(1.0f, false);
        btnCancel.setSize(fBreite, 60.0f, false);
        hLayout.addChild((GuiElement)btnCancel, Integer.valueOf(2));
        this.vLayoutFiles = this.addNewLayoutChild(2, 2);
        this.vLayoutFiles.setMargin(2);
        this.vLayoutFiles.setColor(0.0f, 0.0f, 0.75f, 0.6f);
        this.refreshFileList();
    }

    private void refreshFileList() {
        this.vLayoutFiles.setMargin(0);
        ((GuiVerticalLayout)this.vLayoutFiles).setMaxVisibleRows(6);
        File[] fileEntries = new File(this.fileDir).listFiles();
        if (fileEntries.length <= 0) {
            return;
        }
        int iL = 7;
        File[] fileArray = fileEntries;
        int n = fileEntries.length;
        int n2 = 0;
        while (n2 < n) {
            File fi = fileArray[n2];
            String sFileName = fi.getName();
            if (sFileName.toLowerCase().endsWith(".model")) {
                String sDisplayName = sFileName.replace(".model", "");
                this.vLayoutFiles.addChild((GuiElement)new GuiLabel(sDisplayName, 0.0f, 0.0f, false), Integer.valueOf(++iL), (Object)fi);
            }
            ++n2;
        }
        this.vLayoutFiles.refresh();
        this.refresh();
    }

    private class DlgHandler
    implements RWGui.RWGuiCallback {
        private UserObjectLoader plugin;

        public DlgHandler(UserObjectLoader oPlugin) {
            this.plugin = oPlugin;
        }

        public void onCall(Player playerGui, int id, Object data) {
            if (this.plugin.showDeveloperInfos) {
                playerGui.sendTextMessage("  ");
                playerGui.sendTextMessage("id: " + id + "  data: " + data);
            }
            if (id == -1) {
                this.plugin.onDialogBoxClose();
                return;
            }
            if (id == 1) {
                this.plugin.onDialogBoxOK();
                return;
            }
            if (id == 2) {
                this.plugin.onDialogBoxCancel();
                return;
            }
            if (data != null) {
                this.plugin.PreviewModel(data, playerGui);
            }
        }
    }
}

