/*
 * Decompiled with CFR 0.152.
 */
package de.kryssi.userobjectloader;

import de.kryssi.userobjectloader.UserObjectLoader;
import de.kryssi.userobjectloader.events.ModelPutDownEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.risingworld.api.database.DatabaseType;
import net.risingworld.api.database.WorldDatabase;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerElementHitEvent;
import net.risingworld.api.events.player.PlayerElementInteractionEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class DatabaseHandleThread
extends Thread
implements Listener {
    private boolean isModelsLoaded = false;
    private int delayMili = 250;
    public World3DModel previewModel = null;
    private Player player = null;
    private WorldDatabase dataBase = null;
    private UserObjectLoader plugin;

    public DatabaseHandleThread(UserObjectLoader oPluginToSet, int delayMS) {
        super("Database Handle Thread");
        this.plugin = oPluginToSet;
        this.delayMili = delayMS;
        try {
            Thread.currentThread().setPriority(1);
        }
        catch (SecurityException exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        this.dataBase = this.plugin.getWorldDatabase();
        if (this.dataBase == null) {
            System.out.println("Error:  dataBase == null ");
            System.out.println("Fehler: speichern und laden von Modellen nicht moeglich ");
            try {
                this.finalize();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.interrupt();
            return;
        }
        if (this.dataBase.getType() == DatabaseType.SQLite) {
            System.out.println("World uses an SQLite database");
        } else if (this.dataBase.getType() == DatabaseType.MySQL) {
            System.out.println("World uses a MySQL database");
        }
        this.createTable();
        this.loadModelsFromDataBase();
        if (!this.plugin.userModels.isEmpty()) {
            this.insertIntoTable(this.plugin.userModels);
        }
    }

    public void createTable() {
        System.out.println("execute  Create Table  IF NOT EXISTS `User3DModels`  ");
        String sp = "";
        sp = String.valueOf(sp) + " `InGameID`  INTEGER  default 0, ";
        sp = String.valueOf(sp) + " `ModelFilename`   VARCHAR(128)  NOT NULL, ";
        sp = String.valueOf(sp) + " `TextureFilename` VARCHAR(128)  NOT NULL, ";
        sp = String.valueOf(sp) + " `Position`  VARCHAR(64)  NOT NULL, ";
        sp = String.valueOf(sp) + " `Rotation`  VARCHAR(96), ";
        sp = String.valueOf(sp) + " `Scale`  REAL   NOT NULL, ";
        sp = String.valueOf(sp) + " `IsPickup`  BOOLEAN default 0, ";
        sp = String.valueOf(sp) + " `Price`  INTEGER   DEFAULT 10,  ";
        sp = String.valueOf(sp) + " CONSTRAINT name_unique UNIQUE (InGameID, ModelFilename) ";
        this.dataBase.execute("CREATE TABLE IF NOT EXISTS `User3DModels` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, " + sp + " ); ");
    }

    public void insertIntoTable(World3DModel modelToInsert, boolean isPickup) {
        System.out.println(" ");
        System.out.println(this.getClass() + "  insertIntoTable()  - in Datenbank schreiben ");
        if (modelToInsert == null) {
            if (this.player != null) {
                this.player.sendTextMessage(" modelToInsert == null ");
            }
            System.out.println("UOL]   modelToInsert == null  !!! ");
            return;
        }
        int inGameID = modelToInsert.getID();
        if (modelToInsert.getPosition() == null) {
            return;
        }
        String sModelFilename = String.valueOf(modelToInsert.getModel().getFilename()) + ".obj";
        String sTextureFilename = String.valueOf(modelToInsert.getTexture().getFilename()) + "." + modelToInsert.getTexture().getExtension();
        String sPos = "" + modelToInsert.getPosition().getX();
        sPos = String.valueOf(sPos) + " " + modelToInsert.getPosition().getY();
        sPos = String.valueOf(sPos) + " " + modelToInsert.getPosition().getZ();
        String sRotat = "" + modelToInsert.getRotation().getX();
        sRotat = String.valueOf(sRotat) + " " + modelToInsert.getRotation().getY();
        sRotat = String.valueOf(sRotat) + " " + modelToInsert.getRotation().getZ();
        sRotat = String.valueOf(sRotat) + " " + modelToInsert.getRotation().getW();
        System.out.println(" " + inGameID + "]  " + sModelFilename + ",  " + sTextureFilename + ",  pos.:(" + sPos + ") ");
        String sRows = "InGameID, ModelFilename, TextureFilename, Position, Rotation, ";
        sRows = String.valueOf(sRows) + "Scale";
        String sValues = inGameID + ", '" + sModelFilename + "', '" + sTextureFilename + "',  ";
        sValues = String.valueOf(sValues) + "'" + sPos + "', ";
        sValues = String.valueOf(sValues) + "'" + sRotat + "', ";
        sValues = String.valueOf(sValues) + " " + modelToInsert.getScale() + " ";
        System.out.println(" dataBase.executeUpdate() ");
        this.dataBase.executeUpdate("INSERT OR REPLACE INTO `User3DModels` (" + sRows + ") VALUES (" + sValues + "); ");
    }

    public void deleteFromTable(int inGameID) {
        System.out.println(" ");
        System.out.println(this.getClass() + "  deleteFromTable()  - World3DModel ID  " + inGameID);
        this.dataBase.execute("DELETE FROM `User3DModels`  WHERE  InGameID=" + inGameID + "; ");
    }

    private void truncateTable() {
        System.out.println("UOL]  " + this.getClass() + "  truncateTable() ");
        this.dataBase.execute("DELETE FROM `User3DModels`; ");
        try {
            DatabaseHandleThread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        System.out.println(" ");
        System.out.println("Thread - START " + Thread.currentThread().getName());
        while (!Thread.currentThread().isInterrupted()) {
            try {
                DatabaseHandleThread.sleep(this.delayMili);
                if (this.isModelsLoaded) continue;
                DatabaseHandleThread.sleep(50L);
                this.plugin.userModels.isEmpty();
            }
            catch (InterruptedException exc) {
                System.out.println(" ");
                System.out.println(exc.getMessage());
                exc.printStackTrace();
            }
        }
    }

    public void loadModelsFromArray(Player pl) {
        for (World3DModel modelToAdd : this.plugin.userModels) {
            pl.addWorldElement((WorldElement)modelToAdd);
        }
    }

    private void loadModelsFromDataBase() {
        if (this.dataBase == null) {
            return;
        }
        System.out.println("UOL]  " + this.getClass() + "  loadModelsFromDataBase() ");
        this.plugin.userModels.clear();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ResultSet result = this.dataBase.executeQuery("SELECT * FROM `User3DModels` ");){
                while (result.next()) {
                    this.placeObjectOnWorld(result);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException exc) {
            System.out.println("  ");
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        this.isModelsLoaded = true;
    }

    public void insertIntoTable(ArrayList<World3DModel> userModelsList) {
        this.truncateTable();
        try {
            DatabaseHandleThread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (World3DModel modelToInsert : userModelsList) {
            String sFilename = modelToInsert.getModel().getFilename();
            if (sFilename == null) continue;
            this.insertIntoTable(modelToInsert, false);
        }
        System.out.println("UOL]  " + this.getClass() + "   Database rewrite  finish ");
        System.out.println("   ");
    }

    private void placeObjectOnWorld(ResultSet dbRes) {
        String[] rotValues;
        System.out.println(" ");
        System.out.println("placeObjectOnWorld( ResultSet dbRes ) ");
        String sModelFilename = "";
        String sTextureFilename = "";
        String sPos = "";
        String sRotat = "";
        float fScale = 1.0f;
        if (dbRes == null) {
            return;
        }
        try {
            sModelFilename = dbRes.getString("ModelFilename");
            sTextureFilename = dbRes.getString("TextureFilename");
            sPos = dbRes.getString("Position");
            sRotat = dbRes.getString("Rotation");
            fScale = dbRes.getFloat("Scale");
        }
        catch (SQLException exc) {
            System.out.println(exc.getMessage());
            return;
        }
        if (sModelFilename == "" || sPos == "") {
            return;
        }
        String fileDir = String.valueOf(this.plugin.getPath()) + "/assets";
        World3DModel model3d = null;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        float rotW = 0.0f;
        ModelInformation modelInf = new ModelInformation(String.valueOf(fileDir) + "/" + sModelFilename);
        ImageInformation textureInf = new ImageInformation(String.valueOf(fileDir) + "/" + sTextureFilename);
        model3d = new World3DModel(modelInf, textureInf);
        String[] posValues = sPos.split(" ");
        if (Utils.StringUtils.isNumeric((String)posValues[0]) && Utils.StringUtils.isNumeric((String)posValues[1]) && Utils.StringUtils.isNumeric((String)posValues[2])) {
            posX = Float.parseFloat(posValues[0]);
            posY = Float.parseFloat(posValues[1]);
            posZ = Float.parseFloat(posValues[2]);
            model3d.setPosition(posX, posY, posZ);
        }
        if ((rotValues = sRotat.split(" ")).length >= 3) {
            System.out.println(" rotValues.length =  " + rotValues.length);
            if (Utils.StringUtils.isNumeric((String)rotValues[0])) {
                rotX = Float.parseFloat(rotValues[0]);
                rotY = Float.parseFloat(rotValues[1]);
                rotZ = Float.parseFloat(rotValues[2]);
                if (rotValues.length == 3) {
                    model3d.setRotation(rotX, rotY, rotZ);
                } else {
                    rotW = Float.parseFloat(rotValues[3]);
                    model3d.setRotation(new Quaternion(rotX, rotY, rotZ, rotW));
                }
            }
        }
        model3d.setScale(fScale);
        model3d.setLightingEnabled(true);
        model3d.setCollisionShape(CollisionShape.createHullCollisionShape());
        model3d.setInteractable(true);
        model3d.setInteractionCrosshair(Crosshair.Pickup);
        model3d.setHittable(true);
        model3d.refresh();
        this.model_addWorld(model3d);
    }

    private void model_addWorld(World3DModel oModelToAdd) {
        for (Player getPlayerVS : this.plugin.getServer().getAllPlayers()) {
            if (!this.plugin.getServer().isPlayerConnected(getPlayerVS.getName())) continue;
            getPlayerVS.removeWorldElement((WorldElement)oModelToAdd);
            getPlayerVS.addWorldElement((WorldElement)oModelToAdd);
        }
        oModelToAdd.refresh();
        this.plugin.userModels.add(oModelToAdd);
    }

    @EventMethod
    public void onPlayerInteract(PlayerElementInteractionEvent evt) {
        Player p = evt.getPlayer();
        this.player = evt.getPlayer();
        boolean isAllowPlc = false;
        if (this.player.hasAttribute("allowPlacement")) {
            isAllowPlc = (Boolean)this.player.getAttribute("allowPlacement");
        }
        WorldElement element = evt.getWorldElement();
        World3DModel temp3dModel = (World3DModel)element;
        if (this.plugin.showDeveloperInfos) {
            p.sendTextMessage(" ");
            p.sendTextMessage("interact with: " + element.getClass().getName());
            p.sendTextMessage(" elem ID: " + element.getID());
            p.sendTextMessage(" 3D Model ID: " + temp3dModel.getID());
            p.sendTextMessage(" Filename: " + temp3dModel.getModel().getFilename());
            p.sendTextMessage(" Crosshair: " + temp3dModel.getInteractionCrosshair());
        }
        if (temp3dModel.getInteractionCrosshair() == Crosshair.Pickup && isAllowPlc) {
            this.plugin.setModelToPlace(temp3dModel, this.player);
        }
    }

    @EventMethod
    public void onPlayerElementHitEvent(PlayerElementHitEvent evt) {
        Player pl = evt.getPlayer();
        System.out.println("UOL]  " + pl.getName() + " Element Hit ");
        boolean isAllowPlc = false;
        if (pl.hasAttribute("allowPlacement")) {
            isAllowPlc = (Boolean)pl.getAttribute("allowPlacement");
        }
        if (!isAllowPlc) {
            System.out.println("UOL]   not allow");
            return;
        }
        WorldElement element = evt.getWorldElement();
        World3DModel temp3dModel = (World3DModel)element;
        temp3dModel.refresh();
        int iElemID = temp3dModel.getID();
        System.out.println("UOL]   hit WorldElement ID " + iElemID);
        if (temp3dModel.getInteractionCrosshair() != Crosshair.Pickup) {
            System.out.println("UOL]   not  Crosshair.Pickup");
            return;
        }
        if (this.plugin.showDeveloperInfos) {
            pl.sendTextMessage("onPlayerElementHitEvent()  ");
            this.plugin.currPlayer.sendTextMessage("onPlayerElementHitEvent()  ");
            pl.sendTextMessage("  3D Model ID: " + iElemID);
            pl.sendTextMessage("     Filename: " + temp3dModel.getModel().getFilename());
        }
        this.deleteFromTable(iElemID);
        for (Player getPlayer : this.plugin.getServer().getAllPlayers()) {
            if (!this.plugin.getServer().isPlayerConnected(getPlayer.getName())) continue;
            getPlayer.removeWorldElement(element);
            getPlayer.removeWorldElement((WorldElement)temp3dModel);
        }
        this.plugin.placementThreadStop();
        this.plugin.onDialogBoxCancel();
    }

    @EventMethod(value=Threading.Threaded)
    public void onModelPutDown(ModelPutDownEvent event) {
        System.out.println("ModelPutDownEvent: " + event.getMessage());
        this.player = event.getPlayer();
        World3DModel temp3dModel = event.getModel();
        this.player.sendTextMessage(" ");
        this.player.sendTextMessage("ModelPutDownEvent: " + event.getMessage() + " and DB saved. ");
        this.player.sendTextMessage(" Filename:   " + temp3dModel.getModel().getFilename());
        this.insertIntoTable(temp3dModel, false);
        if (!this.plugin.userModels.contains(temp3dModel)) {
            this.plugin.userModels.add(temp3dModel);
        }
    }
}

