/*
 * Decompiled with CFR 0.152.
 */
package de.kryssi.userobjectloader;

import de.kryssi.userobjectloader.UserObjectLoader;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.objects.Player;

public class PlayerListener
implements Listener {
    private UserObjectLoader plugin;

    public PlayerListener(UserObjectLoader oPlugin) {
        this.plugin = oPlugin;
    }

    @EventMethod(value=Threading.Sync)
    public void onPlayerConnect(PlayerConnectEvent evt) {
        Player p = evt.getPlayer();
        p.setAttribute("allowPlacement", (Object)false);
        evt.isNewPlayer();
        this.plugin.onPlayerConnect(p);
        if (!this.allowPlacement(p)) {
            return;
        }
        System.out.println("UOL]  " + p.getName() + " allowPlacement = true ");
        System.out.println("UOL]   Spieler " + p.getName() + " darf Objekte plazieren ");
        p.sendTextMessage("3D Objekte Loader  ist geladen. Benutze  " + this.plugin.getProp("guiCommand") + " fuer DialogBox");
        p.registerKeys(new int[]{1});
        p.registerKeys(new int[]{25});
        p.registerKeys(new int[]{78});
        p.registerKeys(new int[]{74});
        p.registerKeys(new int[]{75});
        p.registerKeys(new int[]{77});
        p.registerKeys(new int[]{79});
        p.registerKeys(new int[]{71});
        p.registerKeys(new int[]{81});
        p.registerKeys(new int[]{73});
        p.registerKeys(new int[]{203});
        p.registerKeys(new int[]{205});
        p.registerKeys(new int[]{200});
        p.registerKeys(new int[]{208});
        p.registerKeys(new int[]{201});
        p.registerKeys(new int[]{209});
        p.registerKeys(new int[]{14});
        p.setListenForKeyInput(true);
    }

    @EventMethod
    public void onCommand(PlayerCommandEvent event) {
        Player myPlayer = event.getPlayer();
        String[] cmd = event.getCommand().split(" ");
        if (cmd[0].equals(this.plugin.getProp("guiCommand"))) {
            if (!this.allowPlacement(myPlayer)) {
                myPlayer.sendTextMessage("[#FF0000]Operation nicht gestattet !!! operation not permitted");
                return;
            }
            this.plugin.showDialogBox(myPlayer);
        }
    }

    public boolean allowPlacement(Player playerToCheck) {
        boolean isAllow = false;
        if (playerToCheck.isAdmin()) {
            playerToCheck.setAttribute("allowPlacement", (Object)true);
            return true;
        }
        int iGr = 0;
        while (iGr <= this.plugin.allowPlacementGroups.length) {
            if (this.plugin.allowPlacementGroups[iGr].equals(playerToCheck.getPermissionGroup())) {
                playerToCheck.setAttribute("allowPlacement", (Object)true);
                return true;
            }
            ++iGr;
        }
        if (this.plugin.allowPlacementGroups[0].equals("any")) {
            playerToCheck.setAttribute("allowPlacement", (Object)true);
            return true;
        }
        if (this.plugin.allowPlacementUsers[0].equals("any")) {
            playerToCheck.setAttribute("allowPlacement", (Object)true);
            return true;
        }
        int iU = 0;
        while (iU <= this.plugin.allowPlacementUsers.length) {
            if (this.plugin.allowPlacementUsers[iU].equals(playerToCheck.getName())) {
                playerToCheck.setAttribute("allowPlacement", (Object)true);
                return true;
            }
            ++iU;
        }
        playerToCheck.setAttribute("allowPlacement", (Object)isAllow);
        System.out.println("UOL]  " + this.getClass() + "  allowPlacement( " + playerToCheck.getName() + " ) ");
        System.out.println("UOL]     =>  isAllow = " + isAllow);
        return isAllow;
    }
}

