/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import net.risingworld.api.gui.Font;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.worldelements.WorldElement;
import pluginapi.manager.PluginElementManager;

public class World3DText
extends WorldElement {
    private String text = "";
    private boolean alwaysVisible = false;
    private boolean billboard = true;
    private Font font = Font.Default;
    private byte fontsize = (byte)5;
    private int fontcolor = -1;
    private int backgroundColor = 0;

    public World3DText(String text) {
        this.text = text;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!this.text.equals(text)) {
            this.text = text;
            this.updateElement();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setAlwaysVisible(boolean set) {
        if (this.alwaysVisible != set) {
            this.alwaysVisible = set;
            this.updateElement();
        }
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    public void setBillboard(boolean set) {
        if (this.billboard != set) {
            this.billboard = set;
            this.updateElement();
        }
    }

    public void setFont(Font font) {
        if (this.font != font) {
            this.font = font;
            this.updateElement();
        }
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isBillboard() {
        return this.billboard;
    }

    public void setFontsize(int size) {
        if (this.fontsize != size) {
            this.fontsize = size > 100 ? (byte)100 : (size < 0 ? (byte)0 : (byte)size);
            this.updateElement();
        }
    }

    public int getFontsize() {
        return this.fontsize;
    }

    public void setFontColor(int color) {
        if (this.fontcolor != color) {
            this.fontcolor = color;
            this.updateElement();
        }
    }

    public void setFontColor(float r, float g, float b, float a) {
        this.setFontColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public int getFontColor() {
        return this.fontcolor;
    }

    public void setBackgroundColor(int backgroundColor) {
        if (this.backgroundColor != backgroundColor) {
            this.backgroundColor = backgroundColor;
            this.updateElement();
        }
    }

    public void setBackgroundColor(float r, float g, float b, float a) {
        this.setBackgroundColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    private void updateElement() {
        PluginElementManager.update3DText((int)this.id, (String)this.text, (boolean)this.alwaysVisible, (boolean)this.billboard, (Font)this.font, (byte)this.fontsize, (int)this.fontcolor, (int)this.backgroundColor);
    }
}

