/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.WorldElement;
import pluginapi.manager.PluginElementManager;

public class World3DModel
extends WorldElement {
    private ModelInformation model;
    private ImageInformation texture;
    private boolean lightingEnabled = true;
    private CollisionShape collisionShape;
    private float scale = 1.0f;
    private float textureScale = 1.0f;
    private boolean interactable = false;
    private Crosshair crosshair = Crosshair.Default;
    private boolean hittable = false;

    public World3DModel(ModelInformation model, ImageInformation texture) {
        this.model = model;
        this.texture = texture;
    }

    public World3DModel(ModelInformation model, ImageInformation texture, Vector3f position, Quaternion rotation) {
        this.model = model;
        this.texture = texture;
        this.setPosition(position);
        this.setRotation(rotation);
    }

    public void setInteractable(boolean set) {
        if (this.interactable != set) {
            this.interactable = set;
            this.updateElement(false);
        }
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractionCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            crosshair = Crosshair.Default;
        }
        if (this.crosshair != crosshair) {
            this.crosshair = crosshair;
            this.updateElement(false);
        }
    }

    public Crosshair getInteractionCrosshair() {
        return this.crosshair;
    }

    public void setHittable(boolean set) {
        if (this.hittable != set) {
            this.hittable = set;
            this.updateElement(false);
        }
    }

    public boolean isHittable() {
        return this.hittable;
    }

    public void setModel(ModelInformation model) {
        if (this.model != model) {
            this.model = model;
            this.updateElement(false);
        }
    }

    public ModelInformation getModel() {
        return this.model;
    }

    public void setTexture(ImageInformation texture) {
        if (this.texture != texture) {
            this.texture = texture;
            this.updateElement(false);
        }
    }

    public ImageInformation getTexture() {
        return this.texture;
    }

    public void setLightingEnabled(boolean lighting) {
        if (this.lightingEnabled != lighting) {
            this.lightingEnabled = lighting;
            this.updateElement(false);
        }
    }

    public boolean isLightingEnabled() {
        return this.lightingEnabled;
    }

    public void setScale(float scale) {
        if (this.scale != scale) {
            this.scale = scale;
            this.updateElement(false);
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setTextureScale(float scale) {
        if (this.textureScale != scale) {
            this.textureScale = scale;
            this.updateElement(false);
        }
    }

    public float getTextureScale() {
        return this.textureScale;
    }

    public void setCollisionShape(CollisionShape collisionShape) {
        if (this.collisionShape != collisionShape) {
            this.collisionShape = collisionShape;
            this.updateElement(true);
        }
    }

    public CollisionShape getCollisionShape() {
        return this.collisionShape;
    }

    public boolean hasCollisionShape() {
        return this.collisionShape != null;
    }

    private void updateElement(boolean collision) {
        int modelID = PluginElementManager.getModelInformationID((ModelInformation)this.model);
        int imageID = PluginElementManager.getImageInformationID((ImageInformation)this.texture);
        if (collision) {
            PluginElementManager.update3DModel((int)this.id, (int)modelID, (int)imageID, (float)this.scale, (float)this.textureScale, (boolean)this.lightingEnabled, (boolean)this.interactable, (boolean)this.hittable, (Crosshair)this.crosshair, (boolean)true, (CollisionShape)this.collisionShape);
        } else {
            PluginElementManager.update3DModel((int)this.id, (int)modelID, (int)imageID, (float)this.scale, (float)this.textureScale, (boolean)this.lightingEnabled, (boolean)this.interactable, (boolean)this.hittable, (Crosshair)this.crosshair, (boolean)false, null);
        }
    }
}

