/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import commons.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import net.risingworld.api.Plugin;
import pluginapi.PluginManager;

abstract class FileInformation {
    byte[] data;
    String filename;
    String extension;
    String md5;

    FileInformation() {
    }

    FileInformation(Plugin plugin, String resource) {
        try {
            this.loadFromResource(plugin, resource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    FileInformation(String filepath) {
        this(new File(filepath));
    }

    FileInformation(File file) {
        try {
            this.loadFromFile(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean loadFromResource(Plugin plugin, String resourcepath) {
        byte[] bytes = PluginManager.getResource((int)plugin.getID(), (String)resourcepath);
        System.out.println("load from resources: " + resourcepath + "      " + bytes);
        if (bytes != null) {
            if (!this.checkFileExtension(resourcepath)) {
                throw new UnsupportedOperationException("File format of \"" + resourcepath + "\" not supported!");
            }
            int dot = resourcepath.lastIndexOf(46);
            int slash = resourcepath.lastIndexOf(47);
            if (slash < 0) {
                slash = 0;
            }
            String ext = resourcepath.substring(dot + 1);
            String name = resourcepath.substring(slash, dot);
            String checksum = Utils.ByteUtils.getMd5((byte[])bytes);
            this.setupFileInfo(name, ext, bytes, checksum);
            System.out.println("load from resources: " + name + " " + ext + " " + checksum + " " + bytes.length);
            return true;
        }
        return false;
    }

    private boolean loadFromFile(File file) throws IOException {
        if (file != null) {
            String name = file.getName();
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            if (file.isDirectory()) {
                throw new FileNotFoundException("You have to specify a single file instead of a directory");
            }
            if (!this.checkFileExtension(name)) {
                throw new UnsupportedOperationException("File format of \"" + file.getName() + "\" not supported!");
            }
            int dot = name.lastIndexOf(46);
            String ext = name.substring(dot + 1);
            name = name.substring(0, dot);
            byte[] bytes = Utils.FileUtils.readBytesFromFile((File)file);
            String checksum = Utils.FileUtils.getMd5((File)file);
            this.setupFileInfo(name, ext, bytes, checksum);
            return true;
        }
        return false;
    }

    void setupFileInfo(String filename, String extension, byte[] data, String md5) {
        this.extension = extension;
        this.filename = filename;
        this.data = data;
        this.md5 = md5;
        this.onInit();
    }

    abstract void onInit();

    abstract boolean checkFileExtension(String var1);

    public byte[] getData() {
        return this.data;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getChecksum() {
        return this.md5;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FileInformation)) {
            return false;
        }
        FileInformation compare = (FileInformation)o;
        return this.filename.equals(compare.filename) && this.extension.equals(compare.extension) && this.md5.equals(compare.md5);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.filename);
        hash = 41 * hash + Objects.hashCode(this.extension);
        hash = 41 * hash + Objects.hashCode(this.md5);
        return hash;
    }
}

