/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

public abstract class CollisionShape {
    private Type type;

    private CollisionShape(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public abstract float getData(int var1);

    public abstract int getData();

    public static CollisionShape createMeshCollisionShape() {
        return new MeshCollisionShape();
    }

    public static CollisionShape createHullCollisionShape() {
        return new HullCollisionShape();
    }

    public static CollisionShape createBoxCollisionShape(float sizeX, float sizeY, float sizeZ) {
        return new BoxCollisionShape(sizeX, sizeY, sizeZ);
    }

    public static CollisionShape createSphereCollisionShape(float radius) {
        return new SphereCollisionShape(radius);
    }

    private static class SphereCollisionShape
    extends CollisionShape {
        private float radius;

        private SphereCollisionShape(float radius) {
            super(Type.Sphere);
            this.radius = radius;
        }

        @Override
        public int getData() {
            return 1;
        }

        @Override
        public float getData(int data) {
            return this.radius;
        }
    }

    private static class BoxCollisionShape
    extends CollisionShape {
        private float sizeX;
        private float sizeY;
        private float sizeZ;

        private BoxCollisionShape(float sizeX, float sizeY, float sizeZ) {
            super(Type.Box);
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
        }

        @Override
        public int getData() {
            return 3;
        }

        @Override
        public float getData(int data) {
            if (data == 0) {
                return this.sizeX;
            }
            if (data == 1) {
                return this.sizeY;
            }
            if (data == 2) {
                return this.sizeZ;
            }
            throw new IllegalStateException("Illegal data access " + data);
        }
    }

    private static class HullCollisionShape
    extends CollisionShape {
        private HullCollisionShape() {
            super(Type.Hull);
        }

        @Override
        public int getData() {
            return 0;
        }

        @Override
        public float getData(int data) {
            return 0.0f;
        }
    }

    private static class MeshCollisionShape
    extends CollisionShape {
        private MeshCollisionShape() {
            super(Type.Mesh);
        }

        @Override
        public int getData() {
            return 0;
        }

        @Override
        public float getData(int data) {
            return 0.0f;
        }
    }

    public static enum Type {
        Mesh,
        Hull,
        Box,
        Sphere;

    }
}

