/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import commons.definitions.Items;

public interface Item {
    public String getName();

    public short getTypeID();

    public int getVariation();

    public int getStacksize();

    public int getMaxStacksize();

    public float getValue();

    public int getStatus();

    public static Definition getItemDefinition(short typeID) {
        Items.ItemDefinition def = Items.getItemDefinition((short)typeID);
        if (def != null) {
            return new Definition(def);
        }
        return null;
    }

    public static Definition getItemDefinition(String name) {
        Items.ItemDefinition def = Items.getItemDefinition((String)name);
        if (def != null) {
            return new Definition(def);
        }
        return null;
    }

    public static class Definition {
        private Items.ItemDefinition def;

        Definition(Items.ItemDefinition itemDef) {
            this.def = itemDef;
        }

        public short getTypeID() {
            return this.def.id;
        }

        public String getItemName() {
            return this.def.name;
        }

        public String getItemType() {
            return this.def.itemtype.name();
        }

        public boolean isEquipmentItem() {
            return this.def.equipmentitem;
        }

        public boolean isArmorItem() {
            return this.def.armoritem;
        }

        public int getStrength() {
            return this.def.strength;
        }

        public int getMaxStacksize() {
            return this.def.stacksize;
        }
    }
}

