/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import commons.util.Utils;
import java.io.File;
import java.util.Calendar;
import java.util.Random;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;

public class Utils {

    public static class SystemUtils {
        public static String getOperatingSystem() {
            return System.getProperty("os.name");
        }

        public static int getProcessorCores() {
            return Runtime.getRuntime().availableProcessors();
        }

        public static int getMemory() {
            return (int)(Runtime.getRuntime().maxMemory() / 1000000L);
        }

        public static String getArchitecture() {
            return System.getProperty("os.arch");
        }

        public static String getJavaVersion() {
            return System.getProperty("java.version");
        }
    }

    public static class StringUtils {
        public static boolean isInteger(String string) {
            return string != null && string.matches("[-]{0,1}[\\d]+");
        }

        public static boolean isNumeric(String string) {
            return string != null && string.matches("[-]?[\\d]+[.]?[\\d]*");
        }

        public static boolean isHex(String string) {
            return string != null && string.matches("0x[0-9A-Fa-f]+");
        }

        public static boolean isBoolean(String string) {
            return string != null && string.matches("(true)|(false)");
        }

        public static String getMd5(String string) {
            return Utils.StringUtils.getMd5((String)string);
        }
    }

    public static class ChunkUtils {
        public static Vector3i getChunkPosition(Vector3f globalPosition) {
            return ChunkUtils.getChunkPosition(globalPosition.x, globalPosition.y, globalPosition.z, new Vector3i());
        }

        public static Vector3i getChunkPosition(Vector3f globalPosition, Vector3i storeTo) {
            return ChunkUtils.getChunkPosition(globalPosition.x, globalPosition.y, globalPosition.z, storeTo);
        }

        public static Vector3i getChunkPosition(float x, float y, float z) {
            return ChunkUtils.getChunkPosition(x, y, z, new Vector3i());
        }

        public static Vector3i getChunkPosition(float x, float y, float z, Vector3i storeTo) {
            if (storeTo == null) {
                storeTo = new Vector3i();
            } else {
                storeTo.zero();
            }
            int calcx = (int)(x / 16.0f);
            int calcy = (int)(y / 64.0f);
            int calcz = (int)(z / 16.0f);
            if (x / 16.0f < 0.0f) {
                --calcx;
            }
            if (y / 64.0f < 0.0f) {
                --calcy;
            }
            if (z / 16.0f < 0.0f) {
                --calcz;
            }
            storeTo.set(calcx, calcy, calcz);
            return storeTo;
        }

        public static int getChunkPositionX(float x) {
            int cx = (int)(x / 16.0f);
            if (x / 16.0f < 0.0f) {
                --cx;
            }
            return cx;
        }

        public static int getChunkPositionY(float y) {
            int cy = (int)(y / 64.0f);
            if (y / 64.0f < 0.0f) {
                --cy;
            }
            return cy;
        }

        public static int getChunkPositionZ(float z) {
            int cz = (int)(z / 16.0f);
            if (z / 16.0f < 0.0f) {
                --cz;
            }
            return cz;
        }

        public static void getChunkAndBlockPosition(Vector3f globalPosition, Vector3i chunkPositionStore, Vector3i blockPositionStore) {
            ChunkUtils.getChunkAndBlockPosition(globalPosition.x, globalPosition.y, globalPosition.z, chunkPositionStore, blockPositionStore);
        }

        public static void getChunkAndBlockPosition(float posx, float posy, float posz, Vector3i chunkPositionStore, Vector3i blockPositionStore) {
            ChunkUtils.getChunkPosition(posx, posy, posz, chunkPositionStore);
            int calcblockx = (int)(posx / 1.0f) - chunkPositionStore.x * 16;
            int calcblocky = (int)(posy / 1.0f) - chunkPositionStore.y * 64;
            int calcblockz = (int)(posz / 1.0f) - chunkPositionStore.z * 16;
            if (posx < 0.0f) {
                --calcblockx;
            }
            if (posy < 0.0f) {
                --calcblocky;
            }
            if (posz < 0.0f) {
                --calcblockz;
            }
            if (blockPositionStore != null) {
                blockPositionStore.set(calcblockx, calcblocky, calcblockz);
            }
        }

        public static int getBlockPositionX(float x, int chunkPositionX) {
            int bx = (int)(x / 1.0f) - chunkPositionX * 16;
            if (x < 0.0f) {
                --bx;
            }
            return bx;
        }

        public static int getBlockPositionY(float y, int chunkPositionY) {
            int by = (int)(y / 1.0f) - chunkPositionY * 64;
            if (y < 0.0f) {
                --by;
            }
            return by;
        }

        public static int getBlockPositionZ(float z, int chunkPositionZ) {
            int bz = (int)(z / 1.0f) - chunkPositionZ * 16;
            if (z < 0.0f) {
                --bz;
            }
            return bz;
        }

        public static Vector3f getGlobalPosition(Vector3i chunkPosition, Vector3i blockPosition) {
            return ChunkUtils.getGlobalPosition(chunkPosition, blockPosition, new Vector3f());
        }

        public static Vector3f getGlobalPosition(Vector3i chunkPosition, Vector3i blockPosition, Vector3f storeTo) {
            if (storeTo == null) {
                storeTo = new Vector3f();
            }
            storeTo.setX(chunkPosition.x * 16 + blockPosition.x);
            storeTo.setY(chunkPosition.y * 64 + blockPosition.y);
            storeTo.setZ(chunkPosition.z * 16 + blockPosition.z);
            return storeTo;
        }
    }

    public static class GeneralUtils {
        public static int colorRGBAToInt(float r, float g, float b, float a) {
            return ((int)(r * 255.0f) & 0xFF) << 24 | ((int)(g * 255.0f) & 0xFF) << 16 | ((int)(b * 255.0f) & 0xFF) << 8 | (int)(a * 255.0f) & 0xFF;
        }

        public static float intToColorR(int color) {
            return (float)((byte)(color >> 24) & 0xFF) / 255.0f;
        }

        public static float intToColorG(int color) {
            return (float)((byte)(color >> 16) & 0xFF) / 255.0f;
        }

        public static float intToColorB(int color) {
            return (float)((byte)(color >> 8) & 0xFF) / 255.0f;
        }

        public static float intToColorA(int color) {
            return (float)((byte)color & 0xFF) / 255.0f;
        }

        public static int nextRandomColor(boolean alpha) {
            return GeneralUtils.colorRGBAToInt(MathUtils.nextRandomFloat(), MathUtils.nextRandomFloat(), MathUtils.nextRandomFloat(), alpha ? MathUtils.nextRandomFloat() : 1.0f);
        }

        public static String getFormattedTimeAndDate(long timestamp) {
            Calendar d = Calendar.getInstance();
            d.setTimeInMillis(timestamp);
            return String.format("%04d/%02d/%02d  %02d:%02d ", d.get(1), d.get(2) + 1, d.get(5), d.get(10) == 0 ? 12 : d.get(10), d.get(12)) + (d.get(9) == 0 ? "AM" : "PM");
        }
    }

    public static class ByteUtils {
        public static byte[] compress(byte[] input) {
            return Utils.ByteUtils.compress((byte[])input);
        }

        public static byte[] decompress(byte[] input) {
            return Utils.ByteUtils.decompress((byte[])input);
        }

        public static byte[] encrypt(byte[] input, String key) {
            return Utils.ByteUtils.encrypt((byte[])input, (String)key);
        }

        public static byte[] decrypt(byte[] input, String key) {
            return Utils.ByteUtils.decrypt((byte[])input, (String)key);
        }

        public int unsignedByteToInt(byte b) {
            return b & 0xFF;
        }
    }

    public static class FileUtils {
        public static boolean writeStringToFile(String text, File file) {
            return Utils.FileUtils.writeToFile((String)text, (File)file);
        }

        public static String readStringFromFile(File file) {
            return Utils.FileUtils.readFromFile((File)file);
        }

        public static boolean writeBytesToFile(byte[] bytes, File file) {
            return Utils.FileUtils.writeBytesToFile((byte[])bytes, (File)file);
        }

        public static byte[] readBytesFromFile(File file) {
            return Utils.FileUtils.readBytesFromFile((File)file);
        }

        public static String getMd5(File file) {
            return Utils.FileUtils.getMd5((File)file);
        }
    }

    public static class MathUtils {
        public static final float PI = (float)Math.PI;
        public static final float HALF_PI = 1.5707964f;
        private static final Random random = new Random(System.currentTimeMillis());

        public static float abs(float value) {
            return value < 0.0f ? -value : value;
        }

        public static int absInt(int value) {
            return value < 0 ? -value : value;
        }

        public static float sqr(float value) {
            return value * value;
        }

        public static float sqrt(float value) {
            return (float)Math.sqrt(value);
        }

        public static float degreeToRadian(float degree) {
            return (float)Math.PI / 180 * degree;
        }

        public static float radianToDegree(float radian) {
            return 57.295776f * radian;
        }

        public static float clamp(float min, float max, float value) {
            return value < min ? min : (value > max ? max : value);
        }

        public static float smoothstep(float min, float max, float value) {
            value = MathUtils.clamp((value - min) / (max - min), 0.0f, 1.0f);
            return value * value * (3.0f - 2.0f * value);
        }

        public static int getGCD(int ... input) {
            int result = input[0];
            for (int i = 1; i < input.length; ++i) {
                result = MathUtils.getGCD(result, input[i]);
            }
            return result;
        }

        public static int getGCD(int a, int b) {
            while (b > 0) {
                int temp = b;
                b = a % b;
                a = temp;
            }
            return a;
        }

        public static float round(float value, int digit) {
            digit = digit == 0 ? 1 : (digit *= 10);
            int intval = (int)(value *= (float)digit);
            float fract = value - (float)intval;
            if ((double)fract >= 0.5) {
                return (intval + 1) / digit;
            }
            return (float)intval / (float)digit;
        }

        public static float nextRandomFloat() {
            return random.nextFloat();
        }

        public static int nextRandomInt(int min, int max) {
            return (int)(random.nextFloat() * (float)(max - min) + 1.0f) + min;
        }

        public static boolean nextRandomBoolean() {
            return random.nextBoolean();
        }
    }
}

