/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.gui;

import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;
import pluginapi.manager.PluginGuiManager;

public class GuiTextField
extends GuiElement {
    private String text = "";
    private Font font = Font.Default;
    private int fontsize = 24;
    private int fontcolor = -1;
    private int backgroundpreset = 0;
    private boolean editable = true;
    private int maxcharacters = -1;
    private boolean listenforinput = false;

    public GuiTextField(float x, float y, boolean relativeposition, float width, float height, boolean relativesize) {
        super(x, y, relativeposition, width, height, relativesize);
        this.borderthickness = 6.0f;
        this.borderthicknessrelative = false;
        this.bordercolor = 255;
    }

    public void setText(String text) {
        this.text = text;
        this.updateTextField(true);
    }

    public String getDefaultText() {
        return this.text;
    }

    public void getCurrentText(Player player, Callback<String> callback) {
        PluginGuiManager.getTextFieldText((int)this.id, (Player)player, callback);
    }

    public void setFont(Font font) {
        if (this.font != font) {
            this.font = font;
            this.updateTextField(false);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFontColor(int color) {
        if (this.fontcolor != color) {
            this.fontcolor = color;
            this.updateTextField(false);
        }
    }

    public void setFontColor(float r, float g, float b, float a) {
        this.setFontColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public int getFontColor() {
        return this.fontcolor;
    }

    public void setBackgroundPreset(int preset) {
        if (this.backgroundpreset != preset) {
            this.backgroundpreset = preset;
            this.updateTextField(false);
        }
    }

    public int getBackgroundPreset() {
        return this.backgroundpreset;
    }

    public void setEditable(boolean set) {
        if (this.editable != set) {
            this.editable = set;
            this.updateTextField(false);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setMaxCharacters(int maxchars) {
        if (this.maxcharacters != maxchars) {
            this.maxcharacters = maxchars;
            this.updateTextField(false);
        }
    }

    public int getMaxCharacters() {
        return this.maxcharacters;
    }

    public void setListenForInput(boolean set) {
        if (this.listenforinput != set) {
            this.listenforinput = set;
            this.updateTextField(false);
        }
    }

    public boolean isListeningForInput() {
        return this.listenforinput;
    }

    @Override
    public void setClickable(boolean set) {
        super.setClickable(set);
    }

    @Override
    public boolean isClickable() {
        return super.isClickable();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateTextField(true);
    }

    private void updateTextField(boolean updateText) {
        PluginGuiManager.updateGuiTextField((int)this.id, (boolean)updateText, (String)(updateText ? this.text : null), (Font)this.font, (int)this.fontcolor, (int)this.backgroundpreset, (boolean)this.editable, (int)this.maxcharacters, (boolean)this.listenforinput);
    }
}

