/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.world;

import commons.world.Plant;
import commons.world.WorldElement;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public abstract class PlayerVegetationEvent
extends PlayerEvent {
    short plantid;
    int cx;
    int cy;
    int cz;
    short px;
    short py;
    short pz;
    short rx;
    short ry;
    short rz;
    boolean iscut;
    Vector3f worldPosition = null;
    Quaternion worldRotation = null;

    public PlayerVegetationEvent(Player player, Plant plant) {
        this(player, plant.plantid, plant.chunkoffsetx, plant.chunkoffsety, plant.chunkoffsetz, plant.positionx, plant.positiony, plant.positionz, plant.rotationx, plant.rotationy, plant.rotationz, plant.isCut);
    }

    public PlayerVegetationEvent(Player player, short plantid, int cx, int cy, int cz, short px, short py, short pz, short rx, short ry, short rz, boolean iscut) {
        super(player);
        this.plantid = plantid;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        this.px = px;
        this.py = py;
        this.pz = pz;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.iscut = iscut;
    }

    public short getPlantTypeID() {
        return this.plantid;
    }

    public int getChunkPositionX() {
        return this.cx;
    }

    public int getChunkPositionY() {
        return this.cy;
    }

    public int getChunkPositionZ() {
        return this.cz;
    }

    public Vector3f getPlantPosition() {
        if (this.worldPosition == null) {
            this.worldPosition = new Vector3f(WorldElement.toWorldPositionX((short)this.px, (int)this.cx), WorldElement.toWorldPositionX((short)this.py, (int)this.cy), WorldElement.toWorldPositionX((short)this.pz, (int)this.cz));
        }
        return this.worldPosition;
    }

    public float getPlantPositionX() {
        return WorldElement.toWorldPositionX((short)this.px, (int)this.cx);
    }

    public float getPlantPositionY() {
        return WorldElement.toWorldPositionX((short)this.py, (int)this.cy);
    }

    public float getPlantPositionZ() {
        return WorldElement.toWorldPositionX((short)this.pz, (int)this.cz);
    }

    public Quaternion getPlantRotation() {
        if (this.worldRotation == null) {
            this.worldRotation = new Quaternion().fromAngles(WorldElement.toWorldRotation((short)this.rx), WorldElement.toWorldRotation((short)this.ry), WorldElement.toWorldRotation((short)this.rz));
        }
        return this.worldRotation;
    }
}

