/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.data;

import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.AnimalDataBase;
import carsten.risingworld.abm.data.DemonThreadFactory;
import carsten.risingworld.abm.data.Rancher;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;

public enum UnitOfWork implements Runnable
{
    INSTANCE;

    private final Lock lock;
    private volatile boolean started;
    private final List<Animal> newAnimals;
    private final List<Animal> dirtyAnimals;
    private final List<Animal> removedAnimals;
    private final List<Rancher> newRanchers;
    private final List<Rancher> dirtyRanchers;
    private final List<Rancher> removedRanchers;
    private ScheduledThreadPoolExecutor scheduler;

    private UnitOfWork() {
        this.setStarted(false);
        this.lock = new ReentrantLock();
        this.newAnimals = new ArrayList<Animal>();
        this.dirtyAnimals = new ArrayList<Animal>();
        this.removedAnimals = new ArrayList<Animal>();
        this.newRanchers = new ArrayList<Rancher>();
        this.dirtyRanchers = new ArrayList<Rancher>();
        this.removedRanchers = new ArrayList<Rancher>();
    }

    public final void registerNew(Animal animal) {
        this.lock.lock();
        try {
            if (!this.newAnimals.contains(animal)) {
                this.newAnimals.add(animal);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void registerDirty(Animal animal) {
        this.lock.lock();
        try {
            if (!this.newAnimals.contains(animal) && !this.dirtyAnimals.contains(animal)) {
                this.dirtyAnimals.add(animal);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void registerRemoved(Animal animal) {
        this.lock.lock();
        try {
            if (!this.newAnimals.remove(animal)) {
                this.dirtyAnimals.remove(animal);
                if (!this.removedAnimals.contains(animal)) {
                    this.removedAnimals.add(animal);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void registerNew(Rancher rancher) {
        this.lock.lock();
        try {
            if (!this.newRanchers.contains(rancher)) {
                this.newRanchers.add(rancher);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void registerDirty(Rancher rancher) {
        this.lock.lock();
        try {
            if (!this.newRanchers.contains(rancher) && !this.dirtyRanchers.contains(rancher)) {
                this.dirtyRanchers.add(rancher);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void registerRemoved(Rancher rancher) {
        this.lock.lock();
        try {
            if (!this.newRanchers.remove(rancher)) {
                this.dirtyRanchers.remove(rancher);
                if (!this.removedRanchers.contains(rancher)) {
                    this.removedRanchers.add(rancher);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void commit() {
        this.lock.lock();
        try {
            AnimalDataBase.INSTANCE.insertAnimals(this.newAnimals);
            AnimalDataBase.INSTANCE.updateAnimals(this.dirtyAnimals);
            AnimalDataBase.INSTANCE.deleteAnimals(this.removedAnimals);
            AnimalDataBase.INSTANCE.insertRanchers(this.newRanchers);
            AnimalDataBase.INSTANCE.updateRanchers(this.dirtyRanchers);
            AnimalDataBase.INSTANCE.deleteRanchers(this.removedRanchers);
            this.newAnimals.clear();
            this.dirtyAnimals.clear();
            this.removedAnimals.clear();
            this.newRanchers.clear();
            this.dirtyRanchers.clear();
            this.removedRanchers.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        this.commit();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private void setStarted(boolean p_started) {
        this.started = p_started;
    }

    public final boolean isStarted() {
        return this.started;
    }

    public final void start() {
        this.lock.lock();
        try {
            if (!this.isStarted()) {
                this.scheduler = new ScheduledThreadPoolExecutor(1, new DemonThreadFactory(5, true, this.toString() + "-Scheduler"));
                this.scheduler.scheduleAtFixedRate(this, 10L, 10L, TimeUnit.SECONDS);
                this.setStarted(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @PreDestroy
    public final void stop() {
        this.lock.lock();
        try {
            if (this.isStarted()) {
                while (!this.scheduler.isShutdown()) {
                    this.scheduler.shutdown();
                }
                this.setStarted(false);
            }
            this.commit();
            this.scheduler = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

