/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.data;

import carsten.risingworld.abm.data.AnimalDataBase;
import carsten.risingworld.abm.data.Rancher;
import carsten.risingworld.abm.data.UnitOfWork;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;

public class RancherMap {
    private static final Map<Integer, Rancher> ranchers = new HashMap<Integer, Rancher>();

    public static void loadAll() {
        List<Rancher> list = AnimalDataBase.INSTANCE.selectRanchers();
        for (Rancher rancher : list) {
            if (ranchers.containsKey(rancher.getPlayerId())) continue;
            RancherMap.add(rancher);
        }
    }

    private static Rancher load(int playerId) {
        Rancher rancher = AnimalDataBase.INSTANCE.selectRancher(playerId);
        if (rancher == Rancher.NULL) {
            rancher = new Rancher(playerId);
            UnitOfWork.INSTANCE.registerNew(rancher);
        }
        return rancher;
    }

    private static void add(Rancher rancher) {
        int playerId = rancher.getPlayerId();
        if (!ranchers.containsKey(playerId)) {
            ranchers.put(playerId, rancher);
        }
    }

    public static Rancher get(int playerId) {
        if (!ranchers.containsKey(playerId)) {
            RancherMap.add(RancherMap.load(playerId));
        }
        return ranchers.get(playerId);
    }

    public static void remove(Rancher rancher) {
        ranchers.remove(rancher.getPlayerId());
    }

    private RancherMap() {
    }

    @PreDestroy
    public static void clearAll() {
        for (Rancher rancher : ranchers.values()) {
            rancher.clear();
        }
        ranchers.clear();
    }
}

