/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.action;

import carsten.risingworld.abm.action.Action;
import carsten.risingworld.abm.action.AnimalInteraction;
import carsten.risingworld.abm.action.FeedAction;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class InteractionItem {
    private static final String APPLE = "apple";
    private static final String BACONCOOKED = "baconcooked";
    private static final String BEEFSTEAKRAW = "beefsteakraw";
    private static final String CARROT = "carrot";
    private static final String CHERRY = "cherry";
    private static final String CHILIPEPPER = "chilipepper";
    private static final String CORNCOB = "corncob";
    private static final String GOLDINGOT = "goldingot";
    private static final String LEMON = "lemon";
    private static final String LUMBER = "lumber";
    private static final String MITHRILINGOT = "mithrilingot";
    private static final String PAPER = "paper";
    private static final String POTATO = "potato";
    private static final String PUMPKINSEED = "pumpkinseed";
    private static final String RIBSRAW = "ribsraw";
    private static final String ROLLINGPIN = "rollingpin";
    private static final String SAPLINGSPRUCE = "saplingspruce";
    private static final String SUGARBEET = "sugarbeet";
    private static final String WATERMELON = "watermelon";
    private static final String WATERMELONPIECE = "watermelonpiece";
    private static final String WATERMELONSEED = "watermelonseed";
    private static final Map<String, AnimalInteraction> itemToActionMapping = new LinkedHashMap<String, AnimalInteraction>();

    private static void registerItemAction(String itemName, AnimalInteraction action) {
        itemToActionMapping.put(itemName, action);
    }

    public static AnimalInteraction getAction(String itemName) {
        return itemToActionMapping.getOrDefault(itemName, Action.NOOP);
    }

    public static Set<String> getItems() {
        return itemToActionMapping.keySet();
    }

    static {
        InteractionItem.registerItemAction(CORNCOB, FeedAction.PIG);
        InteractionItem.registerItemAction(CARROT, FeedAction.COW);
        InteractionItem.registerItemAction(SAPLINGSPRUCE, FeedAction.GOAT);
        InteractionItem.registerItemAction(SUGARBEET, FeedAction.SHEEP);
        InteractionItem.registerItemAction(CHERRY, FeedAction.BEAR);
        InteractionItem.registerItemAction(WATERMELONSEED, FeedAction.CHICKEN);
        InteractionItem.registerItemAction(PUMPKINSEED, FeedAction.CHICKEN);
        InteractionItem.registerItemAction(CHILIPEPPER, FeedAction.CHICKEN);
        InteractionItem.registerItemAction(APPLE, FeedAction.ELEPHANT);
        InteractionItem.registerItemAction(BEEFSTEAKRAW, FeedAction.JAGUAR);
        InteractionItem.registerItemAction(RIBSRAW, FeedAction.TIGER);
        InteractionItem.registerItemAction(WATERMELONPIECE, FeedAction.MINIPIG);
        InteractionItem.registerItemAction(BACONCOOKED, FeedAction.RAT);
        InteractionItem.registerItemAction(POTATO, FeedAction.OTHER);
        InteractionItem.registerItemAction(LEMON, FeedAction.OTHER);
        InteractionItem.registerItemAction(WATERMELON, FeedAction.OTHER);
        InteractionItem.registerItemAction(ROLLINGPIN, Action.FOLLOW);
        InteractionItem.registerItemAction(PAPER, Action.RENAME);
    }
}

