/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.data;

import javax.annotation.PreDestroy;
import net.risingworld.api.objects.Npc;

public class Animal {
    private static int OBJID = 0;
    public static final Animal NULL = new Animal(-1);
    private final int id = OBJID++;
    private int npcId;
    private String npcName;
    private int playerId;
    private boolean offspring;
    private boolean prolific;
    private int pregnancyProgress;
    private int feedCount;
    private Npc npc;

    public Animal(int npcId) {
        this(npcId, "", -1, false, false, 0);
    }

    public Animal(int p_npcId, String p_npcName, int p_playerId, boolean p_offspring, boolean p_prolific, int p_pregnancyProgress) {
        this.npcId = p_npcId;
        this.npcName = p_npcName;
        this.playerId = p_playerId;
        this.offspring = p_offspring;
        this.prolific = p_prolific;
        this.pregnancyProgress = p_pregnancyProgress;
    }

    public int getNpcId() {
        return this.npcId;
    }

    public String getNpcName() {
        return this.npcName;
    }

    public void setNpcName(String p_npcName) {
        this.npcName = p_npcName;
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(int p_playerId) {
        this.playerId = p_playerId;
        if (this.playerId < 0) {
            this.playerId = -1;
        }
    }

    public boolean isOffspring() {
        return this.offspring;
    }

    public void setOffspring() {
        this.offspring = true;
    }

    public boolean isProlific() {
        return this.prolific;
    }

    public void setProlific(boolean p_prolific) {
        this.prolific = p_prolific;
    }

    public int getPregnancyProgress() {
        return this.pregnancyProgress;
    }

    public void setPregnancyProgress(int p_pregnancyProgress) {
        this.pregnancyProgress = p_pregnancyProgress;
    }

    public void resetFeedCount() {
        this.feedCount = 0;
    }

    public void incFeedCount() {
        ++this.feedCount;
    }

    public int getFeedCount() {
        return this.feedCount;
    }

    public boolean isOwnedByPlayer(int playerId) {
        return this.getPlayerId() == playerId;
    }

    public boolean isOwned() {
        return this.getPlayerId() > 0;
    }

    public boolean isPregnant() {
        return this.pregnancyProgress > 0;
    }

    void setNpc(Npc p_npc) {
        this.npc = p_npc;
    }

    public Npc getNpc() {
        return this.npc;
    }

    @PreDestroy
    void clear() {
        this.npc = null;
    }

    public String toString() {
        return "Animal[id=" + this.id + ", npcId=" + this.getNpcId() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Animal) {
            Animal anotherAnimal = (Animal)obj;
            return this.getNpcId() == anotherAnimal.getNpcId();
        }
        return false;
    }
}

