/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.action;

import carsten.risingworld.abm.action.ActionDelegate;
import carsten.risingworld.abm.action.DeniableAnimalInteraction;
import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.AnimalType;
import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;

public enum FeedAction implements DeniableAnimalInteraction
{
    PIG(1, 5.0f),
    COW(2, 5.0f),
    GOAT(3, 5.0f),
    SHEEP(4, 5.0f),
    BEAR(7, 8.0f),
    CHICKEN(10, 3.0f),
    ELEPHANT(11, 10.0f),
    JAGUAR(14, 8.0f),
    TIGER(17, 8.0f),
    MINIPIG(19, 8.0f),
    RAT(23, 10.0f),
    OTHER(0, 10.0f);

    private static final List<Integer> npcTypes;
    private final int npcType;
    private final float maxDistance;
    private ActionDelegate execDelegate;
    private ActionDelegate denyDelegate;

    private FeedAction(int p_npcType, float p_maxDistance) {
        this.npcType = p_npcType;
        this.maxDistance = p_maxDistance;
        this.denyDelegate = this.execDelegate = (player, animal) -> {};
    }

    @Override
    public void setDelegates(ActionDelegate p_execDelegate, ActionDelegate p_denyDelegate) {
        this.execDelegate = p_execDelegate;
        this.denyDelegate = p_denyDelegate;
    }

    @Override
    public float getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public void execute(Player player, Animal animal) {
        Npc npc = animal.getNpc();
        if (npc == null) {
            return;
        }
        if (!this.isInRange(player, npc)) {
            return;
        }
        if (this.npcType == AnimalType.filterNpcType(npc.getTypeID()) || this == OTHER && !npcTypes.contains(npc.getTypeID())) {
            this.execDelegate.action(player, animal);
        } else {
            this.denyDelegate.action(player, animal);
        }
    }

    @Override
    public String actionName() {
        return "action.feed." + this.name();
    }

    static {
        npcTypes = new ArrayList<Integer>(25);
        for (FeedAction action : FeedAction.values()) {
            if (action == OTHER) continue;
            npcTypes.add(action.npcType);
        }
    }
}

