/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm;

import carsten.risingworld.abm.ABMResourceBundle;
import carsten.risingworld.abm.AnimalController;
import carsten.risingworld.abm.action.Action;
import carsten.risingworld.abm.action.AnimalInteraction;
import carsten.risingworld.abm.action.FeedAction;
import carsten.risingworld.abm.action.InteractionItem;
import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.AnimalMap;
import carsten.risingworld.abm.data.AnimalType;
import carsten.risingworld.abm.event.AnimalBornEvent;
import carsten.risingworld.abm.event.AnimalFollowEvent;
import carsten.risingworld.abm.event.AnimalOwnerChangedEvent;
import carsten.risingworld.abm.event.AnimalPregnantEvent;
import carsten.risingworld.abm.event.AnimalProlificEvent;
import carsten.risingworld.abm.event.AnimalRenamedEvent;
import carsten.risingworld.abm.event.AnimalSleepEvent;
import carsten.risingworld.abm.event.PlayerAnimalLimitReachedEvent;
import carsten.risingworld.abm.util.FW;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.events.Event;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.gui.PlayerGuiInputEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.GuiTextField;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.RayCastResult;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DText;
import net.risingworld.api.worldelements.WorldElement;

public class AnimalBreedMaster
extends Plugin
implements Listener {
    private static final float VERSION = 0.11f;
    private static final String SEP = FileSystems.getDefault().getSeparator();
    private static final String ABM_PREFS = "AnimalBreedMaster.prefs";
    private static final String EXT = ".xml";
    private static final String PROP_MAX_ANIMALS = "max_animals_per_player";
    private static final int FEED_TIMER_SCALER;
    private static final int BREED_TIMER_SCALER;
    private static final int GENERAL_TIMER_SCALER_1;
    private static final float INTERVALL;
    private static final int COLLISIONTYPES = 249;
    private static final Map<Player, CallbackRayCastResult> playerCallbackResultMap;
    private static final int NUM_FEED_OWN = 4;
    private static final int NUM_FEED_PROLIFIC = 3;
    private static final int MIN_PREG_TIME = 2500;
    private static final int PROGRESS_INTERVAL = 10;
    private static final int GENERAL_INTERVAL_1 = 30;
    private static final int FEED_PROGRESS_BONUS_TIME = 100;
    private final Runnable timerTask_FP = this::timerTask;
    private final Properties settings = new Properties();
    private Timer actionTimer;
    private int feedTimerLoop;
    private int breedTimerLoop;
    private int generalTimerLoop1;
    private int maxOwnableAnimals;

    public AnimalBreedMaster() {
        AnimalMap.setNpcFetcher(this::getNpc);
        Action.FOLLOW.setDelegate(this::tagAnimalToFollowAction);
        Action.RENAME.setDelegate(this::tagAnimalToRenameAction);
        for (FeedAction action : FeedAction.values()) {
            action.setDelegates(this::feedAction, this::noThanks);
        }
    }

    public void onEnable() {
        this.loadSettings();
        this.initController();
        this.registerEventListener(this);
        if (this.actionTimer != null) {
            this.actionTimer.kill();
        }
        this.actionTimer = new Timer(INTERVALL, 1.0f, -1, this.timerTask_FP);
        this.actionTimer.start();
    }

    public void onDisable() {
        this.actionTimer.kill();
        this.unregisterEventListener(this);
        AnimalController.disable();
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerConnectEvent(PlayerConnectEvent evt) {
        Player player = evt.getPlayer();
        AnimalBreedMaster.initBundle(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent evt) {
        Player player = evt.getPlayer();
        player.deleteAttribute("abm_raycast_lastitem");
        AnimalBreedMaster.removeBundle(player);
        AnimalBreedMaster.removeGui(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerSpawnEvent(PlayerSpawnEvent evt) {
        Player player = evt.getPlayer();
        AnimalBreedMaster.loadAnimals(player.getDbID());
        AnimalController.updateRancherName(player);
        AnimalBreedMaster.initGui(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerGuiInputEvent(PlayerGuiInputEvent evt) {
        Player player = evt.getPlayer();
        GuiPanel panel = (GuiPanel)player.getAttribute("abm_rename_panel");
        GuiTextField field = (GuiTextField)player.getAttribute("abm_rename_input");
        if (field != evt.getGuiElement()) {
            return;
        }
        field.setListenForInput(false);
        panel.setVisible(false);
        player.setMouseCursorVisible(false);
        this.renameAnimal(player, AnimalController.getRenameTaggedAnimal(player), evt.getInput());
        AnimalController.resetRenameTaggedAnimal(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerAnimalLimitReachedEvent(PlayerAnimalLimitReachedEvent evt) {
        Player player = evt.getPlayer();
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        player.sendTextMessage("[#ffff00]" + evt.getMessage() + ": " + AnimalBreedMaster.getVal(bundle, "owner.limit") + " (" + this.getMaxOwnableAnimals() + ")");
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalRenamedEvent(AnimalRenamedEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        player.sendTextMessage("[#7fff00]" + AnimalBreedMaster.getVal(bundle, "rename.old") + evt.getOldName() + " [#ffff00]" + AnimalBreedMaster.getVal(bundle, "rename.new") + animal.getNpcName());
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalBornEvent(AnimalBornEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        player.playGameSound("fireworks_explosion", player.getPosition());
        player.playGameSound("fireworks_explosion", animal.getNpc().getPosition());
        player.playGameSound("fireworks_explosion", player.getPosition());
        player.playGameSound("fireworks_explosion", animal.getNpc().getPosition());
        player.sendTextMessage("[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + AnimalBreedMaster.getVal(bundle, "birth.ok"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalProlificEvent(AnimalProlificEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        player.sendTextMessage("[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + AnimalBreedMaster.getVal(bundle, "prolific"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalPregnantEvent(AnimalPregnantEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        player.sendTextMessage("[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + AnimalBreedMaster.getVal(bundle, "pregnant"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalOwnerChangedEvent(AnimalOwnerChangedEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        player.sendTextMessage("[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + AnimalBreedMaster.getVal(bundle, "owner.new"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalFollowEvent(AnimalFollowEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String name = AnimalBreedMaster.getNameOrDefault(player, animal);
        if (evt.getMode().equals("start")) {
            player.sendTextMessage("[#7fff00]" + name + AnimalBreedMaster.getVal(bundle, "following.start"));
        } else {
            player.sendTextMessage("[#ffff00]" + name + AnimalBreedMaster.getVal(bundle, "following.stop"));
        }
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalSleepEvent(AnimalSleepEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        String name = AnimalBreedMaster.getNameOrDefault(player, animal);
        player.sendTextMessage("[#ffff00]" + name + ": ...zzzzz zzzzz");
    }

    private void timerTask() {
        ++this.feedTimerLoop;
        if ((float)this.feedTimerLoop % ((float)FEED_TIMER_SCALER / this.actionTimer.getInterval()) == 0.0f) {
            this.feedTimerLoop = 0;
        }
        ++this.breedTimerLoop;
        if ((float)this.breedTimerLoop % ((float)BREED_TIMER_SCALER / this.actionTimer.getInterval()) == 0.0f) {
            this.breedTimerLoop = 0;
        }
        ++this.generalTimerLoop1;
        if ((float)this.generalTimerLoop1 % ((float)GENERAL_TIMER_SCALER_1 / this.actionTimer.getInterval()) == 0.0f) {
            this.generalTimerLoop1 = 0;
        }
        this.executeForEachPlayer();
        this.raycastPlayerToNpc();
        this.removeDeadAnimals();
    }

    private void processAction(Player player, Animal animal) {
        Item item = player.getEquippedItem();
        if (item == null) {
            return;
        }
        Item lastItem = (Item)player.getAttribute("abm_raycast_lastitem");
        if (lastItem != item) {
            player.setAttribute("abm_raycast_idle", (Object)true);
        }
        player.setAttribute("abm_raycast_lastitem", (Object)item);
        AnimalInteraction action = InteractionItem.getAction(item.getName());
        if (action instanceof Action) {
            action.execute(player, animal);
            player.setAttribute("abm_raycast_idle", (Object)true);
            return;
        }
        if (this.feedTimerLoop > 0) {
            return;
        }
        if (action instanceof FeedAction) {
            action.execute(player, animal);
        }
    }

    private void tagAnimalToFollowAction(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        boolean wasIdle = (Boolean)player.getAttribute("abm_raycast_idle");
        if (wasIdle) {
            Animal taggedAnimal = AnimalController.getFollowingTaggedAnimal(player);
            if (animal.getNpc().isSleeping()) {
                this.triggerEvent((Event)new AnimalSleepEvent(player, animal));
            } else if (taggedAnimal == Animal.NULL) {
                AnimalController.setFollowingTaggedAnimal(player, animal);
                this.triggerEvent((Event)new AnimalFollowEvent(player, animal, "start"));
            } else if (taggedAnimal == animal) {
                AnimalController.resetFollowingTaggedAnimal(player);
                Npc npc = animal.getNpc();
                npc.moveTo(new Vector3f(npc.getPosition()));
                this.triggerEvent((Event)new AnimalFollowEvent(player, animal, "stop"));
            }
        }
    }

    private void tagAnimalToRenameAction(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        boolean wasIdle = (Boolean)player.getAttribute("abm_raycast_idle");
        if (!wasIdle) {
            return;
        }
        if (AnimalController.getRenameTaggedAnimal(player) != Animal.NULL) {
            return;
        }
        AnimalController.setRenameTaggedAnimal(player, animal);
        GuiPanel panel = (GuiPanel)player.getAttribute("abm_rename_panel");
        GuiTextField field = (GuiTextField)player.getAttribute("abm_rename_input");
        if (panel == null || field == null) {
            return;
        }
        if (panel.isVisible()) {
            return;
        }
        field.setListenForInput(true);
        panel.setVisible(true);
        field.setText(AnimalBreedMaster.getNameOrDefault(player, animal));
        player.setMouseCursorVisible(true);
    }

    private void feedAction(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        Npc npc = animal.getNpc();
        if (npc.isSleeping()) {
            this.triggerEvent((Event)new AnimalSleepEvent(player, animal));
            return;
        }
        Inventory inv = player.getInventory();
        byte slot = inv.getQuickslotFocus();
        inv.removeItem((int)slot, Inventory.SlotType.Quickslot, 1);
        int hunger = npc.getHunger() + 5;
        if (hunger > 100) {
            hunger = 100;
        }
        npc.setHunger(hunger);
        int health = npc.getHealth() + 10;
        if (health > 100) {
            health = 100;
        }
        npc.setHealth(health);
        player.playGameSound("player_eat_carrot", npc.getPosition());
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String msg = "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + AnimalBreedMaster.getVal(bundle, "feeding.yum");
        if (animal.isOwnedByPlayer(player.getDbID())) {
            msg = msg + " [#7fff00]" + AnimalBreedMaster.getVal(bundle, "feeding.thx") + player.getName() + "!";
        }
        player.sendTextMessage(msg);
        animal.incFeedCount();
        if (!animal.isOwned()) {
            if (animal.getFeedCount() > 4) {
                this.changeOwner(player, animal);
            }
        } else if (animal.isOwnedByPlayer(player.getDbID()) && !animal.isProlific()) {
            if (!animal.isPregnant()) {
                if (animal.getFeedCount() > 3) {
                    AnimalController.updateProlific(animal, true);
                    this.triggerEvent((Event)new AnimalProlificEvent(player, animal));
                }
            } else {
                int pregnancyProgress = animal.getPregnancyProgress() + 100;
                AnimalController.updatePregnancyProgress(animal, pregnancyProgress);
            }
        }
    }

    private void noThanks(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String msg = "[#ffff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + AnimalBreedMaster.getVal(bundle, "feeding.nothx");
        player.sendTextMessage(msg);
    }

    private void executeForEachPlayer() {
        for (Player player : this.getServer().getAllPlayers()) {
            this.showNameAction(player, AnimalController.getFollowingTaggedAnimal(player));
            this.followPlayer(player);
            if (this.breedTimerLoop != 0) continue;
            this.procreation(player);
            this.updatePregnancyProgress(player);
        }
    }

    private void followPlayer(Player player) {
        Animal animal = AnimalController.getFollowingTaggedAnimal(player);
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        Npc npc = animal.getNpc();
        if (npc.isSleeping()) {
            AnimalController.resetFollowingTaggedAnimal(player);
            return;
        }
        float distance = npc.getPosition().distance(player.getPosition());
        Vector3f pos = new Vector3f(npc.getPosition()).subtractLocal(player.getPosition()).normalizeLocal().multLocal(4.0f).addLocal(player.getPosition());
        npc.setAlerted(false);
        if (distance > Action.FOLLOW.getMaxDistance()) {
            npc.setPosition(pos);
        } else if (distance > 10.0f) {
            npc.setAlerted(true, 1);
            npc.moveTo(pos);
        } else if (distance > 5.0f) {
            npc.moveTo(pos);
        }
    }

    private CallbackRayCastResult getPlayerCallbackResult(Player player) {
        return playerCallbackResultMap.computeIfAbsent(player, x$0 -> new CallbackRayCastResult((Player)x$0));
    }

    private void raycastPlayerToNpc() {
        for (Player player : this.getServer().getAllPlayers()) {
            player.raycast(249, (Callback)this.getPlayerCallbackResult(player));
        }
    }

    private void removeDeadAnimals() {
        if (this.generalTimerLoop1 != 0) {
            return;
        }
        AnimalController.removeAnimalsWithoutNpc();
    }

    private void showNameAction(Player player, Animal animal) {
        World3DText text = (World3DText)player.getAttribute("abm_3d_label");
        if (text == null) {
            return;
        }
        player.removeWorldElement((WorldElement)text);
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        Npc npc = animal.getNpc();
        float distance = npc.getPosition().distance(player.getPosition());
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String t = AnimalBreedMaster.getNameOrDefault(player, animal);
        if (animal.isPregnant()) {
            t = t + "\n" + AnimalBreedMaster.getVal(bundle, "label.pregnant");
        }
        if (!animal.isOwned()) {
            text.setFontColor(-65281);
        } else if (animal.isOwnedByPlayer(player.getDbID())) {
            text.setFontColor(0xFF00FF);
        } else {
            text.setFontColor(0x7F7FFFFF);
        }
        float s = (float)((double)distance / (1.0 - 1.0 / Math.exp((double)distance / Math.E)));
        text.setFontsize((int)s);
        text.setText(t);
        float y = 2.0f;
        Vector3f v = new Vector3f(npc.getPosition()).addLocal(0.0f, y, 0.0f);
        text.setPosition(v);
        if (distance < 70.0f) {
            player.addWorldElement((WorldElement)text);
        }
    }

    private void procreation(Player player) {
        Map<Integer, List<Animal>> prolificMap = AnimalController.getProlificAnimals(player.getDbID());
        for (int npcType : prolificMap.keySet()) {
            ArrayList list = new ArrayList(prolificMap.get(npcType));
            if (list.size() < 2) continue;
            list.sort((a1, a2) -> this.sortByDistance((Animal)a1, (Animal)a2, player));
            Animal partner1 = (Animal)list.get(0);
            Animal partner2 = (Animal)list.get(1);
            AnimalController.updateProlific(partner1, false);
            AnimalController.updateProlific(partner2, false);
            AnimalController.updatePregnancyProgress(partner1, 1);
            this.triggerEvent((Event)new AnimalPregnantEvent(player, partner1));
        }
    }

    private int sortByDistance(Animal a1, Animal a2, Player player) {
        Npc n1 = a1.getNpc();
        Npc n2 = a2.getNpc();
        if (n1 == null || n2 == null) {
            return 0;
        }
        float distance1 = player.getPosition().distance(n1.getPosition());
        float distance2 = player.getPosition().distance(n2.getPosition());
        return Float.compare(distance1, distance2);
    }

    private void updatePregnancyProgress(Player player) {
        List<Animal> list = AnimalBreedMaster.loadAnimals(player.getDbID());
        Animal p = null;
        for (Animal animal : list) {
            int pregnancyProgress = animal.getPregnancyProgress();
            if (pregnancyProgress > 0) {
                pregnancyProgress += 10;
            }
            if (pregnancyProgress > 2500) {
                pregnancyProgress = 0;
                p = animal;
            }
            AnimalController.updatePregnancyProgress(animal, pregnancyProgress);
        }
        this.giveBirth(player, p);
    }

    private void giveBirth(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        List<Animal> list = AnimalBreedMaster.loadAnimals(player.getDbID());
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        if (list.size() < this.getMaxOwnableAnimals()) {
            this.spawnNpc(player, animal);
        } else {
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(player, AnimalBreedMaster.getVal(bundle, "birth.fail")));
        }
    }

    private void spawnNpc(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        AnimalController.updatePregnancyProgress(animal, 0);
        Npc npc = animal.getNpc();
        Vector3f pos = new Vector3f(npc.getPosition()).addLocal(npc.getViewDirection().multLocal(2.0f));
        Quaternion q = new Quaternion();
        q.lookAt(npc.getViewDirection());
        Npc newNpc = this.getWorld().spawnNpc((short)AnimalType.filterNpcType(npc.getTypeID()), new Vector3f(pos), q);
        newNpc.setName(AnimalBreedMaster.getNameOrDefault(player, newNpc));
        Animal newAnimal = AnimalController.newAnimal(player, newNpc);
        AnimalController.increaseOffspringCounter(player);
        this.triggerEvent((Event)new AnimalBornEvent(player, newAnimal));
        this.changeOwner(player, newAnimal);
    }

    private static String getNameOrDefault(Player player, Animal animal) {
        if (animal == null) {
            return "";
        }
        return AnimalBreedMaster.getNameOrDefault(player, animal.getNpc());
    }

    private static String getNameOrDefault(Player player, Npc npc) {
        if (npc == null) {
            return "";
        }
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String name = npc.getName();
        if (name.length() <= 0) {
            name = AnimalBreedMaster.getVal(bundle, "animal." + AnimalType.name(npc.getTypeID())) + " " + npc.getGlobalID();
        }
        return name;
    }

    private int getMaxOwnableAnimals() {
        return this.maxOwnableAnimals;
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerCommand(PlayerCommandEvent evt) {
        Player admin = evt.getPlayer();
        if (!admin.isAdmin()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() < 2) {
            return;
        }
        String cmd = st.nextToken();
        if (!"abm".equals(cmd)) {
            return;
        }
        switch (cmd = st.nextToken()) {
            case "help": {
                this.printHelp(admin);
                if (st.countTokens() <= 0 || !st.nextToken().equals("write")) break;
                this.writeHelp(admin);
                break;
            }
            case "lang": {
                if (st.countTokens() <= 0) break;
                String lang = st.nextToken();
                ResourceBundle bundle = ResourceBundle.getBundle(ABMResourceBundle.class.getName(), new Locale(lang));
                AnimalBreedMaster.removeBundle(admin);
                admin.setAttribute("abm_bundle", (Object)bundle);
                break;
            }
            case "load": {
                if (st.countTokens() <= 0) break;
                int playerId = AnimalBreedMaster.getInteger(st.nextToken());
                AnimalBreedMaster.printAnimals(playerId, admin);
                break;
            }
            case "erase": {
                if (st.countTokens() <= 0) break;
                int playerId = AnimalBreedMaster.getInteger(st.nextToken());
                AnimalController.deleteAllAnimalsFromPlayer(playerId);
                break;
            }
            case "changeowner": {
                if (st.countTokens() <= 1) break;
                int playerId1 = AnimalBreedMaster.getInteger(st.nextToken());
                int playerId2 = AnimalBreedMaster.getInteger(st.nextToken());
                this.changeOwnerAllAnimals(admin, playerId1, playerId2);
                break;
            }
            case "procreation": {
                this.procreation(admin);
                break;
            }
        }
    }

    private Npc getNpc(int npcId) {
        return this.getWorld().getNpc(npcId);
    }

    private static List<Animal> loadAnimals(int loadPlayerId) {
        return AnimalController.getPlayersAnimals(loadPlayerId);
    }

    private static int countAnimals(int playerId) {
        return AnimalBreedMaster.loadAnimals(playerId).size();
    }

    private static void printAnimals(int loadPlayerId, Player admin) {
        List<Animal> list = AnimalBreedMaster.loadAnimals(loadPlayerId);
        for (Animal animal : list) {
            admin.sendTextMessage("[#7fff00] P:" + animal.getPlayerId() + " N: " + animal.getNpcName() + " (" + animal.getNpcId() + ")");
        }
    }

    private void renameAnimal(Player player, Animal animal, String p_newName) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        String oldName = animal.getNpcName();
        String newName = p_newName;
        if (newName == null || newName.equals("")) {
            newName = AnimalBreedMaster.getNameOrDefault(player, animal.getNpc());
        }
        AnimalController.updateAnimalName(animal, newName);
        this.triggerEvent((Event)new AnimalRenamedEvent(player, animal, oldName));
    }

    private void changeOwner(Player player, Animal animal) {
        if (AnimalBreedMaster.countAnimals(player.getDbID()) < this.getMaxOwnableAnimals()) {
            AnimalController.updatePlayerId(animal, player.getDbID());
            AnimalController.updateAnimalName(animal, animal.getNpc().getName());
            this.triggerEvent((Event)new AnimalOwnerChangedEvent(player, animal));
        } else {
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(player, AnimalBreedMaster.getPlayerBundle(player).getString("owner.fail")));
        }
    }

    private void changeOwnerAllAnimals(Player admin, int oldPlayerId, int newPlayerId) {
        ArrayList<Animal> copy = new ArrayList<Animal>(AnimalBreedMaster.loadAnimals(oldPlayerId));
        for (Animal animal : copy) {
            if (AnimalBreedMaster.countAnimals(newPlayerId) < this.getMaxOwnableAnimals()) {
                String txt = "[#ffff00] Animal:" + animal.getNpcId() + " Old Player:" + animal.getPlayerId();
                AnimalController.updatePlayerId(animal, newPlayerId);
                admin.sendTextMessage(txt + " New Player:" + animal.getPlayerId());
                continue;
            }
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(admin, AnimalBreedMaster.getPlayerBundle(admin).getString("owner.fail")));
        }
    }

    private void printItemInteraction(Player player) {
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        for (String itemName : InteractionItem.getItems()) {
            player.sendTextMessage("* [#ffff00]" + AnimalBreedMaster.getVal(bundle, "item." + itemName) + ": " + AnimalBreedMaster.getVal(bundle, InteractionItem.getAction(itemName).actionName()));
        }
    }

    private void printHelp(Player player) {
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        player.sendTextMessage("");
        player.sendTextMessage("");
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage(AnimalBreedMaster.getVal(bundle, "help.title"));
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage("* ");
        player.sendTextMessage("* " + AnimalBreedMaster.getVal(bundle, "help.descr.line1"));
        player.sendTextMessage("* " + AnimalBreedMaster.getVal(bundle, "help.descr.line2"));
        player.sendTextMessage("* ");
        player.sendTextMessage("* [#7fff00]" + AnimalBreedMaster.getVal(bundle, "help.itemlist.head"));
        this.printItemInteraction(player);
        player.sendTextMessage("* ");
        player.sendTextMessage("* " + AnimalBreedMaster.getVal(bundle, "help.readme"));
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage("");
        player.sendTextMessage("" + AnimalBreedMaster.getVal(bundle, "help.scrollinfo"));
        player.sendTextMessage("");
    }

    private void writeHelp(Player player) {
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        FW.defFilepath = this.getPath() + SEP + "readme_" + bundle.getLocale().getLanguage() + ".txt";
        new File(FW.defFilepath).delete();
        FW.writeToFile("*************************************************************************");
        FW.writeToFile(AnimalBreedMaster.getVal(bundle, "help.title"));
        FW.writeToFile("*************************************************************************");
        FW.writeToFile("");
        FW.writeToFile(AnimalBreedMaster.getVal(bundle, "help.descr.line1"));
        FW.writeToFile(AnimalBreedMaster.getVal(bundle, "help.descr.line2"));
        FW.writeToFile("");
        FW.writeToFile(AnimalBreedMaster.getVal(bundle, "help.itemlist.head"));
        FW.writeToFile("***********************************");
        for (String itemName : InteractionItem.getItems()) {
            player.sendTextMessage("* [#ffff00]" + AnimalBreedMaster.getVal(bundle, "item." + itemName) + ": " + AnimalBreedMaster.getVal(bundle, InteractionItem.getAction(itemName).actionName()));
            FW.writeToFile("" + AnimalBreedMaster.getVal(bundle, "item." + itemName) + ": " + AnimalBreedMaster.getVal(bundle, InteractionItem.getAction(itemName).actionName()));
        }
    }

    private static String getVal(ResourceBundle bundle, String key) {
        String value;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException npe) {
            value = "(" + key + ": TRANSLATION MISSING)";
        }
        return value;
    }

    private void initController() {
        File dataFile = new File(this.getPath() + SEP + "data" + SEP + "abm_" + this.getWorld().getName() + ".db");
        AnimalController.enable(this.getSQLiteConnection(dataFile.getAbsolutePath()), 0.11f, this.getWorld().getSeed());
    }

    private static ResourceBundle getPlayerBundle(Player player) {
        ResourceBundle bundle = (ResourceBundle)player.getAttribute("abm_bundle");
        if (bundle == null) {
            bundle = AnimalBreedMaster.initBundle(player);
        }
        return bundle;
    }

    private static ResourceBundle initBundle(Player player) {
        ResourceBundle bundle = ResourceBundle.getBundle(ABMResourceBundle.class.getName(), new Locale(player.getLanguage()));
        player.setAttribute("abm_bundle", (Object)bundle);
        return bundle;
    }

    private static void removeBundle(Player player) {
        player.deleteAttribute("abm_bundle");
    }

    private static void initGui(Player player) {
        ResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        GuiTextField field = new GuiTextField(0.5f, 0.5f, true, 0.98f, 0.35f, true);
        field.setPivot(PivotPosition.Center);
        field.setColor(0x111111FF);
        field.setFontColor(-1431655681);
        field.setFont(Font.DefaultMono_Bold);
        field.setBorderColor(-1431655681);
        field.setMaxCharacters(32);
        field.setText("empty");
        field.setVisible(true);
        GuiLabel label = new GuiLabel(0.01f, 0.99f, true);
        label.setPivot(PivotPosition.TopLeft);
        label.setFontColor(-1431655681);
        label.setFont(Font.DefaultMono_Bold);
        label.setFontSize(40);
        label.setText(AnimalBreedMaster.getVal(bundle, "label.rename"));
        label.setVisible(true);
        GuiPanel panel = new GuiPanel(0.5f, 0.5f, true, 0.45f, 0.15f, true);
        panel.setPivot(PivotPosition.Center);
        panel.addChild((GuiElement)label);
        panel.addChild((GuiElement)field);
        panel.setVisible(false);
        World3DText text = new World3DText("");
        text.setFontColor(0xAA00FF);
        text.setBillboard(true);
        text.setAlwaysVisible(true);
        player.setAttribute("abm_rename_panel", (Object)panel);
        player.setAttribute("abm_rename_input", (Object)field);
        player.setAttribute("abm_3d_label", (Object)text);
        player.addGuiElement((GuiElement)panel);
        player.addGuiElement((GuiElement)label);
        player.addGuiElement((GuiElement)field);
        player.addWorldElement((WorldElement)text);
    }

    private static void removeGui(Player player) {
        player.deleteAttribute("abm_3d_label");
        player.deleteAttribute("abm_rename_input");
        player.deleteAttribute("abm_rename_panel");
    }

    private static int getInteger(String str) {
        int i;
        if (str == null) {
            str = "";
        }
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            i = 0;
        }
        return i;
    }

    private void loadSettings() {
        this.loadPreferences(ABM_PREFS, this.settings);
        this.checkSettings();
        this.savePreferences(ABM_PREFS, this.settings);
        this.maxOwnableAnimals = AnimalBreedMaster.getInteger(this.settings.getProperty(PROP_MAX_ANIMALS));
    }

    private void checkSettings() {
        int i = AnimalBreedMaster.getInteger(this.settings.getProperty(PROP_MAX_ANIMALS));
        if (i < 1 || i > 1000) {
            this.settings.setProperty(PROP_MAX_ANIMALS, "50");
        }
    }

    private void loadPreferences(String filename, Properties props) {
        String path = this.getPath();
        if (path == null || path.length() < 1) {
            return;
        }
        String filepath = path + SEP + filename + EXT;
        File file = new File(filepath);
        if (!file.exists()) {
            this.savePreferences(filename, props);
        }
        try (FileInputStream in = new FileInputStream(file);){
            props.loadFromXML(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void savePreferences(String filename, Properties props) {
        String path = this.getPath();
        if (path == null || path.length() < 1) {
            return;
        }
        String filepath = path + SEP + filename + EXT;
        File file = new File(filepath);
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (FileOutputStream out = new FileOutputStream(file, false);){
            props.storeToXML((OutputStream)out, "", StandardCharsets.UTF_8.name());
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        INTERVALL = 1.0f;
        FEED_TIMER_SCALER = (int)(4.0f / INTERVALL);
        BREED_TIMER_SCALER = (int)(10.0f / INTERVALL);
        GENERAL_TIMER_SCALER_1 = (int)(30.0f / INTERVALL);
        playerCallbackResultMap = new HashMap<Player, CallbackRayCastResult>(20);
    }

    class CallbackRayCastResult
    implements Callback<RayCastResult> {
        private final Player player;

        CallbackRayCastResult(Player p_player) {
            this.player = p_player;
        }

        public void onCall(RayCastResult result) {
            if (result == null) {
                return;
            }
            if (result.getDistance() > 100.0f) {
                return;
            }
            Object collisionObject = result.getCollisionObject();
            Npc npc = null;
            if (collisionObject != null && collisionObject instanceof Npc) {
                npc = (Npc)collisionObject;
            }
            if (npc == null) {
                this.player.setAttribute("abm_raycast_idle", (Object)true);
                return;
            }
            Animal animal = AnimalController.getAnimal(npc);
            AnimalBreedMaster.this.processAction(this.player, animal);
            AnimalBreedMaster.this.showNameAction(this.player, animal);
            this.player.setAttribute("abm_raycast_idle", (Object)false);
        }
    }
}

