/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.tsc;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerSleepEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class TimeSpeedChanger
extends Plugin
implements Listener {
    private static final String SEP = FileSystems.getDefault().getSeparator();
    private static final String FILENAME = "tsc.prefs";
    private static final DecimalFormat dig2 = new DecimalFormat("00");
    private static final String MODE_GT = "gametime";
    private static final String MODE_RT = "realtime";
    private static final String MODE_DN = "daynight";
    private static final List<String> MODE_LIST = new ArrayList<String>(3);
    private static final String CMD_HELP = "command_help";
    private static final String CMD_CLCK = "command_clock";
    private static final String CMD_GAME = "command_gametime";
    private static final String CMD_REAL = "command_realtime";
    private static final String CMD_DAYN = "command_daynight";
    private static final String MODE = "mode";
    private static final String TSP_DAY = "timespeed_day";
    private static final String TSP_NIGHT = "timespeed_night";
    private static final String CLCK_VIS = "clock_visible";
    private static final String CLCK_X = "clock_posx";
    private static final String CLCK_Y = "clock_posy";
    private static final String CLCK_SIZE = "clock_size";
    private final Runnable timerTask_FP = this::timerTask;
    private Properties props;
    private float origTimeSpeed;
    private int second;
    private int minute;
    private int hour;

    public void onEnable() {
        Server server = this.getServer();
        this.origTimeSpeed = server.getGameTimeSpeed();
        this.props = new Properties();
        this.loadSettings();
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    @EventMethod(value=Threading.Sync)
    public void onPlayerSpawn(PlayerSpawnEvent evt) {
        Player player = evt.getPlayer();
        if (!player.isAdmin()) {
            return;
        }
        player.sendTextMessage("[#ffff0f]TimeSpeedChanger V1.1: mode=" + this.props.getProperty(MODE) + ", enter /" + this.props.getProperty(CMD_HELP) + " for help page");
        player.sendTextMessage("");
        GuiLabel label = new GuiLabel(TimeSpeedChanger.getFloat(this.props.getProperty(CLCK_X)), TimeSpeedChanger.getFloat(this.props.getProperty(CLCK_Y)), true);
        label.setPivot(PivotPosition.TopLeft);
        label.setFont(Font.DefaultMono_Bold);
        label.setFontSize(TimeSpeedChanger.getInteger(this.props.getProperty(CLCK_SIZE)));
        label.setClickable(false);
        label.setBorderColor(0.2f, 0.2f, 0.2f, 0.5f);
        label.setBorderThickness(0.6f, true);
        label.setText("          ");
        player.addGuiElement((GuiElement)label);
        player.setAttribute("tsc_clock_label", (Object)label);
        this.setGuiClockVisible(player);
        Timer timer = new Timer(1.0f, 0.0f, -1, this.timerTask_FP);
        timer.start();
        this.updateRealTime();
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerCommand(PlayerCommandEvent evt) {
        Player player = evt.getPlayer();
        if (!player.isAdmin()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() <= 0) {
            return;
        }
        String cmd = st.nextToken();
        if (cmd.equals(this.props.getProperty(CMD_HELP))) {
            this.printHelp(player);
        } else if (cmd.equals(this.props.getProperty(CMD_CLCK))) {
            this.toggleClock(player);
        } else if (cmd.equals(this.props.getProperty(CMD_GAME))) {
            this.setGameTime();
        } else if (cmd.equals(this.props.getProperty(CMD_REAL))) {
            this.setRealTime();
        } else if (cmd.equals(this.props.getProperty(CMD_DAYN))) {
            float night;
            float day;
            if (st.countTokens() != 2) {
                this.printMode(player);
                return;
            }
            try {
                day = Float.parseFloat(st.nextToken());
                night = Float.parseFloat(st.nextToken());
            }
            catch (NumberFormatException nfex) {
                player.sendTextMessage("error: not a number");
                return;
            }
            this.setDayNight(day, night);
        }
        this.printMode(player);
        this.saveSettings();
    }

    private void printMode(Player player) {
        String txt = "[#ffff0f]TimeSpeedChanger V1.1: mode=" + this.props.getProperty(MODE);
        if (this.props.getProperty(MODE).equals(MODE_DN)) {
            txt = txt + " speed day: " + this.props.getProperty(TSP_DAY) + " speed night: " + this.props.getProperty(TSP_NIGHT);
        }
        player.sendTextMessage(txt);
        player.sendTextMessage("");
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerSleep(PlayerSleepEvent evt) {
        if (!evt.getPlayer().isAdmin()) {
            return;
        }
        if (evt.isSleeping()) {
            return;
        }
        this.updateRealTime();
    }

    private void timerTask() {
        this.updateTime();
        this.updateLabelAllPlayers();
        this.updateDayNight();
    }

    private void updateTime() {
        Calendar calendar = Calendar.getInstance();
        this.second = calendar.get(13);
        this.minute = calendar.get(12);
        this.hour = calendar.get(11);
    }

    private void updateLabelAllPlayers() {
        if (!this.isClockVisible()) {
            return;
        }
        for (Player player : this.getServer().getAllPlayers()) {
            if (!player.isAdmin()) continue;
            this.updateLabel(player);
            break;
        }
    }

    private void updateLabel(Player player) {
        GuiLabel label = (GuiLabel)player.getAttribute("tsc_clock_label");
        if (label == null) {
            return;
        }
        String time = " " + dig2.format(this.hour) + ":" + dig2.format(this.minute) + ":" + dig2.format(this.second) + " ";
        label.setText(time);
    }

    private void updateRealTime() {
        if (!MODE_RT.equals(this.props.getProperty(MODE))) {
            return;
        }
        this.updateTime();
        this.setRealTime();
    }

    private void updateDayNight() {
        if (!MODE_DN.equals(this.props.getProperty(MODE))) {
            return;
        }
        Server server = this.getServer();
        int hours = server.getGameTime().getHours();
        if (hours >= 8 && hours < 22) {
            server.setGameTimeSpeed(Float.parseFloat(this.props.getProperty(TSP_DAY)));
        } else {
            server.setGameTimeSpeed(Float.parseFloat(this.props.getProperty(TSP_NIGHT)));
        }
    }

    private boolean isClockVisible() {
        return Boolean.parseBoolean(this.props.getProperty(CLCK_VIS));
    }

    private void toggleClock(Player player) {
        this.props.setProperty(CLCK_VIS, Boolean.toString(!this.isClockVisible()));
        this.setGuiClockVisible(player);
    }

    private void setGuiClockVisible(Player player) {
        GuiLabel label = (GuiLabel)player.getAttribute("tsc_clock_label");
        if (label == null) {
            return;
        }
        player.setGuiElementVisible((GuiElement)label, Boolean.parseBoolean(this.props.getProperty(CLCK_VIS)));
    }

    private void setGameTime() {
        this.props.setProperty(MODE, MODE_GT);
        this.getServer().setGameTimeSpeed(this.origTimeSpeed);
    }

    private void setRealTime() {
        this.props.setProperty(MODE, MODE_RT);
        Server server = this.getServer();
        server.setGameTimeSpeed(60.0f);
        server.setGameTime(this.hour, this.minute);
    }

    private void setDayNight(float p_day, float p_night) {
        if (p_day <= 0.0f || p_night <= 0.0f) {
            return;
        }
        this.props.setProperty(MODE, MODE_DN);
        this.props.setProperty(TSP_DAY, Float.toString(p_day));
        this.props.setProperty(TSP_NIGHT, Float.toString(p_night));
    }

    private void printHelp(Player player) {
        player.sendTextMessage("");
        player.sendTextMessage("");
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage("*                TimeSpeedChanger V1.1 Plugin - help page               *");
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage("* ");
        player.sendTextMessage("* Available commands:");
        player.sendTextMessage("* /" + this.props.getProperty(CMD_HELP));
        player.sendTextMessage("*   show this help page");
        player.sendTextMessage("* ");
        player.sendTextMessage("* /" + this.props.getProperty(CMD_CLCK));
        player.sendTextMessage("*   show/ hide realtime clock on screen");
        player.sendTextMessage("* ");
        player.sendTextMessage("* /" + this.props.getProperty(CMD_GAME));
        player.sendTextMessage("*   switch to normal ingame timespeed");
        player.sendTextMessage("* ");
        player.sendTextMessage("* /" + this.props.getProperty(CMD_REAL));
        player.sendTextMessage("*   switch to current time and realtime timespeed");
        player.sendTextMessage("* ");
        player.sendTextMessage("* /" + this.props.getProperty(CMD_DAYN) + " x.xx y.yy");
        player.sendTextMessage("*   set distinct timespeed for day (08:00-22:00) and night (22:00-08:00),");
        player.sendTextMessage("*   the amount of realtime seconds for one ingame minute, f.e.:");
        player.sendTextMessage("*   /" + this.props.getProperty(CMD_DAYN) + " 3.0 2.0");
        player.sendTextMessage("*   a minute at daytime takes 3 seconds, at night it takes 2 seconds");
        player.sendTextMessage("* ");
        player.sendTextMessage("* The readme.txt in the plugin folder contains further information.");
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage("");
        player.sendTextMessage("(Activate chat and press <Page Up> <Page Down> to scroll) ");
        player.sendTextMessage("");
    }

    public void loadSettings() {
        this.loadPreferences(FILENAME, this.props);
        this.checkSettings();
        this.savePreferences(FILENAME, this.props);
    }

    public void saveSettings() {
        this.savePreferences(FILENAME, this.props);
    }

    public void checkSettings() {
        this.checkStringValue(this.props, CMD_HELP, "tschelp");
        this.checkStringValue(this.props, CMD_CLCK, "tscclock");
        this.checkStringValue(this.props, CMD_GAME, "tscgametime");
        this.checkStringValue(this.props, CMD_REAL, "tscrealtime");
        this.checkStringValue(this.props, CMD_DAYN, "tscdaynight");
        String str = this.props.getProperty(MODE);
        if (str == null || !MODE_LIST.contains(str)) {
            this.props.setProperty(MODE, MODE_GT);
        }
        if ((str = this.props.getProperty(CLCK_VIS)) == null || !str.equals("true") || !str.equals("false")) {
            this.props.setProperty(CLCK_VIS, "true");
        }
        this.checkFloatRange(this.props, TSP_DAY, 0.01f, 999.99f, 1.75f);
        this.checkFloatRange(this.props, TSP_NIGHT, 0.01f, 999.99f, 1.75f);
        this.checkFloatRange(this.props, CLCK_X, 0.0f, 1.0f, 0.0f);
        this.checkFloatRange(this.props, CLCK_Y, 0.0f, 1.0f, 1.0f);
        this.checkIntegerRange(this.props, CLCK_SIZE, 1, 100, 20);
    }

    private void checkStringValue(Properties props, String key, String defaultValue) {
        String str = props.getProperty(key);
        if (str == null || str.length() <= 0) {
            props.setProperty(key, defaultValue);
        }
    }

    private void checkFloatRange(Properties props, String key, float min, float max, float def) {
        float f = TimeSpeedChanger.getFloat(props.getProperty(key));
        if (f < min || f > max) {
            props.setProperty(key, Float.toString(def));
        }
    }

    private void checkIntegerRange(Properties props, String key, int min, int max, int def) {
        int i = TimeSpeedChanger.getInteger(props.getProperty(key));
        if (i < min || i > max) {
            props.setProperty(key, Integer.toString(def));
        }
    }

    public static float getFloat(String str) {
        float f;
        if (str == null) {
            str = "";
        }
        try {
            f = Float.parseFloat(str);
        }
        catch (NumberFormatException ex) {
            f = Float.POSITIVE_INFINITY;
        }
        return f;
    }

    public static int getInteger(String str) {
        int i;
        if (str == null) {
            str = "";
        }
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            i = 0;
        }
        return i;
    }

    public void loadPreferences(String filename, Properties props) {
        String path = this.getPath();
        if (path == null || path.length() < 1) {
            return;
        }
        String filepath = path + SEP + filename;
        File file = new File(filepath);
        if (!file.exists()) {
            this.savePreferences(filename, props);
        }
        try (FileReader reader = new FileReader(file);){
            props.load(reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void savePreferences(String filename, Properties props) {
        String path = this.getPath();
        if (path == null || path.length() < 1) {
            return;
        }
        String filepath = path + SEP + filename;
        File file = new File(filepath);
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (FileWriter writer = new FileWriter(file, false);){
            props.store(writer, null);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        MODE_LIST.add(MODE_GT);
        MODE_LIST.add(MODE_RT);
        MODE_LIST.add(MODE_DN);
    }
}

