/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.ups;

import com.vistamaresoft.rwgui.GuiDialogueBox;
import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.GuiMessageBox;
import com.vistamaresoft.rwgui.GuiModalWindow;
import com.vistamaresoft.rwgui.GuiTableLayout;
import com.vistamaresoft.rwgui.GuiUsersMenu;
import com.vistamaresoft.rwgui.RWGui;
import com.vistamaresoft.ups.Msgs;
import com.vistamaresoft.ups.Ups;
import net.risingworld.api.Plugin;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiTextField;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;

public class SendGui
extends GuiDialogueBox {
    private static final int NUM_OF_ITEMS = 5;
    private static final int CODTXT_W = 90;
    private static final int CODTXT_H = 23;
    private static final int TO_TXT_W = 150;
    private static final int TO_TXT_H = 23;
    private static final int INTERQTY_PADDING = 18;
    private static final int OBJECTKIT_ID = 43;
    private static final int MINUSBUTT_ID = 6;
    private static final int PLUSBUTT_ID = 7;
    private static final int DOWNBUTT_ID = 8;
    private static final int CODTXT_ID = 9;
    private static final int DOBUTT_ID = 10;
    private int itemSel;
    private int itemSelOld;
    private int[] itemQuant;
    private GuiLabel[] items;
    private int quant;
    private GuiImage minusButt;
    private GuiLabel quantText;
    private GuiImage plusButt;
    private int toDbId;
    private String toName;
    private GuiTextField toText;
    private boolean hasBank;
    private String currency;
    private double cost;
    private double cod;
    private GuiTextField codText;
    private GuiLabel shipText;
    private GuiLabel doButt;
    private GuiUsersMenu usersMenu;

    public SendGui(Player player) {
        super((Plugin)Ups.plugin, Msgs.msg[0], 2, null);
        this.setCallback(new DlgHandler());
        this.hasBank = Ups.bankPlugin != null;
        this.currency = this.hasBank ? Ups.currencySymbol : "";
        GuiLayout layout = this.addNewLayoutChild(1, 0);
        layout.addChild((GuiElement)new GuiLabel(Msgs.msg[4], 0.0f, 0.0f, false));
        layout = this.addNewLayoutChild(2, 0);
        layout.setBorderColor(0x505050FF);
        layout.setBorderThickness(2.0f, false);
        layout.setMargin(6);
        this.itemSelOld = -1;
        this.itemSel = -1;
        this.itemQuant = new int[5];
        Inventory inv = player.getInventory();
        this.items = new GuiLabel[5];
        int i = 0;
        while (i < 5) {
            String txt;
            Item item = inv.getItem(i, Inventory.SlotType.Quickslot);
            if (item != null) {
                this.itemQuant[i] = item.getStacksize();
                txt = String.format(Msgs.msg[5], this.itemQuant[i], item.getName(), item.getVariation());
                if (item.getTypeID() == 43) {
                    this.itemQuant[i] = 0;
                }
            } else {
                this.itemQuant[i] = 0;
                txt = Msgs.msg[6];
            }
            this.items[i] = new GuiLabel(txt, 0.0f, 0.0f, false);
            boolean active = this.itemQuant[i] > 0;
            layout.addChild((GuiElement)this.items[i], active ? Integer.valueOf(i + 1) : null);
            this.items[i].setFontColor(active ? -1 : -2139062017);
            ++i;
        }
        layout = this.addNewTableLayoutChild(2, 4, 0);
        this.quant = 0;
        layout.addChild((GuiElement)new GuiLabel(Msgs.msg[7], 0.0f, 0.0f, false));
        GuiLayout layout2 = layout.addNewLayoutChild(1, 8);
        layout2.setPadding(18);
        this.minusButt = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
        RWGui.setImage((GuiImage)this.minusButt, (int)8);
        this.minusButt.setVisible(false);
        layout2.addChild((GuiElement)this.minusButt, Integer.valueOf(6));
        this.quantText = new GuiLabel("0", 0.0f, 0.0f, false);
        layout2.addChild((GuiElement)this.quantText);
        this.plusButt = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
        RWGui.setImage((GuiImage)this.plusButt, (int)7);
        this.plusButt.setVisible(false);
        layout2.addChild((GuiElement)this.plusButt, Integer.valueOf(7));
        layout.addChild((GuiElement)new GuiLabel(Msgs.msg[9], 0.0f, 0.0f, false));
        layout2 = layout.addNewLayoutChild(1, 8);
        this.codText = new GuiTextField(0.0f, 0.0f, false, 90.0f, 23.0f, false);
        layout2.addChild((GuiElement)this.codText, this.hasBank ? Integer.valueOf(9) : null);
        layout2.addChild((GuiElement)new GuiLabel(this.currency, 0.0f, 0.0f, false));
        this.toDbId = 0;
        layout.addChild((GuiElement)new GuiLabel(Msgs.msg[8], 0.0f, 0.0f, false));
        layout2 = layout.addNewLayoutChild(1, 8);
        this.toText = new GuiTextField(0.0f, 0.0f, false, 150.0f, 23.0f, false);
        layout2.addChild((GuiElement)this.toText);
        GuiImage img = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
        RWGui.setImage((GuiImage)img, (int)0);
        layout2.addChild((GuiElement)img, Integer.valueOf(8));
        layout.addChild((GuiElement)new GuiLabel(Msgs.msg[10], 0.0f, 0.0f, false));
        this.shipText = new GuiLabel(0.0f, 0.0f, false);
        layout.addChild((GuiElement)this.shipText);
        ((GuiTableLayout)layout).setColFlag(0, 2);
        layout = this.addNewLayoutChild(1, 1);
        this.doButt = new GuiLabel(Msgs.msg[12], 0.0f, 0.0f, false);
        layout.addChild((GuiElement)this.doButt, Integer.valueOf(10));
        this.doButt.setColor(0x404040FF);
        this.doButt.setClickable(false);
        this.updateSelected();
    }

    private void updateCost() {
        this.cost = 0.0;
        int tempQuant = this.quant;
        if (this.hasBank) {
            int unitsOf64 = tempQuant / 64;
            int unitsOf16 = (tempQuant %= 64) / 16;
            int unitsOf4 = (tempQuant %= 16) / 4;
            int unitsOf1 = tempQuant % 4;
            this.cost = (double)unitsOf64 * Ups.costPer64Items + (double)unitsOf16 * Ups.costPer16Items + (double)unitsOf4 * Ups.costPer4Items + (double)unitsOf1 * Ups.costPerItem;
        }
        this.quantText.setText(Integer.toString(this.quant));
        this.shipText.setText(String.format(Msgs.msg[11], this.cost, this.currency));
    }

    private void updateSelected() {
        if (this.itemSelOld >= 0) {
            this.items[this.itemSelOld].setFontColor(this.itemQuant[this.itemSelOld] > 0 ? -1 : -2139062017);
        }
        if (this.itemSel >= 0) {
            this.items[this.itemSel].setFontColor(0xB0FFFF);
            this.itemSelOld = this.itemSel;
            this.quant = this.itemQuant[this.itemSel] > 0 ? 1 : 0;
            this.minusButt.setVisible(false);
            this.plusButt.setVisible(this.itemQuant[this.itemSel] > 1);
            this.quantText.setText(Integer.toString(this.quant));
        }
        this.updateCost();
        this.updateDoButton();
    }

    private void updateDoButton() {
        boolean complete = this.toDbId != 0 && this.quant > 0;
        this.doButt.setColor(complete ? 6344959 : 0x404040FF);
        this.doButt.setClickable(complete);
    }

    private class DlgHandler
    implements RWGui.RWGuiCallback {
        private DlgHandler() {
        }

        public void onCall(Player player, int id, Object data) {
            if (id >= 1 && id <= 5) {
                SendGui.this.itemSel = id - 1;
                SendGui.this.updateSelected();
                return;
            }
            switch (id) {
                case -1: {
                    return;
                }
                case 6: {
                    SendGui sendGui = SendGui.this;
                    sendGui.quant = sendGui.quant - 1;
                    if (SendGui.this.quant <= 1) {
                        SendGui.this.quant = 1;
                        SendGui.this.minusButt.setVisible(false);
                    }
                    if (SendGui.this.quant == SendGui.this.itemQuant[SendGui.this.itemSel] - 1) {
                        SendGui.this.plusButt.setVisible(true);
                    }
                    SendGui.this.updateCost();
                    break;
                }
                case 7: {
                    SendGui sendGui = SendGui.this;
                    sendGui.quant = sendGui.quant + 1;
                    if (SendGui.this.quant >= SendGui.this.itemQuant[SendGui.this.itemSel]) {
                        SendGui.this.quant = SendGui.this.itemQuant[SendGui.this.itemSel];
                        SendGui.this.plusButt.setVisible(false);
                    }
                    if (SendGui.this.quant == 2) {
                        SendGui.this.minusButt.setVisible(true);
                    }
                    SendGui.this.updateCost();
                    break;
                }
                case 8: {
                    SendGui.this.usersMenu = new GuiUsersMenu((Plugin)Ups.plugin, Msgs.msg[13], (RWGui.RWGuiCallback)new UserMenuHandler(), player.getDbID());
                    SendGui.this.push(player, (GuiModalWindow)SendGui.this.usersMenu);
                    break;
                }
                case 10: {
                    SendGui.this.pop(player);
                    Item item = player.getInventory().getItem(SendGui.this.itemSel, Inventory.SlotType.Quickslot);
                    if (item == null) break;
                    int retVal = Ups.plugin.send(player, Inventory.SlotType.Quickslot, SendGui.this.itemSel, SendGui.this.quant, SendGui.this.toName, SendGui.this.toDbId, SendGui.this.cost, SendGui.this.cod);
                    String[] texts = retVal > 0 ? new String[]{String.format(Msgs.msg[26], retVal)} : (retVal == -5 ? new String[]{Msgs.msg[28]} : new String[]{Msgs.msg[27]});
                    new GuiMessageBox((Plugin)Ups.plugin, player, Msgs.msg[0], texts, 0);
                }
            }
        }
    }

    private class UserMenuHandler
    implements RWGui.RWGuiCallback {
        private UserMenuHandler() {
        }

        public void onCall(Player player, int id, Object data) {
            if (SendGui.this.usersMenu == null) {
                return;
            }
            SendGui.this.usersMenu = null;
            if (id == -1) {
                return;
            }
            SendGui.this.toDbId = id;
            SendGui.this.toName = (String)data;
            SendGui.this.toText.setText(SendGui.this.toName);
            SendGui.this.updateDoButton();
        }
    }
}

