/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.ups;

import com.vistamaresoft.ups.Msgs;
import com.vistamaresoft.ups.Ups;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.risingworld.api.database.Database;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;

public class Db {
    protected static Database db = null;

    protected static void init() {
        if (db == null) {
            db = Ups.plugin.getSQLiteConnection(String.valueOf(Ups.plugin.getPath()) + "/ups-" + Ups.plugin.getWorld().getName() + ".db");
        }
        db.execute("CREATE TABLE IF NOT EXISTS `parcels` (`id`          INTEGER PRIMARY KEY, `from_dbid`   INTEGER  NOT NULL DEFAULT ( 0 ),`from_name`   CHAR(64) NOT NULL DEFAULT ('[NoName]'),`to_dbid`     INTEGER  NOT NULL DEFAULT ( 0 ),`to_name`     CHAR(64) NOT NULL DEFAULT ('[NoName]'),`item_id`     INTEGER  NOT NULL DEFAULT ( 0 ),`item_var`    INTEGER  NOT NULL DEFAULT ( 0 ),`item_qty`    INTEGER  NOT NULL DEFAULT ( 0 ),`cash_on_del` REAL     NOT NULL DEFAULT ( 0 ),`sent_on`     INTEGER  NOT NULL DEFAULT ( 0 ),`recd_on`     INTEGER  NOT NULL DEFAULT ( 0 ));");
        db.execute("CREATE INDEX IF NOT EXISTS `from` ON `parcels` (`from_dbid`, `sent_on`);");
        db.execute("CREATE INDEX IF NOT EXISTS `to` ON `parcels` (`to_dbid`, `recd_on`);");
    }

    protected static void deinit() {
        db.close();
        db = null;
    }

    public static ArrayList<Ups.Parcel> getParcelsFromPlayer(int playerDbId) {
        String query = "SELECT * FROM `parcels` WHERE `from_dbid`=" + playerDbId + " ORDER BY `sent_on` DESC";
        return Db.getResultParcels(query);
    }

    public static ArrayList<Ups.Parcel> getParcelsToPlayer(int playerDbId) {
        String query = "SELECT * FROM `parcels` WHERE `to_dbid`=" + playerDbId + " ORDER BY `sent_on` DESC";
        return Db.getResultParcels(query);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static int deliver(Player player, int parcelId) {
        try {
            Item item;
            ResultSet result = db.executeQuery("SELECT * FROM `parcels` WHERE `id`=" + parcelId);
            if (!result.next()) {
                return -1;
            }
            int payingDbId = result.getInt(4);
            int paidDbId = result.getInt(2);
            double cod = result.getDouble(9);
            if (player.getDbID() != payingDbId) {
                return -3;
            }
            if (Ups.bankPlugin != null && cod > 0.0) {
                if (!Ups.bankPlugin.hasAvailableMoney(payingDbId, cod)) {
                    return -5;
                }
                Ups.bankPlugin.transferMoney(payingDbId, paidDbId, cod, String.format(Msgs.msg[33], parcelId));
            }
            if ((item = player.getInventory().insertNewItem((short)result.getInt(6), result.getInt(7), result.getInt(8))) == null) {
                return -4;
            }
            db.executeUpdate("UPDATE `parcels` SET `recd_on`=" + System.currentTimeMillis() + " WHERE `id`=" + parcelId);
            return 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -2;
        }
    }

    protected static int send(Player player, int itemId, int itemVar, int quantity, String toName, int toDbId, double cost, double cashOnDel) {
        int newId = -2;
        int fromDbId = player.getDbID();
        if (Ups.bankPlugin != null && cost > 0.0 && !Ups.bankPlugin.hasAvailableMoney(fromDbId, cost)) {
            return -5;
        }
        try {
            Throwable throwable = null;
            Object var13_13 = null;
            try (PreparedStatement stmt = db.getConnection().prepareStatement("INSERT INTO 'parcels' ('from_dbid','from_name','to_dbid','to_name','item_id','item_var','item_qty','cash_on_del','sent_on') VALUES (" + fromDbId + ",?," + toDbId + ",?," + itemId + "," + itemVar + "," + quantity + "," + cashOnDel + "," + System.currentTimeMillis() + ")");){
                stmt.setString(1, player.getName());
                stmt.setString(2, toName);
                stmt.executeUpdate();
                Throwable throwable2 = null;
                Object var16_18 = null;
                try (ResultSet idSet = stmt.getGeneratedKeys();){
                    if (idSet.next()) {
                        newId = idSet.getInt(1);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                if (Ups.bankPlugin != null && cost > 0.0) {
                    Ups.bankPlugin.transferMoney(fromDbId, -1, cost, String.format(Msgs.msg[32], newId));
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return newId;
    }

    private static ArrayList<Ups.Parcel> getResultParcels(String query) {
        ArrayList<Ups.Parcel> parcels = new ArrayList<Ups.Parcel>();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ResultSet result = db.executeQuery(query);){
                while (result.next()) {
                    Ups.Parcel parcel = new Ups.Parcel(result.getInt(1), result.getInt(2), result.getString(3), result.getInt(4), result.getString(5), result.getInt(6), result.getInt(7), result.getInt(8), result.getDouble(9), result.getLong(10), result.getLong(11));
                    parcels.add(parcel);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return parcels;
    }
}

