/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.tsc;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerSleepEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class TimeSpeedChanger
extends Plugin
implements Listener {
    private static final String FILENAME = "tsc.prefs";
    private static final DecimalFormat dig2 = new DecimalFormat("00");
    private static final String MODE_GT = "gametime";
    private static final String MODE_RT = "realtime";
    private static final String MODE_DN = "daynight";
    private static final List<String> MODE_LIST = new ArrayList<String>(3);
    private static final String CMD_HELP = "command_help";
    private static final String CMD_CLCK = "command_clock";
    private static final String CMD_GAME = "command_gametime";
    private static final String CMD_REAL = "command_realtime";
    private static final String CMD_DAYN = "command_daynight";
    private static final String MODE = "mode";
    private static final String TSP_DAY = "timespeed_day";
    private static final String TSP_NIGHT = "timespeed_night";
    private static final String CLCK_VIS = "clock_visible";
    private static final String CLCK_X = "clock_posx";
    private static final String CLCK_Y = "clock_posy";
    private static final String CLCK_SIZE = "clock_size";
    private final Runnable timerTask_FP = this::timerTask;
    private Properties props;
    private Player player;
    private float origTimeSpeed;
    private int second;
    private int minute;
    private int hour;

    public void onEnable() {
        Server server = this.getServer();
        if (server.getType() != Server.Type.Singleplayer) {
            return;
        }
        this.origTimeSpeed = server.getGameTimeSpeed();
        this.props = new Properties();
        this.loadPreferences();
        this.checkPreferences();
        this.savePreferences();
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    @EventMethod(value=Threading.Sync)
    public void onPlayerSpawn(PlayerSpawnEvent evt) {
        this.player = evt.getPlayer();
        this.player.sendTextMessage("TimeSpeedChanger loaded, actual mode = " + this.props.get(MODE) + ", enter /" + this.props.get(CMD_HELP) + " for help page");
        this.player.sendTextMessage("");
        GuiLabel label = new GuiLabel(TimeSpeedChanger.getFloat(this.props.getProperty(CLCK_X)), TimeSpeedChanger.getFloat(this.props.getProperty(CLCK_Y)), true);
        label.setPivot(PivotPosition.TopLeft);
        label.setFont(Font.DefaultMono_Bold);
        label.setFontSize(TimeSpeedChanger.getInteger(this.props.getProperty(CLCK_SIZE)));
        label.setClickable(false);
        label.setBorderColor(0.2f, 0.2f, 0.2f, 0.5f);
        label.setBorderThickness(0.6f, true);
        label.setText("          ");
        this.player.addGuiElement((GuiElement)label);
        this.player.setAttribute("tsc_clock_label", (Object)label);
        this.setGuiClockVisible();
        Timer timer = new Timer(1.0f, 0.0f, -1, this.timerTask_FP);
        timer.start();
        this.updateRealTime();
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerCommand(PlayerCommandEvent evt) {
        Server server = this.getServer();
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() <= 0) {
            return;
        }
        Properties p = this.props;
        String cmd = st.nextToken();
        if (cmd.equals(p.getProperty(CMD_HELP))) {
            this.printHelp();
        } else if (cmd.equals(p.getProperty(CMD_CLCK))) {
            this.toggleClock();
        } else if (cmd.equals(p.getProperty(CMD_GAME))) {
            this.setGameTime();
        } else if (cmd.equals(p.getProperty(CMD_REAL))) {
            this.setRealTime();
        } else if (cmd.equals(p.getProperty(CMD_DAYN))) {
            if (st.countTokens() != 2) {
                this.player.sendTextMessage("error: two numbers expected");
                return;
            }
            float day = Float.parseFloat(p.getProperty(TSP_DAY));
            float night = Float.parseFloat(p.getProperty(TSP_NIGHT));
            try {
                day = Float.parseFloat(st.nextToken());
                night = Float.parseFloat(st.nextToken());
            }
            catch (NumberFormatException nfex) {
                this.player.sendTextMessage("error: not a number");
                return;
            }
            this.setDayNight(day, night);
        }
        this.savePreferences();
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerSleep(PlayerSleepEvent evt) {
        if (evt.isSleeping()) {
            return;
        }
        this.updateRealTime();
    }

    private void timerTask() {
        this.updateTime();
        this.updateLabel();
        this.updateDayNight();
    }

    private void updateTime() {
        Calendar calendar = Calendar.getInstance();
        this.second = calendar.get(13);
        this.minute = calendar.get(12);
        this.hour = calendar.get(11);
    }

    private void updateLabel() {
        if (!this.isClockVisible()) {
            return;
        }
        GuiLabel label = (GuiLabel)this.player.getAttribute("tsc_clock_label");
        if (label == null) {
            return;
        }
        String time = " " + dig2.format(this.hour) + ":" + dig2.format(this.minute) + ":" + dig2.format(this.second) + " ";
        label.setText(time);
    }

    private void updateRealTime() {
        if (!MODE_RT.equals(this.props.getProperty(MODE))) {
            return;
        }
        this.updateTime();
        this.setRealTime();
    }

    private void updateDayNight() {
        if (!MODE_DN.equals(this.props.getProperty(MODE))) {
            return;
        }
        Server server = this.getServer();
        int hours = server.getGameTime().getHours();
        if (hours >= 8 && hours < 22) {
            server.setGameTimeSpeed(Float.parseFloat(this.props.getProperty(TSP_DAY)));
        } else {
            server.setGameTimeSpeed(Float.parseFloat(this.props.getProperty(TSP_NIGHT)));
        }
    }

    private boolean isClockVisible() {
        return Boolean.parseBoolean(this.props.getProperty(CLCK_VIS));
    }

    private void toggleClock() {
        this.props.setProperty(CLCK_VIS, Boolean.toString(!this.isClockVisible()));
        this.setGuiClockVisible();
    }

    private void setGuiClockVisible() {
        GuiLabel label = (GuiLabel)this.player.getAttribute("tsc_clock_label");
        if (label == null) {
            return;
        }
        this.player.setGuiElementVisible((GuiElement)label, Boolean.parseBoolean(this.props.getProperty(CLCK_VIS)));
    }

    private void setGameTime() {
        this.props.setProperty(MODE, MODE_GT);
        this.getServer().setGameTimeSpeed(this.origTimeSpeed);
    }

    private void setRealTime() {
        this.props.setProperty(MODE, MODE_RT);
        Server server = this.getServer();
        server.setGameTimeSpeed(60.0f);
        server.setGameTime(this.hour, this.minute);
    }

    private void setDayNight(float p_day, float p_night) {
        if (p_day <= 0.0f || p_night <= 0.0f) {
            return;
        }
        this.props.setProperty(MODE, MODE_DN);
        this.props.setProperty(TSP_DAY, Float.toString(p_day));
        this.props.setProperty(TSP_NIGHT, Float.toString(p_night));
    }

    private void printHelp() {
        this.player.sendTextMessage("");
        this.player.sendTextMessage("");
        this.player.sendTextMessage("*************************************************************************");
        this.player.sendTextMessage("*                   TimeSpeedChanger Plugin - help page                 *");
        this.player.sendTextMessage("*************************************************************************");
        this.player.sendTextMessage("* ");
        this.player.sendTextMessage("* Available commands:");
        this.player.sendTextMessage("* /" + this.props.getProperty(CMD_HELP));
        this.player.sendTextMessage("*   show this help page");
        this.player.sendTextMessage("* ");
        this.player.sendTextMessage("* /" + this.props.getProperty(CMD_CLCK));
        this.player.sendTextMessage("*   show/ hide realtime clock on screen");
        this.player.sendTextMessage("* ");
        this.player.sendTextMessage("* /" + this.props.getProperty(CMD_GAME));
        this.player.sendTextMessage("*   switch to normal ingame timespeed");
        this.player.sendTextMessage("* ");
        this.player.sendTextMessage("* /" + this.props.getProperty(CMD_REAL));
        this.player.sendTextMessage("*   switch to current time and realtime timespeed");
        this.player.sendTextMessage("* ");
        this.player.sendTextMessage("* /" + this.props.getProperty(CMD_DAYN) + " x.xx y.yy");
        this.player.sendTextMessage("*   set distinct timespeed for day (08:00-22:00) and night (22:00-08:00),");
        this.player.sendTextMessage("*   the amount of realtime seconds for one ingame minute, f.e.:");
        this.player.sendTextMessage("*   /" + this.props.getProperty(CMD_DAYN) + " 3.0 2.0");
        this.player.sendTextMessage("*   a minute at daytime takes 3 seconds, at night it takes 2 seconds");
        this.player.sendTextMessage("* ");
        this.player.sendTextMessage("* The readme.txt in the plugin folder contains further information.");
        this.player.sendTextMessage("*************************************************************************");
        this.player.sendTextMessage("");
        this.player.sendTextMessage("(Activate chat and press <Page Up> <Page Down> to scroll) ");
        this.player.sendTextMessage("");
    }

    public void checkPreferences() {
        int i;
        float f;
        String str = this.props.getProperty(CMD_HELP);
        if (str == null || str.length() <= 0) {
            this.props.setProperty(CMD_HELP, "tschelp");
        }
        if ((str = this.props.getProperty(CMD_CLCK)) == null || str.length() <= 0) {
            this.props.setProperty(CMD_CLCK, "tscclock");
        }
        if ((str = this.props.getProperty(CMD_GAME)) == null || str.length() <= 0) {
            this.props.setProperty(CMD_GAME, "tscgametime");
        }
        if ((str = this.props.getProperty(CMD_REAL)) == null || str.length() <= 0) {
            this.props.setProperty(CMD_REAL, "tscrealtime");
        }
        if ((str = this.props.getProperty(CMD_DAYN)) == null || str.length() <= 0) {
            this.props.setProperty(CMD_DAYN, "tscdaynight");
        }
        if ((str = this.props.getProperty(MODE)) == null || !MODE_LIST.contains(str)) {
            this.props.setProperty(MODE, MODE_GT);
        }
        if ((f = TimeSpeedChanger.getFloat(this.props.getProperty(TSP_DAY))) <= 0.01f || f > 999.99f) {
            this.props.setProperty(TSP_DAY, "1.75");
        }
        if ((f = TimeSpeedChanger.getFloat(this.props.getProperty(TSP_NIGHT))) <= 0.01f || f > 999.99f) {
            this.props.setProperty(TSP_NIGHT, "1.75");
        }
        if ((f = TimeSpeedChanger.getFloat(this.props.getProperty(CLCK_X))) < 0.0f || f > 1.0f) {
            this.props.setProperty(CLCK_X, "0.0");
        }
        if ((f = TimeSpeedChanger.getFloat(this.props.getProperty(CLCK_Y))) < 0.0f || f > 1.0f) {
            this.props.setProperty(CLCK_Y, "1.0");
        }
        if ((i = TimeSpeedChanger.getInteger(this.props.getProperty(CLCK_SIZE))) < 1 || i > 100) {
            this.props.setProperty(CLCK_SIZE, "20");
        }
        if ((str = this.props.getProperty(CLCK_VIS)) == null || !str.equals("true") || !str.equals("false")) {
            this.props.setProperty(CLCK_VIS, "true");
        }
    }

    public static float getFloat(String str) {
        float f;
        if (str == null) {
            str = "";
        }
        try {
            f = Float.parseFloat(str);
        }
        catch (NumberFormatException ex) {
            f = Float.POSITIVE_INFINITY;
        }
        return f;
    }

    public static int getInteger(String str) {
        int i;
        if (str == null) {
            str = "";
        }
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            i = 0;
        }
        return i;
    }

    public void loadPreferences() {
        String path = this.getPath();
        if (path == null || path.length() < 1) {
            return;
        }
        String filename = path + FileSystems.getDefault().getSeparator() + FILENAME;
        File file = new File(filename);
        if (!file.exists()) {
            this.savePreferences();
        }
        try (FileReader reader = new FileReader(file);){
            this.props.load(reader);
            ((Reader)reader).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void savePreferences() {
        String path = this.getPath();
        if (path == null || path.length() < 1) {
            return;
        }
        String filename = path + FileSystems.getDefault().getSeparator() + FILENAME;
        File file = new File(filename);
        try {
            boolean bl = file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (FileWriter writer = new FileWriter(file, false);){
            this.props.store(writer, null);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        MODE_LIST.add(MODE_GT);
        MODE_LIST.add(MODE_RT);
        MODE_LIST.add(MODE_DN);
    }
}

