/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.plugincentral;

import com.vistamaresoft.plugincentral.Menu;
import com.vistamaresoft.plugincentral.Msgs;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.objects.Player;

public class PluginCentral
extends Plugin
implements Listener {
    protected static final String localeLanguageDef = "en";
    protected static String commandPrefix = "/pc";
    protected static Locale locale;
    public static final String version = "0.2.0";
    public static final String publicName = "Plug-in Central";
    private static final Class[] mainGuiClasses;
    protected static Plugin pluginCentral;
    private static Map<String, Integer> plugins;

    static {
        mainGuiClasses = new Class[]{Player.class};
    }

    public void onEnable() {
        pluginCentral = this;
        this.initSettings();
        Msgs.init(this.getPath(), locale);
        this.initPlugins();
        this.registerEventListener(this);
        System.out.println("PLUGIN-CENTRAL 0.2.0 loaded successfully!");
    }

    public void onDisable() {
        this.unregisterEventListener(this);
        System.out.println("PLUGIN-CENTRAL 0.2.0 unloaded successfully!");
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        String[] cmd = event.getCommand().split(" ");
        if (cmd[0].equals(commandPrefix)) {
            this.showMainGui(event.getPlayer());
        }
    }

    public void showMainGui(Player player) {
        if (plugins.size() < 1) {
            player.sendTextMessage(Msgs.msg[1]);
            return;
        }
        Menu menu = new Menu(this);
        for (Map.Entry<String, Integer> entry : plugins.entrySet()) {
            menu.addChild(entry.getKey(), entry.getValue(), null);
        }
        menu.show(player);
    }

    public static boolean invokePluginMainGui(Player player, int pluginId) {
        Plugin plugin = pluginCentral.getPluginByID(pluginId);
        if (plugin != null) {
            Method method;
            block4: {
                method = plugin.getClass().getMethod("mainGui", mainGuiClasses);
                if (method != null) break block4;
                return false;
            }
            try {
                method.invoke((Object)plugin, player);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return false;
            }
        }
        return true;
    }

    private void initPlugins() {
        if (plugins == null) {
            plugins = new TreeMap<String, Integer>();
            Collection allPlugins = this.getAllPlugins();
            for (Plugin plugin : allPlugins) {
                try {
                    String publicName;
                    Method method = plugin.getClass().getMethod("getPublicName", null);
                    if (method == null || (publicName = (String)method.invoke((Object)plugin, null)) == null || (method = plugin.getClass().getMethod("mainGui", mainGuiClasses)) == null) continue;
                    plugins.put(publicName, plugin.getID());
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
    }

    private void initSettings() {
        String strLocale;
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(this.getPath()) + "/settings.properties");
            settings.load(in);
            in.close();
            commandPrefix = "/" + settings.getProperty("command", commandPrefix);
            strLocale = settings.getProperty("locale", localeLanguageDef);
        }
        catch (IOException e) {
            strLocale = localeLanguageDef;
        }
        String[] localeParams = strLocale.split("-");
        locale = localeParams.length > 0 ? (localeParams.length > 1 && localeParams[2].length() > 0 ? (localeParams.length > 2 && localeParams[2].length() > 0 ? new Locale(localeParams[0], localeParams[1], localeParams[2]) : new Locale(localeParams[0], localeParams[1])) : new Locale(localeParams[0])) : new Locale(localeLanguageDef);
    }
}

